/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.PartitionPath;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitionSpec$;
import org.apache.spark.sql.execution.datasources.PartitioningUtils;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.Try;
import scala.util.Try$;

public final class PartitioningUtils$ {
    public static final PartitioningUtils$ MODULE$;
    private final Function2<DataType, DataType, DataType> findWiderTypeForPartitionColumn;

    static {
        new PartitioningUtils$();
    }

    public PartitionSpec parsePartitions(Seq<Path> paths, boolean typeInference, Set<Path> basePaths2, Option<StructType> userSpecifiedSchema, boolean caseSensitive, String timeZoneId) {
        return this.parsePartitions(paths, typeInference, basePaths2, userSpecifiedSchema, caseSensitive, DateTimeUtils$.MODULE$.getTimeZone(timeZoneId));
    }

    public PartitionSpec parsePartitions(Seq<Path> paths, boolean typeInference, Set<Path> basePaths2, Option<StructType> userSpecifiedSchema, boolean caseSensitive, TimeZone timeZone) {
        Tuple2 tuple2;
        block5: {
            PartitioningUtils.PartitionValues partitionValues;
            block8: {
                PartitionSpec partitionSpec2;
                block7: {
                    Tuple2 tuple22;
                    Seq pathsWithPartitionValues;
                    Seq optDiscoveredBasePaths;
                    Map userSpecifiedNames;
                    Map userSpecifiedDataTypes;
                    block6: {
                        Tuple2 tuple23;
                        Object object;
                        if (userSpecifiedSchema.isDefined()) {
                            Map nameToDataType = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((StructType)userSpecifiedSchema.get()).fields()).map((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<String, DataType> apply(StructField f) {
                                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f.dataType());
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
                            object = caseSensitive ? nameToDataType : CaseInsensitiveMap$.MODULE$.apply(nameToDataType);
                        } else {
                            object = Predef$.MODULE$.Map().empty();
                        }
                        userSpecifiedDataTypes = object;
                        userSpecifiedNames = userSpecifiedSchema.isDefined() && !caseSensitive ? CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((StructType)userSpecifiedSchema.get()).fields()).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, String> apply(StructField f) {
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f.name());
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms())) : Predef$.MODULE$.Map().empty();
                        tuple2 = ((GenericTraversableTemplate)paths.map((Function1)new Serializable(typeInference, basePaths2, timeZone, userSpecifiedDataTypes){
                            public static final long serialVersionUID = 0L;
                            private final boolean typeInference$1;
                            private final Set basePaths$1;
                            private final TimeZone timeZone$1;
                            private final Map userSpecifiedDataTypes$1;

                            public final Tuple2<Option<PartitioningUtils.PartitionValues>, Option<Path>> apply(Path path) {
                                return PartitioningUtils$.MODULE$.parsePartition(path, this.typeInference$1, (Set<Path>)this.basePaths$1, (Map<String, DataType>)this.userSpecifiedDataTypes$1, this.timeZone$1);
                            }
                            {
                                this.typeInference$1 = typeInference$1;
                                this.basePaths$1 = basePaths$1;
                                this.timeZone$1 = timeZone$1;
                                this.userSpecifiedDataTypes$1 = userSpecifiedDataTypes$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
                        if (tuple2 == null) break block5;
                        Seq partitionValues2 = (Seq)tuple2._1();
                        Seq optDiscoveredBasePaths2 = (Seq)tuple2._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)partitionValues2, (Object)optDiscoveredBasePaths2);
                        Seq partitionValues3 = (Seq)tuple24._1();
                        optDiscoveredBasePaths = (Seq)tuple24._2();
                        pathsWithPartitionValues = (Seq)((TraversableLike)paths.zip((GenIterable)partitionValues3, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Iterable<Tuple2<Path, PartitioningUtils.PartitionValues>> apply(Tuple2<Path, Option<PartitioningUtils.PartitionValues>> x) {
                                return Option$.MODULE$.option2Iterable(((Option)x._2()).map((Function1)new Serializable(this, x){
                                    public static final long serialVersionUID = 0L;
                                    private final Tuple2 x$27;

                                    public final Tuple2<Path, PartitioningUtils.PartitionValues> apply(PartitioningUtils.PartitionValues x$2) {
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.x$27._1()), (Object)x$2);
                                    }
                                    {
                                        this.x$27 = x$27;
                                    }
                                }));
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        if (!pathsWithPartitionValues.isEmpty()) break block6;
                        partitionSpec2 = PartitionSpec$.MODULE$.emptySpec();
                        break block7;
                    }
                    Seq discoveredBasePaths = (Seq)((TraversableLike)optDiscoveredBasePaths.flatten((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Iterable<Path> apply(Option<Path> xo) {
                            return Option$.MODULE$.option2Iterable(xo);
                        }
                    })).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Path x$3) {
                            return x$3.toString().toLowerCase();
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    Predef$.MODULE$.assert(((SeqLike)discoveredBasePaths.distinct()).size() == 1, (Function0)new Serializable(discoveredBasePaths){
                        public static final long serialVersionUID = 0L;
                        private final Seq discoveredBasePaths$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Conflicting directory structures detected. Suspicious paths:\b").append((Object)((TraversableOnce)this.discoveredBasePaths$1.distinct()).mkString("\n\t", "\n\t", "\n\n")).append((Object)"If provided paths are partition directories, please set ").append((Object)"\"basePath\" in the options of the data source to specify the ").append((Object)"root directory of the table. If there are multiple root directories, ").append((Object)"please load them separately and then union them.").toString();
                        }
                        {
                            this.discoveredBasePaths$1 = discoveredBasePaths$1;
                        }
                    });
                    Seq<PartitioningUtils.PartitionValues> resolvedPartitionValues = this.resolvePartitions((Seq<Tuple2<Path, PartitioningUtils.PartitionValues>>)pathsWithPartitionValues, timeZone);
                    partitionValues = (PartitioningUtils.PartitionValues)resolvedPartitionValues.head();
                    if (partitionValues == null) break block8;
                    Seq<String> columnNames = partitionValues.columnNames();
                    Seq<Literal> literals = partitionValues.literals();
                    Tuple2 tuple25 = tuple22 = new Tuple2(columnNames, literals);
                    Seq columnNames2 = (Seq)tuple25._1();
                    Seq literals2 = (Seq)tuple25._2();
                    Seq fields = (Seq)((TraversableLike)columnNames2.zip((GenIterable)literals2, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(userSpecifiedDataTypes, userSpecifiedNames){
                        public static final long serialVersionUID = 0L;
                        private final Map userSpecifiedDataTypes$1;
                        private final Map userSpecifiedNames$1;

                        public final StructField apply(Tuple2<String, Literal> x0$1) {
                            Tuple2<String, Literal> tuple2 = x0$1;
                            if (tuple2 != null) {
                                String name2 = (String)tuple2._1();
                                Literal literal = (Literal)tuple2._2();
                                if (literal != null) {
                                    DataType dataType = literal.dataType();
                                    String resultName = (String)this.userSpecifiedNames$1.getOrElse((Object)name2, (Function0)new Serializable(this, name2){
                                        public static final long serialVersionUID = 0L;
                                        private final String name$1;

                                        public final String apply() {
                                            return this.name$1;
                                        }
                                        {
                                            this.name$1 = name$1;
                                        }
                                    });
                                    DataType resultDataType = (DataType)this.userSpecifiedDataTypes$1.getOrElse((Object)name2, (Function0)new Serializable(this, dataType){
                                        public static final long serialVersionUID = 0L;
                                        private final DataType dataType$1;

                                        public final DataType apply() {
                                            return this.dataType$1;
                                        }
                                        {
                                            this.dataType$1 = dataType$1;
                                        }
                                    });
                                    StructField structField = new StructField(resultName, resultDataType, true, StructField$.MODULE$.apply$default$4());
                                    return structField;
                                }
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.userSpecifiedDataTypes$1 = userSpecifiedDataTypes$1;
                            this.userSpecifiedNames$1 = userSpecifiedNames$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    Seq partitions = (Seq)((TraversableLike)resolvedPartitionValues.zip((GenIterable)pathsWithPartitionValues, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final PartitionPath apply(Tuple2<PartitioningUtils.PartitionValues, Tuple2<Path, PartitioningUtils.PartitionValues>> x0$2) {
                            Tuple2<PartitioningUtils.PartitionValues, Tuple2<Path, PartitioningUtils.PartitionValues>> tuple2 = x0$2;
                            if (tuple2 != null) {
                                PartitioningUtils.PartitionValues partitionValues = (PartitioningUtils.PartitionValues)tuple2._1();
                                Tuple2 tuple22 = (Tuple2)tuple2._2();
                                if (partitionValues != null) {
                                    Seq<Literal> literals = partitionValues.literals();
                                    if (tuple22 != null) {
                                        Path path = (Path)tuple22._1();
                                        PartitionPath partitionPath = new PartitionPath(InternalRow$.MODULE$.fromSeq((Seq)literals.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Object apply(Literal x$5) {
                                                return x$5.value();
                                            }
                                        }, Seq$.MODULE$.canBuildFrom())), path);
                                        return partitionPath;
                                    }
                                }
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    partitionSpec2 = new PartitionSpec(StructType$.MODULE$.apply(fields), (Seq<PartitionPath>)partitions);
                }
                return partitionSpec2;
            }
            throw new MatchError((Object)partitionValues);
        }
        throw new MatchError((Object)tuple2);
    }

    public Tuple2<Option<PartitioningUtils.PartitionValues>, Option<Path>> parsePartition(Path path, boolean typeInference, Set<Path> basePaths2, Map<String, DataType> userSpecifiedDataTypes, TimeZone timeZone) {
        ArrayBuffer columns2 = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        boolean finished = path.getParent() == null;
        Path currentPath = path;
        while (true) {
            block6: {
                Tuple2 tuple2;
                block9: {
                    Tuple2 tuple22;
                    block8: {
                        Tuple2 tuple23;
                        block7: {
                            if (!finished) break block6;
                            if (!columns2.isEmpty()) break block7;
                            tuple22 = new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)path));
                            break block8;
                        }
                        tuple2 = ((GenericTraversableTemplate)columns2.reverse()).unzip((Function1)Predef$.MODULE$.$conforms());
                        if (tuple2 == null) break block9;
                        ArrayBuffer columnNames = (ArrayBuffer)tuple2._1();
                        ArrayBuffer values2 = (ArrayBuffer)tuple2._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)columnNames, (Object)values2);
                        ArrayBuffer columnNames2 = (ArrayBuffer)tuple24._1();
                        ArrayBuffer values3 = (ArrayBuffer)tuple24._2();
                        tuple22 = new Tuple2((Object)new Some((Object)new PartitioningUtils.PartitionValues((Seq<String>)columnNames2, (Seq<Literal>)values3)), (Object)new Some((Object)currentPath));
                    }
                    return tuple22;
                }
                throw new MatchError((Object)tuple2);
            }
            String string = currentPath.getName().toLowerCase(Locale.ROOT);
            String string2 = "_temporary";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            if (basePaths2.contains((Object)currentPath)) {
                finished = true;
                continue;
            }
            Option<Tuple2<String, Literal>> maybeColumn = this.parsePartitionColumn(currentPath.getName(), typeInference, userSpecifiedDataTypes, timeZone);
            maybeColumn.foreach((Function1)new Serializable(columns2){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer columns$1;

                public final ArrayBuffer<Tuple2<String, Literal>> apply(Tuple2<String, Literal> x$6) {
                    return this.columns$1.$plus$eq(x$6);
                }
                {
                    this.columns$1 = columns$1;
                }
            });
            finished = maybeColumn.isEmpty() && !columns2.isEmpty() || currentPath.getParent() == null;
            if (finished) continue;
            currentPath = currentPath.getParent();
        }
    }

    private Option<Tuple2<String, Literal>> parsePartitionColumn(String columnSpec, boolean typeInference, Map<String, DataType> userSpecifiedDataTypes, TimeZone timeZone) {
        None$ none$;
        int equalSignIndex = columnSpec.indexOf(61);
        if (equalSignIndex == -1) {
            none$ = None$.MODULE$;
        } else {
            Literal literal;
            String columnName = ExternalCatalogUtils$.MODULE$.unescapePathName((String)new StringOps(Predef$.MODULE$.augmentString(columnSpec)).take(equalSignIndex));
            Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(columnName)).nonEmpty(), (Function0)new Serializable(columnSpec){
                public static final long serialVersionUID = 0L;
                private final String columnSpec$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Empty partition column name in '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.columnSpec$1}));
                }
                {
                    this.columnSpec$1 = columnSpec$1;
                }
            });
            String rawColumnValue = (String)new StringOps(Predef$.MODULE$.augmentString(columnSpec)).drop(equalSignIndex + 1);
            Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(rawColumnValue)).nonEmpty(), (Function0)new Serializable(columnSpec){
                public static final long serialVersionUID = 0L;
                private final String columnSpec$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Empty partition column value in '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.columnSpec$1}));
                }
                {
                    this.columnSpec$1 = columnSpec$1;
                }
            });
            if (userSpecifiedDataTypes.contains((Object)columnName)) {
                Literal columnValue = this.inferPartitionColumnValue(rawColumnValue, false, timeZone);
                Cast qual$1 = new Cast((Expression)columnValue, (DataType)userSpecifiedDataTypes.apply((Object)columnName), Option$.MODULE$.apply((Object)timeZone.getID()));
                InternalRow x$21 = qual$1.eval$default$1();
                Object castedValue = qual$1.eval(x$21);
                literal = Literal$.MODULE$.create(castedValue, (DataType)userSpecifiedDataTypes.apply((Object)columnName));
            } else {
                literal = this.inferPartitionColumnValue(rawColumnValue, typeInference, timeZone);
            }
            Literal literal2 = literal;
            none$ = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnName), (Object)literal2));
        }
        return none$;
    }

    public Map<String, String> parsePathFragment(String pathFragment) {
        return this.parsePathFragmentAsSeq(pathFragment).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<Tuple2<String, String>> parsePathFragmentAsSeq(String pathFragment) {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])pathFragment.split("/")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String kv) {
                String[] pair = kv.split("=", 2);
                return new Tuple2((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(pair[0]), (Object)ExternalCatalogUtils$.MODULE$.unescapePathName(pair[1]));
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public String getPathFragment(Map<String, String> spec, StructType partitionSchema) {
        return ((TraversableOnce)partitionSchema.map((Function1)new Serializable(spec){
            public static final long serialVersionUID = 0L;
            private final Map spec$1;

            public final String apply(StructField field) {
                return new StringBuilder().append((Object)ExternalCatalogUtils$.MODULE$.escapePathName(field.name())).append((Object)"=").append((Object)ExternalCatalogUtils$.MODULE$.escapePathName((String)this.spec$1.apply((Object)field.name()))).toString();
            }
            {
                this.spec$1 = spec$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("/");
    }

    public String getPathFragment(Map<String, String> spec, Seq<Attribute> partitionColumns) {
        return this.getPathFragment(spec, StructType$.MODULE$.fromAttributes(partitionColumns));
    }

    public <T> Map<String, T> normalizePartitionSpec(Map<String, T> partitionSpec2, Seq<String> partColNames, String tblName, Function2<String, String, Object> resolver) {
        Seq normalizedPartSpec = (Seq)partitionSpec2.toSeq().map((Function1)new Serializable(partColNames, tblName, resolver){
            public static final long serialVersionUID = 0L;
            private final Seq partColNames$1;
            public final String tblName$1;
            public final Function2 resolver$1;

            public final Tuple2<String, T> apply(Tuple2<String, T> x0$3) {
                Tuple2<String, T> tuple2 = x0$3;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    String normalizedKey = (String)this.partColNames$1.find((Function1)new Serializable(this, key){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.11 $outer;
                        private final String key$1;

                        public final boolean apply(String x$8) {
                            return BoxesRunTime.unboxToBoolean((Object)this.$outer.resolver$1.apply((Object)x$8, (Object)this.key$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.key$1 = key$1;
                        }
                    }).getOrElse((Function0)new Serializable(this, key){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.11 $outer;
                        private final String key$1;

                        public final Nothing$ apply() {
                            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a valid partition column in table ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1, this.$outer.tblName$1})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.key$1 = key$1;
                        }
                    });
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)normalizedKey), value);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.partColNames$1 = partColNames$1;
                this.tblName$1 = tblName$1;
                this.resolver$1 = resolver$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)normalizedPartSpec.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, T> x$9) {
                return (String)x$9._1();
            }
        }, Seq$.MODULE$.canBuildFrom()), "in the partition schema", resolver);
        return normalizedPartSpec.toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<PartitioningUtils.PartitionValues> resolvePartitions(Seq<Tuple2<Path, PartitioningUtils.PartitionValues>> pathsWithPartitionValues, TimeZone timeZone) {
        Seq seq;
        if (pathsWithPartitionValues.isEmpty()) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            Seq distinctPartColNames = (Seq)((SeqLike)pathsWithPartitionValues.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<String> apply(Tuple2<Path, PartitioningUtils.PartitionValues> x$10) {
                    return (Seq)((PartitioningUtils.PartitionValues)x$10._2()).columnNames().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String x$11) {
                            return x$11.toLowerCase();
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
            }, Seq$.MODULE$.canBuildFrom())).distinct();
            Predef$.MODULE$.assert(distinctPartColNames.size() == 1, (Function0)new Serializable(pathsWithPartitionValues){
                public static final long serialVersionUID = 0L;
                private final Seq pathsWithPartitionValues$1;

                public final String apply() {
                    return PartitioningUtils$.MODULE$.listConflictingPartitionColumns((Seq<Tuple2<Path, PartitioningUtils.PartitionValues>>)this.pathsWithPartitionValues$1);
                }
                {
                    this.pathsWithPartitionValues$1 = pathsWithPartitionValues$1;
                }
            });
            Seq values2 = (Seq)pathsWithPartitionValues.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final PartitioningUtils.PartitionValues apply(Tuple2<Path, PartitioningUtils.PartitionValues> x$12) {
                    return (PartitioningUtils.PartitionValues)x$12._2();
                }
            }, Seq$.MODULE$.canBuildFrom());
            int columnCount = ((PartitioningUtils.PartitionValues)values2.head()).columnNames().size();
            IndexedSeq resolvedValues = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), columnCount).map((Function1)new Serializable(timeZone, values2){
                public static final long serialVersionUID = 0L;
                private final TimeZone timeZone$2;
                private final Seq values$1;

                public final Seq<Literal> apply(int i) {
                    return PartitioningUtils$.MODULE$.org$apache$spark$sql$execution$datasources$PartitioningUtils$$resolveTypeConflicts((Seq<Literal>)((Seq)this.values$1.map((Function1)new Serializable(this, i){
                        public static final long serialVersionUID = 0L;
                        private final int i$1;

                        public final Literal apply(PartitioningUtils.PartitionValues x$13) {
                            return (Literal)x$13.literals().apply(this.i$1);
                        }
                        {
                            this.i$1 = i$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom())), this.timeZone$2);
                }
                {
                    this.timeZone$2 = timeZone$2;
                    this.values$1 = values$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            seq = (Seq)((TraversableLike)values2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(resolvedValues){
                public static final long serialVersionUID = 0L;
                private final IndexedSeq resolvedValues$1;

                public final PartitioningUtils.PartitionValues apply(Tuple2<PartitioningUtils.PartitionValues, Object> x0$4) {
                    Tuple2<PartitioningUtils.PartitionValues, Object> tuple2 = x0$4;
                    if (tuple2 != null) {
                        PartitioningUtils.PartitionValues d = (PartitioningUtils.PartitionValues)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        Seq x$22 = (Seq)this.resolvedValues$1.map((Function1)new Serializable(this, index){
                            public static final long serialVersionUID = 0L;
                            private final int index$1;

                            public final Literal apply(Seq<Literal> x$14) {
                                return (Literal)x$14.apply(this.index$1);
                            }
                            {
                                this.index$1 = index$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                        Seq<String> x$23 = d.copy$default$1();
                        PartitioningUtils.PartitionValues partitionValues = d.copy(x$23, (Seq<Literal>)x$22);
                        return partitionValues;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.resolvedValues$1 = resolvedValues$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public String listConflictingPartitionColumns(Seq<Tuple2<Path, PartitioningUtils.PartitionValues>> pathWithPartitionValues) {
        Seq distinctPartColNames = (Seq)((SeqLike)pathWithPartitionValues.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<Path, PartitioningUtils.PartitionValues> x$15) {
                return ((PartitioningUtils.PartitionValues)x$15._2()).columnNames();
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        Map partColNamesToPaths = this.groupByKey$1((Seq)pathWithPartitionValues.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Seq<String>, Path> apply(Tuple2<Path, PartitioningUtils.PartitionValues> x0$7) {
                Tuple2<Path, PartitioningUtils.PartitionValues> tuple2 = x0$7;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    PartitioningUtils.PartitionValues partValues = (PartitioningUtils.PartitionValues)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partValues.columnNames()), (Object)path);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Seq distinctPartColLists = (Seq)((TraversableLike)((IterableLike)distinctPartColNames.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Seq<String> x$17) {
                return x$17.mkString(", ");
            }
        }, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$8) {
                Tuple2<String, Object> tuple2 = x0$8;
                if (tuple2 != null) {
                    String names = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition column name list #", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), names}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq suspiciousPaths = (Seq)((TraversableLike)distinctPartColNames.sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<String> x$18) {
                return x$18.length();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1)partColNamesToPaths, Seq$.MODULE$.canBuildFrom());
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conflicting partition column names detected:\\n"})).s((Seq)Nil$.MODULE$)).append((Object)distinctPartColLists.mkString("\n\t", "\n\t", "\n\n")).append((Object)"For partitioned table directories, data files should only live in leaf directories.\n").append((Object)"And directories at the same level should have the same partition column name.\n").append((Object)"Please check the following directories for unexpected files or ").append((Object)"inconsistent partition column names:\n").append((Object)((TraversableOnce)suspiciousPaths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Path x$19) {
                return new StringBuilder().append((Object)"\t").append((Object)x$19).toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n", "\n", "")).toString();
    }

    public Literal inferPartitionColumnValue(String raw, boolean typeInference, TimeZone timeZone) {
        Literal literal;
        Try decimalTry = Try$.MODULE$.apply((Function0)new Serializable(raw){
            public static final long serialVersionUID = 0L;
            private final String raw$1;

            public final Literal apply() {
                BigDecimal bigDecimal = new BigDecimal(this.raw$1);
                Predef$.MODULE$.require(bigDecimal.scale() <= 0);
                return Literal$.MODULE$.apply((Object)bigDecimal);
            }
            {
                this.raw$1 = raw$1;
            }
        });
        Try dateTry = Try$.MODULE$.apply((Function0)new Serializable(raw){
            public static final long serialVersionUID = 0L;
            private final String raw$1;

            public final Literal apply() {
                DateTimeUtils$.MODULE$.getThreadLocalDateFormat(DateTimeUtils$.MODULE$.defaultTimeZone()).parse(this.raw$1);
                Cast qual$2 = new Cast((Expression)Literal$.MODULE$.apply((Object)this.raw$1), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3());
                InternalRow x$24 = qual$2.eval$default$1();
                Object dateValue = qual$2.eval(x$24);
                Predef$.MODULE$.require(dateValue != null);
                return Literal$.MODULE$.create(dateValue, (DataType)DateType$.MODULE$);
            }
            {
                this.raw$1 = raw$1;
            }
        });
        Try timestampTry = Try$.MODULE$.apply((Function0)new Serializable(raw, timeZone){
            public static final long serialVersionUID = 0L;
            private final String raw$1;
            private final TimeZone timeZone$3;

            public final Literal apply() {
                String unescapedRaw = ExternalCatalogUtils$.MODULE$.unescapePathName(this.raw$1);
                DateTimeUtils$.MODULE$.getThreadLocalTimestampFormat(this.timeZone$3).parse(unescapedRaw);
                Cast qual$3 = new Cast((Expression)Literal$.MODULE$.apply((Object)unescapedRaw), (DataType)TimestampType$.MODULE$, (Option)new Some((Object)this.timeZone$3.getID()));
                InternalRow x$25 = qual$3.eval$default$1();
                Object timestampValue = qual$3.eval(x$25);
                Predef$.MODULE$.require(timestampValue != null);
                return Literal$.MODULE$.create(timestampValue, (DataType)TimestampType$.MODULE$);
            }
            {
                this.raw$1 = raw$1;
                this.timeZone$3 = timeZone$3;
            }
        });
        if (typeInference) {
            literal = (Literal)Try$.MODULE$.apply((Function0)new Serializable(raw){
                public static final long serialVersionUID = 0L;
                private final String raw$1;

                public final Literal apply() {
                    return Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(this.raw$1)), (DataType)IntegerType$.MODULE$);
                }
                {
                    this.raw$1 = raw$1;
                }
            }).orElse((Function0)new Serializable(raw){
                public static final long serialVersionUID = 0L;
                public final String raw$1;

                public final Try<Literal> apply() {
                    return Try$.MODULE$.apply((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.inferPartitionColumnValue.2 $outer;

                        public final Literal apply() {
                            return Literal$.MODULE$.create((Object)BoxesRunTime.boxToLong((long)Long.parseLong(this.$outer.raw$1)), (DataType)LongType$.MODULE$);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.raw$1 = raw$1;
                }
            }).orElse((Function0)new Serializable(decimalTry){
                public static final long serialVersionUID = 0L;
                private final Try decimalTry$1;

                public final Try<Literal> apply() {
                    return this.decimalTry$1;
                }
                {
                    this.decimalTry$1 = decimalTry$1;
                }
            }).orElse((Function0)new Serializable(raw){
                public static final long serialVersionUID = 0L;
                public final String raw$1;

                public final Try<Literal> apply() {
                    return Try$.MODULE$.apply((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.inferPartitionColumnValue.4 $outer;

                        public final Literal apply() {
                            return Literal$.MODULE$.create((Object)BoxesRunTime.boxToDouble((double)Double.parseDouble(this.$outer.raw$1)), (DataType)DoubleType$.MODULE$);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.raw$1 = raw$1;
                }
            }).orElse((Function0)new Serializable(timestampTry){
                public static final long serialVersionUID = 0L;
                private final Try timestampTry$1;

                public final Try<Literal> apply() {
                    return this.timestampTry$1;
                }
                {
                    this.timestampTry$1 = timestampTry$1;
                }
            }).orElse((Function0)new Serializable(dateTry){
                public static final long serialVersionUID = 0L;
                private final Try dateTry$1;

                public final Try<Literal> apply() {
                    return this.dateTry$1;
                }
                {
                    this.dateTry$1 = dateTry$1;
                }
            }).getOrElse((Function0)new Serializable(raw){
                public static final long serialVersionUID = 0L;
                private final String raw$1;

                public final Literal apply() {
                    String string = this.raw$1;
                    String string2 = ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME();
                    return !(string != null ? !string.equals(string2) : string2 != null) ? Literal$.MODULE$.create(null, (DataType)NullType$.MODULE$) : Literal$.MODULE$.create((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(this.raw$1), (DataType)StringType$.MODULE$);
                }
                {
                    this.raw$1 = raw$1;
                }
            });
        } else {
            String string = raw;
            String string2 = ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME();
            literal = !(string != null ? !string.equals(string2) : string2 != null) ? Literal$.MODULE$.create(null, (DataType)NullType$.MODULE$) : Literal$.MODULE$.create((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(raw), (DataType)StringType$.MODULE$);
        }
        return literal;
    }

    public void validatePartitionColumn(StructType schema2, Seq<String> partitionColumns, boolean caseSensitive) {
        this.partitionColumnsSchema(schema2, partitionColumns, caseSensitive).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(StructField field) {
                DataType dataType = field.dataType();
                if (dataType instanceof AtomicType) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot use ", " for partition column"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.dataType()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        });
        if (partitionColumns.nonEmpty() && partitionColumns.size() == schema2.fields().length) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot use all columns for partition columns"})).s((Seq)Nil$.MODULE$), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public StructType partitionColumnsSchema(StructType schema2, Seq<String> partitionColumns, boolean caseSensitive) {
        Function2<String, String, Object> equality = this.columnNameEquality(caseSensitive);
        return StructType$.MODULE$.apply((Seq)partitionColumns.map((Function1)new Serializable(schema2, equality){
            public static final long serialVersionUID = 0L;
            public final StructType schema$1;
            public final Function2 equality$1;

            public final StructField apply(String col) {
                return (StructField)this.schema$1.find((Function1)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.partitionColumnsSchema.1 $outer;
                    private final String col$1;

                    public final boolean apply(StructField f) {
                        return BoxesRunTime.unboxToBoolean((Object)this.$outer.equality$1.apply((Object)f.name(), (Object)this.col$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.col$1 = col$1;
                    }
                }).getOrElse((Function0)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.partitionColumnsSchema.1 $outer;
                    private final String col$1;

                    public final Nothing$ apply() {
                        String schemaCatalog = this.$outer.schema$1.catalogString();
                        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition column `", "` not found in schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.col$1, schemaCatalog})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.col$1 = col$1;
                    }
                });
            }
            {
                this.schema$1 = schema$1;
                this.equality$1 = equality$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).asNullable();
    }

    private Function2<String, String, Object> columnNameEquality(boolean caseSensitive) {
        return caseSensitive ? package$.MODULE$.caseSensitiveResolution() : package$.MODULE$.caseInsensitiveResolution();
    }

    public Seq<Literal> org$apache$spark$sql$execution$datasources$PartitioningUtils$$resolveTypeConflicts(Seq<Literal> literals, TimeZone timeZone) {
        Seq litTypes = (Seq)literals.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(Literal x$20) {
                return x$20.dataType();
            }
        }, Seq$.MODULE$.canBuildFrom());
        DataType desiredType = (DataType)litTypes.reduce(this.findWiderTypeForPartitionColumn());
        return (Seq)literals.map((Function1)new Serializable(timeZone, desiredType){
            public static final long serialVersionUID = 0L;
            private final TimeZone timeZone$4;
            private final DataType desiredType$1;

            public final Literal apply(Literal x0$9) {
                Literal literal = x0$9;
                if (literal != null) {
                    Cast qual$4 = new Cast((Expression)literal, this.desiredType$1, (Option)new Some((Object)this.timeZone$4.getID()));
                    InternalRow x$26 = qual$4.eval$default$1();
                    Literal literal2 = Literal$.MODULE$.create(qual$4.eval(x$26), this.desiredType$1);
                    return literal2;
                }
                throw new MatchError((Object)literal);
            }
            {
                this.timeZone$4 = timeZone$4;
                this.desiredType$1 = desiredType$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Function2<DataType, DataType, DataType> findWiderTypeForPartitionColumn() {
        return this.findWiderTypeForPartitionColumn;
    }

    private final Map groupByKey$1(Seq seq) {
        return seq.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final K apply(Tuple2<K, V> x0$5) {
                Tuple2<K, V> tuple2 = x0$5;
                if (tuple2 != null) {
                    Object key;
                    Object object = key = tuple2._1();
                    return (K)object;
                }
                throw new MatchError(tuple2);
            }
        }).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<V> apply(Seq<Tuple2<K, V>> x$16) {
                return (Iterable)x$16.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final V apply(Tuple2<K, V> x0$6) {
                        Tuple2<K, V> tuple2 = x0$6;
                        if (tuple2 != null) {
                            Object value;
                            Object object = value = tuple2._2();
                            return (V)object;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        });
    }

    private PartitioningUtils$() {
        MODULE$ = this;
        this.findWiderTypeForPartitionColumn = new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Unable to fully structure code
             */
            public final DataType apply(DataType x0$10, DataType x1$1) {
                block14: {
                    block10: {
                        block13: {
                            block12: {
                                block11: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                var3_3 = new Tuple2((Object)x0$10, (Object)x1$1);
                                                if (var3_3 == null || !DoubleType$.MODULE$.equals(var4_4 = (DataType)var3_3._1()) || !(var3_3._2() instanceof DecimalType)) break block7;
                                                var5_5 = true;
                                                break block8;
                                            }
                                            if (var3_3 == null) ** GOTO lbl-1000
                                            var6_6 = (DataType)var3_3._2();
                                            if (var3_3._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var6_6)) {
                                                var5_5 = true;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                var5_5 = false;
                                            }
                                        }
                                        if (!var5_5) break block9;
                                        var7_7 = StringType$.MODULE$;
                                        break block10;
                                    }
                                    if (var3_3 == null) break block11;
                                    var8_8 = (DataType)var3_3._1();
                                    var9_9 = (DataType)var3_3._2();
                                    if (!DoubleType$.MODULE$.equals(var8_8) || !LongType$.MODULE$.equals(var9_9)) break block11;
                                    var10_10 = true;
                                    break block12;
                                }
                                if (var3_3 == null) ** GOTO lbl-1000
                                var11_11 = (DataType)var3_3._1();
                                var12_12 = (DataType)var3_3._2();
                                if (LongType$.MODULE$.equals(var11_11) && DoubleType$.MODULE$.equals(var12_12)) {
                                    var10_10 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    var10_10 = false;
                                }
                            }
                            if (!var10_10) break block13;
                            var7_7 = StringType$.MODULE$;
                            break block10;
                        }
                        if (var3_3 == null) break block14;
                        t1 = (DataType)var3_3._1();
                        t2 = (DataType)var3_3._2();
                        var7_7 = (DataType)TypeCoercion$.MODULE$.findWiderTypeForTwo(t1, t2).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final StringType$ apply() {
                                return StringType$.MODULE$;
                            }
                        });
                    }
                    return var7_7;
                }
                throw new MatchError((Object)var3_3);
            }
        };
    }
}

