/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.AccessInfo;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.catalyst.planning.PhysicalOperation$;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.datasources.CatalogFileIndex;
import org.apache.spark.sql.execution.datasources.DataSourceStrategy$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.package$;

public final class PruneFileSourcePartitions$
extends Rule<LogicalPlan> {
    public static final PruneFileSourcePartitions$ MODULE$;

    static {
        new PruneFileSourcePartitions$();
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return plan.transformDown((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = PhysicalOperation$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    LogicalRelation logicalRelation;
                    BaseRelation fsRelation;
                    Seq projects = (Seq)((Tuple3)option.get())._1();
                    Seq filters = (Seq)((Tuple3)option.get())._2();
                    LogicalPlan logicalRelation2 = (LogicalPlan)((Tuple3)option.get())._3();
                    if (logicalRelation2 instanceof LogicalRelation && (fsRelation = (logicalRelation = (LogicalRelation)logicalRelation2).relation()) instanceof HadoopFsRelation) {
                        HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)fsRelation;
                        FileIndex catalogFileIndex = hadoopFsRelation.location();
                        StructType partitionSchema = hadoopFsRelation.partitionSchema();
                        if (catalogFileIndex instanceof CatalogFileIndex) {
                            CatalogFileIndex catalogFileIndex2 = (CatalogFileIndex)catalogFileIndex;
                            if (filters.nonEmpty() && hadoopFsRelation.partitionSchemaOption().isDefined()) {
                                Object object2;
                                SparkSession sparkSession;
                                Seq partitionColumns;
                                AttributeSet partitionSet;
                                Seq<Expression> normalizedFilters = DataSourceStrategy$.MODULE$.normalizeFilters((Seq<Expression>)((Seq)filters.filterNot((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Expression e) {
                                        return SubqueryExpression$.MODULE$.hasSubquery(e);
                                    }
                                })), logicalRelation.output());
                                ExpressionSet partitionKeyFilters = ExpressionSet$.MODULE$.apply((TraversableOnce)normalizedFilters.filter((Function1)new Serializable(this, partitionSet = AttributeSet$.MODULE$.apply((Iterable)(partitionColumns = logicalRelation.resolve(partitionSchema, (sparkSession = hadoopFsRelation.sparkSession()).sessionState().analyzer().resolver())))){
                                    public static final long serialVersionUID = 0L;
                                    private final AttributeSet partitionSet$1;

                                    public final boolean apply(Expression f) {
                                        return f.references().subsetOf(this.partitionSet$1);
                                    }
                                    {
                                        this.partitionSet$1 = partitionSet$1;
                                    }
                                }));
                                if (partitionKeyFilters.nonEmpty()) {
                                    InMemoryFileIndex prunedFileIndex = catalogFileIndex2.filterPartitions((Seq<Expression>)partitionKeyFilters.toSeq());
                                    HadoopFsRelation prunedFsRelation = hadoopFsRelation.copy(prunedFileIndex, hadoopFsRelation.copy$default$2(), hadoopFsRelation.copy$default$3(), hadoopFsRelation.copy$default$4(), hadoopFsRelation.copy$default$5(), hadoopFsRelation.copy$default$6(), sparkSession);
                                    Option withStats = logicalRelation.catalogTable().map((Function1)new Serializable(this, prunedFileIndex){
                                        public static final long serialVersionUID = 0L;
                                        private final InMemoryFileIndex prunedFileIndex$1;

                                        public final CatalogTable apply(CatalogTable x$1) {
                                            Some x$2 = new Some((Object)new CatalogStatistics(package$.MODULE$.BigInt().apply(this.prunedFileIndex$1.sizeInBytes()), CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3()));
                                            TableIdentifier x$3 = x$1.copy$default$1();
                                            CatalogTableType x$4 = x$1.copy$default$2();
                                            CatalogStorageFormat x$5 = x$1.copy$default$3();
                                            StructType x$6 = x$1.copy$default$4();
                                            Option x$7 = x$1.copy$default$5();
                                            Seq x$8 = x$1.copy$default$6();
                                            Option x$9 = x$1.copy$default$7();
                                            String x$10 = x$1.copy$default$8();
                                            long x$11 = x$1.copy$default$9();
                                            long x$12 = x$1.copy$default$10();
                                            String x$13 = x$1.copy$default$11();
                                            Map x$14 = x$1.copy$default$12();
                                            Option x$15 = x$1.copy$default$14();
                                            Option x$16 = x$1.copy$default$15();
                                            Seq x$17 = x$1.copy$default$16();
                                            boolean x$18 = x$1.copy$default$17();
                                            boolean x$19 = x$1.copy$default$18();
                                            Map x$20 = x$1.copy$default$19();
                                            AccessInfo x$21 = x$1.copy$default$20();
                                            return x$1.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option)x$2, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
                                        }
                                        {
                                            this.prunedFileIndex$1 = prunedFileIndex$1;
                                        }
                                    });
                                    HadoopFsRelation x$22 = prunedFsRelation;
                                    Option x$23 = withStats;
                                    Seq<AttributeReference> x$24 = logicalRelation.copy$default$2();
                                    boolean x$25 = logicalRelation.copy$default$4();
                                    LogicalRelation prunedLogicalRelation = logicalRelation.copy(x$22, x$24, (Option<CatalogTable>)x$23, x$25);
                                    Expression filterExpression = (Expression)filters.reduceLeft((Function2)And$.MODULE$);
                                    Filter filter = new Filter(filterExpression, (LogicalPlan)prunedLogicalRelation);
                                    object2 = new Project(projects, (LogicalPlan)filter);
                                } else {
                                    object2 = A1;
                                }
                                object = object2;
                                return (B1)object;
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                Option option = PhysicalOperation$.MODULE$.unapply(logicalPlan2);
                if (option.isEmpty()) return false;
                Seq filters = (Seq)((Tuple3)option.get())._2();
                LogicalPlan logicalRelation = (LogicalPlan)((Tuple3)option.get())._3();
                if (!(logicalRelation instanceof LogicalRelation)) return false;
                LogicalRelation logicalRelation2 = (LogicalRelation)logicalRelation;
                BaseRelation fsRelation = logicalRelation2.relation();
                if (!(fsRelation instanceof HadoopFsRelation)) return false;
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)fsRelation;
                FileIndex catalogFileIndex = hadoopFsRelation.location();
                if (!(catalogFileIndex instanceof CatalogFileIndex)) return false;
                if (!filters.nonEmpty()) return false;
                if (!hadoopFsRelation.partitionSchemaOption().isDefined()) return false;
                return true;
            }
        });
    }

    private PruneFileSourcePartitions$() {
        MODULE$ = this;
    }
}

