/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource;
import org.apache.spark.sql.execution.datasources.csv.MultiLineCSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class CSVDataSource$
implements Logging,
Serializable {
    public static final CSVDataSource$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CSVDataSource$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public CSVDataSource apply(CSVOptions options) {
        return options.multiLine() ? MultiLineCSVDataSource$.MODULE$ : TextInputCSVDataSource$.MODULE$;
    }

    public void checkHeaderColumnNames(StructType schema2, String[] columnNames, String fileName, boolean enforceSchema, boolean caseSensitive) {
        if (columnNames != null) {
            IndexedSeq fieldNames = ((TraversableOnce)schema2.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField x$2) {
                    return x$2.name();
                }
            }, Seq$.MODULE$.canBuildFrom())).toIndexedSeq();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(Predef$.MODULE$.refArrayOps((Object[])columnNames).size(), fieldNames.length());
            if (sp2 != null) {
                Tuple2.mcII.sp sp3;
                int headerLen = sp2._1$mcI$sp();
                int schemaSize = sp2._2$mcI$sp();
                Tuple2.mcII.sp sp4 = sp3 = new Tuple2.mcII.sp(headerLen, schemaSize);
                int headerLen2 = sp4._1$mcI$sp();
                int schemaSize2 = sp4._2$mcI$sp();
                None$ errorMessage = None$.MODULE$;
                if (headerLen2 == schemaSize2) {
                    for (int i = 0; errorMessage.isEmpty() && i < headerLen2; ++i) {
                        Tuple2 tuple2 = new Tuple2(fieldNames.apply(i), (Object)columnNames[i]);
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            String nameInSchema = (String)tuple2._1();
                            String nameInHeader = (String)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)nameInSchema, (Object)nameInHeader);
                            String nameInSchema2 = (String)tuple23._1();
                            String nameInHeader2 = (String)tuple23._2();
                            if (!caseSensitive) {
                                nameInSchema2 = nameInSchema2.toLowerCase();
                                nameInHeader2 = nameInHeader2.toLowerCase();
                            }
                            String string = nameInHeader2;
                            String string2 = nameInSchema2;
                            if (!(string == null ? string2 != null : !string.equals(string2))) continue;
                            errorMessage = new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|CSV header does not conform to the schema.\n                  | Header: ", "\n                  | Schema: ", "\n                  |Expected: ", " but found: ", "\n                  |CSV file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])columnNames).mkString(", "), fieldNames.mkString(", "), fieldNames.apply(i), columnNames[i], fileName})))).stripMargin());
                            continue;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                } else {
                    errorMessage = new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|Number of column in CSV header is not equal to number of fields in the schema:\n              | Header length: ", ", schema size: ", "\n              |CSV file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)headerLen2), BoxesRunTime.boxToInteger((int)schemaSize2), fileName})))).stripMargin());
                }
                errorMessage.foreach((Function1)new Serializable(enforceSchema){
                    public static final long serialVersionUID = 0L;
                    private final boolean enforceSchema$1;

                    public final void apply(String msg) {
                        if (this.enforceSchema$1) {
                            CSVDataSource$.MODULE$.logWarning((Function0<String>)new Serializable(this, msg){
                                public static final long serialVersionUID = 0L;
                                private final String msg$1;

                                public final String apply() {
                                    return this.msg$1;
                                }
                                {
                                    this.msg$1 = msg$1;
                                }
                            });
                            return;
                        }
                        throw new IllegalArgumentException(msg);
                    }
                    {
                        this.enforceSchema$1 = enforceSchema$1;
                    }
                });
            } else {
                throw new MatchError((Object)sp2);
            }
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CSVDataSource$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

