/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import com.univocity.parsers.csv.CsvParser;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.csv.CSVExprUtils$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.csv.UnivocityParser$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVInferSchema$;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.execution.datasources.text.TextFileFormat;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class TextInputCSVDataSource$
extends CSVDataSource {
    public static final TextInputCSVDataSource$ MODULE$;
    private final boolean isSplitable;

    static {
        new TextInputCSVDataSource$();
    }

    @Override
    public boolean isSplitable() {
        return this.isSplitable;
    }

    @Override
    public Iterator<InternalRow> readFile(Configuration conf, PartitionedFile file, UnivocityParser parser, StructType requiredSchema, StructType dataSchema, boolean caseSensitive, boolean columnPruning) {
        boolean hasHeader;
        HadoopFileLinesReader linesReader = new HadoopFileLinesReader(file, conf);
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new Serializable(linesReader){
            public static final long serialVersionUID = 0L;
            public final HadoopFileLinesReader linesReader$1;

            public final TaskContext apply(TaskContext x$5) {
                return x$5.addTaskCompletionListener((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.4 $outer;

                    public final void apply(TaskContext x$6) {
                        this.$outer.linesReader$1.close();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.linesReader$1 = linesReader$1;
            }
        });
        Iterator lines = linesReader.map(new Serializable(parser){
            public static final long serialVersionUID = 0L;
            private final UnivocityParser parser$1;

            public final String apply(Text line) {
                return new String(line.getBytes(), 0, line.getLength(), this.parser$1.options().charset());
            }
            {
                this.parser$1 = parser$1;
            }
        });
        boolean bl = hasHeader = parser.options().headerFlag() && file.start() == 0L;
        if (hasHeader) {
            CSVExprUtils$.MODULE$.extractHeader(lines, parser.options()).foreach((Function1)new Serializable(file, parser, requiredSchema, dataSchema, caseSensitive, columnPruning){
                public static final long serialVersionUID = 0L;
                private final PartitionedFile file$1;
                public final UnivocityParser parser$1;
                private final StructType requiredSchema$1;
                private final StructType dataSchema$1;
                private final boolean caseSensitive$2;
                private final boolean columnPruning$1;

                public final void apply(String header) {
                    StructType actualRequiredSchema = StructType$.MODULE$.apply((Seq)this.requiredSchema$1.filterNot((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.readFile.1 $outer;

                        public final boolean apply(StructField x$7) {
                            String string = x$7.name();
                            String string2 = this.$outer.parser$1.options().columnNameOfCorruptRecord();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                    StructType actualDataSchema = StructType$.MODULE$.apply((Seq)this.dataSchema$1.filterNot((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.readFile.1 $outer;

                        public final boolean apply(StructField x$8) {
                            String string = x$8.name();
                            String string2 = this.$outer.parser$1.options().columnNameOfCorruptRecord();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                    StructType schema2 = this.columnPruning$1 ? actualRequiredSchema : actualDataSchema;
                    String[] columnNames = this.parser$1.tokenizer().parseLine(header);
                    CSVDataSource$.MODULE$.checkHeaderColumnNames(schema2, columnNames, this.file$1.filePath(), this.parser$1.options().enforceSchema(), this.caseSensitive$2);
                }
                {
                    this.file$1 = file$1;
                    this.parser$1 = parser$1;
                    this.requiredSchema$1 = requiredSchema$1;
                    this.dataSchema$1 = dataSchema$1;
                    this.caseSensitive$2 = caseSensitive$2;
                    this.columnPruning$1 = columnPruning$1;
                }
            });
        }
        return UnivocityParser$.MODULE$.parseIterator(lines, parser, requiredSchema);
    }

    @Override
    public StructType infer(SparkSession sparkSession, Seq<FileStatus> inputPaths, CSVOptions parsedOptions) {
        Dataset<String> csv = this.createBaseDataset(sparkSession, inputPaths, parsedOptions);
        Option maybeFirstLine = Predef$.MODULE$.refArrayOps((Object[])CSVUtils$.MODULE$.filterCommentAndEmpty(csv, parsedOptions).take(1)).headOption();
        return this.inferFromDataset(sparkSession, csv, (Option<String>)maybeFirstLine, parsedOptions);
    }

    public StructType inferFromDataset(SparkSession sparkSession, Dataset<String> csv, Option<String> maybeFirstLine, CSVOptions parsedOptions) {
        StructType structType;
        Some some;
        String[] firstRow;
        CsvParser csvParser = new CsvParser(parsedOptions.asParserSettings());
        Option option = maybeFirstLine.map((Function1)new Serializable(csvParser){
            public static final long serialVersionUID = 0L;
            private final CsvParser csvParser$1;

            public final String[] apply(String x$9) {
                return this.csvParser$1.parseLine(x$9);
            }
            {
                this.csvParser$1 = csvParser$1;
            }
        });
        if (option instanceof Some && (firstRow = (String[])(some = (Some)option).x()) != null) {
            boolean caseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
            String[] header = this.makeSafeHeader(firstRow, caseSensitive, parsedOptions);
            Dataset<String> sampled = CSVUtils$.MODULE$.sample(csv, parsedOptions);
            RDD tokenRDD = sampled.rdd().mapPartitions((Function1)new Serializable(maybeFirstLine, parsedOptions){
                public static final long serialVersionUID = 0L;
                private final Option maybeFirstLine$1;
                private final CSVOptions parsedOptions$1;

                public final Iterator<String[]> apply(Iterator<String> iter) {
                    Iterator<String> filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty(iter, this.parsedOptions$1);
                    Iterator<String> linesWithoutHeader = CSVUtils$.MODULE$.filterHeaderLine(filteredLines, (String)this.maybeFirstLine$1.get(), this.parsedOptions$1);
                    CsvParser parser = new CsvParser(this.parsedOptions$1.asParserSettings());
                    return linesWithoutHeader.map((Function1)new Serializable(this, parser){
                        public static final long serialVersionUID = 0L;
                        private final CsvParser parser$2;

                        public final String[] apply(String x$1) {
                            return this.parser$2.parseLine(x$1);
                        }
                        {
                            this.parser$2 = parser$2;
                        }
                    });
                }
                {
                    this.maybeFirstLine$1 = maybeFirstLine$1;
                    this.parsedOptions$1 = parsedOptions$1;
                }
            }, sampled.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
            structType = CSVInferSchema$.MODULE$.infer((RDD<String[]>)tokenRDD, header, parsedOptions);
        } else {
            structType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        return structType;
    }

    private Dataset<String> createBaseDataset(SparkSession sparkSession, Seq<FileStatus> inputPaths, CSVOptions options) {
        Dataset<String> dataset;
        Seq paths = (Seq)inputPaths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$10) {
                return x$10.getPath().toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Charset charset = Charset.forName(options.charset());
        Charset charset2 = StandardCharsets.UTF_8;
        if (!(charset != null ? !((Object)charset).equals(charset2) : charset2 != null)) {
            SparkSession x$15 = sparkSession;
            Seq x$16 = paths;
            String x$17 = TextFileFormat.class.getName();
            CaseInsensitiveMap x$18 = options.parameters();
            Option<StructType> x$19 = DataSource$.MODULE$.apply$default$4();
            Seq<String> x$20 = DataSource$.MODULE$.apply$default$5();
            Option<BucketSpec> x$21 = DataSource$.MODULE$.apply$default$6();
            Option<CatalogTable> x$22 = DataSource$.MODULE$.apply$default$8();
            dataset = sparkSession.baseRelationToDataFrame(new DataSource(x$15, x$17, (Seq<String>)x$16, x$19, x$20, x$21, (Map<String, String>)x$18, x$22).resolveRelation(false)).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(Encoders$.MODULE$.STRING());
        } else {
            String charset3 = options.charset();
            RDD qual$1 = sparkSession.sparkContext().hadoopFile(paths.mkString(","), ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(Text.class), ClassTag$.MODULE$.apply(TextInputFormat.class));
            Serializable x$23 = new Serializable(charset3){
                public static final long serialVersionUID = 0L;
                public final String charset$1;

                public final Iterator<String> apply(Iterator<Tuple2<LongWritable, Text>> x$11) {
                    return x$11.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.11 $outer;

                        public final String apply(Tuple2<LongWritable, Text> pair) {
                            return new String(((Text)pair._2()).getBytes(), 0, ((Text)pair._2()).getLength(), this.$outer.charset$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.charset$1 = charset$1;
                }
            };
            boolean x$24 = qual$1.mapPartitions$default$2();
            RDD rdd2 = qual$1.mapPartitions((Function1)x$23, x$24, ClassTag$.MODULE$.apply(String.class));
            dataset = sparkSession.createDataset(rdd2, Encoders$.MODULE$.STRING());
        }
        return dataset;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TextInputCSVDataSource$() {
        MODULE$ = this;
        this.isSplitable = true;
    }
}

