/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Text;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JsonInferSchema$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource;
import org.apache.spark.sql.execution.datasources.json.JsonUtils$;
import org.apache.spark.sql.execution.datasources.json.TextInputJsonDataSource$;
import org.apache.spark.sql.execution.datasources.text.TextFileFormat;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;

public final class TextInputJsonDataSource$
extends JsonDataSource {
    public static final TextInputJsonDataSource$ MODULE$;
    private final boolean isSplitable;

    static {
        new TextInputJsonDataSource$();
    }

    @Override
    public boolean isSplitable() {
        return this.isSplitable;
    }

    @Override
    public StructType infer(SparkSession sparkSession, Seq<FileStatus> inputPaths, JSONOptions parsedOptions) {
        Dataset<String> json = this.createBaseDataset(sparkSession, inputPaths, parsedOptions);
        return this.inferFromDataset(json, parsedOptions);
    }

    public StructType inferFromDataset(Dataset<String> json, JSONOptions parsedOptions) {
        Dataset<String> sampled = JsonUtils$.MODULE$.sample(json, parsedOptions);
        RDD<InternalRow> rdd2 = sampled.queryExecution().toRdd();
        Function2 rowParser = (Function2)parsedOptions.encoding().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function2<JsonFactory, InternalRow, JsonParser> apply(String enc) {
                return new Serializable(this, enc){
                    public static final long serialVersionUID = 0L;
                    private final String enc$1;

                    public final JsonParser apply(JsonFactory x$1, InternalRow x$2) {
                        return CreateJacksonParser$.MODULE$.internalRow(this.enc$1, x$1, x$2);
                    }
                    {
                        this.enc$1 = enc$1;
                    }
                };
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function2<JsonFactory, InternalRow, JsonParser> apply() {
                return new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonParser apply(JsonFactory x$3, InternalRow x$4) {
                        return CreateJacksonParser$.MODULE$.internalRow(x$3, x$4);
                    }
                };
            }
        });
        return (StructType)SQLExecution$.MODULE$.withSQLConfPropagated(json.sparkSession(), new Serializable(parsedOptions, rdd2, rowParser){
            public static final long serialVersionUID = 0L;
            private final JSONOptions parsedOptions$1;
            private final RDD rdd$1;
            private final Function2 rowParser$1;

            public final StructType apply() {
                return JsonInferSchema$.MODULE$.infer(this.rdd$1, this.parsedOptions$1, this.rowParser$1);
            }
            {
                this.parsedOptions$1 = parsedOptions$1;
                this.rdd$1 = rdd$1;
                this.rowParser$1 = rowParser$1;
            }
        });
    }

    private Dataset<String> createBaseDataset(SparkSession sparkSession, Seq<FileStatus> inputPaths, JSONOptions parsedOptions) {
        SparkSession x$21 = sparkSession;
        Seq x$22 = (Seq)inputPaths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$5) {
                return x$5.getPath().toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        String x$23 = TextFileFormat.class.getName();
        CaseInsensitiveMap x$24 = parsedOptions.parameters();
        Option<StructType> x$25 = DataSource$.MODULE$.apply$default$4();
        Seq<String> x$26 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$27 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$28 = DataSource$.MODULE$.apply$default$8();
        return sparkSession.baseRelationToDataFrame(new DataSource(x$21, x$23, (Seq<String>)x$22, x$25, x$26, x$27, (Map<String, String>)x$24, x$28).resolveRelation(false)).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(Encoders$.MODULE$.STRING());
    }

    @Override
    public Iterator<InternalRow> readFile(Configuration conf, PartitionedFile file, JacksonParser parser, StructType schema2) {
        HadoopFileLinesReader linesReader = new HadoopFileLinesReader(file, (Option<byte[]>)parser.options().lineSeparatorInRead(), conf);
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new Serializable(linesReader){
            public static final long serialVersionUID = 0L;
            public final HadoopFileLinesReader linesReader$1;

            public final TaskContext apply(TaskContext x$6) {
                return x$6.addTaskCompletionListener((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.readFile.1 $outer;

                    public final void apply(TaskContext x$7) {
                        this.$outer.linesReader$1.close();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.linesReader$1 = linesReader$1;
            }
        });
        Function2 textParser = (Function2)parser.options().encoding().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function2<JsonFactory, Text, JsonParser> apply(String enc) {
                return new Serializable(this, enc){
                    public static final long serialVersionUID = 0L;
                    private final String enc$2;

                    public final JsonParser apply(JsonFactory x$8, Text x$9) {
                        return CreateJacksonParser$.MODULE$.text(this.enc$2, x$8, x$9);
                    }
                    {
                        this.enc$2 = enc$2;
                    }
                };
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function2<JsonFactory, Text, JsonParser> apply() {
                return new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonParser apply(JsonFactory x$10, Text x$11) {
                        return CreateJacksonParser$.MODULE$.text(x$10, x$11);
                    }
                };
            }
        });
        FailureSafeParser safeParser = new FailureSafeParser((Function1)new Serializable(parser, textParser){
            public static final long serialVersionUID = 0L;
            private final JacksonParser parser$1;
            private final Function2 textParser$1;

            public final Seq<InternalRow> apply(Text input) {
                return this.parser$1.parse((Object)input, this.textParser$1, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final UTF8String apply(Text value) {
                        return TextInputJsonDataSource$.MODULE$.org$apache$spark$sql$execution$datasources$json$TextInputJsonDataSource$$textToUTF8String(value);
                    }
                });
            }
            {
                this.parser$1 = parser$1;
                this.textParser$1 = textParser$1;
            }
        }, parser.options().parseMode(), schema2, parser.options().columnNameOfCorruptRecord());
        return linesReader.flatMap(new Serializable(safeParser){
            public static final long serialVersionUID = 0L;
            private final FailureSafeParser safeParser$1;

            public final Iterator<InternalRow> apply(Text input) {
                return this.safeParser$1.parse((Object)input);
            }
            {
                this.safeParser$1 = safeParser$1;
            }
        });
    }

    public UTF8String org$apache$spark$sql$execution$datasources$json$TextInputJsonDataSource$$textToUTF8String(Text value) {
        return UTF8String.fromBytes((byte[])value.getBytes(), (int)0, (int)value.getLength());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TextInputJsonDataSource$() {
        MODULE$ = this;
        this.isSplitable = true;
    }
}

