/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.util.Locale;
import java.util.Optional;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelation$;
import org.apache.spark.sql.execution.streaming.StreamingRelationV2;
import org.apache.spark.sql.sources.StreamSourceProvider;
import org.apache.spark.sql.sources.v2.ContinuousReadSupport;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.MicroBatchReadSupport;
import org.apache.spark.sql.sources.v2.reader.streaming.ContinuousReader;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Evolving
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u00055\u0011\u0001\u0003R1uCN#(/Z1n%\u0016\fG-\u001a:\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005e1\"a\u0002'pO\u001eLgn\u001a\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005a1\u000f]1sWN+7o]5p]B\u0011QDH\u0007\u0002\t%\u0011q\u0004\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\u0007C\u0001!\t\u0001\u0002\u0012\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\t!\u0001C\u0003\u001cA\u0001\u0007A\u0004C\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004g_Jl\u0017\r\u001e\u000b\u0003G%BQA\u000b\u0014A\u0002-\naa]8ve\u000e,\u0007C\u0001\u00170\u001d\tyQ&\u0003\u0002/!\u00051\u0001K]3eK\u001aL!\u0001M\u0019\u0003\rM#(/\u001b8h\u0015\tq\u0003\u0003C\u00034\u0001\u0011\u0005A'\u0001\u0004tG\",W.\u0019\u000b\u0003GUBQa\r\u001aA\u0002Y\u0002\"a\u000e\u001e\u000e\u0003aR!!\u000f\u0003\u0002\u000bQL\b/Z:\n\u0005mB$AC*ueV\u001cG\u000fV=qK\")1\u0007\u0001C\u0001{Q\u00111E\u0010\u0005\u0006\u007fq\u0002\raK\u0001\rg\u000eDW-\\1TiJLgn\u001a\u0005\u0006\u0003\u0002!\tAQ\u0001\u0007_B$\u0018n\u001c8\u0015\u0007\r\u001aU\tC\u0003E\u0001\u0002\u00071&A\u0002lKfDQA\u0012!A\u0002-\nQA^1mk\u0016DQ!\u0011\u0001\u0005\u0002!#2aI%K\u0011\u0015!u\t1\u0001,\u0011\u00151u\t1\u0001L!\tyA*\u0003\u0002N!\t9!i\\8mK\u0006t\u0007\"B!\u0001\t\u0003yEcA\u0012Q#\")AI\u0014a\u0001W!)aI\u0014a\u0001%B\u0011qbU\u0005\u0003)B\u0011A\u0001T8oO\")\u0011\t\u0001C\u0001-R\u00191e\u0016-\t\u000b\u0011+\u0006\u0019A\u0016\t\u000b\u0019+\u0006\u0019A-\u0011\u0005=Q\u0016BA.\u0011\u0005\u0019!u.\u001e2mK\")Q\f\u0001C\u0001=\u00069q\u000e\u001d;j_:\u001cHCA\u0012`\u0011\u0015iF\f1\u0001a!\u0011\tGmK\u0016\u000e\u0003\tT!a\u0019\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002fE\n\u0019Q*\u00199\t\u000bu\u0003A\u0011A4\u0015\u0005\rB\u0007\"B/g\u0001\u0004I\u0007\u0003\u00026pW-j\u0011a\u001b\u0006\u0003Y6\fA!\u001e;jY*\ta.\u0001\u0003kCZ\f\u0017BA3l\u0011\u0015\t\b\u0001\"\u0001s\u0003\u0011aw.\u00193\u0015\u0003M\u00042\u0001^A\u0003\u001d\r)\u0018\u0011\u0001\b\u0003m~t!a\u001e@\u000f\u0005alhBA=}\u001b\u0005Q(BA>\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I1!a\u0001\u0005\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0002\u0002\n\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0003\u0007!\u0001BB9\u0001\t\u0003\ti\u0001F\u0002t\u0003\u001fAq!!\u0005\u0002\f\u0001\u00071&\u0001\u0003qCRD\u0007bBA\u000b\u0001\u0011\u0005\u0011qC\u0001\u0005UN|g\u000eF\u0002t\u00033Aq!!\u0005\u0002\u0014\u0001\u00071\u0006C\u0004\u0002\u001e\u0001!\t!a\b\u0002\u0007\r\u001ch\u000fF\u0002t\u0003CAq!!\u0005\u0002\u001c\u0001\u00071\u0006C\u0004\u0002&\u0001!\t!a\n\u0002\u0007=\u00148\rF\u0002t\u0003SAq!!\u0005\u0002$\u0001\u00071\u0006C\u0004\u0002.\u0001!\t!a\f\u0002\u000fA\f'/];fiR\u00191/!\r\t\u000f\u0005E\u00111\u0006a\u0001W!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0012\u0001\u0002;fqR$2a]A\u001d\u0011\u001d\t\t\"a\rA\u0002-Bq!!\u0010\u0001\t\u0003\ty$\u0001\u0005uKb$h)\u001b7f)\u0011\t\t%a\u0012\u0011\tu\t\u0019eK\u0005\u0004\u0003\u000b\"!a\u0002#bi\u0006\u001cX\r\u001e\u0005\b\u0003#\tY\u00041\u0001,\u0011!Q\u0003\u00011A\u0005\n\u0005-S#A\u0016\t\u0013\u0005=\u0003\u00011A\u0005\n\u0005E\u0013AC:pkJ\u001cWm\u0018\u0013fcR!\u00111KA-!\ry\u0011QK\u0005\u0004\u0003/\u0002\"\u0001B+oSRD\u0011\"a\u0017\u0002N\u0005\u0005\t\u0019A\u0016\u0002\u0007a$\u0013\u0007C\u0004\u0002`\u0001\u0001\u000b\u0015B\u0016\u0002\u000fM|WO]2fA!I\u00111\r\u0001A\u0002\u0013%\u0011QM\u0001\u0014kN,'o\u00159fG&4\u0017.\u001a3TG\",W.Y\u000b\u0003\u0003O\u0002BaDA5m%\u0019\u00111\u000e\t\u0003\r=\u0003H/[8o\u0011%\ty\u0007\u0001a\u0001\n\u0013\t\t(A\fvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017m\u0018\u0013fcR!\u00111KA:\u0011)\tY&!\u001c\u0002\u0002\u0003\u0007\u0011q\r\u0005\t\u0003o\u0002\u0001\u0015)\u0003\u0002h\u0005!Ro]3s'B,7-\u001b4jK\u0012\u001c6\r[3nC\u0002B\u0011\"a\u001f\u0001\u0001\u0004%I!! \u0002\u0019\u0015DHO]1PaRLwN\\:\u0016\u0005\u0005}\u0004CBAA\u0003\u000f[3&\u0004\u0002\u0002\u0004*\u0019\u0011Q\u00112\u0002\u000f5,H/\u00192mK&!\u0011\u0011RAB\u0005\u001dA\u0015m\u001d5NCBD\u0011\"!$\u0001\u0001\u0004%I!a$\u0002!\u0015DHO]1PaRLwN\\:`I\u0015\fH\u0003BA*\u0003#C!\"a\u0017\u0002\f\u0006\u0005\t\u0019AA@\u0011!\t)\n\u0001Q!\n\u0005}\u0014!D3yiJ\fw\n\u001d;j_:\u001c\b\u0005K\u0002\u0001\u00033\u0003B!a'\u0002(:!\u0011QTAR\u001b\t\tyJC\u0002\u0002\"\u001a\t!\"\u00198o_R\fG/[8o\u0013\u0011\t)+a(\u0002%%sG/\u001a:gC\u000e,7\u000b^1cS2LG/_\u0005\u0005\u0003S\u000bYK\u0001\u0005Fm>dg/\u001b8h\u0015\u0011\t)+a(")
public final class DataStreamReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private HashMap<String, String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public DataStreamReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamReader schema(StructType schema2) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema2));
        return this;
    }

    public DataStreamReader schema(String schemaString2) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)StructType$.MODULE$.fromDDL(schemaString2)));
        return this;
    }

    public DataStreamReader option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataStreamReader option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataStreamReader option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataStreamReader option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataStreamReader options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataStreamReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Dataset<Row> load() {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (string == null) {
            if (string2 == null) throw new AnalysisException("Hive data source can only be used with tables, you can not read files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        } else if (string.equals(string2)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not read files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Object ds = DataSource$.MODULE$.lookupDataSource(this.source(), this.sparkSession.sqlContext().conf()).newInstance();
        SparkSession x$1 = this.sparkSession;
        Option<StructType> x$2 = this.userSpecifiedSchema();
        String x$3 = this.source();
        scala.collection.immutable.Map x$4 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource v1DataSource = new DataSource(x$1, x$3, x$5, x$2, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$4, x$8);
        Object obj = ds;
        Object object = obj instanceof StreamSourceProvider ? new Some((Object)StreamingRelation$.MODULE$.apply(v1DataSource)) : None$.MODULE$;
        None$ v1Relation = object;
        Object obj2 = ds;
        if (obj2 instanceof MicroBatchReadSupport) {
            StructType structType;
            scala.collection.immutable.Map options;
            MicroBatchReadSupport microBatchReadSupport;
            block6: {
                microBatchReadSupport = (MicroBatchReadSupport)obj2;
                scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(microBatchReadSupport, this.sparkSession.sessionState().conf());
                options = sessionOptions.$plus$plus(this.extraOptions());
                DataSourceOptions dataSourceOptions = new DataSourceOptions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options).asJava());
                MicroBatchReader tempReader = null;
                try {
                    String x$9 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"temporaryReader"})).s((Seq)Nil$.MODULE$);
                    String x$10 = Utils$.MODULE$.createTempDir$default$1();
                    tempReader = microBatchReadSupport.createMicroBatchReader(Optional.ofNullable(this.userSpecifiedSchema().orNull(Predef$.MODULE$.$conforms())), Utils$.MODULE$.createTempDir(x$10, x$9).getCanonicalPath(), dataSourceOptions);
                    structType = tempReader.readSchema();
                    if (tempReader == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var21_20;
                    if (var21_20 == null) throw throwable;
                    var21_20.stop();
                    var21_20 = null;
                    throw throwable;
                }
                tempReader.stop();
                tempReader = null;
            }
            StructType schema2 = structType;
            return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new StreamingRelationV2(microBatchReadSupport, this.source(), (scala.collection.immutable.Map<String, String>)options, (Seq<Attribute>)schema2.toAttributes(), (Option<StreamingRelation>)v1Relation, this.sparkSession));
        }
        if (!(obj2 instanceof ContinuousReadSupport)) return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)StreamingRelation$.MODULE$.apply(v1DataSource));
        ContinuousReadSupport continuousReadSupport = (ContinuousReadSupport)obj2;
        scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(continuousReadSupport, this.sparkSession.sessionState().conf());
        scala.collection.immutable.Map options = sessionOptions.$plus$plus(this.extraOptions());
        DataSourceOptions dataSourceOptions = new DataSourceOptions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options).asJava());
        String x$11 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"temporaryReader"})).s((Seq)Nil$.MODULE$);
        String x$12 = Utils$.MODULE$.createTempDir$default$1();
        ContinuousReader tempReader = continuousReadSupport.createContinuousReader(Optional.ofNullable(this.userSpecifiedSchema().orNull(Predef$.MODULE$.$conforms())), Utils$.MODULE$.createTempDir(x$12, x$11).getCanonicalPath(), dataSourceOptions);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new StreamingRelationV2(continuousReadSupport, this.source(), (scala.collection.immutable.Map<String, String>)options, (Seq<Attribute>)tempReader.readSchema().toAttributes(), (Option<StreamingRelation>)v1Relation, this.sparkSession));
    }

    public Dataset<Row> load(String path) {
        return this.option("path", path).load();
    }

    public Dataset<Row> json(String path) {
        return this.format("json").load(path);
    }

    public Dataset<Row> csv(String path) {
        return this.format("csv").load(path);
    }

    public Dataset<Row> orc(String path) {
        return this.format("orc").load(path);
    }

    public Dataset<Row> parquet(String path) {
        return this.format("parquet").load(path);
    }

    public Dataset<Row> text(String path) {
        return this.format("text").load(path);
    }

    public Dataset<String> textFile(String path) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw new AnalysisException("User specified schema not supported with `textFile`", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.text(path).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(this.sparkSession.implicits().newStringEncoder());
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(HashMap<String, String> x$1) {
        this.extraOptions = x$1;
    }

    public DataStreamReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.class.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = new HashMap();
    }
}

