/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.csv.CSVExprUtils$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class CSVUtils$ {
    public static final CSVUtils$ MODULE$;

    static {
        new CSVUtils$();
    }

    public Dataset<String> filterCommentAndEmpty(Dataset<String> lines, CSVOptions options) {
        Dataset<String> nonEmptyLines = lines.filter(functions$.MODULE$.length(functions$.MODULE$.trim(lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq<Object>)Nil$.MODULE$))).$greater(BoxesRunTime.boxToInteger((int)0)));
        return options.isCommentSet() ? nonEmptyLines.filter(lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq<Object>)Nil$.MODULE$).startsWith(((Object)BoxesRunTime.boxToCharacter((char)options.comment())).toString()).unary_$bang()) : nonEmptyLines;
    }

    public Iterator<String> filterHeaderLine(Iterator<String> iter, String firstLine, CSVOptions options) {
        return options.headerFlag() ? iter.filterNot((Function1)new Serializable(firstLine){
            public static final long serialVersionUID = 0L;
            private final String firstLine$1;

            public final boolean apply(String x$1) {
                String string = x$1;
                String string2 = this.firstLine$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.firstLine$1 = firstLine$1;
            }
        }) : iter;
    }

    public Dataset<String> sample(Dataset<String> csv, CSVOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final CSVOptions options$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"samplingRatio (", ") should be greater than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.options$2.samplingRatio())}));
            }
            {
                this.options$2 = options$2;
            }
        });
        return options.samplingRatio() > 0.99 ? csv : csv.sample(false, options.samplingRatio(), 1L);
    }

    public RDD<String[]> sample(RDD<String[]> csv, CSVOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final CSVOptions options$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"samplingRatio (", ") should be greater than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.options$1.samplingRatio())}));
            }
            {
                this.options$1 = options$1;
            }
        });
        return options.samplingRatio() > 0.99 ? csv : csv.sample(false, options.samplingRatio(), 1L);
    }

    public Iterator<String> filterCommentAndEmpty(Iterator<String> iter, CSVOptions options) {
        return CSVExprUtils$.MODULE$.filterCommentAndEmpty(iter, options);
    }

    private CSVUtils$() {
        MODULE$ = this;
    }
}

