/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import java.util.Optional;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.execution.streaming.continuous.TextSocketContinuousReader;
import org.apache.spark.sql.execution.streaming.sources.TextSocketMicroBatchReader;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.v2.ContinuousReadSupport;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.MicroBatchReadSupport;
import org.apache.spark.sql.sources.v2.reader.streaming.ContinuousReader;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001#\tAB+\u001a=u'>\u001c7.\u001a;T_V\u00148-\u001a)s_ZLG-\u001a:\u000b\u0005\r!\u0011aB:pkJ\u001cWm\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!C3yK\u000e,H/[8o\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\u001d\u0001!CG\u0011%O-\u0002\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\t1\fgn\u001a\u0006\u0002/\u0005!!.\u0019<b\u0013\tIBC\u0001\u0004PE*,7\r\u001e\t\u00037}i\u0011\u0001\b\u0006\u0003;y\t!A\u001e\u001a\u000b\u0005\rA\u0011B\u0001\u0011\u001d\u00051!\u0015\r^1T_V\u00148-\u001a,3!\tY\"%\u0003\u0002$9\t)R*[2s_\n\u000bGo\u00195SK\u0006$7+\u001e9q_J$\bCA\u000e&\u0013\t1CDA\u000bD_:$\u0018N\\;pkN\u0014V-\u00193TkB\u0004xN\u001d;\u0011\u0005!JS\"\u0001\u0010\n\u0005)r\"A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\u0004\"\u0001L\u0018\u000e\u00035R!A\f\u0006\u0002\u0011%tG/\u001a:oC2L!\u0001M\u0017\u0003\u000f1{wmZ5oO\")!\u0007\u0001C\u0001g\u00051A(\u001b8jiz\"\u0012\u0001\u000e\t\u0003k\u0001i\u0011A\u0001\u0005\u0006o\u0001!I\u0001O\u0001\u0010G\",7m\u001b)be\u0006lW\r^3sgR\u0011\u0011h\u0010\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\u0005+:LG\u000fC\u0003Am\u0001\u0007\u0011)\u0001\u0004qCJ\fWn\u001d\t\u00037\tK!a\u0011\u000f\u0003#\u0011\u000bG/Y*pkJ\u001cWm\u00149uS>t7\u000fC\u0003F\u0001\u0011\u0005c)\u0001\fde\u0016\fG/Z'jGJ|')\u0019;dQJ+\u0017\rZ3s)\u00119e\nX3\u0011\u0005!cU\"A%\u000b\u0005\u0015Q%BA&\u001d\u0003\u0019\u0011X-\u00193fe&\u0011Q*\u0013\u0002\u0011\u001b&\u001c'o\u001c\"bi\u000eD'+Z1eKJDQa\u0014#A\u0002A\u000baa]2iK6\f\u0007cA)U-6\t!K\u0003\u0002T-\u0005!Q\u000f^5m\u0013\t)&K\u0001\u0005PaRLwN\\1m!\t9&,D\u0001Y\u0015\tI\u0006\"A\u0003usB,7/\u0003\u0002\\1\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000bu#\u0005\u0019\u00010\u0002%\rDWmY6q_&tG\u000fT8dCRLwN\u001c\t\u0003?\nt!A\u000f1\n\u0005\u0005\\\u0014A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!Y\u001e\t\u000b\u0019$\u0005\u0019A!\u0002\u000f=\u0004H/[8og\")\u0001\u000e\u0001C!S\u000612M]3bi\u0016\u001cuN\u001c;j]V|Wo\u001d*fC\u0012,'\u000f\u0006\u0003k[:|\u0007C\u0001%l\u0013\ta\u0017J\u0001\tD_:$\u0018N\\;pkN\u0014V-\u00193fe\")qj\u001aa\u0001!\")Ql\u001aa\u0001=\")am\u001aa\u0001\u0003\")\u0011\u000f\u0001C!e\u0006I1\u000f[8si:\u000bW.\u001a\u000b\u0002=\u0002")
public class TextSocketSourceProvider
implements MicroBatchReadSupport,
ContinuousReadSupport,
DataSourceRegister,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private void checkParameters(DataSourceOptions params) {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The socket source should not be used for production applications! It does not support recovery.";
            }
        });
        if (params.get("host").isPresent()) {
            if (params.get("port").isPresent()) {
                Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, params){
                    public static final long serialVersionUID = 0L;
                    private final DataSourceOptions params$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return new StringOps(Predef$.MODULE$.augmentString(this.params$1.get("includeTimestamp").orElse("false"))).toBoolean();
                    }
                    {
                        this.params$1 = params$1;
                    }
                });
                if (try_ instanceof Success) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (try_ instanceof Failure) {
                    throw new AnalysisException("includeTimestamp must be set to either \"true\" or \"false\"", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                throw new MatchError((Object)try_);
            }
            throw new AnalysisException("Set a port to read from with option(\"port\", ...).", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        throw new AnalysisException("Set a host to read from with option(\"host\", ...).", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    @Override
    public MicroBatchReader createMicroBatchReader(Optional<StructType> schema2, String checkpointLocation, DataSourceOptions options) {
        this.checkParameters(options);
        if (schema2.isPresent()) {
            throw new AnalysisException("The socket source does not support a user-specified schema.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return new TextSocketMicroBatchReader(options);
    }

    @Override
    public ContinuousReader createContinuousReader(Optional<StructType> schema2, String checkpointLocation, DataSourceOptions options) {
        this.checkParameters(options);
        if (schema2.isPresent()) {
            throw new AnalysisException("The socket source does not support a user-specified schema.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return new TextSocketContinuousReader(options);
    }

    @Override
    public String shortName() {
        return "socket";
    }

    public TextSocketSourceProvider() {
        Logging.class.$init$((Logging)this);
    }
}

