/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.SpecializedGettersReader;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.sql.vectorized.ColumnarRow;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

@InterfaceStability.Evolving
public final class ColumnarArray
extends ArrayData {
    private final ColumnVector data;
    private final int offset;
    private final int length;

    public ColumnarArray(ColumnVector data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public int numElements() {
        return this.length;
    }

    public ArrayData copy() {
        throw new UnsupportedOperationException();
    }

    public boolean[] toBooleanArray() {
        return this.data.getBooleans(this.offset, this.length);
    }

    public byte[] toByteArray() {
        return this.data.getBytes(this.offset, this.length);
    }

    public short[] toShortArray() {
        return this.data.getShorts(this.offset, this.length);
    }

    public int[] toIntArray() {
        return this.data.getInts(this.offset, this.length);
    }

    public long[] toLongArray() {
        return this.data.getLongs(this.offset, this.length);
    }

    public float[] toFloatArray() {
        return this.data.getFloats(this.offset, this.length);
    }

    public double[] toDoubleArray() {
        return this.data.getDoubles(this.offset, this.length);
    }

    public Object[] array() {
        DataType dt = this.data.dataType();
        Object[] list = new Object[this.length];
        try {
            for (int i = 0; i < this.length; ++i) {
                if (this.data.isNullAt(this.offset + i)) continue;
                list[i] = this.get(i, dt);
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get the array", e);
        }
    }

    public boolean isNullAt(int ordinal) {
        return this.data.isNullAt(this.offset + ordinal);
    }

    public boolean getBoolean(int ordinal) {
        return this.data.getBoolean(this.offset + ordinal);
    }

    public byte getByte(int ordinal) {
        return this.data.getByte(this.offset + ordinal);
    }

    public short getShort(int ordinal) {
        return this.data.getShort(this.offset + ordinal);
    }

    public int getInt(int ordinal) {
        return this.data.getInt(this.offset + ordinal);
    }

    public long getLong(int ordinal) {
        return this.data.getLong(this.offset + ordinal);
    }

    public float getFloat(int ordinal) {
        return this.data.getFloat(this.offset + ordinal);
    }

    public double getDouble(int ordinal) {
        return this.data.getDouble(this.offset + ordinal);
    }

    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return this.data.getDecimal(this.offset + ordinal, precision, scale);
    }

    public UTF8String getUTF8String(int ordinal) {
        return this.data.getUTF8String(this.offset + ordinal);
    }

    public byte[] getBinary(int ordinal) {
        return this.data.getBinary(this.offset + ordinal);
    }

    public CalendarInterval getInterval(int ordinal) {
        return this.data.getInterval(this.offset + ordinal);
    }

    public ColumnarRow getStruct(int ordinal, int numFields) {
        return this.data.getStruct(this.offset + ordinal);
    }

    public ColumnarArray getArray(int ordinal) {
        return this.data.getArray(this.offset + ordinal);
    }

    public ColumnarMap getMap(int ordinal) {
        return this.data.getMap(this.offset + ordinal);
    }

    public Object get(int ordinal, DataType dataType) {
        return SpecializedGettersReader.read((SpecializedGetters)this, (int)ordinal, (DataType)dataType, (boolean)false, (boolean)false);
    }

    public void update(int ordinal, Object value) {
        throw new UnsupportedOperationException();
    }

    public void setNullAt(int ordinal) {
        throw new UnsupportedOperationException();
    }
}

