/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.net.URI;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.AccessInfo;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.CreateDataSourceTableCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand$class;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001>\u0011Ad\u0011:fCR,G)\u0019;b'>,(oY3UC\ndWmQ8n[\u0006tGM\u0003\u0002\u0004\t\u000591m\\7nC:$'BA\u0003\u0007\u0003%)\u00070Z2vi&|gN\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!iqB\u0005\u0005\u0002\u001215\t!C\u0003\u0002\u0014)\u00059An\\4jG\u0006d'BA\u000b\u0017\u0003\u0015\u0001H.\u00198t\u0015\t9b!\u0001\u0005dCR\fG._:u\u0013\tI\"CA\u0006M_\u001eL7-\u00197QY\u0006t\u0007CA\u000e\u001d\u001b\u0005\u0011\u0011BA\u000f\u0003\u0005=\u0011VO\u001c8bE2,7i\\7nC:$\u0007CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#a\u0002)s_\u0012,8\r\u001e\t\u0003?\u0015J!A\n\u0011\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011!\u0002!Q3A\u0005\u0002%\nQ\u0001^1cY\u0016,\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0003[Y\tqaY1uC2|w-\u0003\u00020Y\ta1)\u0019;bY><G+\u00192mK\"A\u0011\u0007\u0001B\tB\u0003%!&\u0001\u0004uC\ndW\r\t\u0005\tg\u0001\u0011)\u001a!C\u0001i\u0005q\u0011n\u001a8pe\u0016Le-\u0012=jgR\u001cX#A\u001b\u0011\u0005}1\u0014BA\u001c!\u0005\u001d\u0011un\u001c7fC:D\u0001\"\u000f\u0001\u0003\u0012\u0003\u0006I!N\u0001\u0010S\u001etwN]3JM\u0016C\u0018n\u001d;tA!)1\b\u0001C\u0001y\u00051A(\u001b8jiz\"2!\u0010 @!\tY\u0002\u0001C\u0003)u\u0001\u0007!\u0006C\u00034u\u0001\u0007Q\u0007C\u0003B\u0001\u0011\u0005#)A\u0002sk:$\"aQ*\u0011\u0007\u0011cuJ\u0004\u0002F\u0015:\u0011a)S\u0007\u0002\u000f*\u0011\u0001JD\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!a\u0013\u0011\u0002\u000fA\f7m[1hK&\u0011QJ\u0014\u0002\u0004'\u0016\f(BA&!!\t\u0001\u0016+D\u0001\u0007\u0013\t\u0011fAA\u0002S_^DQ\u0001\u0016!A\u0002U\u000bAb\u001d9be.\u001cVm]:j_:\u0004\"\u0001\u0015,\n\u0005]3!\u0001D*qCJ\\7+Z:tS>t\u0007bB-\u0001\u0003\u0003%\tAW\u0001\u0005G>\u0004\u0018\u0010F\u0002>7rCq\u0001\u000b-\u0011\u0002\u0003\u0007!\u0006C\u000441B\u0005\t\u0019A\u001b\t\u000fy\u0003\u0011\u0013!C\u0001?\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00011+\u0005)\n7&\u00012\u0011\u0005\rDW\"\u00013\u000b\u0005\u00154\u0017!C;oG\",7m[3e\u0015\t9\u0007%\u0001\u0006b]:|G/\u0019;j_:L!!\u001b3\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004l\u0001E\u0005I\u0011\u00017\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\tQN\u000b\u00026C\"9q\u000eAA\u0001\n\u0003\u0002\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001r!\t\u0011x/D\u0001t\u0015\t!X/\u0001\u0003mC:<'\"\u0001<\u0002\t)\fg/Y\u0005\u0003qN\u0014aa\u0015;sS:<\u0007b\u0002>\u0001\u0003\u0003%\ta_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002yB\u0011q$`\u0005\u0003}\u0002\u00121!\u00138u\u0011%\t\t\u0001AA\u0001\n\u0003\t\u0019!\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015\u00111\u0002\t\u0004?\u0005\u001d\u0011bAA\u0005A\t\u0019\u0011I\\=\t\u0011\u00055q0!AA\u0002q\f1\u0001\u001f\u00132\u0011%\t\t\u0002AA\u0001\n\u0003\n\u0019\"A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u0002\u0005\u0004\u0002\u0018\u0005u\u0011QA\u0007\u0003\u00033Q1!a\u0007!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\tIB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\u0019\u0003AA\u0001\n\u0003\t)#\u0001\u0005dC:,\u0015/^1m)\r)\u0014q\u0005\u0005\u000b\u0003\u001b\t\t#!AA\u0002\u0005\u0015\u0001\"CA\u0016\u0001\u0005\u0005I\u0011IA\u0017\u0003\u0019)\u0017/^1mgR\u0019Q'a\f\t\u0015\u00055\u0011\u0011FA\u0001\u0002\u0004\t)aB\u0005\u00024\t\t\t\u0011#\u0001\u00026\u0005a2I]3bi\u0016$\u0015\r^1T_V\u00148-\u001a+bE2,7i\\7nC:$\u0007cA\u000e\u00028\u0019A\u0011AAA\u0001\u0012\u0003\tIdE\u0003\u00028\u0005mB\u0005E\u0004\u0002>\u0005\r#&N\u001f\u000e\u0005\u0005}\"bAA!A\u00059!/\u001e8uS6,\u0017\u0002BA#\u0003\u007f\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001dY\u0014q\u0007C\u0001\u0003\u0013\"\"!!\u000e\t\u0015\u00055\u0013qGA\u0001\n\u000b\ny%\u0001\u0005u_N#(/\u001b8h)\u0005\t\bBCA*\u0003o\t\t\u0011\"!\u0002V\u0005)\u0011\r\u001d9msR)Q(a\u0016\u0002Z!1\u0001&!\u0015A\u0002)BaaMA)\u0001\u0004)\u0004BCA/\u0003o\t\t\u0011\"!\u0002`\u00059QO\\1qa2LH\u0003BA1\u0003[\u0002RaHA2\u0003OJ1!!\u001a!\u0005\u0019y\u0005\u000f^5p]B)q$!\u001b+k%\u0019\u00111\u000e\u0011\u0003\rQ+\b\u000f\\33\u0011%\ty'a\u0017\u0002\u0002\u0003\u0007Q(A\u0002yIAB!\"a\u001d\u00028\u0005\u0005I\u0011BA;\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005]\u0004c\u0001:\u0002z%\u0019\u00111P:\u0003\r=\u0013'.Z2u\u0001")
public class CreateDataSourceTableCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final CatalogTable table;
    private final boolean ignoreIfExists;
    private final Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<CatalogTable, Object>> unapply(CreateDataSourceTableCommand createDataSourceTableCommand) {
        return CreateDataSourceTableCommand$.MODULE$.unapply(createDataSourceTableCommand);
    }

    public static Function1<Tuple2<CatalogTable, Object>, CreateDataSourceTableCommand> tupled() {
        return CreateDataSourceTableCommand$.MODULE$.tupled();
    }

    public static Function1<CatalogTable, Function1<Object, CreateDataSourceTableCommand>> curried() {
        return CreateDataSourceTableCommand$.MODULE$.curried();
    }

    private Map metrics$lzycompute() {
        CreateDataSourceTableCommand createDataSourceTableCommand = this;
        synchronized (createDataSourceTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand$class.metrics(this);
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.class.children((Command)this);
    }

    public CatalogTable table() {
        return this.table;
    }

    public boolean ignoreIfExists() {
        return this.ignoreIfExists;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        CatalogTable catalogTable;
        HadoopFsRelation hadoopFsRelation;
        Seq seq;
        CatalogTableType catalogTableType = this.table().tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        Predef$.MODULE$.assert(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null);
        Predef$.MODULE$.assert(this.table().provider().isDefined());
        SessionState sessionState2 = sparkSession.sessionState();
        if (sessionState2.catalog().tableExists(this.table().identifier())) {
            if (this.ignoreIfExists()) {
                return (Seq)Seq$.MODULE$.empty();
            }
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table().identifier().unquotedString()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Option pathOption = this.table().storage().locationUri().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(URI x$1) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)CatalogUtils$.MODULE$.URIToString(x$1));
            }
        });
        Some x$3 = new Some(this.table().identifier().database().getOrElse((Function0)new Serializable(this, sessionState2){
            public static final long serialVersionUID = 0L;
            private final SessionState sessionState$1;

            public final String apply() {
                return this.sessionState$1.catalog().getCurrentDatabase();
            }
            {
                this.sessionState$1 = sessionState$1;
            }
        }));
        String x$4 = this.table().identifier().copy$default$1();
        TableIdentifier x$5 = this.table().identifier().copy(x$4, (Option)x$3);
        boolean x$6 = sessionState2.conf().manageFilesourcePartitions();
        CatalogTableType x$7 = this.table().copy$default$2();
        CatalogStorageFormat x$8 = this.table().copy$default$3();
        StructType x$9 = this.table().copy$default$4();
        Option x$10 = this.table().copy$default$5();
        Seq x$11 = this.table().copy$default$6();
        Option x$12 = this.table().copy$default$7();
        String x$13 = this.table().copy$default$8();
        long x$14 = this.table().copy$default$9();
        long x$15 = this.table().copy$default$10();
        String x$16 = this.table().copy$default$11();
        Map x$17 = this.table().copy$default$12();
        Option x$18 = this.table().copy$default$13();
        Option x$19 = this.table().copy$default$14();
        Option x$20 = this.table().copy$default$15();
        Seq x$21 = this.table().copy$default$16();
        boolean x$22 = this.table().copy$default$18();
        Map x$23 = this.table().copy$default$19();
        AccessInfo x$24 = this.table().copy$default$20();
        CatalogTable tableWithDefaultOptions = this.table().copy(x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$6, x$22, x$23, x$24);
        SparkSession x$25 = sparkSession;
        None$ x$26 = this.table().schema().isEmpty() ? None$.MODULE$ : new Some((Object)this.table().schema());
        Seq x$27 = this.table().partitionColumnNames();
        String x$28 = (String)this.table().provider().get();
        Option x$29 = this.table().bucketSpec();
        Map x$30 = this.table().storage().properties().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(pathOption));
        Some x$31 = new Some((Object)tableWithDefaultOptions);
        Seq<String> x$32 = DataSource$.MODULE$.apply$default$3();
        BaseRelation dataSource = new DataSource(x$25, x$28, x$32, (Option<StructType>)x$26, (Seq<String>)x$27, (Option<BucketSpec>)x$29, (Map<String, String>)x$30, (Option<CatalogTable>)x$31).resolveRelation(false);
        if (this.table().schema().nonEmpty()) {
            seq = this.table().partitionColumnNames();
        } else {
            Nil$ nil$;
            Predef$.MODULE$.assert(this.table().partitionColumnNames().isEmpty());
            BaseRelation baseRelation = dataSource;
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation2 = (HadoopFsRelation)baseRelation;
                nil$ = Predef$.MODULE$.refArrayOps((Object[])hadoopFsRelation2.partitionSchema().fieldNames()).toSeq();
            } else {
                nil$ = Nil$.MODULE$;
            }
            seq = nil$;
        }
        Seq partitionColumnNames = seq;
        BaseRelation baseRelation = dataSource;
        if (baseRelation instanceof HadoopFsRelation && (hadoopFsRelation = (HadoopFsRelation)baseRelation).overlappedPartCols().nonEmpty()) {
            this.logWarning((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "It is not recommended to create a table with overlapped data and partition columns, as Spark cannot store a valid table schema and has to infer it at runtime, which hurts performance. Please check your data files and remove the partition columns in it.";
                }
            });
            StructType x$33 = new StructType();
            Nil$ x$34 = Nil$.MODULE$;
            TableIdentifier x$35 = this.table().copy$default$1();
            CatalogTableType x$36 = this.table().copy$default$2();
            CatalogStorageFormat x$37 = this.table().copy$default$3();
            Option x$38 = this.table().copy$default$5();
            Option x$39 = this.table().copy$default$7();
            String x$40 = this.table().copy$default$8();
            long x$41 = this.table().copy$default$9();
            long x$42 = this.table().copy$default$10();
            String x$43 = this.table().copy$default$11();
            Map x$44 = this.table().copy$default$12();
            Option x$45 = this.table().copy$default$13();
            Option x$46 = this.table().copy$default$14();
            Option x$47 = this.table().copy$default$15();
            Seq x$48 = this.table().copy$default$16();
            boolean x$49 = this.table().copy$default$17();
            boolean x$50 = this.table().copy$default$18();
            Map x$51 = this.table().copy$default$19();
            AccessInfo x$52 = this.table().copy$default$20();
            catalogTable = this.table().copy(x$35, x$36, x$37, x$33, x$38, (Seq)x$34, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52);
        } else {
            StructType x$53 = dataSource.schema();
            Seq x$54 = partitionColumnNames;
            boolean x$55 = partitionColumnNames.nonEmpty() && sessionState2.conf().manageFilesourcePartitions();
            TableIdentifier x$56 = this.table().copy$default$1();
            CatalogTableType x$57 = this.table().copy$default$2();
            CatalogStorageFormat x$58 = this.table().copy$default$3();
            Option x$59 = this.table().copy$default$5();
            Option x$60 = this.table().copy$default$7();
            String x$61 = this.table().copy$default$8();
            long x$62 = this.table().copy$default$9();
            long x$63 = this.table().copy$default$10();
            String x$64 = this.table().copy$default$11();
            Map x$65 = this.table().copy$default$12();
            Option x$66 = this.table().copy$default$13();
            Option x$67 = this.table().copy$default$14();
            Option x$68 = this.table().copy$default$15();
            Seq x$69 = this.table().copy$default$16();
            boolean x$70 = this.table().copy$default$18();
            Map x$71 = this.table().copy$default$19();
            AccessInfo x$72 = this.table().copy$default$20();
            catalogTable = this.table().copy(x$56, x$57, x$58, x$53, x$59, x$54, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$55, x$70, x$71, x$72);
        }
        CatalogTable newTable = catalogTable;
        sessionState2.catalog().createTable(newTable, false, sessionState2.catalog().createTable$default$3());
        return (Seq)Seq$.MODULE$.empty();
    }

    public CreateDataSourceTableCommand copy(CatalogTable table, boolean ignoreIfExists) {
        return new CreateDataSourceTableCommand(table, ignoreIfExists);
    }

    public CatalogTable copy$default$1() {
        return this.table();
    }

    public boolean copy$default$2() {
        return this.ignoreIfExists();
    }

    public String productPrefix() {
        return "CreateDataSourceTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreIfExists());
                break;
            }
            case 0: {
                object = this.table();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateDataSourceTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateDataSourceTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateDataSourceTableCommand createDataSourceTableCommand = (CreateDataSourceTableCommand)x$1;
        CatalogTable catalogTable = this.table();
        CatalogTable catalogTable2 = createDataSourceTableCommand.table();
        if (catalogTable == null) {
            if (catalogTable2 != null) {
                return false;
            }
        } else if (!catalogTable.equals(catalogTable2)) return false;
        if (this.ignoreIfExists() != createDataSourceTableCommand.ignoreIfExists()) return false;
        if (!createDataSourceTableCommand.canEqual(this)) return false;
        return true;
    }

    public CreateDataSourceTableCommand(CatalogTable table, boolean ignoreIfExists) {
        this.table = table;
        this.ignoreIfExists = ignoreIfExists;
        Command.class.$init$((Command)this);
        RunnableCommand$class.$init$(this);
    }
}

