/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext$;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.internal.BaseSessionStateBuilder;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.internal.SessionStateBuilder;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@InterfaceStability.Stable
public final class SparkSession$
implements Logging,
Serializable {
    public static final SparkSession$ MODULE$;
    private final InheritableThreadLocal<SparkSession> org$apache$spark$sql$SparkSession$$activeThreadSession;
    private final AtomicReference<SparkSession> org$apache$spark$sql$SparkSession$$defaultSession;
    private final String HIVE_SESSION_STATE_BUILDER_CLASS_NAME;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkSession$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public SparkSession.Builder builder() {
        return new SparkSession.Builder();
    }

    public void setActiveSession(SparkSession session) {
        this.org$apache$spark$sql$SparkSession$$activeThreadSession().set(session);
    }

    public void clearActiveSession() {
        this.org$apache$spark$sql$SparkSession$$activeThreadSession().remove();
    }

    public void setDefaultSession(SparkSession session) {
        this.org$apache$spark$sql$SparkSession$$defaultSession().set(session);
    }

    public void clearDefaultSession() {
        this.org$apache$spark$sql$SparkSession$$defaultSession().set(null);
    }

    public Option<SparkSession> getActiveSession() {
        return TaskContext$.MODULE$.get() == null ? Option$.MODULE$.apply(this.org$apache$spark$sql$SparkSession$$activeThreadSession().get()) : None$.MODULE$;
    }

    public Option<SparkSession> getDefaultSession() {
        return TaskContext$.MODULE$.get() == null ? Option$.MODULE$.apply((Object)this.org$apache$spark$sql$SparkSession$$defaultSession().get()) : None$.MODULE$;
    }

    public SparkSession active() {
        return (SparkSession)this.getActiveSession().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SparkSession apply() {
                return (SparkSession)SparkSession$.MODULE$.getDefaultSession().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw new IllegalStateException("No active or default Spark session found");
                    }
                });
            }
        });
    }

    public InheritableThreadLocal<SparkSession> org$apache$spark$sql$SparkSession$$activeThreadSession() {
        return this.org$apache$spark$sql$SparkSession$$activeThreadSession;
    }

    public AtomicReference<SparkSession> org$apache$spark$sql$SparkSession$$defaultSession() {
        return this.org$apache$spark$sql$SparkSession$$defaultSession;
    }

    private String HIVE_SESSION_STATE_BUILDER_CLASS_NAME() {
        return this.HIVE_SESSION_STATE_BUILDER_CLASS_NAME;
    }

    public String org$apache$spark$sql$SparkSession$$sessionStateClassName(SparkConf conf) {
        String string;
        block4: {
            String string2;
            block3: {
                block2: {
                    string = (String)conf.get(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION());
                    if (!"hive".equals(string)) break block2;
                    string2 = this.HIVE_SESSION_STATE_BUILDER_CLASS_NAME();
                    break block3;
                }
                if (!"in-memory".equals(string)) break block4;
                string2 = SessionStateBuilder.class.getCanonicalName();
            }
            return string2;
        }
        throw new MatchError((Object)string);
    }

    public void org$apache$spark$sql$SparkSession$$assertOnDriver() {
        if (Utils$.MODULE$.isTesting() && TaskContext$.MODULE$.get() != null) {
            throw new IllegalStateException("SparkSession should only be created and accessed on the driver.");
        }
    }

    public SessionState org$apache$spark$sql$SparkSession$$instantiateSessionState(String className, SparkSession sparkSession) {
        try {
            Class clazz = Utils$.MODULE$.classForName(className);
            Constructor ctor = (Constructor)Predef$.MODULE$.refArrayOps((Object[])clazz.getConstructors()).head();
            return ((BaseSessionStateBuilder)ctor.newInstance(sparkSession, None$.MODULE$)).build();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while instantiating '", "':"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{className})), e);
        }
    }

    public boolean hiveClassesArePresent() {
        Throwable throwable2;
        block2: {
            boolean bl;
            try {
                Utils$.MODULE$.classForName(this.HIVE_SESSION_STATE_BUILDER_CLASS_NAME());
                Utils$.MODULE$.classForName("org.apache.hadoop.hive.conf.HiveConf");
                bl = true;
            }
            catch (Throwable throwable2) {
                boolean bl2;
                Throwable throwable3 = throwable2;
                boolean bl3 = throwable3 instanceof ClassNotFoundException ? true : throwable3 instanceof NoClassDefFoundError;
                if (!bl3) break block2;
                bl = bl2 = false;
            }
            return bl;
        }
        throw throwable2;
    }

    public void cleanupAnyExistingSession() {
        Option session = this.getActiveSession().orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<SparkSession> apply() {
                return SparkSession$.MODULE$.getDefaultSession();
            }
        });
        if (session.isDefined()) {
            this.logWarning((Function0<String>)new Serializable(session){
                public static final long serialVersionUID = 0L;
                private final Option session$3;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"An existing Spark session exists as the active or default session.\n           |This probably means another suite leaked it. Attempting to stop it before continuing.\n           |This existing Spark session was created at:\n           |\n           |", "\n           |\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((SparkSession)this.session$3.get()).org$apache$spark$sql$SparkSession$$creationSite().longForm()})))).stripMargin();
                }
                {
                    this.session$3 = session$3;
                }
            });
            ((SparkSession)session.get()).stop();
            this.clearActiveSession();
            this.clearDefaultSession();
        }
    }

    public SparkSessionExtensions org$apache$spark$sql$SparkSession$$applyExtensions(Seq<String> extensionConfClassNames, SparkSessionExtensions extensions) {
        extensionConfClassNames.foreach((Function1)new Serializable(extensions){
            public static final long serialVersionUID = 0L;
            private final SparkSessionExtensions extensions$1;

            public final void apply(String extensionConfClassName) {
                Throwable throwable2;
                block2: {
                    try {
                        Class extensionConfClass = Utils$.MODULE$.classForName(extensionConfClassName);
                        Function1 extensionConf = (Function1)extensionConfClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        extensionConf.apply((Object)this.extensions$1);
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        boolean bl = throwable3 instanceof ClassCastException ? true : (throwable3 instanceof ClassNotFoundException ? true : throwable3 instanceof NoClassDefFoundError);
                        if (!bl) break block2;
                        SparkSession$.MODULE$.logWarning((Function0<String>)new Serializable(this, extensionConfClassName){
                            public static final long serialVersionUID = 0L;
                            private final String extensionConfClassName$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot use ", " to configure session extensions."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.extensionConfClassName$1}));
                            }
                            {
                                this.extensionConfClassName$1 = extensionConfClassName$1;
                            }
                        }, throwable3);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw throwable2;
            }
            {
                this.extensions$1 = extensions$1;
            }
        });
        return extensions;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparkSession$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$sql$SparkSession$$activeThreadSession = new InheritableThreadLocal();
        this.org$apache$spark$sql$SparkSession$$defaultSession = new AtomicReference();
        this.HIVE_SESSION_STATE_BUILDER_CLASS_NAME = "org.apache.spark.sql.hive.HiveSessionStateBuilder";
    }
}

