/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.joins;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.joins.HashedRelation;
import org.apache.spark.sql.execution.joins.UnsafeHashedRelation;
import org.apache.spark.unsafe.map.BytesToBytesMap;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class UnsafeHashedRelation$
implements Serializable {
    public static final UnsafeHashedRelation$ MODULE$;

    static {
        new UnsafeHashedRelation$();
    }

    public HashedRelation apply(Iterator<InternalRow> input, Seq<Expression> key, int sizeEstimate, TaskMemoryManager taskMemoryManager) {
        long pageSizeBytes = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(SparkEnv x$2) {
                return x$2.memoryManager().pageSizeBytes();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return new SparkConf().getSizeAsBytes("spark.buffer.pageSize", "16m");
            }
        }));
        BytesToBytesMap binaryMap = new BytesToBytesMap(taskMemoryManager, (int)((double)sizeEstimate * 1.5 + 1.0), pageSizeBytes, true);
        UnsafeProjection keyGenerator = UnsafeProjection$.MODULE$.create(key);
        int numFields = 0;
        while (input.hasNext()) {
            BytesToBytesMap.Location loc;
            boolean success;
            UnsafeRow row = (UnsafeRow)input.next();
            numFields = row.numFields();
            UnsafeRow key2 = keyGenerator.apply((InternalRow)row);
            if (key2.anyNull() || (success = (loc = binaryMap.lookup(key2.getBaseObject(), key2.getBaseOffset(), key2.getSizeInBytes())).append(key2.getBaseObject(), key2.getBaseOffset(), key2.getSizeInBytes(), row.getBaseObject(), row.getBaseOffset(), row.getSizeInBytes()))) continue;
            binaryMap.free();
            throw new SparkException("There is no enough memory to build hash map");
        }
        return new UnsafeHashedRelation(key.size(), numFields, binaryMap);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private UnsafeHashedRelation$() {
        MODULE$ = this;
    }
}

