/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker$;
import org.apache.spark.sql.execution.datasources.BasicWriteTaskStats;
import org.apache.spark.sql.execution.datasources.BasicWriteTaskStatsTracker$;
import org.apache.spark.sql.execution.datasources.WriteTaskStats;
import org.apache.spark.sql.execution.datasources.WriteTaskStatsTracker;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u0001=\u0011!DQ1tS\u000e<&/\u001b;f)\u0006\u001c8n\u0015;biN$&/Y2lKJT!a\u0001\u0003\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u000b\u0019\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001bC\u0007\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]AR\"\u0001\u0002\n\u0005e\u0011!!F,sSR,G+Y:l'R\fGo\u001d+sC\u000e\\WM\u001d\t\u00037yi\u0011\u0001\b\u0006\u0003;!\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003?q\u0011q\u0001T8hO&tw\r\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\nAaY8oM*\u0011qEC\u0001\u0007Q\u0006$wn\u001c9\n\u0005%\"#!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003,\u0001\u0011\u0005A&\u0001\u0004=S:LGO\u0010\u000b\u0003[9\u0002\"a\u0006\u0001\t\u000b\u0005R\u0003\u0019\u0001\u0012\t\rA\u0002\u0001\u0015!\u00032\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0004e]JT\"A\u001a\u000b\u0005Q*\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003mI\t!bY8mY\u0016\u001cG/[8o\u0013\tA4GA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bC\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u0007\u0003!\u0019\u0017\r^1msN$\u0018B\u0001 <\u0005-Ie\u000e^3s]\u0006d'k\\<\t\r\u0001\u0003\u0001\u0015)\u0003B\u0003!qW/\u001c$jY\u0016\u001c\bCA\tC\u0013\t\u0019%CA\u0002J]RDa!\u0012\u0001!B\u0013\t\u0015AD:vE6LG\u000f^3e\r&dWm\u001d\u0005\u0007\u000f\u0002\u0001\u000b\u0015\u0002%\u0002\u00119,XNQ=uKN\u0004\"!E%\n\u0005)\u0013\"\u0001\u0002'p]\u001eDa\u0001\u0014\u0001!B\u0013A\u0015a\u00028v[J{wo\u001d\u0005\u0007\u001d\u0002\u0001\u000b\u0015B(\u0002\u000f\r,(OR5mKB\u0019\u0011\u0003\u0015*\n\u0005E\u0013\"AB(qi&|g\u000e\u0005\u0002T-:\u0011\u0011\u0003V\u0005\u0003+J\ta\u0001\u0015:fI\u00164\u0017BA,Y\u0005\u0019\u0019FO]5oO*\u0011QK\u0005\u0005\u00065\u0002!IaW\u0001\fO\u0016$h)\u001b7f'&TX\r\u0006\u0002];B\u0019\u0011\u0003\u0015%\t\u000byK\u0006\u0019\u0001*\u0002\u0011\u0019LG.\u001a)bi\"DaA\u0017\u0001\u0005\u0002\t\u0001Gc\u0001/bQ\")!m\u0018a\u0001G\u0006\u0011am\u001d\t\u0003I\u001al\u0011!\u001a\u0006\u0003E\u001aJ!aZ3\u0003\u0015\u0019KG.Z*zgR,W\u000eC\u0003j?\u0002\u0007!.\u0001\u0003qCRD\u0007C\u00013l\u0013\taWM\u0001\u0003QCRD\u0007\"\u00028\u0001\t\u0003z\u0017\u0001\u00048foB\u000b'\u000f^5uS>tGC\u00019t!\t\t\u0012/\u0003\u0002s%\t!QK\\5u\u0011\u0015!X\u000e1\u0001:\u0003=\u0001\u0018M\u001d;ji&|gNV1mk\u0016\u001c\b\"\u0002<\u0001\t\u0003:\u0018!\u00038fo\n+8m[3u)\t\u0001\b\u0010C\u0003zk\u0002\u0007\u0011)\u0001\u0005ck\u000e\\W\r^%e\u0011\u0015Y\b\u0001\"\u0011}\u0003\u001dqWm\u001e$jY\u0016$\"\u0001]?\t\u000byS\b\u0019\u0001*\t\r}\u0004A\u0011BA\u0001\u0003=\u0019H/\u0019;DkJ\u0014XM\u001c;GS2,G#\u00019\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b\u00051a.Z<S_^$2\u0001]A\u0005\u0011\u001d\tY!a\u0001A\u0002e\n1A]8x\u0011\u001d\ty\u0001\u0001C!\u0003#\tQbZ3u\r&t\u0017\r\\*uCR\u001cHCAA\n!\r9\u0012QC\u0005\u0004\u0003/\u0011!AD,sSR,G+Y:l'R\fGo\u001d")
public class BasicWriteTaskStatsTracker
implements WriteTaskStatsTracker,
Logging {
    private final Configuration hadoopConf;
    private final ArrayBuffer<InternalRow> partitions;
    public int org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numFiles;
    public int org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$submittedFiles;
    public long org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numBytes;
    public long org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numRows;
    public Option<String> org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$curFile;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Option<Object> org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$getFileSize(String filePath) {
        Path path = new Path(filePath);
        FileSystem fs = path.getFileSystem(this.hadoopConf);
        return this.getFileSize(fs, path);
    }

    public Option<Object> getFileSize(FileSystem fs, Path path) {
        long len;
        try {
            long len2 = fs.getFileStatus(path).getLen();
            if (len2 > 0L) {
                return new Some((Object)BoxesRunTime.boxToLong((long)len2));
            }
            len = 0L;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logDebug((Function0<String>)new Serializable(this, path){
                public static final long serialVersionUID = 0L;
                private final Path path$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File ", " is not yet visible"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                }
                {
                    this.path$1 = path$1;
                }
            }, fileNotFoundException);
            return None$.MODULE$;
        }
        try {
            byte[] attr = fs.getXAttr(path, BasicWriteJobStatsTracker$.MODULE$.FILE_LENGTH_XATTR());
            if (attr != null && Predef$.MODULE$.byteArrayOps(attr).nonEmpty()) {
                String str2 = new String(attr, StandardCharsets.UTF_8);
                this.logInfo((Function0<String>)new Serializable(this, path, str2){
                    public static final long serialVersionUID = 0L;
                    private final Path path$1;
                    private final String str$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File Length statistics for ", " retrieved from XAttr: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1, this.str$1}));
                    }
                    {
                        this.path$1 = path$1;
                        this.str$1 = str$1;
                    }
                });
                long l = Long.parseLong(str2);
                if (l > 0L) {
                    len = l;
                } else {
                    this.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Ignoring negative value in Xattr file length";
                        }
                    });
                }
            }
        }
        catch (Exception exception) {
            this.logDebug((Function0<String>)new Serializable(this, path){
                public static final long serialVersionUID = 0L;
                private final Path path$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Xattr processing failure on ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                }
                {
                    this.path$1 = path$1;
                }
            }, exception);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.logDebug((Function0<String>)new Serializable(this, path){
                public static final long serialVersionUID = 0L;
                private final Path path$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Xattr not supported on path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                }
                {
                    this.path$1 = path$1;
                }
            }, unsupportedOperationException);
        }
        catch (NumberFormatException numberFormatException) {
            this.logInfo((Function0<String>)new Serializable(this, numberFormatException){
                public static final long serialVersionUID = 0L;
                private final NumberFormatException e$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BasicWriteJobStatsTracker$.MODULE$.FILE_LENGTH_XATTR(), this.e$1}))).toString();
                }
                {
                    this.e$1 = e$1;
                }
            });
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)len));
    }

    @Override
    public void newPartition(InternalRow partitionValues) {
        this.partitions.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{partitionValues}));
    }

    @Override
    public void newBucket(int bucketId) {
    }

    @Override
    public void newFile(String filePath) {
        this.statCurrentFile();
        this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$curFile = new Some((Object)filePath);
        ++this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$submittedFiles;
    }

    private void statCurrentFile() {
        this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$curFile.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicWriteTaskStatsTracker $outer;

            public final void apply(String path) {
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$getFileSize(path).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$statCurrentFile$1 $outer;

                    public final void apply(long len) {
                        this.apply$mcVJ$sp(len);
                    }

                    public void apply$mcVJ$sp(long len) {
                        this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$anonfun$$$outer().org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numBytes += len;
                        ++this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$anonfun$$$outer().org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numFiles;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$curFile = None$.MODULE$;
            }

            public /* synthetic */ BasicWriteTaskStatsTracker org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void newRow(InternalRow row) {
        ++this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numRows;
    }

    @Override
    public WriteTaskStats getFinalStats() {
        this.statCurrentFile();
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final OutputMetrics apply(TaskContext x$1) {
                return x$1.taskMetrics().outputMetrics();
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicWriteTaskStatsTracker $outer;

            public final void apply(OutputMetrics outputMetrics) {
                outputMetrics.setBytesWritten(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numBytes);
                outputMetrics.setRecordsWritten(this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numRows);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$submittedFiles != this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numFiles) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BasicWriteTaskStatsTracker $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " files, but only saw ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$submittedFiles), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numFiles)}))).append((Object)"This could be due to the output format not writing empty files, ").append((Object)"or files being not immediately visible in the filesystem.").toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        return new BasicWriteTaskStats((Seq<InternalRow>)this.partitions.toSeq(), this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numFiles, this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numBytes, this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numRows);
    }

    public BasicWriteTaskStatsTracker(Configuration hadoopConf) {
        this.hadoopConf = hadoopConf;
        Logging.class.$init$((Logging)this);
        this.partitions = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numFiles = 0;
        this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$submittedFiles = 0;
        this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numBytes = 0L;
        this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$numRows = 0L;
        this.org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTracker$$curFile = None$.MODULE$;
    }
}

