/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.mapred.OrcOutputFormat;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapreduce.OrcInputFormat;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$class;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnarBatchReader;
import org.apache.spark.sql.execution.datasources.orc.OrcDeserializer;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat$;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat$$anonfun$buildReaderWithPartitionValues$2$;
import org.apache.spark.sql.execution.datasources.orc.OrcFilters$;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.orc.OrcOutputWriter;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005xAB\u0001\u0003\u0011\u0003A\u0001#A\u0007Pe\u000e4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003\u0007\u0011\t1a\u001c:d\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u0004\"!\u0005\n\u000e\u0003\t1aa\u0005\u0002\t\u0002!!\"!D(sG\u001aKG.\u001a$pe6\fGoE\u0002\u0013+m\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0007C\u0001\f\u001d\u0013\tirC\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003 %\u0011\u0005\u0011%\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0001\u0002\"B\u0012\u0013\t\u0013!\u0013AD2iK\u000e\\g)[3mI:\u000bW.\u001a\u000b\u0003K!\u0002\"A\u0006\u0014\n\u0005\u001d:\"\u0001B+oSRDQ!\u000b\u0012A\u0002)\nAA\\1nKB\u00111F\f\b\u0003-1J!!L\f\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[]AQA\r\n\u0005\u0002M\nqb\u00195fG.4\u0015.\u001a7e\u001d\u0006lWm\u001d\u000b\u0003KQBQ!N\u0019A\u0002Y\nQA\\1nKN\u00042aN +\u001d\tATH\u0004\u0002:y5\t!H\u0003\u0002<A\u00051AH]8pizJ\u0011\u0001G\u0005\u0003}]\tq\u0001]1dW\u0006<W-\u0003\u0002A\u0003\n\u00191+Z9\u000b\u0005y:\u0002\"B\"\u0013\t\u0003!\u0015!F4fiF+x\u000e^3e'\u000eDW-\\1TiJLgn\u001a\u000b\u0003U\u0015CQA\u0012\"A\u0002\u001d\u000b\u0001\u0002Z1uCRK\b/\u001a\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\"\tQ\u0001^=qKNL!\u0001T%\u0003\u0011\u0011\u000bG/\u0019+za\u0016DqA\u0014\n\u0002\u0002\u0013%q*A\u0006sK\u0006$'+Z:pYZ,G#\u0001)\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016\u0001\u00027b]\u001eT\u0011!V\u0001\u0005U\u00064\u0018-\u0003\u0002X%\n1qJ\u00196fGR4Aa\u0005\u0002\u00013N)\u0001,\u0006._IB\u00111\fX\u0007\u0002\t%\u0011Q\f\u0002\u0002\u000b\r&dWMR8s[\u0006$\bCA0c\u001b\u0005\u0001'BA1\t\u0003\u001d\u0019x.\u001e:dKNL!a\u00191\u0003%\u0011\u000bG/Y*pkJ\u001cWMU3hSN$XM\u001d\t\u0003K\"l\u0011A\u001a\u0006\u0003OR\u000b!![8\n\u0005u1\u0007\"B\u0010Y\t\u0003QG#A6\u0011\u0005EA\u0006\"B7Y\t\u0003r\u0017!C:i_J$h*Y7f)\u0005Q\u0003\"\u00029Y\t\u0003r\u0017\u0001\u0003;p'R\u0014\u0018N\\4\t\u000bIDF\u0011I:\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001\u001e\t\u0003-UL!A^\f\u0003\u0007%sG\u000fC\u0003y1\u0012\u0005\u00130\u0001\u0004fcV\fGn\u001d\u000b\u0003uv\u0004\"AF>\n\u0005q<\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006}^\u0004\ra`\u0001\u0006_RDWM\u001d\t\u0004-\u0005\u0005\u0011bAA\u0002/\t\u0019\u0011I\\=\t\u000f\u0005\u001d\u0001\f\"\u0011\u0002\n\u0005Y\u0011N\u001c4feN\u001b\u0007.Z7b)!\tY!a\u0006\u0002$\u00055\u0002#\u0002\f\u0002\u000e\u0005E\u0011bAA\b/\t1q\n\u001d;j_:\u00042\u0001SA\n\u0013\r\t)\"\u0013\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002CA\r\u0003\u000b\u0001\r!a\u0007\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\t\u0005u\u0011qD\u0007\u0002\u0011%\u0019\u0011\u0011\u0005\u0005\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u0011\u0005\u0015\u0012Q\u0001a\u0001\u0003O\tqa\u001c9uS>t7\u000fE\u0003,\u0003SQ#&C\u0002\u0002,A\u00121!T1q\u0011!\ty#!\u0002A\u0002\u0005E\u0012!\u00024jY\u0016\u001c\b\u0003B\u001c@\u0003g\u0001B!!\u000e\u0002@5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$\u0001\u0002gg*\u0019\u0011Q\b\u0007\u0002\r!\fGm\\8q\u0013\u0011\t\t%a\u000e\u0003\u0015\u0019KG.Z*uCR,8\u000fC\u0004\u0002Fa#\t%a\u0012\u0002\u0019A\u0014X\r]1sK^\u0013\u0018\u000e^3\u0015\u0015\u0005%\u0013qJA)\u0003C\n\u0019\u0007E\u0002\\\u0003\u0017J1!!\u0014\u0005\u0005MyU\u000f\u001e9vi^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z\u0011!\tI\"a\u0011A\u0002\u0005m\u0001\u0002CA*\u0003\u0007\u0002\r!!\u0016\u0002\u0007)|'\r\u0005\u0003\u0002X\u0005uSBAA-\u0015\u0011\tY&a\u000f\u0002\u00135\f\u0007O]3ek\u000e,\u0017\u0002BA0\u00033\u00121AS8c\u0011!\t)#a\u0011A\u0002\u0005\u001d\u0002\u0002CA3\u0003\u0007\u0002\r!!\u0005\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017\rC\u0004\u0002ja#\t%a\u001b\u0002\u0019M,\b\u000f]8si\n\u000bGo\u00195\u0015\u000bi\fi'a\u001c\t\u0011\u0005e\u0011q\ra\u0001\u00037A\u0001\"!\u001d\u0002h\u0001\u0007\u0011\u0011C\u0001\u0007g\u000eDW-\\1\t\u000f\u0005U\u0004\f\"\u0011\u0002x\u0005Y\u0011n]*qY&$\u0018M\u00197f)\u001dQ\u0018\u0011PA>\u0003{B\u0001\"!\u0007\u0002t\u0001\u0007\u00111\u0004\u0005\t\u0003K\t\u0019\b1\u0001\u0002(!A\u0011qPA:\u0001\u0004\t\t)\u0001\u0003qCRD\u0007\u0003BA\u001b\u0003\u0007KA!!\"\u00028\t!\u0001+\u0019;i\u0011\u001d\tI\t\u0017C!\u0003\u0017\u000baDY;jY\u0012\u0014V-\u00193fe^KG\u000f\u001b)beRLG/[8o-\u0006dW/Z:\u0015!\u00055\u00151VAW\u0003_\u000b\u0019,a.\u0002D\u0006\u0015\u0007c\u0002\f\u0002\u0010\u0006M\u0015\u0011T\u0005\u0004\u0003#;\"!\u0003$v]\u000e$\u0018n\u001c82!\rY\u0016QS\u0005\u0004\u0003/#!a\u0004)beRLG/[8oK\u00124\u0015\u000e\\3\u0011\u000b]\nY*a(\n\u0007\u0005u\u0015I\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0011\t\t+a*\u000e\u0005\u0005\r&bAAS\u0011\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002*\u0006\r&aC%oi\u0016\u0014h.\u00197S_^D\u0001\"!\u0007\u0002\b\u0002\u0007\u00111\u0004\u0005\t\u0003K\n9\t1\u0001\u0002\u0012!A\u0011\u0011WAD\u0001\u0004\t\t\"A\bqCJ$\u0018\u000e^5p]N\u001b\u0007.Z7b\u0011!\t),a\"A\u0002\u0005E\u0011A\u0004:fcVL'/\u001a3TG\",W.\u0019\u0005\t\u0003s\u000b9\t1\u0001\u0002<\u00069a-\u001b7uKJ\u001c\b\u0003B\u001c@\u0003{\u00032aXA`\u0013\r\t\t\r\u0019\u0002\u0007\r&dG/\u001a:\t\u0011\u0005\u0015\u0012q\u0011a\u0001\u0003OA\u0001\"a2\u0002\b\u0002\u0007\u0011\u0011Z\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003BAf\u0003#l!!!4\u000b\t\u0005=\u00171H\u0001\u0005G>tg-\u0003\u0003\u0002T\u00065'!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004\u0002Xb#\t%!7\u0002\u001fM,\b\u000f]8si\u0012\u000bG/\u0019+za\u0016$RA_An\u0003;DaARAk\u0001\u00049\u0005bBAp\u0003+\u0004\rA_\u0001\u000bSN\u0014V-\u00193QCRD\u0007")
public class OrcFileFormat
implements FileFormat,
DataSourceRegister,
Serializable {
    public static String getQuotedSchemaString(DataType dataType) {
        return OrcFileFormat$.MODULE$.getQuotedSchemaString(dataType);
    }

    public static void checkFieldNames(Seq<String> seq) {
        OrcFileFormat$.MODULE$.checkFieldNames(seq);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat$class.vectorTypes(this, requiredSchema, partitionSchema, sqlConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat$class.buildReader(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public String shortName() {
        return "orc";
    }

    public String toString() {
        return "ORC";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof OrcFileFormat;
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return OrcUtils$.MODULE$.readSchema(sparkSession, files, options);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        OrcOptions orcOptions = new OrcOptions(options, sparkSession.sessionState().conf());
        Configuration conf = job.getConfiguration();
        conf.set(OrcConf.MAPRED_OUTPUT_SCHEMA.getAttribute(), OrcFileFormat$.MODULE$.getQuotedSchemaString((DataType)dataSchema));
        conf.set(OrcConf.COMPRESS.getAttribute(), orcOptions.compressionCodec());
        ((JobConf)conf).setOutputFormat(OrcOutputFormat.class);
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new OrcOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                String name2 = context.getConfiguration().get(OrcConf.COMPRESS.getAttribute());
                String compressionExtension = (String)OrcUtils$.MODULE$.extensionsForCompressionCodecNames().getOrElse((Object)name2, (Function0)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                return new StringBuilder().append((Object)compressionExtension).append((Object)".orc").toString();
            }
        };
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema2) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.orcVectorizedReaderEnabled() && conf.wholeStageEnabled() && schema2.length() <= conf.wholeStageMaxNumFields() && schema2.forall((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$1) {
                return x$1.dataType() instanceof AtomicType;
            }
        });
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        if (sparkSession.sessionState().conf().orcFilterPushDown()) {
            OrcFilters$.MODULE$.createFilter(dataSchema, filters).foreach((Function1)new scala.Serializable(this, dataSchema, hadoopConf){
                public static final long serialVersionUID = 0L;
                private final StructType dataSchema$1;
                private final Configuration hadoopConf$1;

                public final void apply(SearchArgument f) {
                    OrcInputFormat.setSearchArgument((Configuration)this.hadoopConf$1, (SearchArgument)f, (String[])this.dataSchema$1.fieldNames());
                }
                {
                    this.dataSchema$1 = dataSchema$1;
                    this.hadoopConf$1 = hadoopConf$1;
                }
            });
        }
        StructType resultSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableVectorizedReader = this.supportBatch(sparkSession, resultSchema);
        int capacity = sqlConf.orcVectorizedReaderBatchSize();
        Broadcast broadcastedConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        boolean isCaseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
        return new scala.Serializable(this, dataSchema, partitionSchema, requiredSchema, resultSchema, enableVectorizedReader, capacity, broadcastedConf, isCaseSensitive){
            public static final long serialVersionUID = 0L;
            private final StructType dataSchema$1;
            private final StructType partitionSchema$1;
            private final StructType requiredSchema$1;
            private final StructType resultSchema$1;
            private final boolean enableVectorizedReader$1;
            private final int capacity$1;
            private final Broadcast broadcastedConf$1;
            private final boolean isCaseSensitive$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                Iterator<B> iterator2;
                Configuration conf = ((SerializableConfiguration)this.broadcastedConf$1.value()).value();
                Path filePath = new Path(new URI(file.filePath()));
                FileSystem fs = filePath.getFileSystem(conf);
                OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)conf).filesystem(fs);
                Reader reader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)readerOptions);
                Option<int[]> requestedColIdsOrEmptyFile = OrcUtils$.MODULE$.requestedColumnIds(this.isCaseSensitive$1, this.dataSchema$1, this.requiredSchema$1, reader, conf);
                if (requestedColIdsOrEmptyFile.isEmpty()) {
                    iterator2 = package$.MODULE$.Iterator().empty();
                } else {
                    int[] requestedColIds = (int[])requestedColIdsOrEmptyFile.get();
                    Predef$.MODULE$.assert(requestedColIds.length == this.requiredSchema$1.length(), (Function0)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "[BUG] requested column IDs do not match required schema";
                        }
                    });
                    Configuration taskConf = new Configuration(conf);
                    taskConf.set(OrcConf.INCLUDE_COLUMNS.getAttribute(), Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(requestedColIds).filter((Function1)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(int x$2) {
                            return this.apply$mcZI$sp(x$2);
                        }

                        public boolean apply$mcZI$sp(int x$2) {
                            return x$2 != -1;
                        }
                    })).sorted((Ordering)Ordering.Int$.MODULE$)).mkString(","));
                    FileSplit fileSplit = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                    TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                    TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(taskConf, attemptId);
                    if (this.enableVectorizedReader$1) {
                        OrcColumnarBatchReader batchReader = new OrcColumnarBatchReader(this.capacity$1);
                        RecordReaderIterator<ColumnarBatch> iter = new RecordReaderIterator<ColumnarBatch>(batchReader);
                        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new scala.Serializable(this, iter){
                            public static final long serialVersionUID = 0L;
                            public final RecordReaderIterator iter$1;

                            public final TaskContext apply(TaskContext x$3) {
                                return x$3.addTaskCompletionListener((Function1)new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$buildReaderWithPartitionValues$2$$anonfun$apply$3 $outer;

                                    public final void apply(TaskContext x$4) {
                                        this.$outer.iter$1.close();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            {
                                this.iter$1 = iter$1;
                            }
                        });
                        int[] requestedDataColIds = (int[])Predef$.MODULE$.intArrayOps(requestedColIds).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps((int[])Array$.MODULE$.fill(this.partitionSchema$1.length(), (Function0)new scala.Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return -1;
                            }
                        }, ClassTag$.MODULE$.Int())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                        int[] requestedPartitionColIds = (int[])Predef$.MODULE$.intArrayOps((int[])Array$.MODULE$.fill(this.requiredSchema$1.length(), (Function0)new scala.Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return -1;
                            }
                        }, ClassTag$.MODULE$.Int())).$plus$plus((GenTraversableOnce)package$.MODULE$.Range().apply(0, this.partitionSchema$1.length()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                        batchReader.initialize((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
                        batchReader.initBatch(reader.getSchema(), this.resultSchema$1.fields(), requestedDataColIds, requestedPartitionColIds, file.partitionValues());
                        iterator2 = iter;
                    } else {
                        RecordReader orcRecordReader = new OrcInputFormat().createRecordReader((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
                        RecordReaderIterator<T> iter = new RecordReaderIterator<T>(orcRecordReader);
                        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new scala.Serializable(this, iter){
                            public static final long serialVersionUID = 0L;
                            public final RecordReaderIterator iter$2;

                            public final TaskContext apply(TaskContext x$5) {
                                return x$5.addTaskCompletionListener((Function1)new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$buildReaderWithPartitionValues$2$$anonfun$apply$5 $outer;

                                    public final void apply(TaskContext x$6) {
                                        this.$outer.iter$2.close();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            {
                                this.iter$2 = iter$2;
                            }
                        });
                        Seq fullSchema = (Seq)this.requiredSchema$1.toAttributes().$plus$plus((GenTraversableOnce)this.partitionSchema$1.toAttributes(), Seq$.MODULE$.canBuildFrom());
                        UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                        OrcDeserializer deserializer = new OrcDeserializer(this.dataSchema$1, this.requiredSchema$1, requestedColIds);
                        if (this.partitionSchema$1.length() == 0) {
                            iterator2 = iter.map(new scala.Serializable(this, unsafeProjection, deserializer){
                                public static final long serialVersionUID = 0L;
                                private final UnsafeProjection unsafeProjection$1;
                                private final OrcDeserializer deserializer$1;

                                public final UnsafeRow apply(OrcStruct value) {
                                    return this.unsafeProjection$1.apply(this.deserializer$1.deserialize(value));
                                }
                                {
                                    this.unsafeProjection$1 = unsafeProjection$1;
                                    this.deserializer$1 = deserializer$1;
                                }
                            });
                        } else {
                            JoinedRow joinedRow = new JoinedRow();
                            iterator2 = iter.map(new scala.Serializable(this, unsafeProjection, deserializer, joinedRow, file){
                                public static final long serialVersionUID = 0L;
                                private final UnsafeProjection unsafeProjection$1;
                                private final OrcDeserializer deserializer$1;
                                private final JoinedRow joinedRow$1;
                                private final PartitionedFile file$1;

                                public final UnsafeRow apply(OrcStruct value) {
                                    return this.unsafeProjection$1.apply((InternalRow)this.joinedRow$1.apply(this.deserializer$1.deserialize(value), this.file$1.partitionValues()));
                                }
                                {
                                    this.unsafeProjection$1 = unsafeProjection$1;
                                    this.deserializer$1 = deserializer$1;
                                    this.joinedRow$1 = joinedRow$1;
                                    this.file$1 = file$1;
                                }
                            });
                        }
                    }
                }
                return iterator2;
            }
            {
                this.dataSchema$1 = dataSchema$1;
                this.partitionSchema$1 = partitionSchema$1;
                this.requiredSchema$1 = requiredSchema$1;
                this.resultSchema$1 = resultSchema$1;
                this.enableVectorizedReader$1 = enableVectorizedReader$1;
                this.capacity$1 = capacity$1;
                this.broadcastedConf$1 = broadcastedConf$1;
                this.isCaseSensitive$1 = isCaseSensitive$1;
            }
        };
    }

    @Override
    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1)new scala.Serializable(this, isReadPath){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OrcFileFormat $outer;
                private final boolean isReadPath$1;

                public final boolean apply(StructField f) {
                    return this.$outer.supportDataType(f.dataType(), this.isReadPath$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.isReadPath$1 = isReadPath$1;
                }
            });
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType, isReadPath);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType, isReadPath) && this.supportDataType(valueType, isReadPath);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType(), isReadPath);
        } else {
            bl = dataType2 instanceof NullType ? isReadPath : false;
        }
        return bl;
    }

    public OrcFileFormat() {
        FileFormat$class.$init$(this);
    }
}

