/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ConcurrentModificationException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\tec\u0001B\u0001\u0003\u0001=\u0011q\u0002\u0013#G'6+G/\u00193bi\u0006dun\u001a\u0006\u0003\u0007\u0011\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00151\u0011!C3yK\u000e,H/[8o\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001+\t\u0001Rd\u0005\u0003\u0001#]\u0019\u0003C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\rE\u0002\u00193mi\u0011AA\u0005\u00035\t\u00111\"T3uC\u0012\fG/\u0019'pOB\u0011A$\b\u0007\u0001\t\u0015q\u0002A1\u0001 \u0005\u0005!\u0016C\u0001\u0011\u0012!\t\u0011\u0012%\u0003\u0002#'\t9aj\u001c;iS:<\u0007C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\t\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0015&\u0005\u001daunZ4j]\u001eD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003Y5j\u0011AB\u0005\u0003]\u0019\u0011Ab\u00159be.\u001cVm]:j_:D\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!M\u0001\u0005a\u0006$\b\u000e\u0005\u00023k9\u0011!cM\u0005\u0003iM\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011Ag\u0005\u0005\ts\u0001\u0011\u0019\u0011)A\u0006u\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u0007mr4$D\u0001=\u0015\ti4#A\u0004sK\u001adWm\u0019;\n\u0005}b$\u0001C\"mCN\u001cH+Y4\t\u000b\u0005\u0003A\u0011\u0001\"\u0002\rqJg.\u001b;?)\r\u0019ei\u0012\u000b\u0003\t\u0016\u00032\u0001\u0007\u0001\u001c\u0011\u0015I\u0004\tq\u0001;\u0011\u0015Q\u0003\t1\u0001,\u0011\u0015\u0001\u0004\t1\u00012\u0011\u001dI\u0005A1A\u0005\f)\u000bqAZ8s[\u0006$8/F\u0001L%\ra\u0015c\u0015\u0004\u0005\u001b\u0002\u00011J\u0001\u0007=e\u00164\u0017N\\3nK:$h(\u0003\u0002J\u001f&\u0011\u0001+\u0015\u0002\u000e'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005Ic\u0011A\u00026t_:$4\u000f\u0005\u0002U+6\t\u0011+\u0003\u0002W#\n9ai\u001c:nCR\u001c\bb\u0002-M\u0005\u0004%\t!W\u0001\u000bI\u0006$XMR8s[\u0006$X#\u0001.\u0011\u0005Q[\u0016B\u0001/R\u0005)!\u0015\r^3G_Jl\u0017\r\u001e\u0005\b=2\u0013\r\u0011\"\u0011`\u0003%!\u0018\u0010]3IS:$8/F\u0001a!\t!\u0016-\u0003\u0002c#\nIA+\u001f9f\u0011&tGo\u001d\u0005\u0007I\u0002\u0001\u000b\u0011B&\u0002\u0011\u0019|'/\\1ug\u0002BqA\u001a\u0001C\u0002\u0013-q-\u0001\u0005nC:Lg-Z:u+\u0005A\u0007cA\u001ej7%\u0011!\u000e\u0010\u0002\t\u001b\u0006t\u0017NZ3ti\"1A\u000e\u0001Q\u0001\n!\f\u0011\"\\1oS\u001a,7\u000f\u001e\u0011\t\u000f9\u0004!\u0019!C\u0001_\u0006aQ.\u001a;bI\u0006$\u0018\rU1uQV\t\u0001\u000f\u0005\u0002rm6\t!O\u0003\u0002ti\u0006\u0011am\u001d\u0006\u0003k*\ta\u0001[1e_>\u0004\u0018BA<s\u0005\u0011\u0001\u0016\r\u001e5\t\re\u0004\u0001\u0015!\u0003q\u00035iW\r^1eCR\f\u0007+\u0019;iA!91\u0010\u0001b\u0001\n#a\u0018a\u00034jY\u0016l\u0015M\\1hKJ,\u0012! \t\u00031yL!a \u0002\u0003+\rCWmY6q_&tGOR5mK6\u000bg.Y4fe\"9\u00111\u0001\u0001!\u0002\u0013i\u0018\u0001\u00044jY\u0016l\u0015M\\1hKJ\u0004\u0003\"CA\u0004\u0001\t\u0007I\u0011CA\u0005\u0003A\u0011\u0017\r^2i\r&dWm\u001d$jYR,'/\u0006\u0002\u0002\fI1\u0011QBA\n\u0003G1a!TA\b\u0001\u0005-\u0001\u0002CA\t\u0001\u0001\u0006I!a\u0003\u0002#\t\fGo\u00195GS2,7OR5mi\u0016\u0014\b\u0005\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\t1\fgn\u001a\u0006\u0003\u0003;\tAA[1wC&!\u0011\u0011EA\f\u0005\u0019y%M[3diB\u0019\u0011/!\n\n\u0007\u0005\u001d\"O\u0001\u0006QCRDg)\u001b7uKJDq!a\u000b\u0001\t#\ti#A\u0007cCR\u001c\u0007.\u00133U_B\u000bG\u000f\u001b\u000b\u0004a\u0006=\u0002\u0002CA\u0019\u0003S\u0001\r!a\r\u0002\u000f\t\fGo\u00195JIB\u0019!#!\u000e\n\u0007\u0005]2C\u0001\u0003M_:<\u0007bBA\u001e\u0001\u0011E\u0011QH\u0001\u000ea\u0006$\b\u000eV8CCR\u001c\u0007.\u00133\u0015\t\u0005M\u0012q\b\u0005\u0007a\u0005e\u0002\u0019\u00019\t\u000f\u0005\r\u0003\u0001\"\u0005\u0002F\u0005Y\u0011n\u001d\"bi\u000eDg)\u001b7f)\u0011\t9%!\u0014\u0011\u0007I\tI%C\u0002\u0002LM\u0011qAQ8pY\u0016\fg\u000e\u0003\u00041\u0003\u0003\u0002\r\u0001\u001d\u0005\b\u0003#\u0002A\u0011CA*\u0003%\u0019XM]5bY&TX\r\u0006\u0004\u0002V\u0005m\u0013q\f\t\u0004%\u0005]\u0013bAA-'\t!QK\\5u\u0011\u001d\ti&a\u0014A\u0002m\t\u0001\"\\3uC\u0012\fG/\u0019\u0005\t\u0003C\ny\u00051\u0001\u0002d\u0005\u0019q.\u001e;\u0011\t\u0005\u0015\u00141N\u0007\u0003\u0003ORA!!\u001b\u0002\u001c\u0005\u0011\u0011n\\\u0005\u0005\u0003[\n9G\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0002r\u0001!\t\"a\u001d\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u00047\u0005U\u0004\u0002CA<\u0003_\u0002\r!!\u001f\u0002\u0005%t\u0007\u0003BA3\u0003wJA!! \u0002h\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\t\t\t\u0001C!\u0003\u0007\u000b1!\u00193e)\u0019\t9%!\"\u0002\b\"A\u0011\u0011GA@\u0001\u0004\t\u0019\u0004C\u0004\u0002^\u0005}\u0004\u0019A\u000e\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\u0006\u0019q-\u001a;\u0015\t\u0005=\u0015Q\u0013\t\u0005%\u0005E5$C\u0002\u0002\u0014N\u0011aa\u00149uS>t\u0007\u0002CA\u0019\u0003\u0013\u0003\r!a\r\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\u00061\u0012\r\u001d9ms\u001asGk\u001c\"bi\u000eD')_*ue\u0016\fW.\u0006\u0003\u0002\u001e\u0006\rF\u0003BAP\u0003s#B!!)\u00020B\u0019A$a)\u0005\u0011\u0005\u0015\u0016q\u0013b\u0001\u0003O\u00131AU#U#\r\u0001\u0013\u0011\u0016\t\u0004%\u0005-\u0016bAAW'\t\u0019\u0011I\\=\t\u0011\u0005E\u0016q\u0013a\u0001\u0003g\u000b!A\u001a8\u0011\u000fI\t),!\u001f\u0002\"&\u0019\u0011qW\n\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0002CA\u0019\u0003/\u0003\r!a\r\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\u0006\u0019\u0012\r\u001a3OK^\u0014\u0015\r^2i\u0005f\u001cFO]3b[R!\u0011\u0011YAd)\u0011\t9%a1\t\u0011\u0005E\u00161\u0018a\u0001\u0003\u000b\u0004rAEA[\u0003G\n)\u0006\u0003\u0005\u00022\u0005m\u0006\u0019AA\u001a\u0011\u001d\tY\t\u0001C!\u0003\u0017$b!!4\u0002Z\u0006}\u0007#\u0002\n\u0002P\u0006M\u0017bAAi'\t)\u0011I\u001d:bsB1!#!6\u00024mI1!a6\u0014\u0005\u0019!V\u000f\u001d7fe!A\u00111\\Ae\u0001\u0004\ti.A\u0004ti\u0006\u0014H/\u00133\u0011\u000bI\t\t*a\r\t\u0011\u0005\u0005\u0018\u0011\u001aa\u0001\u0003;\fQ!\u001a8e\u0013\u0012Dq!!:\u0001\t\u0003\t9/\u0001\thKRd\u0015\r^3ti\n\u000bGo\u00195JIR\u0011\u0011Q\u001c\u0005\b\u0003W\u0004A\u0011IAw\u0003%9W\r\u001e'bi\u0016\u001cH\u000f\u0006\u0002\u0002pB)!#!%\u0002T\"9\u00111\u001f\u0001\u0005\u0002\u0005U\u0018\u0001F4fi>\u0013H-\u001a:fI\n\u000bGo\u00195GS2,7\u000f\u0006\u0002\u0002xB)!#a4\u0002zB\u0019\u0011/a?\n\u0007\u0005u(O\u0001\u0006GS2,7\u000b^1ukNDqA!\u0001\u0001\t\u0003\u0012\u0019!A\u0003qkJ<W\r\u0006\u0003\u0002V\t\u0015\u0001\u0002\u0003B\u0004\u0003\u007f\u0004\r!a\r\u0002!QD'/Z:i_2$')\u0019;dQ&#\u0007b\u0002B\u0006\u0001\u0011\u0005!QB\u0001\u000baV\u0014x-Z!gi\u0016\u0014H\u0003BA+\u0005\u001fA\u0001Ba\u0002\u0003\n\u0001\u0007\u00111\u0007\u0005\t\u0005'\u0001A\u0011\u0001\u0004\u0003\u0016\u0005a\u0001/\u0019:tKZ+'o]5p]R1!q\u0003B\u000f\u0005C\u00012A\u0005B\r\u0013\r\u0011Yb\u0005\u0002\u0004\u0013:$\bb\u0002B\u0010\u0005#\u0001\r!M\u0001\u0005i\u0016DH\u000f\u0003\u0005\u0003$\tE\u0001\u0019\u0001B\f\u0003Mi\u0017\r_*vaB|'\u000f^3e-\u0016\u00148/[8o\u000f\u001d\u00119C\u0001E\u0001\u0005S\tq\u0002\u0013#G'6+G/\u00193bi\u0006dun\u001a\t\u00041\t-bAB\u0001\u0003\u0011\u0003\u0011icE\u0002\u0003,EAq!\u0011B\u0016\t\u0003\u0011\t\u0004\u0006\u0002\u0003*!A!Q\u0007B\u0016\t\u0003\u00119$\u0001\bwKJLg-\u001f\"bi\u000eD\u0017\nZ:\u0015\u0011\u0005U#\u0011\bB+\u0005/B\u0001Ba\u000f\u00034\u0001\u0007!QH\u0001\tE\u0006$8\r[%egB1!q\bB(\u0003gqAA!\u0011\u0003L9!!1\tB%\u001b\t\u0011)EC\u0002\u0003H9\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000b\n\u0007\t53#A\u0004qC\u000e\\\u0017mZ3\n\t\tE#1\u000b\u0002\u0004'\u0016\f(b\u0001B''!A\u00111\u001cB\u001a\u0001\u0004\ti\u000e\u0003\u0005\u0002b\nM\u0002\u0019AAo\u0001")
public class HDFSMetadataLog<T>
implements MetadataLog<T>,
Logging {
    public final String org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$path;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final Path metadataPath;
    private final CheckpointFileManager fileManager;
    private final PathFilter batchFilesFilter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void verifyBatchIds(Seq<Object> seq, Option<Object> option, Option<Object> option2) {
        HDFSMetadataLog$.MODULE$.verifyBatchIds(seq, option, option2);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public Path metadataPath() {
        return this.metadataPath;
    }

    public CheckpointFileManager fileManager() {
        return this.fileManager;
    }

    public PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    public Path batchIdToPath(long batchId) {
        return new Path(this.metadataPath(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString());
    }

    public long pathToBatchId(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void serialize(T metadata, OutputStream out) {
        Serialization$.MODULE$.write(metadata, out, this.formats());
    }

    public T deserialize(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return (T)Serialization$.MODULE$.read((Reader)reader, this.formats(), this.manifest());
    }

    @Override
    public boolean add(long batchId, T metadata) {
        Predef$.MODULE$.require(metadata != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "'null' metadata cannot written to a metadata log";
            }
        });
        return this.addNewBatchByStream(batchId, (Function1<OutputStream, BoxedUnit>)new Serializable(this, metadata){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;
            private final Object metadata$1;

            public final void apply(OutputStream output2) {
                this.$outer.serialize(this.metadata$1, output2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metadata$1 = metadata$1;
            }
        });
    }

    @Override
    public Option<T> get(long batchId) {
        Option option;
        try {
            option = (Option)this.applyFnToBatchByStream(batchId, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HDFSMetadataLog $outer;

                public final Some<T> apply(InputStream input) {
                    return new Some(this.$outer.deserialize(input));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logDebug((Function0<String>)new Serializable(this, fileNotFoundException){
                public static final long serialVersionUID = 0L;
                private final FileNotFoundException fne$1;

                public final String apply() {
                    return this.fne$1.getMessage();
                }
                {
                    this.fne$1 = fne$1;
                }
            });
            option = None$.MODULE$;
        }
        return option;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <RET> RET applyFnToBatchByStream(long batchId, Function1<InputStream, RET> fn) {
        Object object;
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (!this.fileManager().exists(batchMetadataFile)) throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batchMetadataFile})));
        FSDataInputStream input = this.fileManager().open(batchMetadataFile);
        try {
            object = fn.apply((Object)input);
        }
        catch (IllegalStateException illegalStateException) {
            try {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to read log file ", ". ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batchMetadataFile, illegalStateException.getMessage()})), illegalStateException);
            }
            catch (Throwable throwable) {
                void var5_4;
                IOUtils.closeQuietly((InputStream)var5_4);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return (RET)object;
    }

    public boolean addNewBatchByStream(long batchId, Function1<OutputStream, BoxedUnit> fn) {
        return BoxesRunTime.unboxToBoolean((Object)this.get(batchId).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(T x$1) {
                return false;
            }
        }).getOrElse((Function0)new Serializable(this, batchId, fn){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;
            private final long batchId$1;
            private final Function1 fn$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * WARNING - void declaration
             */
            public boolean apply$mcZ$sp() {
                void var1_1;
                CheckpointFileManager.CancellableFSDataOutputStream output2 = this.$outer.fileManager().createAtomic(this.$outer.batchIdToPath(this.batchId$1), false);
                try {
                    this.fn$1.apply((Object)((Object)output2));
                    output2.close();
                    return true;
                }
                catch (Throwable throwable) {
                    var1_1.cancel();
                    throw throwable;
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    var1_1.cancel();
                    throw new ConcurrentModificationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multiple streaming queries are concurrently using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$path})), fileAlreadyExistsException);
                }
            }
            {
                void var4_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batchId$1 = batchId$1;
                this.fn$1 = var4_3;
            }
        }));
    }

    @Override
    public Tuple2<Object, T>[] get(Option<Object> startId, Option<Object> endId) {
        Predef$.MODULE$.assert(startId.isEmpty() || endId.isEmpty() || BoxesRunTime.unboxToLong((Object)startId.get()) <= BoxesRunTime.unboxToLong((Object)endId.get()));
        FileStatus[] files = this.fileManager().list(this.metadataPath(), this.batchFilesFilter());
        long[] batchIds = (long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).filter((Function1)new Serializable(this, startId, endId){
            public static final long serialVersionUID = 0L;
            private final Option startId$1;
            private final Option endId$1;

            public final boolean apply(long batchId) {
                return this.apply$mcZJ$sp(batchId);
            }

            public boolean apply$mcZJ$sp(long batchId) {
                return !(!this.endId$1.isEmpty() && batchId > BoxesRunTime.unboxToLong((Object)this.endId$1.get()) || !this.startId$1.isEmpty() && batchId < BoxesRunTime.unboxToLong((Object)this.startId$1.get()));
            }
            {
                void var3_3;
                this.startId$1 = startId$1;
                this.endId$1 = var3_3;
            }
        })).sorted((Ordering)Ordering.Long$.MODULE$);
        HDFSMetadataLog$.MODULE$.verifyBatchIds((Seq<Object>)Predef$.MODULE$.wrapLongArray(batchIds), startId, endId);
        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.longArrayOps(batchIds).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final Tuple2<Object, Option<T>> apply(long batchId) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), this.$outer.get(batchId));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Option<T>> x$2) {
                return ((Option)x$2._2()).isDefined();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, T> apply(Tuple2<Object, Option<T>> x0$1) {
                Tuple2<Object, Option<T>> tuple2 = x0$1;
                if (tuple2 != null) {
                    long batchId = tuple2._1$mcJ$sp();
                    Option metadataOption = (Option)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), metadataOption.get());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public Option<Object> getLatestBatchId() {
        return Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sorted(Ordering.Long$.MODULE$.reverse())).headOption();
    }

    @Override
    public Option<Tuple2<Object, T>> getLatest() {
        return this.getLatestBatchId().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final Tuple2<Object, T> apply(long batchId) {
                Object content = this.$outer.get(batchId).getOrElse((Function0)new Serializable(this, batchId){
                    public static final long serialVersionUID = 0L;
                    private final long batchId$2;

                    public final Nothing$ apply() {
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to read log file for batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.batchId$2)})));
                    }
                    {
                        this.batchId$2 = batchId$2;
                    }
                });
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), content);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public FileStatus[] getOrderedBatchFiles() {
        return (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Ordering)Ordering.Long$.MODULE$)).reverse();
    }

    @Override
    public void purge(long thresholdBatchId) {
        long[] batchIds = (long[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        Predef$.MODULE$.longArrayOps(batchIds).withFilter((Function1)new Serializable(this, thresholdBatchId){
            public static final long serialVersionUID = 0L;
            private final long thresholdBatchId$1;

            public final boolean apply(long batchId) {
                return this.apply$mcZJ$sp(batchId);
            }

            public boolean apply$mcZJ$sp(long batchId) {
                return batchId < this.thresholdBatchId$1;
            }
            {
                this.thresholdBatchId$1 = thresholdBatchId$1;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final void apply(long batchId) {
                this.apply$mcVJ$sp(batchId);
            }

            public void apply$mcVJ$sp(long batchId) {
                Path path = this.$outer.batchIdToPath(batchId);
                this.$outer.fileManager().delete(path);
                this.$outer.logTrace((Function0<String>)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final Path path$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed metadata log file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                    }
                    {
                        this.path$1 = path$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void purgeAfter(long thresholdBatchId) {
        long[] batchIds = (long[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        Predef$.MODULE$.longArrayOps(batchIds).withFilter((Function1)new Serializable(this, thresholdBatchId){
            public static final long serialVersionUID = 0L;
            private final long thresholdBatchId$2;

            public final boolean apply(long batchId) {
                return this.apply$mcZJ$sp(batchId);
            }

            public boolean apply$mcZJ$sp(long batchId) {
                return batchId > this.thresholdBatchId$2;
            }
            {
                this.thresholdBatchId$2 = thresholdBatchId$2;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final void apply(long batchId) {
                this.apply$mcVJ$sp(batchId);
            }

            public void apply$mcVJ$sp(long batchId) {
                Path path = this.$outer.batchIdToPath(batchId);
                this.$outer.fileManager().delete(path);
                this.$outer.logTrace((Function0<String>)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final Path path$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed metadata log file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$2}));
                    }
                    {
                        this.path$2 = path$2;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int parseVersion(String text, int maxSupportedVersion) {
        int version;
        if (text.length() <= 0 || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text), 0) != 'v') throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log file was malformed: failed to read correct log "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"version from ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{text}))).toString());
        try {
            version = new StringOps(Predef$.MODULE$.augmentString(text.substring(1, text.length()))).toInt();
            if (version <= 0) throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log file was malformed: failed to read correct log "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"version from ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{text}))).toString());
            if (version <= maxSupportedVersion) return version;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log file was malformed: failed to read correct log "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"version from ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{text}))).toString());
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnsupportedLogVersion: maximum supported log version "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is v", ", but encountered v", ". The log file was produced "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSupportedVersion), BoxesRunTime.boxToInteger((int)version)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"by a newer version of Spark and cannot be read by this version. Please upgrade."})).s((Seq)Nil$.MODULE$)).toString());
    }

    public HDFSMetadataLog(SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$path = path;
        Logging.class.$init$((Logging)this);
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        Class clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.manifest())).runtimeClass();
        Class<Seq> clazz2 = Seq.class;
        Predef$.MODULE$.require(clazz != null ? !clazz.equals(clazz2) : clazz2 != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Should not create a log with type Seq, use Arrays instead - see SPARK-17372";
            }
        });
        this.metadataPath = new Path(path);
        this.fileManager = CheckpointFileManager$.MODULE$.create(this.metadataPath(), sparkSession.sessionState().newHadoopConf());
        if (!this.fileManager().exists(this.metadataPath())) {
            this.fileManager().mkdirs(this.metadataPath());
        }
        this.batchFilesFilter = new PathFilter(this){
            private final /* synthetic */ HDFSMetadataLog $outer;

            public boolean accept(Path path) {
                return this.$outer.isBatchFile(path);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

