/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.ui;

import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.state.StateStoreCustomMetric;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.StateOperatorProgress;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.ui.StreamingQueryStatisticsPage$$anonfun$generateAggregatedCustomMetrics$2$;
import org.apache.spark.sql.streaming.ui.StreamingQueryTab;
import org.apache.spark.sql.streaming.ui.StreamingQueryUIData;
import org.apache.spark.sql.streaming.ui.UIUtils$;
import org.apache.spark.ui.GraphUIData;
import org.apache.spark.ui.GraphUIData$;
import org.apache.spark.ui.JsCollector;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.WebUIPage;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u0005-e!B\u0001\u0003\u0001\tq!\u0001H*ue\u0016\fW.\u001b8h#V,'/_*uCRL7\u000f^5dgB\u000bw-\u001a\u0006\u0003\u0007\u0011\t!!^5\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0004\u0001=!\u0002C\u0001\t\u0013\u001b\u0005\t\"BA\u0002\t\u0013\t\u0019\u0012CA\u0005XK\n,\u0016\nU1hKB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\tS:$XM\u001d8bY&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h\u0011!Y\u0002A!A!\u0002\u0013i\u0012A\u00029be\u0016tGo\u0001\u0001\u0011\u0005yyR\"\u0001\u0002\n\u0005\u0001\u0012!!E*ue\u0016\fW.\u001b8h#V,'/\u001f+bE\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001J\u0013\u0011\u0005y\u0001\u0001\"B\u000e\"\u0001\u0004i\u0002bB\u0014\u0001\u0005\u0004%I\u0001K\u0001\u0017gV\u0004\bo\u001c:uK\u0012\u001cUo\u001d;p[6+GO]5dgV\t\u0011\u0006E\u0002+i]r!aK\u0019\u000f\u00051zS\"A\u0017\u000b\u00059b\u0012A\u0002\u001fs_>$h(C\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u00114'A\u0004qC\u000e\\\u0017mZ3\u000b\u0003AJ!!\u000e\u001c\u0003\u0007M+\u0017O\u0003\u00023gA\u0011\u0001HP\u0007\u0002s)\u0011!hO\u0001\u0006gR\fG/\u001a\u0006\u0003\u000bqR!!\u0010\u0004\u0002\u0013\u0015DXmY;uS>t\u0017BA :\u0005Y\u0019F/\u0019;f'R|'/Z\"vgR|W.T3ue&\u001c\u0007BB!\u0001A\u0003%\u0011&A\ftkB\u0004xN\u001d;fI\u000e+8\u000f^8n\u001b\u0016$(/[2tA!91\t\u0001b\u0001\n\u0013!\u0015\u0001F3oC\ndW\rZ\"vgR|W.T3ue&\u001c7/F\u0001F!\r1\u0015JS\u0007\u0002\u000f*\u0011\u0001jM\u0001\u000bG>dG.Z2uS>t\u0017BA\u001bH!\tY\u0005+D\u0001M\u0015\tie*\u0001\u0003mC:<'\"A(\u0002\t)\fg/Y\u0005\u0003#2\u0013aa\u0015;sS:<\u0007BB*\u0001A\u0003%Q)A\u000bf]\u0006\u0014G.\u001a3DkN$x.\\'fiJL7m\u001d\u0011\t\u000bU\u0003A\u0011\u0001,\u0002+\u001d,g.\u001a:bi\u0016du.\u00193SKN|WO]2fgR\u0011qK\u0018\t\u0004UQB\u0006CA-]\u001b\u0005Q&BA.4\u0003\rAX\u000e\\\u0005\u0003;j\u0013AAT8eK\")q\f\u0016a\u0001A\u00069!/Z9vKN$\bCA1i\u001b\u0005\u0011'BA2e\u0003\u0011AG\u000f\u001e9\u000b\u0005\u00154\u0017aB:feZdW\r\u001e\u0006\u0002O\u0006)!.\u0019<bq&\u0011\u0011N\u0019\u0002\u0013\u0011R$\boU3sm2,GOU3rk\u0016\u001cH\u000fC\u0003l\u0001\u0011\u0005C.\u0001\u0004sK:$WM\u001d\u000b\u0003/6DQa\u00186A\u0002\u0001DQa\u001c\u0001\u0005\u0002A\fqbZ3oKJ\fG/\u001a+j[\u0016l\u0015\r\u001d\u000b\u0003/FDQA\u001d8A\u0002M\fQ\u0001^5nKN\u00042A\u000b\u001bu!\t)h/D\u00014\u0013\t98G\u0001\u0003M_:<\u0007\"B=\u0001\t\u0003Q\u0018AF4f]\u0016\u0014\u0018\r^3US6,G+\u001b9TiJLgnZ:\u0015\u0005][\b\"\u0002?y\u0001\u0004i\u0018A\u0002<bYV,7\u000f\u0005\u0003v}\u0006\u0005\u0011BA@4\u0005\u0015\t%O]1z!\u0015)\u00181\u0001;u\u0013\r\t)a\r\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f\u0005yr-\u001a8fe\u0006$XMR8s[\u0006$H/\u001a3US6,G+\u001b9TiJLgnZ:\u0015\u0007]\u000bi\u0001\u0003\u0004}\u0003\u000f\u0001\r! \u0005\b\u0003#\u0001A\u0011AA\n\u0003Q9WM\\3sCR,G+[7f)>4\u0016\r\\;fgR\u0019q+!\u0006\t\u000fq\fy\u00011\u0001\u0002\u0018A!QO`A\r!\u0019)\u00181\u0001;\u0002\u001cAA\u0011QDA\u0012\u0003O\t\u0019$\u0004\u0002\u0002 )\u0019\u0011\u0011\u0005(\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003K\tyBA\u0002NCB\u0004B!!\u000b\u000209\u0019Q/a\u000b\n\u0007\u000552'\u0001\u0004Qe\u0016$WMZ\u0005\u0004#\u0006E\"bAA\u0017gA\u00191*!\u000e\n\u0005]d\u0005bBA\u001d\u0001\u0011\u0005\u00111H\u0001\u0012O\u0016tWM]1uK\n\u000b7/[2J]\u001a|GcA,\u0002>!A\u0011qHA\u001c\u0001\u0004\t\t%A\u0003rk\u0016\u0014\u0018\u0010E\u0002\u001f\u0003\u0007J1!!\u0012\u0003\u0005Q\u0019FO]3b[&tw-U;fef,\u0016\nR1uC\"9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0013!E4f]\u0016\u0014\u0018\r^3XCR,'/\\1sWRIq+!\u0014\u0002P\u0005M\u0013q\u000b\u0005\t\u0003\u007f\t9\u00051\u0001\u0002B!9\u0011\u0011KA$\u0001\u0004!\u0018\u0001D7j]\n\u000bGo\u00195US6,\u0007bBA+\u0003\u000f\u0002\r\u0001^\u0001\r[\u0006D()\u0019;dQRKW.\u001a\u0005\t\u00033\n9\u00051\u0001\u0002\\\u0005Y!n]\"pY2,7\r^8s!\r\u0001\u0012QL\u0005\u0004\u0003?\n\"a\u0003&t\u0007>dG.Z2u_JDq!a\u0019\u0001\t\u0003\t)'\u0001\u0011hK:,'/\u0019;f\u0003\u001e<'/Z4bi\u0016$7\u000b^1uK>\u0003XM]1u_J\u001cHCCA4\u0003[\ny'!\u001d\u0002tA\u0019\u0011,!\u001b\n\u0007\u0005-$L\u0001\u0006O_\u0012,')\u001e4gKJD\u0001\"a\u0010\u0002b\u0001\u0007\u0011\u0011\t\u0005\b\u0003#\n\t\u00071\u0001u\u0011\u001d\t)&!\u0019A\u0002QD\u0001\"!\u0017\u0002b\u0001\u0007\u00111\f\u0005\b\u0003o\u0002A\u0011AA=\u0003}9WM\\3sCR,\u0017iZ4sK\u001e\fG/\u001a3DkN$x.\\'fiJL7m\u001d\u000b\u000b\u0003O\nY(! \u0002\u0000\u0005\u0005\u0005\u0002CA \u0003k\u0002\r!!\u0011\t\u000f\u0005E\u0013Q\u000fa\u0001i\"9\u0011QKA;\u0001\u0004!\b\u0002CA-\u0003k\u0002\r!a\u0017\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\u0006\tr-\u001a8fe\u0006$Xm\u0015;biR\u000b'\r\\3\u0015\u0007]\u000bI\t\u0003\u0005\u0002@\u0005\r\u0005\u0019AA!\u0001")
public class StreamingQueryStatisticsPage
extends WebUIPage
implements Logging {
    private final StreamingQueryTab parent;
    private final Seq<StateStoreCustomMetric> org$apache$spark$sql$streaming$ui$StreamingQueryStatisticsPage$$supportedCustomMetrics;
    private final Seq<String> org$apache$spark$sql$streaming$ui$StreamingQueryStatisticsPage$$enabledCustomMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Seq<StateStoreCustomMetric> org$apache$spark$sql$streaming$ui$StreamingQueryStatisticsPage$$supportedCustomMetrics() {
        return this.org$apache$spark$sql$streaming$ui$StreamingQueryStatisticsPage$$supportedCustomMetrics;
    }

    public Seq<String> org$apache$spark$sql$streaming$ui$StreamingQueryStatisticsPage$$enabledCustomMetrics() {
        return this.org$apache$spark$sql$streaming$ui$StreamingQueryStatisticsPage$$enabledCustomMetrics;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> generateLoadResources(HttpServletRequest request) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("src", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, "/static/d3.min.js", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("href", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, "/static/streaming-page.css", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("src", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, "/static/streaming-page.js", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("src", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, "/static/structured-streaming-page.js", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        return var2_2;
    }

    public Seq<Node> render(HttpServletRequest request) {
        String parameterId = request.getParameter("id");
        Predef$.MODULE$.require(parameterId != null && new StringOps(Predef$.MODULE$.augmentString(parameterId)).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Missing id parameter";
            }
        });
        StreamingQueryUIData query = (StreamingQueryUIData)this.parent.statusListener().allQueryStatus().find((Function1)new Serializable(this, parameterId){
            public static final long serialVersionUID = 0L;
            private final String parameterId$1;

            public final boolean apply(StreamingQueryUIData x0$1) {
                StreamingQueryUIData streamingQueryUIData = x0$1;
                boolean bl = streamingQueryUIData.runId().equals(UUID.fromString(this.parameterId$1));
                return bl;
            }
            {
                this.parameterId$1 = parameterId$1;
            }
        }).getOrElse((Function0)new Serializable(this, parameterId){
            public static final long serialVersionUID = 0L;
            private final String parameterId$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find streaming query ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parameterId$1})));
            }
            {
                this.parameterId$1 = parameterId$1;
            }
        });
        Seq<Node> resources = this.generateLoadResources(request);
        Seq<Node> basicInfo = this.generateBasicInfo(query);
        Seq content = (Seq)((TraversableLike)resources.$plus$plus(basicInfo, Seq$.MODULE$.canBuildFrom())).$plus$plus(this.generateStatTable(query), Seq$.MODULE$.canBuildFrom());
        return org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage(request, "Streaming Query Statistics", (Function0)new Serializable(this, content){
            public static final long serialVersionUID = 0L;
            private final Seq content$1;

            public final Seq<Node> apply() {
                return this.content$1;
            }
            {
                this.content$1 = content$1;
            }
        }, (SparkUITab)this.parent, org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$5(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$6(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$7(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$8());
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> generateTimeMap(Seq<Object> times) {
        void var3_3;
        String js = new StringBuilder().append((Object)"var timeFormat = {};\n").append((Object)((TraversableOnce)times.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(long time) {
                String formattedTime = org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime(time, 1L, false, org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime$default$4());
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timeFormat[", "] = '", "';"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)time), formattedTime}));
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n")).toString();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(js));
        return new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> generateTimeTipStrings(Tuple2<Object, Object>[] values2) {
        void var3_3;
        String js = new StringBuilder().append((Object)"var timeTipStrings = {};\n").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])values2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    long batchId = tuple2._1$mcJ$sp();
                    long time = tuple2._2$mcJ$sp();
                    String formattedTime = org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime(time, 1L, false, org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime$default$4());
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timeTipStrings[", "] = 'batch ", " (", ")';"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)time), BoxesRunTime.boxToLong((long)batchId), formattedTime}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\n")).toString();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(js));
        return new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> generateFormattedTimeTipStrings(Tuple2<Object, Object>[] values2) {
        void var3_3;
        String js = new StringBuilder().append((Object)"var formattedTimeTipStrings = {};\n").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])values2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Object, Object> x0$3) {
                Tuple2<Object, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    long batchId = tuple2._1$mcJ$sp();
                    long time = tuple2._2$mcJ$sp();
                    String formattedTime = org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime(time, 1L, false, org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime$default$4());
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"formattedTimeTipStrings[\"", "\"] = 'batch ", " (", ")';"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formattedTime, BoxesRunTime.boxToLong((long)batchId), formattedTime}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\n")).toString();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(js));
        return new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    public Seq<Node> generateTimeToValues(Tuple2<Object, Map<String, Long>>[] values2) {
        Tuple2[] durationDataPadding = org.apache.spark.ui.UIUtils$.MODULE$.durationDataPadding(values2);
        String js = new StringBuilder().append((Object)"var formattedTimeToValues = {};\n").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])durationDataPadding).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Object, scala.collection.immutable.Map<String, Object>> x0$4) {
                Tuple2<Object, scala.collection.immutable.Map<String, Object>> tuple2 = x0$4;
                if (tuple2 != null) {
                    long x = tuple2._1$mcJ$sp();
                    scala.collection.immutable.Map y = (scala.collection.immutable.Map)tuple2._2();
                    String s = ((TraversableOnce)((TraversableLike)y.toSeq().sortBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<String, Object> x$2) {
                            return (String)x$2._1();
                        }
                    }, (Ordering)Ordering.String$.MODULE$)).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<String, Object> e) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)e._2$mcD$sp())}));
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
                    String formattedTime = org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime(x, 1L, false, org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime$default$4());
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"formattedTimeToValues[\"", "\"] = ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formattedTime, s}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\n")).toString();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(js));
        return new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public Seq<Node> generateBasicInfo(StreamingQueryUIData query) {
        String duration = query.isActive() ? org.apache.spark.ui.UIUtils$.MODULE$.formatDurationVerbose(System.currentTimeMillis() - query.startTimestamp()) : UIUtils$.MODULE$.withNoProgress(query, new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryUIData query$1;

            public final String apply() {
                String end = this.query$1.lastProgress().timestamp();
                String start2 = ((StreamingQueryProgress)Predef$.MODULE$.refArrayOps((Object[])this.query$1.recentProgress()).head()).timestamp();
                return org.apache.spark.ui.UIUtils$.MODULE$.formatDurationVerbose(UIUtils$.MODULE$.parseProgressTimestamp(end) - UIUtils$.MODULE$.parseProgressTimestamp(start2));
            }
            {
                this.query$1 = query$1;
            }
        }, "-");
        String name2 = UIUtils$.MODULE$.getQueryName(query);
        long numBatches = BoxesRunTime.unboxToLong((Object)UIUtils$.MODULE$.withNoProgress(query, new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryUIData query$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.query$1.lastProgress().batchId() + 1L;
            }
            {
                this.query$1 = query$1;
            }
        }, BoxesRunTime.boxToLong((long)0L)));
        NodeBuffer $buf = new NodeBuffer();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Running batches for\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)duration);
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      since\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDate(query.startTimestamp()));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf2.$amp$plus((Object)new Text("\n      ("));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)BoxesRunTime.boxToLong((long)numBatches));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf2.$amp$plus((Object)new Text(" completed batches)\n    "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        NodeBuffer $buf6 = new NodeBuffer();
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Name: "));
        $buf6.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf6.$amp$plus((Object)name2);
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        NodeBuffer $buf8 = new NodeBuffer();
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Id: "));
        $buf8.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf8.$amp$plus((Object)query.id());
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        NodeBuffer $buf10 = new NodeBuffer();
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("RunId: "));
        $buf10.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf10.$amp$plus((Object)query.runId());
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        return $buf;
    }

    public Seq<Node> generateWatermark(StreamingQueryUIData query, long minBatchTime, long maxBatchTime, JsCollector jsCollector) {
        Seq seq;
        Predef$.MODULE$.require(query.lastProgress() != null);
        if (query.lastProgress().eventTime().containsKey("watermark")) {
            Tuple2[] watermarkData = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()).flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<Tuple2<Object, Object>> apply(StreamingQueryProgress p) {
                    long batchTimestamp = UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp());
                    long watermarkValue = UIUtils$.MODULE$.parseProgressTimestamp(p.eventTime().get("watermark"));
                    return watermarkValue > 0L ? Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2.mcJD.sp(batchTimestamp, (double)(batchTimestamp - watermarkValue) / 1000.0))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            if (Predef$.MODULE$.refArrayOps((Object[])watermarkData).nonEmpty()) {
                double maxWatermark = ((Tuple2)Predef$.MODULE$.refArrayOps((Object[])watermarkData).maxBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x$3) {
                        return x$3._2$mcD$sp();
                    }
                }, (Ordering)Ordering.Double$.MODULE$))._2$mcD$sp();
                GraphUIData graphUIDataForWatermark = new GraphUIData("watermark-gap-timeline", "watermark-gap-histogram", (Seq)Predef$.MODULE$.wrapRefArray((Object[])watermarkData), minBatchTime, maxBatchTime, 0.0, maxWatermark, "seconds", GraphUIData$.MODULE$.$lessinit$greater$default$9());
                graphUIDataForWatermark.generateDataJs(jsCollector);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n          "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md);
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("\n            "));
                Null$ $md2 = Null$.MODULE$;
                $md2 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md2);
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf4 = new NodeBuffer();
                NodeBuffer $buf5 = new NodeBuffer();
                $buf5.$amp$plus((Object)new Text("Global Watermark Gap "));
                $buf5.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("The gap between batch timestamp and global watermark for the batch.", "right"));
                $buf4.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
                $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
                $buf3.$amp$plus((Object)new Text("\n            "));
                $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                $buf2.$amp$plus((Object)new Text("\n          "));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n          "));
                Null$ $md3 = Null$.MODULE$;
                $md3 = new UnprefixedAttribute("class", (Seq)new Text("watermark-gap-timeline"), (MetaData)$md3);
                NodeBuffer $buf6 = new NodeBuffer();
                $buf6.$amp$plus((Object)graphUIDataForWatermark.generateTimelineHtml(jsCollector));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
                $buf.$amp$plus((Object)new Text("\n          "));
                Null$ $md4 = Null$.MODULE$;
                $md4 = new UnprefixedAttribute("class", (Seq)new Text("watermark-gap-histogram"), (MetaData)$md4);
                NodeBuffer $buf7 = new NodeBuffer();
                $buf7.$amp$plus((Object)graphUIDataForWatermark.generateHistogramHtml(jsCollector));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
                $buf.$amp$plus((Object)new Text("\n        "));
                Elem elem = new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                seq = elem;
            } else {
                seq = (Seq)Seq$.MODULE$.empty();
            }
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public NodeBuffer generateAggregatedStateOperators(StreamingQueryUIData query, long minBatchTime, long maxBatchTime, JsCollector jsCollector) {
        NodeBuffer nodeBuffer;
        Predef$.MODULE$.require(query.lastProgress() != null);
        if (Predef$.MODULE$.refArrayOps((Object[])query.lastProgress().stateOperators()).nonEmpty()) {
            Tuple2[] numRowsTotalData = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(StreamingQueryProgress p) {
                    return new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), (double)BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])p.stateOperators()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(StateOperatorProgress x$4) {
                            return x$4.numRowsTotal();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            double maxNumRowsTotal = ((Tuple2)Predef$.MODULE$.refArrayOps((Object[])numRowsTotalData).maxBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x$5) {
                    return x$5._2$mcD$sp();
                }
            }, (Ordering)Ordering.Double$.MODULE$))._2$mcD$sp();
            Tuple2[] numRowsUpdatedData = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(StreamingQueryProgress p) {
                    return new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), (double)BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])p.stateOperators()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(StateOperatorProgress x$6) {
                            return x$6.numRowsUpdated();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            double maxNumRowsUpdated = ((Tuple2)Predef$.MODULE$.refArrayOps((Object[])numRowsUpdatedData).maxBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x$7) {
                    return x$7._2$mcD$sp();
                }
            }, (Ordering)Ordering.Double$.MODULE$))._2$mcD$sp();
            Tuple2[] memoryUsedBytesData = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(StreamingQueryProgress p) {
                    return new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), (double)BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])p.stateOperators()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(StateOperatorProgress x$8) {
                            return x$8.memoryUsedBytes();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            double maxMemoryUsedBytes = ((Tuple2)Predef$.MODULE$.refArrayOps((Object[])memoryUsedBytesData).maxBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x$9) {
                    return x$9._2$mcD$sp();
                }
            }, (Ordering)Ordering.Double$.MODULE$))._2$mcD$sp();
            Tuple2[] numRowsDroppedByWatermarkData = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(StreamingQueryProgress p) {
                    return new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), (double)BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])p.stateOperators()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(StateOperatorProgress x$10) {
                            return x$10.numRowsDroppedByWatermark();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            double maxNumRowsDroppedByWatermark = ((Tuple2)Predef$.MODULE$.refArrayOps((Object[])numRowsDroppedByWatermarkData).maxBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x$11) {
                    return x$11._2$mcD$sp();
                }
            }, (Ordering)Ordering.Double$.MODULE$))._2$mcD$sp();
            GraphUIData graphUIDataForNumberTotalRows = new GraphUIData("aggregated-num-total-state-rows-timeline", "aggregated-num-total-state-rows-histogram", (Seq)Predef$.MODULE$.wrapRefArray((Object[])numRowsTotalData), minBatchTime, maxBatchTime, 0.0, maxNumRowsTotal, "records", GraphUIData$.MODULE$.$lessinit$greater$default$9());
            graphUIDataForNumberTotalRows.generateDataJs(jsCollector);
            GraphUIData graphUIDataForNumberUpdatedRows = new GraphUIData("aggregated-num-updated-state-rows-timeline", "aggregated-num-updated-state-rows-histogram", (Seq)Predef$.MODULE$.wrapRefArray((Object[])numRowsUpdatedData), minBatchTime, maxBatchTime, 0.0, maxNumRowsUpdated, "records", GraphUIData$.MODULE$.$lessinit$greater$default$9());
            graphUIDataForNumberUpdatedRows.generateDataJs(jsCollector);
            GraphUIData graphUIDataForMemoryUsedBytes = new GraphUIData("aggregated-state-memory-used-bytes-timeline", "aggregated-state-memory-used-bytes-histogram", (Seq)Predef$.MODULE$.wrapRefArray((Object[])memoryUsedBytesData), minBatchTime, maxBatchTime, 0.0, maxMemoryUsedBytes, "bytes", GraphUIData$.MODULE$.$lessinit$greater$default$9());
            graphUIDataForMemoryUsedBytes.generateDataJs(jsCollector);
            GraphUIData graphUIDataForNumRowsDroppedByWatermark = new GraphUIData("aggregated-num-rows-dropped-by-watermark-timeline", "aggregated-num-rows-dropped-by-watermark-histogram", (Seq)Predef$.MODULE$.wrapRefArray((Object[])numRowsDroppedByWatermarkData), minBatchTime, maxBatchTime, 0.0, maxNumRowsDroppedByWatermark, "records", GraphUIData$.MODULE$.$lessinit$greater$default$9());
            graphUIDataForNumRowsDroppedByWatermark.generateDataJs(jsCollector);
            NodeBuffer $buf = new NodeBuffer();
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md2);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf5 = new NodeBuffer();
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("Aggregated Number Of Total State Rows "));
            $buf6.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Aggregated number of total state rows.", "right"));
            $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
            $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
            $buf4.$amp$plus((Object)new Text("\n            "));
            $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
            $buf2.$amp$plus((Object)new Text("\n          "));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("class", "aggregated-num-total-state-rows-timeline", (MetaData)$md3);
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)graphUIDataForNumberTotalRows.generateTimelineHtml(jsCollector));
            $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
            $buf2.$amp$plus((Object)new Text("\n          "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("class", "aggregated-num-total-state-rows-histogram", (MetaData)$md4);
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)graphUIDataForNumberTotalRows.generateHistogramHtml(jsCollector));
            $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
            $buf2.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus((Object)new Text("\n          "));
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md5);
            NodeBuffer $buf10 = new NodeBuffer();
            $buf10.$amp$plus((Object)new Text("\n            "));
            Null$ $md6 = Null$.MODULE$;
            $md6 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md6);
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf12 = new NodeBuffer();
            NodeBuffer $buf13 = new NodeBuffer();
            $buf13.$amp$plus((Object)new Text("Aggregated Number Of Updated State Rows "));
            $buf13.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Aggregated number of updated state rows.", "right"));
            $buf12.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13));
            $buf11.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
            $buf11.$amp$plus((Object)new Text("\n            "));
            $buf10.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
            $buf10.$amp$plus((Object)new Text("\n          "));
            $buf9.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
            $buf9.$amp$plus((Object)new Text("\n          "));
            Null$ $md7 = Null$.MODULE$;
            $md7 = new UnprefixedAttribute("class", "aggregated-num-updated-state-rows-timeline", (MetaData)$md7);
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)graphUIDataForNumberUpdatedRows.generateTimelineHtml(jsCollector));
            $buf9.$amp$plus((Object)new Elem(null, "td", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
            $buf9.$amp$plus((Object)new Text("\n          "));
            Null$ $md8 = Null$.MODULE$;
            $md8 = new UnprefixedAttribute("class", "aggregated-num-updated-state-rows-histogram", (MetaData)$md8);
            NodeBuffer $buf15 = new NodeBuffer();
            $buf15.$amp$plus((Object)graphUIDataForNumberUpdatedRows.generateHistogramHtml(jsCollector));
            $buf9.$amp$plus((Object)new Elem(null, "td", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15));
            $buf9.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
            NodeBuffer $buf16 = new NodeBuffer();
            $buf16.$amp$plus((Object)new Text("\n          "));
            Null$ $md9 = Null$.MODULE$;
            $md9 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md9);
            NodeBuffer $buf17 = new NodeBuffer();
            $buf17.$amp$plus((Object)new Text("\n            "));
            Null$ $md10 = Null$.MODULE$;
            $md10 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md10);
            NodeBuffer $buf18 = new NodeBuffer();
            $buf18.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf19 = new NodeBuffer();
            NodeBuffer $buf20 = new NodeBuffer();
            $buf20.$amp$plus((Object)new Text("Aggregated State Memory Used In Bytes "));
            $buf20.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Aggregated state memory used in bytes.", "right"));
            $buf19.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf20));
            $buf18.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf19));
            $buf18.$amp$plus((Object)new Text("\n            "));
            $buf17.$amp$plus((Object)new Elem(null, "div", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf18));
            $buf17.$amp$plus((Object)new Text("\n          "));
            $buf16.$amp$plus((Object)new Elem(null, "td", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf17));
            $buf16.$amp$plus((Object)new Text("\n          "));
            Null$ $md11 = Null$.MODULE$;
            $md11 = new UnprefixedAttribute("class", "aggregated-state-memory-used-bytes-timeline", (MetaData)$md11);
            NodeBuffer $buf21 = new NodeBuffer();
            $buf21.$amp$plus((Object)graphUIDataForMemoryUsedBytes.generateTimelineHtml(jsCollector));
            $buf16.$amp$plus((Object)new Elem(null, "td", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf21));
            $buf16.$amp$plus((Object)new Text("\n          "));
            Null$ $md12 = Null$.MODULE$;
            $md12 = new UnprefixedAttribute("class", "aggregated-state-memory-used-bytes-histogram", (MetaData)$md12);
            NodeBuffer $buf22 = new NodeBuffer();
            $buf22.$amp$plus((Object)graphUIDataForMemoryUsedBytes.generateHistogramHtml(jsCollector));
            $buf16.$amp$plus((Object)new Elem(null, "td", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf22));
            $buf16.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16));
            NodeBuffer $buf23 = new NodeBuffer();
            $buf23.$amp$plus((Object)new Text("\n          "));
            Null$ $md13 = Null$.MODULE$;
            $md13 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md13);
            NodeBuffer $buf24 = new NodeBuffer();
            $buf24.$amp$plus((Object)new Text("\n            "));
            Null$ $md14 = Null$.MODULE$;
            $md14 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md14);
            NodeBuffer $buf25 = new NodeBuffer();
            $buf25.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf26 = new NodeBuffer();
            NodeBuffer $buf27 = new NodeBuffer();
            $buf27.$amp$plus((Object)new Text("Aggregated Number Of Rows Dropped By Watermark "));
            $buf27.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Accumulates all input rows being dropped in stateful operators by watermark. 'Inputs' are relative to operators.", "right"));
            $buf26.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf27));
            $buf25.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf26));
            $buf25.$amp$plus((Object)new Text("\n            "));
            $buf24.$amp$plus((Object)new Elem(null, "div", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf25));
            $buf24.$amp$plus((Object)new Text("\n          "));
            $buf23.$amp$plus((Object)new Elem(null, "td", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf24));
            $buf23.$amp$plus((Object)new Text("\n          "));
            Null$ $md15 = Null$.MODULE$;
            $md15 = new UnprefixedAttribute("class", "aggregated-num-rows-dropped-by-watermark-timeline", (MetaData)$md15);
            NodeBuffer $buf28 = new NodeBuffer();
            $buf28.$amp$plus((Object)graphUIDataForNumRowsDroppedByWatermark.generateTimelineHtml(jsCollector));
            $buf23.$amp$plus((Object)new Elem(null, "td", (MetaData)$md15, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf28));
            $buf23.$amp$plus((Object)new Text("\n          "));
            Null$ $md16 = Null$.MODULE$;
            $md16 = new UnprefixedAttribute("class", "aggregated-num-rows-dropped-by-watermark-histogram", (MetaData)$md16);
            NodeBuffer $buf29 = new NodeBuffer();
            $buf29.$amp$plus((Object)graphUIDataForNumRowsDroppedByWatermark.generateHistogramHtml(jsCollector));
            $buf23.$amp$plus((Object)new Elem(null, "td", (MetaData)$md16, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf29));
            $buf23.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf23));
            NodeBuffer result = $buf;
            Object object = this.org$apache$spark$sql$streaming$ui$StreamingQueryStatisticsPage$$enabledCustomMetrics().nonEmpty() ? result.$plus$plus$eq((TraversableOnce)this.generateAggregatedCustomMetrics(query, minBatchTime, maxBatchTime, jsCollector)) : BoxedUnit.UNIT;
            nodeBuffer = result;
        } else {
            nodeBuffer = new NodeBuffer();
        }
        return nodeBuffer;
    }

    public NodeBuffer generateAggregatedCustomMetrics(StreamingQueryUIData query, long minBatchTime, long maxBatchTime, JsCollector jsCollector) {
        NodeBuffer result = new NodeBuffer();
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])query.lastProgress().stateOperators()).nonEmpty());
        ((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(((StateOperatorProgress)Predef$.MODULE$.refArrayOps((Object[])query.lastProgress().stateOperators()).head()).customMetrics().keySet()).asScala()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingQueryStatisticsPage $outer;

            public final boolean apply(String m) {
                return this.$outer.org$apache$spark$sql$streaming$ui$StreamingQueryStatisticsPage$$enabledCustomMetrics().contains((Object)m.toLowerCase(Locale.ROOT));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).map((Function1)new Serializable(this, query, minBatchTime, maxBatchTime, jsCollector, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingQueryStatisticsPage $outer;
            private final StreamingQueryUIData query$3;
            private final long minBatchTime$1;
            private final long maxBatchTime$1;
            private final JsCollector jsCollector$1;
            private final NodeBuffer result$1;

            public final NodeBuffer apply(String metricName) {
                Tuple2[] data = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.query$3.recentProgress()).map((Function1)new Serializable(this, metricName){
                    public static final long serialVersionUID = 0L;
                    public final String metricName$1;

                    public final Tuple2<Object, Object> apply(StreamingQueryProgress p) {
                        return new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])p.stateOperators()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$generateAggregatedCustomMetrics$2$$anonfun$30 $outer;

                            public final double apply(StateOperatorProgress x$12) {
                                return Predef$.MODULE$.Long2long(x$12.customMetrics().get(this.$outer.metricName$1));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
                    }
                    {
                        this.metricName$1 = metricName$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                double max = ((Tuple2)Predef$.MODULE$.refArrayOps((Object[])data).maxBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x$13) {
                        return x$13._2$mcD$sp();
                    }
                }, (Ordering)Ordering.Double$.MODULE$))._2$mcD$sp();
                StateStoreCustomMetric metric = (StateStoreCustomMetric)this.$outer.org$apache$spark$sql$streaming$ui$StreamingQueryStatisticsPage$$supportedCustomMetrics().find((Function1)new Serializable(this, metricName){
                    public static final long serialVersionUID = 0L;
                    private final String metricName$1;

                    public final boolean apply(StateStoreCustomMetric x$14) {
                        return x$14.name().equalsIgnoreCase(this.metricName$1);
                    }
                    {
                        this.metricName$1 = metricName$1;
                    }
                }).get();
                GraphUIData graphUIData = new GraphUIData(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aggregated-", "-timeline"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricName})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aggregated-", "-histogram"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])data), this.minBatchTime$1, this.maxBatchTime$1, 0.0, max, "", GraphUIData$.MODULE$.$lessinit$greater$default$9());
                graphUIData.generateDataJs(this.jsCollector$1);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n            "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md);
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("\n              "));
                Null$ $md2 = Null$.MODULE$;
                $md2 = new UnprefixedAttribute("style", (Seq)new Text("width: 240px;"), (MetaData)$md2);
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("\n                "));
                NodeBuffer $buf4 = new NodeBuffer();
                NodeBuffer $buf5 = new NodeBuffer();
                $buf5.$amp$plus((Object)new Text("Aggregated Custom Metric "));
                $buf5.$amp$plus((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricName})));
                $buf5.$amp$plus((Object)new Text(" "));
                $buf5.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip(metric.desc(), "right"));
                $buf4.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
                $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
                $buf3.$amp$plus((Object)new Text("\n              "));
                $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                $buf2.$amp$plus((Object)new Text("\n            "));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n            "));
                Null$ $md3 = Null$.MODULE$;
                $md3 = new UnprefixedAttribute("class", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aggregated-", "-timeline"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricName})), (MetaData)$md3);
                NodeBuffer $buf6 = new NodeBuffer();
                $buf6.$amp$plus((Object)graphUIData.generateTimelineHtml(this.jsCollector$1));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
                $buf.$amp$plus((Object)new Text("\n            "));
                Null$ $md4 = Null$.MODULE$;
                $md4 = new UnprefixedAttribute("class", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aggregated-", "-histogram"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricName})), (MetaData)$md4);
                NodeBuffer $buf7 = new NodeBuffer();
                $buf7.$amp$plus((Object)graphUIData.generateHistogramHtml(this.jsCollector$1));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
                $buf.$amp$plus((Object)new Text("\n          "));
                return (NodeBuffer)this.result$1.$plus$plus$eq((TraversableOnce)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.query$3 = query$3;
                this.minBatchTime$1 = minBatchTime$1;
                this.maxBatchTime$1 = maxBatchTime$1;
                this.jsCollector$1 = jsCollector$1;
                this.result$1 = result$1;
            }
        }, Set$.MODULE$.canBuildFrom());
        return result;
    }

    public Seq<Node> generateStatTable(StreamingQueryUIData query) {
        Elem elem;
        Tuple2[] batchToTimestamps = (Tuple2[])UIUtils$.MODULE$.withNoProgress(query, new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryUIData query$2;

            public final Tuple2<Object, Object>[] apply() {
                return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.query$2.recentProgress()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(StreamingQueryProgress p) {
                        return new Tuple2.mcJJ.sp(p.batchId(), UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            }
            {
                this.query$2 = query$2;
            }
        }, Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        long[] batchTimes = (long[])Predef$.MODULE$.refArrayOps((Object[])batchToTimestamps).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, Object> x$15) {
                return x$15._2$mcJ$sp();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        long minBatchTime = BoxesRunTime.unboxToLong((Object)UIUtils$.MODULE$.withNoProgress(query, new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryUIData query$2;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return UIUtils$.MODULE$.parseProgressTimestamp(((StreamingQueryProgress)Predef$.MODULE$.refArrayOps((Object[])this.query$2.recentProgress()).head()).timestamp());
            }
            {
                this.query$2 = query$2;
            }
        }, BoxesRunTime.boxToLong((long)0L)));
        long maxBatchTime = BoxesRunTime.unboxToLong((Object)UIUtils$.MODULE$.withNoProgress(query, new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryUIData query$2;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return UIUtils$.MODULE$.parseProgressTimestamp(this.query$2.lastProgress().timestamp());
            }
            {
                this.query$2 = query$2;
            }
        }, BoxesRunTime.boxToLong((long)0L)));
        double maxRecordRate = BoxesRunTime.unboxToDouble((Object)UIUtils$.MODULE$.withNoProgress(query, new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryUIData query$2;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])this.query$2.recentProgress()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(StreamingQueryProgress x$16) {
                        return x$16.inputRowsPerSecond();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                this.query$2 = query$2;
            }
        }, BoxesRunTime.boxToDouble((double)0.0)));
        long minRecordRate = 0L;
        double maxProcessRate = BoxesRunTime.unboxToDouble((Object)UIUtils$.MODULE$.withNoProgress(query, new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryUIData query$2;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])this.query$2.recentProgress()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(StreamingQueryProgress x$17) {
                        return x$17.processedRowsPerSecond();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                this.query$2 = query$2;
            }
        }, BoxesRunTime.boxToDouble((double)0.0)));
        long minProcessRate = 0L;
        long maxRows = BoxesRunTime.unboxToLong((Object)UIUtils$.MODULE$.withNoProgress(query, new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryUIData query$2;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.query$2.recentProgress()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(StreamingQueryProgress x$18) {
                        return x$18.numInputRows();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).max((Ordering)Ordering.Long$.MODULE$));
            }
            {
                this.query$2 = query$2;
            }
        }, BoxesRunTime.boxToLong((long)0L)));
        long minRows = 0L;
        long maxBatchDuration = BoxesRunTime.unboxToLong((Object)UIUtils$.MODULE$.withNoProgress(query, new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryUIData query$2;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.query$2.recentProgress()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(StreamingQueryProgress x$19) {
                        return x$19.batchDuration();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).max((Ordering)Ordering.Long$.MODULE$));
            }
            {
                this.query$2 = query$2;
            }
        }, BoxesRunTime.boxToLong((long)0L)));
        long minBatchDuration = 0L;
        Tuple2[] inputRateData = (Tuple2[])UIUtils$.MODULE$.withNoProgress(query, new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryUIData query$2;

            public final Tuple2<Object, Object>[] apply() {
                return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.query$2.recentProgress()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(StreamingQueryProgress p) {
                        return new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), UIUtils$.MODULE$.withNumberInvalid((Function0<Object>)new Serializable(this, p){
                            public static final long serialVersionUID = 0L;
                            private final StreamingQueryProgress p$1;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return this.p$1.inputRowsPerSecond();
                            }
                            {
                                this.p$1 = p$1;
                            }
                        }));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            }
            {
                this.query$2 = query$2;
            }
        }, Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2[] processRateData = (Tuple2[])UIUtils$.MODULE$.withNoProgress(query, new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryUIData query$2;

            public final Tuple2<Object, Object>[] apply() {
                return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.query$2.recentProgress()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(StreamingQueryProgress p) {
                        return new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), UIUtils$.MODULE$.withNumberInvalid((Function0<Object>)new Serializable(this, p){
                            public static final long serialVersionUID = 0L;
                            private final StreamingQueryProgress p$2;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return this.p$2.processedRowsPerSecond();
                            }
                            {
                                this.p$2 = p$2;
                            }
                        }));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            }
            {
                this.query$2 = query$2;
            }
        }, Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2[] inputRowsData = (Tuple2[])UIUtils$.MODULE$.withNoProgress(query, new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryUIData query$2;

            public final Tuple2<Object, Object>[] apply() {
                return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.query$2.recentProgress()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(StreamingQueryProgress p) {
                        return new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), UIUtils$.MODULE$.withNumberInvalid((Function0<Object>)new Serializable(this, p){
                            public static final long serialVersionUID = 0L;
                            private final StreamingQueryProgress p$3;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return this.p$3.numInputRows();
                            }
                            {
                                this.p$3 = p$3;
                            }
                        }));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            }
            {
                this.query$2 = query$2;
            }
        }, Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2[] batchDurations = (Tuple2[])UIUtils$.MODULE$.withNoProgress(query, new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryUIData query$2;

            public final Tuple2<Object, Object>[] apply() {
                return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.query$2.recentProgress()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(StreamingQueryProgress p) {
                        return new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), UIUtils$.MODULE$.withNumberInvalid((Function0<Object>)new Serializable(this, p){
                            public static final long serialVersionUID = 0L;
                            private final StreamingQueryProgress p$4;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return this.p$4.batchDuration();
                            }
                            {
                                this.p$4 = p$4;
                            }
                        }));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            }
            {
                this.query$2 = query$2;
            }
        }, Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2[] operationDurationData = (Tuple2[])UIUtils$.MODULE$.withNoProgress(query, new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryUIData query$2;

            public final Tuple2<Object, Map<String, Long>>[] apply() {
                return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.query$2.recentProgress()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Map<String, Long>> apply(StreamingQueryProgress p) {
                        Map<String, Long> durationMs = p.durationMs();
                        durationMs.remove("triggerExecution");
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp())), durationMs);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            }
            {
                this.query$2 = query$2;
            }
        }, Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        JsCollector jsCollector = new JsCollector();
        GraphUIData graphUIDataForInputRate = new GraphUIData("input-rate-timeline", "input-rate-histogram", (Seq)Predef$.MODULE$.wrapRefArray((Object[])inputRateData), minBatchTime, maxBatchTime, (double)minRecordRate, maxRecordRate, "records/sec", GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForInputRate.generateDataJs(jsCollector);
        GraphUIData graphUIDataForProcessRate = new GraphUIData("process-rate-timeline", "process-rate-histogram", (Seq)Predef$.MODULE$.wrapRefArray((Object[])processRateData), minBatchTime, maxBatchTime, (double)minProcessRate, maxProcessRate, "records/sec", GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForProcessRate.generateDataJs(jsCollector);
        GraphUIData graphUIDataForInputRows = new GraphUIData("input-rows-timeline", "input-rows-histogram", (Seq)Predef$.MODULE$.wrapRefArray((Object[])inputRowsData), minBatchTime, maxBatchTime, (double)minRows, (double)maxRows, "records", GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForInputRows.generateDataJs(jsCollector);
        GraphUIData graphUIDataForBatchDuration = new GraphUIData("batch-duration-timeline", "batch-duration-histogram", (Seq)Predef$.MODULE$.wrapRefArray((Object[])batchDurations), minBatchTime, maxBatchTime, (double)minBatchDuration, (double)maxBatchDuration, "ms", GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForBatchDuration.generateDataJs(jsCollector);
        GraphUIData graphUIDataForDuration = new GraphUIData("duration-area-stack", "", (Seq)Seq$.MODULE$.empty(), 0L, 0L, 0.0, 0.0, "ms", GraphUIData$.MODULE$.$lessinit$greater$default$9());
        if (query.lastProgress() == null) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("id", (Seq)new Text("empty-streaming-query-message"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("No visualization information available."));
            $buf.$amp$plus((Object)new Elem(null, "b", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem elem2 = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            elem = elem2;
        } else {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("style", (Seq)new Text("width: auto"), (MetaData)$md);
            $md = new UnprefixedAttribute("class", (Seq)new Text("table table-bordered"), (MetaData)$md);
            $md = new UnprefixedAttribute("id", (Seq)new Text("stat-table"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n            "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md2);
            $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf4.$amp$plus((Object)new Text("\n            "));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("style", (Seq)new Text("width: 492px;"), (MetaData)$md3);
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("Timelines"));
            $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
            $buf4.$amp$plus((Object)new Text("\n            "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("style", (Seq)new Text("width: 350px;"), (MetaData)$md4);
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("Histograms"));
            $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
            $buf4.$amp$plus((Object)new Text("\n          "));
            $buf3.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
            $buf3.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
            $buf.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("\n            "));
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md5);
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus((Object)new Text("\n              "));
            Null$ $md6 = Null$.MODULE$;
            $md6 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md6);
            NodeBuffer $buf10 = new NodeBuffer();
            $buf10.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf11 = new NodeBuffer();
            NodeBuffer $buf12 = new NodeBuffer();
            $buf12.$amp$plus((Object)new Text("Input Rate "));
            $buf12.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("The aggregate (across all sources) rate of data arriving.", "right"));
            $buf11.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
            $buf10.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
            $buf10.$amp$plus((Object)new Text("\n              "));
            $buf9.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
            $buf9.$amp$plus((Object)new Text("\n            "));
            $buf8.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
            $buf8.$amp$plus((Object)new Text("\n            "));
            Null$ $md7 = Null$.MODULE$;
            $md7 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md7);
            NodeBuffer $buf13 = new NodeBuffer();
            $buf13.$amp$plus((Object)graphUIDataForInputRate.generateTimelineHtml(jsCollector));
            $buf8.$amp$plus((Object)new Elem(null, "td", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13));
            $buf8.$amp$plus((Object)new Text("\n            "));
            Null$ $md8 = Null$.MODULE$;
            $md8 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md8);
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)graphUIDataForInputRate.generateHistogramHtml(jsCollector));
            $buf8.$amp$plus((Object)new Elem(null, "td", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
            $buf8.$amp$plus((Object)new Text("\n          "));
            $buf7.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
            $buf7.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf15 = new NodeBuffer();
            $buf15.$amp$plus((Object)new Text("\n            "));
            Null$ $md9 = Null$.MODULE$;
            $md9 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md9);
            NodeBuffer $buf16 = new NodeBuffer();
            $buf16.$amp$plus((Object)new Text("\n              "));
            Null$ $md10 = Null$.MODULE$;
            $md10 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md10);
            NodeBuffer $buf17 = new NodeBuffer();
            $buf17.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf18 = new NodeBuffer();
            NodeBuffer $buf19 = new NodeBuffer();
            $buf19.$amp$plus((Object)new Text("Process Rate "));
            $buf19.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("The aggregate (across all sources) rate at which Spark is processing data.", "right"));
            $buf18.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf19));
            $buf17.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf18));
            $buf17.$amp$plus((Object)new Text("\n              "));
            $buf16.$amp$plus((Object)new Elem(null, "div", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf17));
            $buf16.$amp$plus((Object)new Text("\n            "));
            $buf15.$amp$plus((Object)new Elem(null, "td", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16));
            $buf15.$amp$plus((Object)new Text("\n            "));
            Null$ $md11 = Null$.MODULE$;
            $md11 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md11);
            NodeBuffer $buf20 = new NodeBuffer();
            $buf20.$amp$plus((Object)graphUIDataForProcessRate.generateTimelineHtml(jsCollector));
            $buf15.$amp$plus((Object)new Elem(null, "td", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf20));
            $buf15.$amp$plus((Object)new Text("\n            "));
            Null$ $md12 = Null$.MODULE$;
            $md12 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md12);
            NodeBuffer $buf21 = new NodeBuffer();
            $buf21.$amp$plus((Object)graphUIDataForProcessRate.generateHistogramHtml(jsCollector));
            $buf15.$amp$plus((Object)new Elem(null, "td", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf21));
            $buf15.$amp$plus((Object)new Text("\n          "));
            $buf7.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15));
            $buf7.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf22 = new NodeBuffer();
            $buf22.$amp$plus((Object)new Text("\n            "));
            Null$ $md13 = Null$.MODULE$;
            $md13 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md13);
            NodeBuffer $buf23 = new NodeBuffer();
            $buf23.$amp$plus((Object)new Text("\n              "));
            Null$ $md14 = Null$.MODULE$;
            $md14 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md14);
            NodeBuffer $buf24 = new NodeBuffer();
            $buf24.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf25 = new NodeBuffer();
            NodeBuffer $buf26 = new NodeBuffer();
            $buf26.$amp$plus((Object)new Text("Input Rows "));
            $buf26.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("The aggregate (across all sources) number of records processed in a trigger.", "right"));
            $buf25.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf26));
            $buf24.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf25));
            $buf24.$amp$plus((Object)new Text("\n              "));
            $buf23.$amp$plus((Object)new Elem(null, "div", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf24));
            $buf23.$amp$plus((Object)new Text("\n            "));
            $buf22.$amp$plus((Object)new Elem(null, "td", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf23));
            $buf22.$amp$plus((Object)new Text("\n            "));
            Null$ $md15 = Null$.MODULE$;
            $md15 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md15);
            NodeBuffer $buf27 = new NodeBuffer();
            $buf27.$amp$plus((Object)graphUIDataForInputRows.generateTimelineHtml(jsCollector));
            $buf22.$amp$plus((Object)new Elem(null, "td", (MetaData)$md15, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf27));
            $buf22.$amp$plus((Object)new Text("\n            "));
            Null$ $md16 = Null$.MODULE$;
            $md16 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md16);
            NodeBuffer $buf28 = new NodeBuffer();
            $buf28.$amp$plus((Object)graphUIDataForInputRows.generateHistogramHtml(jsCollector));
            $buf22.$amp$plus((Object)new Elem(null, "td", (MetaData)$md16, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf28));
            $buf22.$amp$plus((Object)new Text("\n          "));
            $buf7.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf22));
            $buf7.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf29 = new NodeBuffer();
            $buf29.$amp$plus((Object)new Text("\n            "));
            Null$ $md17 = Null$.MODULE$;
            $md17 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md17);
            NodeBuffer $buf30 = new NodeBuffer();
            $buf30.$amp$plus((Object)new Text("\n              "));
            Null$ $md18 = Null$.MODULE$;
            $md18 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md18);
            NodeBuffer $buf31 = new NodeBuffer();
            $buf31.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf32 = new NodeBuffer();
            NodeBuffer $buf33 = new NodeBuffer();
            $buf33.$amp$plus((Object)new Text("Batch Duration "));
            $buf33.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("The process duration of each batch.", "right"));
            $buf32.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf33));
            $buf31.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf32));
            $buf31.$amp$plus((Object)new Text("\n              "));
            $buf30.$amp$plus((Object)new Elem(null, "div", (MetaData)$md18, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf31));
            $buf30.$amp$plus((Object)new Text("\n            "));
            $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)$md17, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf30));
            $buf29.$amp$plus((Object)new Text("\n            "));
            Null$ $md19 = Null$.MODULE$;
            $md19 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md19);
            NodeBuffer $buf34 = new NodeBuffer();
            $buf34.$amp$plus((Object)graphUIDataForBatchDuration.generateTimelineHtml(jsCollector));
            $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)$md19, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf34));
            $buf29.$amp$plus((Object)new Text("\n            "));
            Null$ $md20 = Null$.MODULE$;
            $md20 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md20);
            NodeBuffer $buf35 = new NodeBuffer();
            $buf35.$amp$plus((Object)graphUIDataForBatchDuration.generateHistogramHtml(jsCollector));
            $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)$md20, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf35));
            $buf29.$amp$plus((Object)new Text("\n          "));
            $buf7.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf29));
            $buf7.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf36 = new NodeBuffer();
            $buf36.$amp$plus((Object)new Text("\n            "));
            Null$ $md21 = Null$.MODULE$;
            $md21 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md21);
            NodeBuffer $buf37 = new NodeBuffer();
            $buf37.$amp$plus((Object)new Text("\n              "));
            Null$ $md22 = Null$.MODULE$;
            $md22 = new UnprefixedAttribute("style", (Seq)new Text("width: auto;"), (MetaData)$md22);
            NodeBuffer $buf38 = new NodeBuffer();
            $buf38.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf39 = new NodeBuffer();
            NodeBuffer $buf40 = new NodeBuffer();
            $buf40.$amp$plus((Object)new Text("Operation Duration "));
            $buf40.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("The amount of time taken to perform various operations in milliseconds.", "right"));
            $buf39.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf40));
            $buf38.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf39));
            $buf38.$amp$plus((Object)new Text("\n              "));
            $buf37.$amp$plus((Object)new Elem(null, "div", (MetaData)$md22, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf38));
            $buf37.$amp$plus((Object)new Text("\n            "));
            $buf36.$amp$plus((Object)new Elem(null, "td", (MetaData)$md21, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf37));
            $buf36.$amp$plus((Object)new Text("\n            "));
            Null$ $md23 = Null$.MODULE$;
            $md23 = new UnprefixedAttribute("colspan", (Seq)new Text("2"), (MetaData)$md23);
            $md23 = new UnprefixedAttribute("class", (Seq)new Text("duration-area-stack"), (MetaData)$md23);
            NodeBuffer $buf41 = new NodeBuffer();
            $buf41.$amp$plus((Object)graphUIDataForDuration.generateAreaStackHtmlWithData(jsCollector, operationDurationData));
            $buf36.$amp$plus((Object)new Elem(null, "td", (MetaData)$md23, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf41));
            $buf36.$amp$plus((Object)new Text("\n          "));
            $buf7.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf36));
            $buf7.$amp$plus((Object)new Text("\n          "));
            $buf7.$amp$plus(this.generateWatermark(query, minBatchTime, maxBatchTime, jsCollector));
            $buf7.$amp$plus((Object)new Text("\n          "));
            $buf7.$amp$plus((Object)this.generateAggregatedStateOperators(query, minBatchTime, maxBatchTime, jsCollector));
            $buf7.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem elem3 = new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            elem = elem3;
        }
        Elem table = elem;
        return (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)this.generateTimeToValues(operationDurationData).$plus$plus(this.generateFormattedTimeTipStrings(batchToTimestamps), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.generateTimeMap((Seq<Object>)Predef$.MODULE$.wrapLongArray(batchTimes)), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.generateTimeTipStrings(batchToTimestamps), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)table, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)jsCollector.toHtml(), Seq$.MODULE$.canBuildFrom());
    }

    public StreamingQueryStatisticsPage(StreamingQueryTab parent) {
        this.parent = parent;
        super("statistics");
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$sql$streaming$ui$StreamingQueryStatisticsPage$$supportedCustomMetrics = StateStoreProvider$.MODULE$.create((String)parent.parent().conf().get(SQLConf$.MODULE$.STATE_STORE_PROVIDER_CLASS())).supportedCustomMetrics();
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingQueryStatisticsPage $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Supported custom metrics: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$streaming$ui$StreamingQueryStatisticsPage$$supportedCustomMetrics()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$sql$streaming$ui$StreamingQueryStatisticsPage$$enabledCustomMetrics = (Seq)((TraversableLike)parent.parent().conf().get(StaticSQLConf$.MODULE$.ENABLED_STREAMING_UI_CUSTOM_METRIC_LIST())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.toLowerCase(Locale.ROOT);
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingQueryStatisticsPage $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Enabled custom metrics: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$streaming$ui$StreamingQueryStatisticsPage$$enabledCustomMetrics()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

