/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.ui;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.ui.StreamingQueryUIData;
import org.apache.spark.sql.streaming.ui.UIUtils$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y4Q!\u0001\u0002\u0001\r9\u0011Ad\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018p\u0015;biV\u001cH*[:uK:,'O\u0003\u0002\u0004\t\u0005\u0011Q/\u001b\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0005\u0002\u0001\u001fA\u0011\u0001#E\u0007\u0002\t%\u0011!\u0003\u0002\u0002\u0017'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0019&\u001cH/\u001a8fe\"AA\u0003\u0001B\u0001B\u0003%a#\u0001\u0003d_:47\u0001\u0001\t\u0003/ai\u0011\u0001C\u0005\u00033!\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\tir\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0003\u00155\u0001\u0007a\u0003\u0003\u0005\"\u0001\t\u0007I\u0011\u0001\u0002#\u0003E\t7\r^5wKF+XM]=Ti\u0006$Xo]\u000b\u0002GA!AeK\u00172\u001b\u0005)#B\u0001\u0014(\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003Q%\nA!\u001e;jY*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017&\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0003]=j\u0011aJ\u0005\u0003a\u001d\u0012A!V+J\tB\u0011aDM\u0005\u0003g\t\u0011Ac\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u00180V%ECR\f\u0007BB\u001b\u0001A\u0003%1%\u0001\nbGRLg/Z)vKJL8\u000b^1ukN\u0004\u0003\u0002C\u001c\u0001\u0005\u0004%\tA\u0001\u001d\u0002'%t\u0017m\u0019;jm\u0016\fV/\u001a:z'R\fG/^:\u0016\u0003e\u00022AO!2\u001b\u0005Y$B\u0001\u001f>\u0003\u001diW\u000f^1cY\u0016T!AP \u0002\u0015\r|G\u000e\\3di&|gNC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u00115HA\u0003Rk\u0016,X\r\u0003\u0004E\u0001\u0001\u0006I!O\u0001\u0015S:\f7\r^5wKF+XM]=Ti\u0006$Xo\u001d\u0011\t\u000f\u0019\u0003!\u0019!C\u0005\u000f\u0006Q2\u000f\u001e:fC6Lgn\u001a)s_\u001e\u0014Xm]:SKR,g\u000e^5p]V\t\u0001\n\u0005\u0002J\u00156\tq(\u0003\u0002L\u007f\t\u0019\u0011J\u001c;\t\r5\u0003\u0001\u0015!\u0003I\u0003m\u0019HO]3b[&tw\r\u0015:pOJ,7o\u001d*fi\u0016tG/[8oA!9q\n\u0001b\u0001\n\u00139\u0015\u0001H5oC\u000e$\u0018N^3Rk\u0016\u0014\u0018p\u0015;biV\u001c(+\u001a;f]RLwN\u001c\u0005\u0007#\u0002\u0001\u000b\u0011\u0002%\u0002;%t\u0017m\u0019;jm\u0016\fV/\u001a:z'R\fG/^:SKR,g\u000e^5p]\u0002BQa\u0015\u0001\u0005BQ\u000bab\u001c8Rk\u0016\u0014\u0018p\u0015;beR,G\r\u0006\u0002V1B\u0011\u0011JV\u0005\u0003/~\u0012A!\u00168ji\")\u0011L\u0015a\u00015\u0006)QM^3oiB\u00111L\u0018\b\u0003!qK!!\u0018\u0003\u0002-M#(/Z1nS:<\u0017+^3ss2K7\u000f^3oKJL!a\u00181\u0003#E+XM]=Ti\u0006\u0014H/\u001a3Fm\u0016tGO\u0003\u0002^\t!)!\r\u0001C!G\u0006yqN\\)vKJL\bK]8he\u0016\u001c8\u000f\u0006\u0002VI\")\u0011,\u0019a\u0001KB\u00111LZ\u0005\u0003O\u0002\u0014!#U;fef\u0004&o\\4sKN\u001cXI^3oi\")\u0011\u000e\u0001C!U\u0006\trN\\)vKJLH+\u001a:nS:\fG/\u001a3\u0015\u0005U[\u0007\"B-i\u0001\u0004a\u0007CA.n\u0013\tq\u0007M\u0001\u000bRk\u0016\u0014\u0018\u0010V3s[&t\u0017\r^3e\u000bZ,g\u000e\u001e\u0005\u0006a\u0002!\t!]\u0001\u000fC2d\u0017+^3ssN#\u0018\r^;t+\u0005\u0011\bcA:|c9\u0011A/\u001f\b\u0003kbl\u0011A\u001e\u0006\u0003oV\ta\u0001\u0010:p_Rt\u0014\"\u0001!\n\u0005i|\u0014a\u00029bG.\fw-Z\u0005\u0003yv\u00141aU3r\u0015\tQx\b")
public class StreamingQueryStatusListener
extends StreamingQueryListener {
    private final ConcurrentHashMap<UUID, StreamingQueryUIData> activeQueryStatus = new ConcurrentHashMap();
    private final Queue<StreamingQueryUIData> inactiveQueryStatus = new Queue();
    private final int streamingProgressRetention;
    private final int inactiveQueryStatusRetention;

    public ConcurrentHashMap<UUID, StreamingQueryUIData> activeQueryStatus() {
        return this.activeQueryStatus;
    }

    public Queue<StreamingQueryUIData> inactiveQueryStatus() {
        return this.inactiveQueryStatus;
    }

    private int streamingProgressRetention() {
        return this.streamingProgressRetention;
    }

    private int inactiveQueryStatusRetention() {
        return this.inactiveQueryStatusRetention;
    }

    @Override
    public void onQueryStarted(StreamingQueryListener.QueryStartedEvent event) {
        long startTimestamp = UIUtils$.MODULE$.parseProgressTimestamp(event.timestamp());
        this.activeQueryStatus().putIfAbsent(event.runId(), new StreamingQueryUIData(event.name(), event.id(), event.runId(), startTimestamp));
    }

    @Override
    public void onQueryProgress(StreamingQueryListener.QueryProgressEvent event) {
        long batchTimestamp = UIUtils$.MODULE$.parseProgressTimestamp(event.progress().timestamp());
        StreamingQueryUIData queryStatus = this.activeQueryStatus().getOrDefault(event.progress().runId(), new StreamingQueryUIData(event.progress().name(), event.progress().id(), event.progress().runId(), batchTimestamp));
        queryStatus.updateProcess(event.progress(), this.streamingProgressRetention());
    }

    @Override
    public synchronized void onQueryTerminated(StreamingQueryListener.QueryTerminatedEvent event) {
        StreamingQueryUIData queryStatus = this.activeQueryStatus().remove(event.runId());
        if (queryStatus != null) {
            queryStatus.queryTerminated(event);
            this.inactiveQueryStatus().$plus$eq((Object)queryStatus);
            while (this.inactiveQueryStatus().length() >= this.inactiveQueryStatusRetention()) {
                this.inactiveQueryStatus().dequeue();
            }
        }
    }

    public synchronized Seq<StreamingQueryUIData> allQueryStatus() {
        return (Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.activeQueryStatus().values()).asScala()).toSeq().$plus$plus(this.inactiveQueryStatus(), Seq$.MODULE$.canBuildFrom());
    }

    public StreamingQueryStatusListener(SparkConf conf) {
        this.streamingProgressRetention = BoxesRunTime.unboxToInt((Object)conf.get(StaticSQLConf$.MODULE$.STREAMING_UI_RETAINED_PROGRESS_UPDATES()));
        this.inactiveQueryStatusRetention = BoxesRunTime.unboxToInt((Object)conf.get(StaticSQLConf$.MODULE$.STREAMING_UI_RETAINED_QUERIES()));
    }
}

