/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.util.Random;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.MemoryTestingUtils$;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.ExternalAppendOnlyUnsafeRowArray;
import org.apache.spark.sql.execution.ExternalAppendOnlyUnsafeRowArray$;
import org.apache.spark.sql.execution.ExternalAppendOnlyUnsafeRowArrayBenchmark$;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.util.collection.unsafe.sort.UnsafeExternalSorter;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

public final class ExternalAppendOnlyUnsafeRowArrayBenchmark$ {
    public static final ExternalAppendOnlyUnsafeRowArrayBenchmark$ MODULE$;

    static {
        new ExternalAppendOnlyUnsafeRowArrayBenchmark$();
    }

    public void testAgainstRawArrayBuffer(int numSpillThreshold, int numRows, int iterations) {
        Random random = new Random();
        IndexedSeq rows = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRows).map((Function1)new Serializable(random){
            public static final long serialVersionUID = 0L;
            private final Random random$1;

            /*
             * WARNING - void declaration
             */
            public final UnsafeRow apply(int x$1) {
                void var2_2;
                UnsafeRow row = new UnsafeRow(1);
                row.pointTo(new byte[64], 16);
                row.setLong(0, this.random$1.nextLong());
                return var2_2;
            }
            {
                this.random$1 = random$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Benchmark benchmark2 = new Benchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Array with ", " rows"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numRows)})), (long)(iterations * numRows), Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        int initialSize = Math.min(ExternalAppendOnlyUnsafeRowArray$.MODULE$.DefaultInitialSizeOfInMemoryBuffer(), numSpillThreshold);
        benchmark2.addCase("ArrayBuffer", benchmark2.addCase$default$2(), (Function1)new Serializable(iterations, rows, initialSize){
            public static final long serialVersionUID = 0L;
            private final int iterations$1;
            public final IndexedSeq rows$1;
            public final int initialSize$1;

            public final void apply(int x$2) {
                this.apply$mcVI$sp(x$2);
            }

            public void apply$mcVI$sp(int x$2) {
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iterations$1)).foreach((Function1)new Serializable(this, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.testAgainstRawArrayBuffer.1 $outer;
                    private final LongRef sum$1;

                    public final void apply(long _) {
                        this.apply$mcVJ$sp(_);
                    }

                    public void apply$mcVJ$sp(long _) {
                        ArrayBuffer array = new ArrayBuffer(this.$outer.initialSize$1);
                        this.$outer.rows$1.foreach((Function1)new Serializable(this, array){
                            public static final long serialVersionUID = 0L;
                            private final ArrayBuffer array$1;

                            public final ArrayBuffer<UnsafeRow> apply(UnsafeRow x) {
                                return this.array$1.$plus$eq((Object)x.copy());
                            }
                            {
                                this.array$1 = array$1;
                            }
                        });
                        int n = array.length();
                        for (int i = 0; i < n; ++i) {
                            this.sum$1.elem += ((UnsafeRow)array.apply(i)).getLong(0);
                        }
                        array.clear();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sum$1 = sum$1;
                    }
                });
            }
            {
                this.iterations$1 = iterations$1;
                this.rows$1 = rows$1;
                this.initialSize$1 = initialSize$1;
            }
        });
        benchmark2.addCase("ExternalAppendOnlyUnsafeRowArray", benchmark2.addCase$default$2(), (Function1)new Serializable(numSpillThreshold, iterations, rows){
            public static final long serialVersionUID = 0L;
            public final int numSpillThreshold$1;
            private final int iterations$1;
            public final IndexedSeq rows$1;

            public final void apply(int x$3) {
                this.apply$mcVI$sp(x$3);
            }

            public void apply$mcVI$sp(int x$3) {
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iterations$1)).foreach((Function1)new Serializable(this, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.testAgainstRawArrayBuffer.2 $outer;
                    private final LongRef sum$2;

                    public final void apply(long _) {
                        this.apply$mcVJ$sp(_);
                    }

                    public void apply$mcVJ$sp(long _) {
                        ExternalAppendOnlyUnsafeRowArray array = new ExternalAppendOnlyUnsafeRowArray(ExternalAppendOnlyUnsafeRowArray$.MODULE$.DefaultInitialSizeOfInMemoryBuffer(), this.$outer.numSpillThreshold$1);
                        this.$outer.rows$1.foreach((Function1)new Serializable(this, array){
                            public static final long serialVersionUID = 0L;
                            private final ExternalAppendOnlyUnsafeRowArray array$2;

                            public final void apply(UnsafeRow x) {
                                this.array$2.add(x);
                            }
                            {
                                this.array$2 = array$2;
                            }
                        });
                        Iterator iterator2 = array.generateIterator();
                        while (iterator2.hasNext()) {
                            this.sum$2.elem += ((UnsafeRow)iterator2.next()).getLong(0);
                        }
                        array.clear();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sum$2 = sum$2;
                    }
                });
            }
            {
                this.numSpillThreshold$1 = numSpillThreshold$1;
                this.iterations$1 = iterations$1;
                this.rows$1 = rows$1;
            }
        });
        SparkConf conf = new SparkConf(false);
        conf.set("spark.serializer.objectStreamReset", "1");
        conf.set("spark.serializer", "org.apache.spark.serializer.JavaSerializer");
        SparkContext sc = new SparkContext("local", "test", conf);
        TaskContext taskContext = MemoryTestingUtils$.MODULE$.fakeTaskContext(SparkEnv$.MODULE$.get());
        TaskContext$.MODULE$.setTaskContext(taskContext);
        benchmark2.run();
        sc.stop();
    }

    public void testAgainstRawUnsafeExternalSorter(int numSpillThreshold, int numRows, int iterations) {
        Random random = new Random();
        IndexedSeq rows = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRows).map((Function1)new Serializable(random){
            public static final long serialVersionUID = 0L;
            private final Random random$2;

            /*
             * WARNING - void declaration
             */
            public final UnsafeRow apply(int x$4) {
                void var2_2;
                UnsafeRow row = new UnsafeRow(1);
                row.pointTo(new byte[64], 16);
                row.setLong(0, this.random$2.nextLong());
                return var2_2;
            }
            {
                this.random$2 = random$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Benchmark benchmark2 = new Benchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spilling with ", " rows"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numRows)})), (long)(iterations * numRows), Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark2.addCase("UnsafeExternalSorter", benchmark2.addCase$default$2(), (Function1)new Serializable(numSpillThreshold, iterations, rows){
            public static final long serialVersionUID = 0L;
            public final int numSpillThreshold$2;
            private final int iterations$2;
            public final IndexedSeq rows$2;

            public final void apply(int x$5) {
                this.apply$mcVI$sp(x$5);
            }

            public void apply$mcVI$sp(int x$5) {
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iterations$2)).foreach((Function1)new Serializable(this, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.testAgainstRawUnsafeExternalSorter.1 $outer;
                    private final LongRef sum$3;

                    public final void apply(long _) {
                        this.apply$mcVJ$sp(_);
                    }

                    public void apply$mcVJ$sp(long _) {
                        UnsafeExternalSorter array = UnsafeExternalSorter.create((TaskMemoryManager)TaskContext$.MODULE$.get().taskMemoryManager(), (BlockManager)SparkEnv$.MODULE$.get().blockManager(), (SerializerManager)SparkEnv$.MODULE$.get().serializerManager(), (TaskContext)TaskContext$.MODULE$.get(), null, null, (int)1024, (long)SparkEnv$.MODULE$.get().memoryManager().pageSizeBytes(), (int)this.$outer.numSpillThreshold$2, (boolean)false);
                        this.$outer.rows$2.foreach((Function1)new Serializable(this, array){
                            public static final long serialVersionUID = 0L;
                            private final UnsafeExternalSorter array$3;

                            public final void apply(UnsafeRow x) {
                                this.array$3.insertRecord(x.getBaseObject(), x.getBaseOffset(), x.getSizeInBytes(), 0L, false);
                            }
                            {
                                this.array$3 = array$3;
                            }
                        });
                        UnsafeRow unsafeRow = new UnsafeRow(1);
                        UnsafeSorterIterator iter = array.getIterator(0);
                        while (iter.hasNext()) {
                            iter.loadNext();
                            unsafeRow.pointTo(iter.getBaseObject(), iter.getBaseOffset(), iter.getRecordLength());
                            this.sum$3.elem += unsafeRow.getLong(0);
                        }
                        array.cleanupResources();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sum$3 = sum$3;
                    }
                });
            }
            {
                this.numSpillThreshold$2 = numSpillThreshold$2;
                this.iterations$2 = iterations$2;
                this.rows$2 = rows$2;
            }
        });
        benchmark2.addCase("ExternalAppendOnlyUnsafeRowArray", benchmark2.addCase$default$2(), (Function1)new Serializable(numSpillThreshold, iterations, rows){
            public static final long serialVersionUID = 0L;
            public final int numSpillThreshold$2;
            private final int iterations$2;
            public final IndexedSeq rows$2;

            public final void apply(int x$6) {
                this.apply$mcVI$sp(x$6);
            }

            public void apply$mcVI$sp(int x$6) {
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iterations$2)).foreach((Function1)new Serializable(this, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.testAgainstRawUnsafeExternalSorter.2 $outer;
                    private final LongRef sum$4;

                    public final void apply(long _) {
                        this.apply$mcVJ$sp(_);
                    }

                    public void apply$mcVJ$sp(long _) {
                        ExternalAppendOnlyUnsafeRowArray array = new ExternalAppendOnlyUnsafeRowArray(this.$outer.numSpillThreshold$2, this.$outer.numSpillThreshold$2);
                        this.$outer.rows$2.foreach((Function1)new Serializable(this, array){
                            public static final long serialVersionUID = 0L;
                            private final ExternalAppendOnlyUnsafeRowArray array$4;

                            public final void apply(UnsafeRow x) {
                                this.array$4.add(x);
                            }
                            {
                                this.array$4 = array$4;
                            }
                        });
                        Iterator iterator2 = array.generateIterator();
                        while (iterator2.hasNext()) {
                            this.sum$4.elem += ((UnsafeRow)iterator2.next()).getLong(0);
                        }
                        array.clear();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sum$4 = sum$4;
                    }
                });
            }
            {
                this.numSpillThreshold$2 = numSpillThreshold$2;
                this.iterations$2 = iterations$2;
                this.rows$2 = rows$2;
            }
        });
        SparkConf conf = new SparkConf(false);
        conf.set("spark.serializer.objectStreamReset", "1");
        conf.set("spark.serializer", "org.apache.spark.serializer.JavaSerializer");
        SparkContext sc = new SparkContext("local", "test", conf);
        TaskContext taskContext = MemoryTestingUtils$.MODULE$.fakeTaskContext(SparkEnv$.MODULE$.get());
        TaskContext$.MODULE$.setTaskContext(taskContext);
        benchmark2.run();
        sc.stop();
    }

    public void main(String[] args) {
        int spillThreshold = 100000;
        this.testAgainstRawArrayBuffer(spillThreshold, 1000, 262144);
        this.testAgainstRawArrayBuffer(spillThreshold, 30000, 16384);
        this.testAgainstRawArrayBuffer(spillThreshold, 100000, 1024);
        this.testAgainstRawUnsafeExternalSorter(100000, 1000, 262144);
        this.testAgainstRawUnsafeExternalSorter(BoxesRunTime.unboxToInt((Object)package$.MODULE$.SHUFFLE_SPILL_NUM_ELEMENTS_FORCE_SPILL_THRESHOLD().defaultValue().get()), 10000, 16);
    }

    private ExternalAppendOnlyUnsafeRowArrayBenchmark$() {
        MODULE$ = this;
    }
}

