/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.aggregate;

import java.util.Properties;
import java.util.Random;
import org.apache.spark.LocalSparkContext;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.TaskContextImpl;
import org.apache.spark.TaskContextImpl$;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.memory.TestMemoryManager;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.aggregate.AggregationBufferEntry;
import org.apache.spark.sql.execution.aggregate.ObjectAggregationMap;
import org.apache.spark.sql.execution.aggregate.SortBasedAggregationStoreSuite$;
import org.apache.spark.sql.execution.aggregate.SortBasedAggregator;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.KVIterator;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.LinearSeqLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u001f\tq2k\u001c:u\u0005\u0006\u001cX\rZ!hOJ,w-\u0019;j_:\u001cFo\u001c:f'VLG/\u001a\u0006\u0003\u0007\u0011\t\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005\u00151\u0011!C3yK\u000e,H/[8o\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0003\u0006\t\u0003#Ii\u0011\u0001C\u0005\u0003'!\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\t\u0016\u0013\t1\u0002BA\tM_\u000e\fGn\u00159be.\u001cuN\u001c;fqRDQ\u0001\u0007\u0001\u0005\u0002e\ta\u0001P5oSRtD#\u0001\u000e\u0011\u0005m\u0001Q\"\u0001\u0002\t\u000bu\u0001A\u0011\t\u0010\u0002\u0013\t,gm\u001c:f\u00032dG#A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006M\u0001!\tEH\u0001\tC\u001a$XM]!mY\"9\u0001\u0006\u0001b\u0001\n\u0013I\u0013\u0001\u0002:b]\u0012,\u0012A\u000b\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\nA!\u001e;jY*\tq&\u0001\u0003kCZ\f\u0017BA\u0019-\u0005\u0019\u0011\u0016M\u001c3p[\"11\u0007\u0001Q\u0001\n)\nQA]1oI\u0002BQ!\u000e\u0001\u0005\nY\n!d\u0019:fCR,g*Z<BO\u001e\u0014XmZ1uS>t')\u001e4gKJ$\u0012a\u000e\t\u0003qmj\u0011!\u000f\u0006\u0003u\u0019\t\u0001bY1uC2L8\u000f^\u0005\u0003ye\u00121\"\u00138uKJt\u0017\r\u001c*po\")a\b\u0001C\u0005\u007f\u0005qQ\u000f\u001d3bi\u0016Le\u000e];u%><X#\u0001!\u0011\u000b\u0001\nugN\u0010\n\u0005\t\u000b#!\u0003$v]\u000e$\u0018n\u001c83\u0011\u0015!\u0005\u0001\"\u0003@\u00039iWM]4f\u0003\u001e<')\u001e4gKJDQA\u0012\u0001\u0005\n\u001d\u000bqb\u0019:fCR,WK\\:bM\u0016\u0014vn\u001e\u000b\u0003\u0011:\u0003\"!\u0013'\u000e\u0003)S!aS\u001d\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003\u001b*\u0013\u0011\"\u00168tC\u001a,'k\\<\t\u000b=+\u0005\u0019\u0001)\u0002\u00159,Xn\u00144GS\u0016dG\r\u0005\u0002!#&\u0011!+\t\u0002\u0004\u0013:$\b\"\u0002+\u0001\t\u0013)\u0016\u0001\u0003:b]\u0012|Wn\u0013,\u0015\u0007}1\u0006\fC\u0003X'\u0002\u0007\u0001*\u0001\u0005j]B,HOU8x\u0011\u0015I6\u000b1\u0001I\u0003\u00159'o\\;q\u0011\u0015Y\u0006\u0001\"\u0001]\u0003u\u0019'/Z1uKN{'\u000f^3e\u0003\u001e<')\u001e4gKJLE/\u001a:bi>\u0014HCA/d!\u0011q\u0016\r\u0013%\u000e\u0003}S!\u0001\u0019\u0005\u0002\rUt7/\u00194f\u0013\t\u0011wL\u0001\u0006L-&#XM]1u_JDQ\u0001\u001a.A\u0002\u0015\fq\u0001[1tQ6\u000b\u0007\u000f\u0005\u0002\u001cM&\u0011qM\u0001\u0002\u0015\u001f\nTWm\u0019;BO\u001e\u0014XmZ1uS>tW*\u00199")
public class SortBasedAggregationStoreSuite
extends SparkFunSuite
implements LocalSparkContext {
    private final Random rand;
    private transient SparkContext sc;

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public /* synthetic */ void org$apache$spark$LocalSparkContext$$super$beforeAll() {
        super.beforeAll();
    }

    public /* synthetic */ void org$apache$spark$LocalSparkContext$$super$afterEach() {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this);
    }

    public void afterEach() {
        LocalSparkContext.class.afterEach((LocalSparkContext)this);
    }

    public void resetSparkContext() {
        LocalSparkContext.class.resetSparkContext((LocalSparkContext)this);
    }

    public void beforeAll() {
        LocalSparkContext.class.beforeAll((LocalSparkContext)this);
        SparkConf conf = new SparkConf();
        this.sc_$eq(new SparkContext("local[2, 4]", "test", conf));
        TaskMemoryManager taskManager = new TaskMemoryManager((MemoryManager)new TestMemoryManager(conf), 0L);
        TaskContext$.MODULE$.setTaskContext((TaskContext)new TaskContextImpl(0, 0, 0, 0L, 0, taskManager, new Properties(), null, TaskContextImpl$.MODULE$.$lessinit$greater$default$9()));
    }

    public void afterAll() {
        TaskContext$.MODULE$.unset();
    }

    private Random rand() {
        return this.rand;
    }

    /*
     * WARNING - void declaration
     */
    public InternalRow org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$createNewAggregationBuffer() {
        void var1_1;
        UnsafeRow buffer = this.org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$createUnsafeRow(1);
        buffer.setInt(0, 0);
        return var1_1;
    }

    public Function2<InternalRow, InternalRow, BoxedUnit> org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$updateInputRow() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(InternalRow buffer, InternalRow input) {
                buffer.setInt(0, buffer.getInt(0) ^ input.getInt(0));
            }
        };
    }

    public Function2<InternalRow, InternalRow, BoxedUnit> org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$mergeAggBuffer() {
        return this.org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$updateInputRow();
    }

    /*
     * WARNING - void declaration
     */
    public UnsafeRow org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$createUnsafeRow(int numOfField) {
        void var3_3;
        byte[] buffer = new byte[1024];
        UnsafeRow row = new UnsafeRow(numOfField);
        row.pointTo(buffer, 1024);
        return var3_3;
    }

    public void org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$randomKV(UnsafeRow inputRow, UnsafeRow group) {
        inputRow.setInt(0, this.rand().nextInt(100000));
        inputRow.setInt(1, this.rand().nextInt(10000));
        group.setInt(0, inputRow.getInt(1) % 100);
    }

    public KVIterator<UnsafeRow, UnsafeRow> createSortedAggBufferIterator(ObjectAggregationMap hashMap) {
        Iterator sortedIterator = ((LinearSeqLike)hashMap.iterator().toList().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(AggregationBufferEntry x$3) {
                return x$3.groupingKey().getInt(0);
            }
        }, (Ordering)Ordering.Int$.MODULE$)).iterator();
        return new KVIterator<UnsafeRow, UnsafeRow>(this, sortedIterator){
            private UnsafeRow key;
            private UnsafeRow value;
            private final Iterator sortedIterator$1;

            private UnsafeRow key() {
                return this.key;
            }

            private void key_$eq(UnsafeRow x$1) {
                this.key = x$1;
            }

            private UnsafeRow value() {
                return this.value;
            }

            private void value_$eq(UnsafeRow x$1) {
                this.value = x$1;
            }

            public boolean next() {
                boolean bl;
                if (this.sortedIterator$1.hasNext()) {
                    AggregationBufferEntry kv = (AggregationBufferEntry)this.sortedIterator$1.next();
                    this.key_$eq(kv.groupingKey());
                    this.value_$eq((UnsafeRow)kv.aggregationBuffer());
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public UnsafeRow getKey() {
                return this.key();
            }

            public UnsafeRow getValue() {
                return this.value();
            }

            public void close() {
            }
            {
                this.sortedIterator$1 = sortedIterator$1;
                this.key = null;
                this.value = null;
            }
        };
    }

    public SortBasedAggregationStoreSuite() {
        LocalSparkContext.class.$init$((LocalSparkContext)this);
        this.rand = new Random();
        this.test("merge input kv iterator and aggregation buffer iterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SortBasedAggregationStoreSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType inputSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
                StructType groupingSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
                UnsafeRow inputRow = this.$outer.org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$createUnsafeRow(2);
                UnsafeRow group = this.$outer.org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$createUnsafeRow(1);
                HashMap expected2 = new HashMap();
                ObjectAggregationMap hashMap = new ObjectAggregationMap();
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5000).foreach$mVc$sp((Function1)new Serializable(this, inputRow, group, expected2, hashMap){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final UnsafeRow inputRow$1;
                    private final UnsafeRow group$1;
                    private final HashMap expected$1;
                    private final ObjectAggregationMap hashMap$1;

                    public final void apply(int x$1) {
                        this.apply$mcVI$sp(x$1);
                    }

                    public void apply$mcVI$sp(int x$1) {
                        this.$outer.org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$anonfun$$$outer().org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$randomKV(this.inputRow$1, this.group$1);
                        this.expected$1.put((Object)BoxesRunTime.boxToInteger((int)this.group$1.getInt(0)), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.expected$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)this.group$1.getInt(0)), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        })) ^ this.inputRow$1.getInt(0))));
                        if (this.hashMap$1.getAggregationBuffer(this.group$1) == null) {
                            this.hashMap$1.putAggregationBuffer(this.group$1.copy(), this.$outer.org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$anonfun$$$outer().org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$createNewAggregationBuffer());
                        }
                        this.$outer.org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$anonfun$$$outer().org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$updateInputRow().apply((Object)this.hashMap$1.getAggregationBuffer(this.group$1), (Object)this.inputRow$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.inputRow$1 = inputRow$1;
                        this.group$1 = group$1;
                        this.expected$1 = expected$1;
                        this.hashMap$1 = hashMap$1;
                    }
                });
                SortBasedAggregator store = new SortBasedAggregator(this.$outer.createSortedAggBufferIterator(hashMap), inputSchema, groupingSchema, this.$outer.org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$updateInputRow(), this.$outer.org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$mergeAggBuffer(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final InternalRow apply() {
                        return this.$outer.org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$anonfun$$$outer().org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$createNewAggregationBuffer();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5000), 100000).foreach$mVc$sp((Function1)new Serializable(this, inputRow, group, expected2, store){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final UnsafeRow inputRow$1;
                    private final UnsafeRow group$1;
                    private final HashMap expected$1;
                    private final SortBasedAggregator store$1;

                    public final void apply(int x$2) {
                        this.apply$mcVI$sp(x$2);
                    }

                    public void apply$mcVI$sp(int x$2) {
                        this.$outer.org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$anonfun$$$outer().org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$randomKV(this.inputRow$1, this.group$1);
                        this.expected$1.put((Object)BoxesRunTime.boxToInteger((int)this.group$1.getInt(0)), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.expected$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)this.group$1.getInt(0)), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        })) ^ this.inputRow$1.getInt(0))));
                        this.store$1.addInput(this.group$1, this.inputRow$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.inputRow$1 = inputRow$1;
                        this.group$1 = group$1;
                        this.expected$1 = expected$1;
                        this.store$1 = store$1;
                    }
                });
                Iterator iter = store.destructiveIterator();
                while (iter.hasNext()) {
                    AggregationBufferEntry agg = (AggregationBufferEntry)iter.next();
                    int $org_scalatest_assert_macro_left = agg.aggregationBuffer().getInt(0);
                    int $org_scalatest_assert_macro_right = BoxesRunTime.unboxToInt((Object)expected2.apply((Object)BoxesRunTime.boxToInteger((int)agg.groupingKey().getInt(0))));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SortBasedAggregationStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
                }
            }

            public /* synthetic */ SortBasedAggregationStoreSuite org$apache$spark$sql$execution$aggregate$SortBasedAggregationStoreSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SortBasedAggregationStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
    }
}

