/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.DataSourceReadBenchmark$;
import org.apache.spark.sql.execution.benchmark.DataSourceReadBenchmark$$anonfun$columnsBenchmark$1$$anonfun$apply$6$;
import org.apache.spark.sql.execution.benchmark.DataSourceReadBenchmark$$anonfun$numericScanBenchmark$1$;
import org.apache.spark.sql.execution.benchmark.DataSourceReadBenchmark$$anonfun$numericScanBenchmark$1$$anonfun$apply$1$;
import org.apache.spark.sql.execution.benchmark.DataSourceReadBenchmark$$anonfun$stringWithNullsScanBenchmark$1$$anonfun$apply$5$;
import org.apache.spark.sql.execution.datasources.parquet.SpecificParquetRecordReaderBase;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class DataSourceReadBenchmark$
implements SQLHelper {
    public static final DataSourceReadBenchmark$ MODULE$;
    private final SparkConf conf;
    private final SparkSession spark;

    static {
        new DataSourceReadBenchmark$();
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.class.withSQLConf((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.class.withTempPath((SQLHelper)this, f);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            tableNames.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String viewName) {
                    return DataSourceReadBenchmark$.MODULE$.spark().catalog().dropTempView(viewName);
                }
            });
            throw throwable;
        }
        tableNames.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public void org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$prepareTable(File dir, Dataset<Row> df3, Option<String> partition) {
        DataFrameWriter testDf = partition.isDefined() ? df3.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)partition.get()})) : df3.write();
        this.saveAsCsvTable((DataFrameWriter<Row>)testDf, new StringBuilder().append((Object)dir.getCanonicalPath()).append((Object)"/csv").toString());
        this.saveAsJsonTable((DataFrameWriter<Row>)testDf, new StringBuilder().append((Object)dir.getCanonicalPath()).append((Object)"/json").toString());
        this.saveAsParquetTable((DataFrameWriter<Row>)testDf, new StringBuilder().append((Object)dir.getCanonicalPath()).append((Object)"/parquet").toString());
        this.saveAsOrcTable((DataFrameWriter<Row>)testDf, new StringBuilder().append((Object)dir.getCanonicalPath()).append((Object)"/orc").toString());
    }

    public Option<String> org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$prepareTable$default$3() {
        return None$.MODULE$;
    }

    private void saveAsCsvTable(DataFrameWriter<Row> df3, String dir) {
        df3.mode("overwrite").option("compression", "gzip").option("header", true).csv(dir);
        this.spark().read().option("header", true).csv(dir).createOrReplaceTempView("csvTable");
    }

    private void saveAsJsonTable(DataFrameWriter<Row> df3, String dir) {
        df3.mode("overwrite").option("compression", "gzip").json(dir);
        this.spark().read().json(dir).createOrReplaceTempView("jsonTable");
    }

    private void saveAsParquetTable(DataFrameWriter<Row> df3, String dir) {
        df3.mode("overwrite").option("compression", "snappy").parquet(dir);
        this.spark().read().parquet(dir).createOrReplaceTempView("parquetTable");
    }

    private void saveAsOrcTable(DataFrameWriter<Row> df3, String dir) {
        df3.mode("overwrite").option("compression", "snappy").orc(dir);
        this.spark().read().orc(dir).createOrReplaceTempView("orcTable");
    }

    public void numericScanBenchmark(int values, DataType dataType) {
        Benchmark sqlBenchmark = new Benchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SQL Single ", " Column Scan"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType.sql()})), (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        Benchmark parquetReaderBenchmark = new Benchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parquet Reader Single ", " Column Scan"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType.sql()})), (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values, dataType, sqlBenchmark, parquetReaderBenchmark){
            public static final long serialVersionUID = 0L;
            public final int values$1;
            public final DataType dataType$1;
            public final Benchmark sqlBenchmark$1;
            public final Benchmark parquetReaderBenchmark$1;

            public final void apply(File dir) {
                DataSourceReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetTable", "orcTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.numericScanBenchmark.1 $outer;
                    private final File dir$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        DataSourceReadBenchmark$.MODULE$.spark().range((long)this.$outer.values$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(Long x$1) {
                                return Random$.MODULE$.nextLong();
                            }
                        }, DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                        DataSourceReadBenchmark$.MODULE$.org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$prepareTable(this.dir$1, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT CAST(value as ", ") id FROM t1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.dataType$1.sql()}))), DataSourceReadBenchmark$.MODULE$.org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$prepareTable$default$3());
                        this.$outer.sqlBenchmark$1.addCase("SQL CSV", this.$outer.sqlBenchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$2) {
                                this.apply$mcVI$sp(x$2);
                            }

                            public void apply$mcVI$sp(int x$2) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from csvTable").collect();
                            }
                        });
                        this.$outer.sqlBenchmark$1.addCase("SQL Json", this.$outer.sqlBenchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$3) {
                                this.apply$mcVI$sp(x$3);
                            }

                            public void apply$mcVI$sp(int x$3) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from jsonTable").collect();
                            }
                        });
                        this.$outer.sqlBenchmark$1.addCase("SQL Parquet Vectorized", this.$outer.sqlBenchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$4) {
                                this.apply$mcVI$sp(x$4);
                            }

                            public void apply$mcVI$sp(int x$4) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from parquetTable").collect();
                            }
                        });
                        this.$outer.sqlBenchmark$1.addCase("SQL Parquet MR", this.$outer.sqlBenchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$5) {
                                this.apply$mcVI$sp(x$5);
                            }

                            public void apply$mcVI$sp(int x$5) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from parquetTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.sqlBenchmark$1.addCase("SQL ORC Vectorized", this.$outer.sqlBenchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$6) {
                                this.apply$mcVI$sp(x$6);
                            }

                            public void apply$mcVI$sp(int x$6) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM orcTable").collect();
                            }
                        });
                        this.$outer.sqlBenchmark$1.addCase("SQL ORC MR", this.$outer.sqlBenchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$7) {
                                this.apply$mcVI$sp(x$7);
                            }

                            public void apply$mcVI$sp(int x$7) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM orcTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.sqlBenchmark$1.run();
                        Object[] files = SpecificParquetRecordReaderBase.listDirectory((File)new File(this.dir$1, "parquet")).toArray();
                        boolean enableOffHeapColumnVector = DataSourceReadBenchmark$.MODULE$.spark().sessionState().conf().offHeapColumnVectorEnabled();
                        int vectorizedReaderBatchSize = DataSourceReadBenchmark$.MODULE$.spark().sessionState().conf().parquetVectorizedReaderBatchSize();
                        this.$outer.parquetReaderBenchmark$1.addCase("ParquetReader Vectorized", this.$outer.parquetReaderBenchmark$1.addCase$default$2(), (Function1)new Serializable(this, files, enableOffHeapColumnVector, vectorizedReaderBatchSize){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$numericScanBenchmark$1$$anonfun$apply$1 $outer;
                            private final Object[] files$1;
                            public final boolean enableOffHeapColumnVector$1;
                            public final int vectorizedReaderBatchSize$1;

                            public final void apply(int x$8) {
                                this.apply$mcVI$sp(x$8);
                            }

                            public void apply$mcVI$sp(int x$8) {
                                DataType dataType;
                                block8: {
                                    Object object;
                                    block3: {
                                        DoubleRef doubleSum;
                                        block7: {
                                            block6: {
                                                LongRef longSum;
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            longSum = LongRef.create((long)0L);
                                                            doubleSum = DoubleRef.create((double)0.0);
                                                            dataType = this.$outer.org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$anonfun$$anonfun$$$outer().dataType$1;
                                                            if (!ByteType$.MODULE$.equals(dataType)) break block2;
                                                            object = new Serializable(this, longSum){
                                                                public static final long serialVersionUID = 0L;
                                                                private final LongRef longSum$1;

                                                                public final void apply(ColumnVector col, int i) {
                                                                    this.longSum$1.elem += (long)col.getByte(i);
                                                                }
                                                                {
                                                                    this.longSum$1 = longSum$1;
                                                                }
                                                            };
                                                            break block3;
                                                        }
                                                        if (!ShortType$.MODULE$.equals(dataType)) break block4;
                                                        object = new Serializable(this, longSum){
                                                            public static final long serialVersionUID = 0L;
                                                            private final LongRef longSum$1;

                                                            public final void apply(ColumnVector col, int i) {
                                                                this.longSum$1.elem += (long)col.getShort(i);
                                                            }
                                                            {
                                                                this.longSum$1 = longSum$1;
                                                            }
                                                        };
                                                        break block3;
                                                    }
                                                    if (!IntegerType$.MODULE$.equals(dataType)) break block5;
                                                    object = new Serializable(this, longSum){
                                                        public static final long serialVersionUID = 0L;
                                                        private final LongRef longSum$1;

                                                        public final void apply(ColumnVector col, int i) {
                                                            this.longSum$1.elem += (long)col.getInt(i);
                                                        }
                                                        {
                                                            this.longSum$1 = longSum$1;
                                                        }
                                                    };
                                                    break block3;
                                                }
                                                if (!LongType$.MODULE$.equals(dataType)) break block6;
                                                object = new Serializable(this, longSum){
                                                    public static final long serialVersionUID = 0L;
                                                    private final LongRef longSum$1;

                                                    public final void apply(ColumnVector col, int i) {
                                                        this.longSum$1.elem += col.getLong(i);
                                                    }
                                                    {
                                                        this.longSum$1 = longSum$1;
                                                    }
                                                };
                                                break block3;
                                            }
                                            if (!FloatType$.MODULE$.equals(dataType)) break block7;
                                            object = new Serializable(this, doubleSum){
                                                public static final long serialVersionUID = 0L;
                                                private final DoubleRef doubleSum$1;

                                                public final void apply(ColumnVector col, int i) {
                                                    this.doubleSum$1.elem += (double)col.getFloat(i);
                                                }
                                                {
                                                    this.doubleSum$1 = doubleSum$1;
                                                }
                                            };
                                            break block3;
                                        }
                                        if (!DoubleType$.MODULE$.equals(dataType)) break block8;
                                        object = new Serializable(this, doubleSum){
                                            public static final long serialVersionUID = 0L;
                                            private final DoubleRef doubleSum$1;

                                            public final void apply(ColumnVector col, int i) {
                                                this.doubleSum$1.elem += col.getDouble(i);
                                            }
                                            {
                                                this.doubleSum$1 = doubleSum$1;
                                            }
                                        };
                                    }
                                    Serializable aggregateValue = object;
                                    Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(this.files$1).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(Object x$9) {
                                            return (String)x$9;
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(this, (Function2)aggregateValue){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$numericScanBenchmark$1$$anonfun$apply$1$$anonfun$apply$mcV$sp$7 $outer;
                                        private final Function2 aggregateValue$1;

                                        /*
                                         * WARNING - void declaration
                                         */
                                        public final void apply(String p) {
                                            VectorizedParquetRecordReader reader = new VectorizedParquetRecordReader(null, this.$outer.enableOffHeapColumnVector$1, this.$outer.vectorizedReaderBatchSize$1);
                                            try {
                                                String string = "id";
                                                reader.initialize(p, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$.$colon$colon((Object)string)).asJava());
                                                ColumnarBatch batch = reader.resultBatch();
                                                ColumnVector col = batch.column(0);
                                                while (reader.nextBatch()) {
                                                    int numRows = batch.numRows();
                                                    for (int i = 0; i < numRows; ++i) {
                                                        Object object = col.isNullAt(i) ? BoxedUnit.UNIT : this.aggregateValue$1.apply((Object)col, (Object)BoxesRunTime.boxToInteger((int)i));
                                                    }
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                void var2_2;
                                                var2_2.close();
                                                throw throwable;
                                            }
                                            reader.close();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.aggregateValue$1 = aggregateValue$1;
                                        }
                                    });
                                    return;
                                }
                                throw new MatchError((Object)dataType);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.files$1 = files$1;
                                this.enableOffHeapColumnVector$1 = enableOffHeapColumnVector$1;
                                this.vectorizedReaderBatchSize$1 = vectorizedReaderBatchSize$1;
                            }
                        });
                        this.$outer.parquetReaderBenchmark$1.addCase("ParquetReader Vectorized -> Row", this.$outer.parquetReaderBenchmark$1.addCase$default$2(), (Function1)new Serializable(this, files, enableOffHeapColumnVector, vectorizedReaderBatchSize){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$numericScanBenchmark$1$$anonfun$apply$1 $outer;
                            private final Object[] files$1;
                            public final boolean enableOffHeapColumnVector$1;
                            public final int vectorizedReaderBatchSize$1;

                            public final void apply(int num) {
                                this.apply$mcVI$sp(num);
                            }

                            public void apply$mcVI$sp(int num) {
                                DataType dataType;
                                block8: {
                                    Object object;
                                    block3: {
                                        DoubleRef doubleSum;
                                        block7: {
                                            block6: {
                                                LongRef longSum;
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            longSum = LongRef.create((long)0L);
                                                            doubleSum = DoubleRef.create((double)0.0);
                                                            dataType = this.$outer.org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$anonfun$$anonfun$$$outer().dataType$1;
                                                            if (!ByteType$.MODULE$.equals(dataType)) break block2;
                                                            object = new Serializable(this, longSum){
                                                                public static final long serialVersionUID = 0L;
                                                                private final LongRef longSum$2;

                                                                public final void apply(InternalRow col) {
                                                                    this.longSum$2.elem += (long)col.getByte(0);
                                                                }
                                                                {
                                                                    this.longSum$2 = longSum$2;
                                                                }
                                                            };
                                                            break block3;
                                                        }
                                                        if (!ShortType$.MODULE$.equals(dataType)) break block4;
                                                        object = new Serializable(this, longSum){
                                                            public static final long serialVersionUID = 0L;
                                                            private final LongRef longSum$2;

                                                            public final void apply(InternalRow col) {
                                                                this.longSum$2.elem += (long)col.getShort(0);
                                                            }
                                                            {
                                                                this.longSum$2 = longSum$2;
                                                            }
                                                        };
                                                        break block3;
                                                    }
                                                    if (!IntegerType$.MODULE$.equals(dataType)) break block5;
                                                    object = new Serializable(this, longSum){
                                                        public static final long serialVersionUID = 0L;
                                                        private final LongRef longSum$2;

                                                        public final void apply(InternalRow col) {
                                                            this.longSum$2.elem += (long)col.getInt(0);
                                                        }
                                                        {
                                                            this.longSum$2 = longSum$2;
                                                        }
                                                    };
                                                    break block3;
                                                }
                                                if (!LongType$.MODULE$.equals(dataType)) break block6;
                                                object = new Serializable(this, longSum){
                                                    public static final long serialVersionUID = 0L;
                                                    private final LongRef longSum$2;

                                                    public final void apply(InternalRow col) {
                                                        this.longSum$2.elem += col.getLong(0);
                                                    }
                                                    {
                                                        this.longSum$2 = longSum$2;
                                                    }
                                                };
                                                break block3;
                                            }
                                            if (!FloatType$.MODULE$.equals(dataType)) break block7;
                                            object = new Serializable(this, doubleSum){
                                                public static final long serialVersionUID = 0L;
                                                private final DoubleRef doubleSum$2;

                                                public final void apply(InternalRow col) {
                                                    this.doubleSum$2.elem += (double)col.getFloat(0);
                                                }
                                                {
                                                    this.doubleSum$2 = doubleSum$2;
                                                }
                                            };
                                            break block3;
                                        }
                                        if (!DoubleType$.MODULE$.equals(dataType)) break block8;
                                        object = new Serializable(this, doubleSum){
                                            public static final long serialVersionUID = 0L;
                                            private final DoubleRef doubleSum$2;

                                            public final void apply(InternalRow col) {
                                                this.doubleSum$2.elem += col.getDouble(0);
                                            }
                                            {
                                                this.doubleSum$2 = doubleSum$2;
                                            }
                                        };
                                    }
                                    Serializable aggregateValue = object;
                                    Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(this.files$1).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(Object x$11) {
                                            return (String)x$11;
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(this, (Function1)aggregateValue){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$numericScanBenchmark$1$$anonfun$apply$1$$anonfun$apply$mcV$sp$8 $outer;
                                        private final Function1 aggregateValue$2;

                                        /*
                                         * WARNING - void declaration
                                         */
                                        public final void apply(String p) {
                                            VectorizedParquetRecordReader reader = new VectorizedParquetRecordReader(null, this.$outer.enableOffHeapColumnVector$1, this.$outer.vectorizedReaderBatchSize$1);
                                            try {
                                                String string = "id";
                                                reader.initialize(p, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$.$colon$colon((Object)string)).asJava());
                                                ColumnarBatch batch = reader.resultBatch();
                                                while (reader.nextBatch()) {
                                                    Iterator it = batch.rowIterator();
                                                    while (it.hasNext()) {
                                                        InternalRow record = (InternalRow)it.next();
                                                        Object object = record.isNullAt(0) ? BoxedUnit.UNIT : this.aggregateValue$2.apply((Object)record);
                                                    }
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                void var2_2;
                                                var2_2.close();
                                                throw throwable;
                                            }
                                            reader.close();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.aggregateValue$2 = aggregateValue$2;
                                        }
                                    });
                                    return;
                                }
                                throw new MatchError((Object)dataType);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.files$1 = files$1;
                                this.enableOffHeapColumnVector$1 = enableOffHeapColumnVector$1;
                                this.vectorizedReaderBatchSize$1 = vectorizedReaderBatchSize$1;
                            }
                        });
                        this.$outer.parquetReaderBenchmark$1.run();
                    }

                    public /* synthetic */ anonfun.numericScanBenchmark.1 org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$1 = dir$1;
                    }
                });
            }
            {
                this.values$1 = values$1;
                this.dataType$1 = dataType$1;
                this.sqlBenchmark$1 = sqlBenchmark$1;
                this.parquetReaderBenchmark$1 = parquetReaderBenchmark$1;
            }
        });
    }

    public void intStringScanBenchmark(int values) {
        Benchmark benchmark2 = new Benchmark("Int and String Scan", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values, benchmark2){
            public static final long serialVersionUID = 0L;
            public final int values$2;
            public final Benchmark benchmark$1;

            public final void apply(File dir) {
                DataSourceReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetTable", "orcTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.intStringScanBenchmark.1 $outer;
                    private final File dir$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        DataSourceReadBenchmark$.MODULE$.spark().range((long)this.$outer.values$2).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(Long x$13) {
                                return Random$.MODULE$.nextLong();
                            }
                        }, DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                        DataSourceReadBenchmark$.MODULE$.org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$prepareTable(this.dir$2, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT CAST(value AS INT) AS c1, CAST(value as STRING) AS c2 FROM t1"), DataSourceReadBenchmark$.MODULE$.org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$prepareTable$default$3());
                        this.$outer.benchmark$1.addCase("SQL CSV", this.$outer.benchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$14) {
                                this.apply$mcVI$sp(x$14);
                            }

                            public void apply$mcVI$sp(int x$14) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(c1), sum(length(c2)) from csvTable").collect();
                            }
                        });
                        this.$outer.benchmark$1.addCase("SQL Json", this.$outer.benchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$15) {
                                this.apply$mcVI$sp(x$15);
                            }

                            public void apply$mcVI$sp(int x$15) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(c1), sum(length(c2)) from jsonTable").collect();
                            }
                        });
                        this.$outer.benchmark$1.addCase("SQL Parquet Vectorized", this.$outer.benchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$16) {
                                this.apply$mcVI$sp(x$16);
                            }

                            public void apply$mcVI$sp(int x$16) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(c1), sum(length(c2)) from parquetTable").collect();
                            }
                        });
                        this.$outer.benchmark$1.addCase("SQL Parquet MR", this.$outer.benchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$17) {
                                this.apply$mcVI$sp(x$17);
                            }

                            public void apply$mcVI$sp(int x$17) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(c1), sum(length(c2)) from parquetTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$1.addCase("SQL ORC Vectorized", this.$outer.benchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$18) {
                                this.apply$mcVI$sp(x$18);
                            }

                            public void apply$mcVI$sp(int x$18) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM orcTable").collect();
                            }
                        });
                        this.$outer.benchmark$1.addCase("SQL ORC MR", this.$outer.benchmark$1.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$19) {
                                this.apply$mcVI$sp(x$19);
                            }

                            public void apply$mcVI$sp(int x$19) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM orcTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$1.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$2 = dir$2;
                    }
                });
            }
            {
                this.values$2 = values$2;
                this.benchmark$1 = benchmark$1;
            }
        });
    }

    public void repeatedStringScanBenchmark(int values) {
        Benchmark benchmark2 = new Benchmark("Repeated String", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values, benchmark2){
            public static final long serialVersionUID = 0L;
            public final int values$3;
            public final Benchmark benchmark$2;

            public final void apply(File dir) {
                DataSourceReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetTable", "orcTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.repeatedStringScanBenchmark.1 $outer;
                    private final File dir$3;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        DataSourceReadBenchmark$.MODULE$.spark().range((long)this.$outer.values$3).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(Long x$20) {
                                return Random$.MODULE$.nextLong();
                            }
                        }, DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                        DataSourceReadBenchmark$.MODULE$.org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$prepareTable(this.dir$3, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql("select cast((value % 200) + 10000 as STRING) as c1 from t1"), DataSourceReadBenchmark$.MODULE$.org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$prepareTable$default$3());
                        this.$outer.benchmark$2.addCase("SQL CSV", this.$outer.benchmark$2.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$21) {
                                this.apply$mcVI$sp(x$21);
                            }

                            public void apply$mcVI$sp(int x$21) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from csvTable").collect();
                            }
                        });
                        this.$outer.benchmark$2.addCase("SQL Json", this.$outer.benchmark$2.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$22) {
                                this.apply$mcVI$sp(x$22);
                            }

                            public void apply$mcVI$sp(int x$22) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from jsonTable").collect();
                            }
                        });
                        this.$outer.benchmark$2.addCase("SQL Parquet Vectorized", this.$outer.benchmark$2.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$23) {
                                this.apply$mcVI$sp(x$23);
                            }

                            public void apply$mcVI$sp(int x$23) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from parquetTable").collect();
                            }
                        });
                        this.$outer.benchmark$2.addCase("SQL Parquet MR", this.$outer.benchmark$2.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$24) {
                                this.apply$mcVI$sp(x$24);
                            }

                            public void apply$mcVI$sp(int x$24) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from parquetTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$2.addCase("SQL ORC Vectorized", this.$outer.benchmark$2.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$25) {
                                this.apply$mcVI$sp(x$25);
                            }

                            public void apply$mcVI$sp(int x$25) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from orcTable").collect();
                            }
                        });
                        this.$outer.benchmark$2.addCase("SQL ORC MR", this.$outer.benchmark$2.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$26) {
                                this.apply$mcVI$sp(x$26);
                            }

                            public void apply$mcVI$sp(int x$26) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from orcTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$2.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$3 = dir$3;
                    }
                });
            }
            {
                this.values$3 = values$3;
                this.benchmark$2 = benchmark$2;
            }
        });
    }

    public void partitionTableScanBenchmark(int values) {
        Benchmark benchmark2 = new Benchmark("Partitioned Table", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values, benchmark2){
            public static final long serialVersionUID = 0L;
            public final int values$4;
            public final Benchmark benchmark$3;

            public final void apply(File dir) {
                DataSourceReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetTable", "orcTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.partitionTableScanBenchmark.1 $outer;
                    private final File dir$4;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        DataSourceReadBenchmark$.MODULE$.spark().range((long)this.$outer.values$4).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(Long x$27) {
                                return Random$.MODULE$.nextLong();
                            }
                        }, DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                        DataSourceReadBenchmark$.MODULE$.org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$prepareTable(this.dir$4, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT value % 2 AS p, value AS id FROM t1"), (Option<String>)new Some((Object)"p"));
                        this.$outer.benchmark$3.addCase("Data column - CSV", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$28) {
                                this.apply$mcVI$sp(x$28);
                            }

                            public void apply$mcVI$sp(int x$28) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from csvTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Data column - Json", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$29) {
                                this.apply$mcVI$sp(x$29);
                            }

                            public void apply$mcVI$sp(int x$29) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from jsonTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Data column - Parquet Vectorized", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$30) {
                                this.apply$mcVI$sp(x$30);
                            }

                            public void apply$mcVI$sp(int x$30) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from parquetTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Data column - Parquet MR", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$31) {
                                this.apply$mcVI$sp(x$31);
                            }

                            public void apply$mcVI$sp(int x$31) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from parquetTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$3.addCase("Data column - ORC Vectorized", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$32) {
                                this.apply$mcVI$sp(x$32);
                            }

                            public void apply$mcVI$sp(int x$32) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM orcTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Data column - ORC MR", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$33) {
                                this.apply$mcVI$sp(x$33);
                            }

                            public void apply$mcVI$sp(int x$33) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM orcTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$3.addCase("Partition column - CSV", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$34) {
                                this.apply$mcVI$sp(x$34);
                            }

                            public void apply$mcVI$sp(int x$34) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p) from csvTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Partition column - Json", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$35) {
                                this.apply$mcVI$sp(x$35);
                            }

                            public void apply$mcVI$sp(int x$35) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p) from jsonTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Partition column - Parquet Vectorized", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$36) {
                                this.apply$mcVI$sp(x$36);
                            }

                            public void apply$mcVI$sp(int x$36) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p) from parquetTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Partition column - Parquet MR", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$37) {
                                this.apply$mcVI$sp(x$37);
                            }

                            public void apply$mcVI$sp(int x$37) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p) from parquetTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$3.addCase("Partition column - ORC Vectorized", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$38) {
                                this.apply$mcVI$sp(x$38);
                            }

                            public void apply$mcVI$sp(int x$38) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM orcTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Partition column - ORC MR", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$39) {
                                this.apply$mcVI$sp(x$39);
                            }

                            public void apply$mcVI$sp(int x$39) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM orcTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$3.addCase("Both columns - CSV", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$40) {
                                this.apply$mcVI$sp(x$40);
                            }

                            public void apply$mcVI$sp(int x$40) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p), sum(id) from csvTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Both columns - Json", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$41) {
                                this.apply$mcVI$sp(x$41);
                            }

                            public void apply$mcVI$sp(int x$41) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p), sum(id) from jsonTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Both columns - Parquet Vectorized", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$42) {
                                this.apply$mcVI$sp(x$42);
                            }

                            public void apply$mcVI$sp(int x$42) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p), sum(id) from parquetTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Both columns - Parquet MR", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$43) {
                                this.apply$mcVI$sp(x$43);
                            }

                            public void apply$mcVI$sp(int x$43) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p), sum(id) from parquetTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$3.addCase("Both columns - ORC Vectorized", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$44) {
                                this.apply$mcVI$sp(x$44);
                            }

                            public void apply$mcVI$sp(int x$44) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM orcTable").collect();
                            }
                        });
                        this.$outer.benchmark$3.addCase("Both columns - ORC MR", this.$outer.benchmark$3.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$45) {
                                this.apply$mcVI$sp(x$45);
                            }

                            public void apply$mcVI$sp(int x$45) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM orcTable").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$3.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$4 = dir$4;
                    }
                });
            }
            {
                this.values$4 = values$4;
                this.benchmark$3 = benchmark$3;
            }
        });
    }

    public void stringWithNullsScanBenchmark(int values, double fractionOfNulls) {
        Benchmark benchmark2 = new Benchmark("String with Nulls Scan", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values, fractionOfNulls, benchmark2){
            public static final long serialVersionUID = 0L;
            public final int values$5;
            public final double fractionOfNulls$1;
            public final Benchmark benchmark$4;

            public final void apply(File dir) {
                DataSourceReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetTable", "orcTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.stringWithNullsScanBenchmark.1 $outer;
                    private final File dir$5;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        DataSourceReadBenchmark$.MODULE$.spark().range((long)this.$outer.values$5).createOrReplaceTempView("t1");
                        DataSourceReadBenchmark$.MODULE$.org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$prepareTable(this.dir$5, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT IF(RAND(1) < ", ", NULL, CAST(id as STRING)) AS c1, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.fractionOfNulls$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IF(RAND(2) < ", ", NULL, CAST(id as STRING)) AS c2 FROM t1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.fractionOfNulls$1)}))).toString()), DataSourceReadBenchmark$.MODULE$.org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$prepareTable$default$3());
                        this.$outer.benchmark$4.addCase("SQL CSV", this.$outer.benchmark$4.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$46) {
                                this.apply$mcVI$sp(x$46);
                            }

                            public void apply$mcVI$sp(int x$46) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c2)) from csvTable where c1 is not NULL and c2 is not NULL").collect();
                            }
                        });
                        this.$outer.benchmark$4.addCase("SQL Json", this.$outer.benchmark$4.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$47) {
                                this.apply$mcVI$sp(x$47);
                            }

                            public void apply$mcVI$sp(int x$47) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c2)) from jsonTable where c1 is not NULL and c2 is not NULL").collect();
                            }
                        });
                        this.$outer.benchmark$4.addCase("SQL Parquet Vectorized", this.$outer.benchmark$4.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$48) {
                                this.apply$mcVI$sp(x$48);
                            }

                            public void apply$mcVI$sp(int x$48) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c2)) from parquetTable where c1 is not NULL and c2 is not NULL").collect();
                            }
                        });
                        this.$outer.benchmark$4.addCase("SQL Parquet MR", this.$outer.benchmark$4.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$49) {
                                this.apply$mcVI$sp(x$49);
                            }

                            public void apply$mcVI$sp(int x$49) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c2)) from parquetTable where c1 is not NULL and c2 is not NULL").collect();
                                    }
                                });
                            }
                        });
                        Object[] files = SpecificParquetRecordReaderBase.listDirectory((File)new File(this.dir$5, "parquet")).toArray();
                        boolean enableOffHeapColumnVector = DataSourceReadBenchmark$.MODULE$.spark().sessionState().conf().offHeapColumnVectorEnabled();
                        int vectorizedReaderBatchSize = DataSourceReadBenchmark$.MODULE$.spark().sessionState().conf().parquetVectorizedReaderBatchSize();
                        this.$outer.benchmark$4.addCase("ParquetReader Vectorized", this.$outer.benchmark$4.addCase$default$2(), (Function1)new Serializable(this, files, enableOffHeapColumnVector, vectorizedReaderBatchSize){
                            public static final long serialVersionUID = 0L;
                            private final Object[] files$2;
                            public final boolean enableOffHeapColumnVector$2;
                            public final int vectorizedReaderBatchSize$2;

                            public final void apply(int num) {
                                this.apply$mcVI$sp(num);
                            }

                            public void apply$mcVI$sp(int num) {
                                IntRef sum = IntRef.create((int)0);
                                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(this.files$2).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(Object x$50) {
                                        return (String)x$50;
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(this, sum){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$stringWithNullsScanBenchmark$1$$anonfun$apply$5$$anonfun$apply$mcV$sp$43 $outer;
                                    private final IntRef sum$1;

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final void apply(String p) {
                                        VectorizedParquetRecordReader reader = new VectorizedParquetRecordReader(null, this.$outer.enableOffHeapColumnVector$2, this.$outer.vectorizedReaderBatchSize$2);
                                        try {
                                            String string = "c1";
                                            String string2 = "c2";
                                            reader.initialize(p, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string)).asJava());
                                            ColumnarBatch batch = reader.resultBatch();
                                            while (reader.nextBatch()) {
                                                Iterator rowIterator = batch.rowIterator();
                                                while (rowIterator.hasNext()) {
                                                    InternalRow row = (InternalRow)rowIterator.next();
                                                    UTF8String value = row.getUTF8String(0);
                                                    if (row.isNullAt(0) || row.isNullAt(1)) continue;
                                                    this.sum$1.elem += value.numBytes();
                                                }
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            void var2_2;
                                            var2_2.close();
                                            throw throwable;
                                        }
                                        reader.close();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.sum$1 = sum$1;
                                    }
                                });
                            }
                            {
                                this.files$2 = files$2;
                                this.enableOffHeapColumnVector$2 = enableOffHeapColumnVector$2;
                                this.vectorizedReaderBatchSize$2 = vectorizedReaderBatchSize$2;
                            }
                        });
                        this.$outer.benchmark$4.addCase("SQL ORC Vectorized", this.$outer.benchmark$4.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$53) {
                                this.apply$mcVI$sp(x$53);
                            }

                            public void apply$mcVI$sp(int x$53) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM orcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL").collect();
                            }
                        });
                        this.$outer.benchmark$4.addCase("SQL ORC MR", this.$outer.benchmark$4.addCase$default$2(), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(int x$54) {
                                this.apply$mcVI$sp(x$54);
                            }

                            public void apply$mcVI$sp(int x$54) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM orcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL").collect();
                                    }
                                });
                            }
                        });
                        this.$outer.benchmark$4.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$5 = dir$5;
                    }
                });
            }
            {
                this.values$5 = values$5;
                this.fractionOfNulls$1 = fractionOfNulls$1;
                this.benchmark$4 = benchmark$4;
            }
        });
    }

    public void columnsBenchmark(int values, int width) {
        Benchmark benchmark2 = new Benchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Single Column Scan from ", " columns"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)width)})), (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(values, width, benchmark2){
            public static final long serialVersionUID = 0L;
            public final int values$6;
            public final int width$1;
            public final Benchmark benchmark$5;

            public final void apply(File dir) {
                DataSourceReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetTable", "orcTable"}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.columnsBenchmark.1 $outer;
                    private final File dir$6;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        int middle = this.$outer.width$1 / 2;
                        IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.$outer.width$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(int i) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value as c", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                        DataSourceReadBenchmark$.MODULE$.spark().range((long)this.$outer.values$6).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(Long x$55) {
                                return Random$.MODULE$.nextLong();
                            }
                        }, DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).toDF().selectExpr((Seq)selectExpr).createOrReplaceTempView("t1");
                        DataSourceReadBenchmark$.MODULE$.org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$prepareTable(this.dir$6, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT * FROM t1"), DataSourceReadBenchmark$.MODULE$.org$apache$spark$sql$execution$benchmark$DataSourceReadBenchmark$$prepareTable$default$3());
                        this.$outer.benchmark$5.addCase("SQL CSV", this.$outer.benchmark$5.addCase$default$2(), (Function1)new Serializable(this, middle){
                            public static final long serialVersionUID = 0L;
                            private final int middle$1;

                            public final void apply(int x$56) {
                                this.apply$mcVI$sp(x$56);
                            }

                            public void apply$mcVI$sp(int x$56) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT sum(c", ") FROM csvTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.middle$1)}))).collect();
                            }
                            {
                                this.middle$1 = middle$1;
                            }
                        });
                        this.$outer.benchmark$5.addCase("SQL Json", this.$outer.benchmark$5.addCase$default$2(), (Function1)new Serializable(this, middle){
                            public static final long serialVersionUID = 0L;
                            private final int middle$1;

                            public final void apply(int x$57) {
                                this.apply$mcVI$sp(x$57);
                            }

                            public void apply$mcVI$sp(int x$57) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT sum(c", ") FROM jsonTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.middle$1)}))).collect();
                            }
                            {
                                this.middle$1 = middle$1;
                            }
                        });
                        this.$outer.benchmark$5.addCase("SQL Parquet Vectorized", this.$outer.benchmark$5.addCase$default$2(), (Function1)new Serializable(this, middle){
                            public static final long serialVersionUID = 0L;
                            private final int middle$1;

                            public final void apply(int x$58) {
                                this.apply$mcVI$sp(x$58);
                            }

                            public void apply$mcVI$sp(int x$58) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT sum(c", ") FROM parquetTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.middle$1)}))).collect();
                            }
                            {
                                this.middle$1 = middle$1;
                            }
                        });
                        this.$outer.benchmark$5.addCase("SQL Parquet MR", this.$outer.benchmark$5.addCase$default$2(), (Function1)new Serializable(this, middle){
                            public static final long serialVersionUID = 0L;
                            public final int middle$1;

                            public final void apply(int x$59) {
                                this.apply$mcVI$sp(x$59);
                            }

                            public void apply$mcVI$sp(int x$59) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$columnsBenchmark$1$$anonfun$apply$6$$anonfun$apply$mcV$sp$49 $outer;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT sum(c", ") FROM parquetTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.middle$1)}))).collect();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            {
                                this.middle$1 = middle$1;
                            }
                        });
                        this.$outer.benchmark$5.addCase("SQL ORC Vectorized", this.$outer.benchmark$5.addCase$default$2(), (Function1)new Serializable(this, middle){
                            public static final long serialVersionUID = 0L;
                            private final int middle$1;

                            public final void apply(int x$60) {
                                this.apply$mcVI$sp(x$60);
                            }

                            public void apply$mcVI$sp(int x$60) {
                                DataSourceReadBenchmark$.MODULE$.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT sum(c", ") FROM orcTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.middle$1)}))).collect();
                            }
                            {
                                this.middle$1 = middle$1;
                            }
                        });
                        this.$outer.benchmark$5.addCase("SQL ORC MR", this.$outer.benchmark$5.addCase$default$2(), (Function1)new Serializable(this, middle){
                            public static final long serialVersionUID = 0L;
                            public final int middle$1;

                            public final void apply(int x$61) {
                                this.apply$mcVI$sp(x$61);
                            }

                            public void apply$mcVI$sp(int x$61) {
                                DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$columnsBenchmark$1$$anonfun$apply$6$$anonfun$apply$mcV$sp$51 $outer;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DataSourceReadBenchmark$.MODULE$.spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT sum(c", ") FROM orcTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.middle$1)}))).collect();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            {
                                this.middle$1 = middle$1;
                            }
                        });
                        this.$outer.benchmark$5.run();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$6 = dir$6;
                    }
                });
            }
            {
                this.values$6 = values$6;
                this.width$1 = width$1;
                this.benchmark$5 = benchmark$5;
            }
        });
    }

    public void main(String[] args) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$}))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(NumericType dataType) {
                DataSourceReadBenchmark$.MODULE$.numericScanBenchmark(0xF00000, (DataType)dataType);
            }
        });
        this.intStringScanBenchmark(0xA00000);
        this.repeatedStringScanBenchmark(0xA00000);
        this.partitionTableScanBenchmark(0xF00000);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5, 0.95})).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(double fractionOfNulls) {
                this.apply$mcVD$sp(fractionOfNulls);
            }

            public void apply$mcVD$sp(double fractionOfNulls) {
                DataSourceReadBenchmark$.MODULE$.stringWithNullsScanBenchmark(0xA00000, fractionOfNulls);
            }
        });
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 50, 100})).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(int columnWidth) {
                this.apply$mcVI$sp(columnWidth);
            }

            public void apply$mcVI$sp(int columnWidth) {
                DataSourceReadBenchmark$.MODULE$.columnsBenchmark(0x100000, columnWidth);
            }
        });
    }

    private DataSourceReadBenchmark$() {
        MODULE$ = this;
        SQLHelper.class.$init$((SQLHelper)this);
        this.conf = new SparkConf().setAppName("DataSourceReadBenchmark").set("spark.master", "local[1]").setIfMissing("spark.driver.memory", "3g").setIfMissing("spark.executor.memory", "3g").setIfMissing("spark.ui.enabled", "false");
        this.spark = SparkSession$.MODULE$.builder().config(this.conf()).getOrCreate();
        this.spark().conf().set(SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key(), "true");
        this.spark().conf().set(SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key(), "true");
        this.spark().conf().set(SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key(), "true");
    }
}

