/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import org.apache.spark.SparkContext;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class PrimitiveArrayBenchmark$
extends BenchmarkBase {
    public static final PrimitiveArrayBenchmark$ MODULE$;
    private SparkSession sparkSession;
    private volatile boolean bitmap$0;

    static {
        new PrimitiveArrayBenchmark$();
    }

    private SparkSession sparkSession$lzycompute() {
        PrimitiveArrayBenchmark$ primitiveArrayBenchmark$ = this;
        synchronized (primitiveArrayBenchmark$) {
            if (!this.bitmap$0) {
                this.sparkSession = SparkSession$.MODULE$.builder().master("local[1]").appName("microbenchmark").config("spark.sql.shuffle.partitions", 1L).config("spark.sql.autoBroadcastJoinThreshold", 1L).getOrCreate();
                this.bitmap$0 = true;
            }
            return this.sparkSession;
        }
    }

    public SparkSession sparkSession() {
        return this.bitmap$0 ? this.sparkSession : this.sparkSession$lzycompute();
    }

    public void benchmark() {
        this.runBenchmark("Write primitive arrays in dataset", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PrimitiveArrayBenchmark$.MODULE$.writeDatasetArray(4);
            }
        });
    }

    public void writeDatasetArray(int iters) {
        int count = 0x200000;
        SparkContext sc = this.sparkSession().sparkContext();
        int[] primitiveIntArray = (int[])Array$.MODULE$.fill(count, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 65535;
            }
        }, ClassTag$.MODULE$.Int());
        Dataset dsInt = this.sparkSession().implicits().rddToDatasetHolder(sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new int[][]{primitiveIntArray})), 1, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))), this.sparkSession().implicits().newIntArrayEncoder()).toDS();
        dsInt.count();
        Serializable intArray = new Serializable(iters, dsInt){
            public static final long serialVersionUID = 0L;
            private final int iters$1;
            private final Dataset dsInt$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int len = 0;
                for (int n = 0; n < this.iters$1; ++n) {
                    len += ((InternalRow[])this.dsInt$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int[] apply(int[] e) {
                            return e;
                        }
                    }, PrimitiveArrayBenchmark$.MODULE$.sparkSession().implicits().newIntArrayEncoder()).queryExecution().toRdd().collect()).length;
                }
            }
            {
                this.iters$1 = iters$1;
                this.dsInt$1 = dsInt$1;
            }
        };
        double[] primitiveDoubleArray = (double[])Array$.MODULE$.fill(count, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 65535.0;
            }
        }, ClassTag$.MODULE$.Double());
        Dataset dsDouble = this.sparkSession().implicits().rddToDatasetHolder(sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{primitiveDoubleArray})), 1, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))), this.sparkSession().implicits().newDoubleArrayEncoder()).toDS();
        dsDouble.count();
        Serializable doubleArray = new Serializable(iters, dsDouble){
            public static final long serialVersionUID = 0L;
            private final int iters$1;
            private final Dataset dsDouble$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int len = 0;
                for (int n = 0; n < this.iters$1; ++n) {
                    len += ((InternalRow[])this.dsDouble$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double[] apply(double[] e) {
                            return e;
                        }
                    }, PrimitiveArrayBenchmark$.MODULE$.sparkSession().implicits().newDoubleArrayEncoder()).queryExecution().toRdd().collect()).length;
                }
            }
            {
                this.iters$1 = iters$1;
                this.dsDouble$1 = dsDouble$1;
            }
        };
        String x$1 = "Write an array in Dataset";
        long x$2 = count * iters;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark2 = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        benchmark2.addCase("Int   ", benchmark2.addCase$default$2(), (Function1)intArray);
        benchmark2.addCase("Double", benchmark2.addCase$default$2(), (Function1)doubleArray);
        benchmark2.run();
    }

    private PrimitiveArrayBenchmark$() {
        MODULE$ = this;
    }
}

