/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import org.apache.spark.SparkConf;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.AliasIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.benchmark.TPCDSQueryBenchmark$;
import org.apache.spark.sql.execution.benchmark.TPCDSQueryBenchmarkArguments;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TPCDSQueryBenchmark$
implements Logging {
    public static final TPCDSQueryBenchmark$ MODULE$;
    private final SparkConf conf;
    private final SparkSession spark;
    private final Seq<String> tables;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new TPCDSQueryBenchmark$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public Seq<String> tables() {
        return this.tables;
    }

    public Map<String, Object> setupTables(String dataLocation) {
        return ((TraversableOnce)this.tables().map((Function1)new Serializable(dataLocation){
            public static final long serialVersionUID = 0L;
            private final String dataLocation$1;

            public final Tuple2<String, Object> apply(String tableName) {
                TPCDSQueryBenchmark$.MODULE$.spark().read().parquet(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataLocation$1, tableName}))).createOrReplaceTempView(tableName);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tableName), (Object)BoxesRunTime.boxToLong((long)TPCDSQueryBenchmark$.MODULE$.spark().table(tableName).count()));
            }
            {
                this.dataLocation$1 = dataLocation$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void runTpcdsQueries(String queryLocation, Seq<String> queries, Map<String, Object> tableSizes, String nameSuffix) {
        queries.foreach((Function1)new Serializable(queryLocation, tableSizes, nameSuffix){
            public static final long serialVersionUID = 0L;
            private final String queryLocation$1;
            public final Map tableSizes$1;
            private final String nameSuffix$1;

            public final void apply(String name) {
                String x$3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".sql"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.queryLocation$1, name}));
                ClassLoader x$4 = Thread.currentThread().getContextClassLoader();
                String x$5 = package$.MODULE$.resourceToString$default$2();
                String queryString = package$.MODULE$.resourceToString(x$3, x$5, x$4);
                HashSet queryRelations = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
                TPCDSQueryBenchmark$.MODULE$.spark().sql(queryString).queryExecution().analyzed().foreach((Function1)new Serializable(this, queryRelations){
                    public static final long serialVersionUID = 0L;
                    private final HashSet queryRelations$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final void apply(LogicalPlan x0$1) {
                        LogicalRelation logicalRelation;
                        Option option;
                        LogicalPlan logicalPlan = x0$1;
                        if (logicalPlan instanceof SubqueryAlias) {
                            SubqueryAlias subqueryAlias = (SubqueryAlias)logicalPlan;
                            AliasIdentifier alias = subqueryAlias.name();
                            if (subqueryAlias.child() instanceof LogicalRelation) {
                                this.queryRelations$1.add((Object)alias.identifier());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                        if (logicalPlan instanceof LogicalRelation && (option = (logicalRelation = (LogicalRelation)logicalPlan).catalogTable()) instanceof Some) {
                            Some some = (Some)option;
                            CatalogTable catalogTable = (CatalogTable)some.x();
                            this.queryRelations$1.add((Object)catalogTable.identifier().table());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        if (logicalPlan instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)logicalPlan;
                            CatalogTable tableMeta = hiveTableRelation.tableMeta();
                            this.queryRelations$1.add((Object)tableMeta.identifier().table());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    {
                        this.queryRelations$1 = queryRelations$1;
                    }
                });
                long numRows = BoxesRunTime.unboxToLong((Object)((TraversableOnce)queryRelations.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.runTpcdsQueries.1 $outer;

                    public final long apply(String x$1) {
                        return BoxesRunTime.unboxToLong((Object)this.$outer.tableSizes$1.getOrElse((Object)x$1, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return 0L;
                            }
                        }));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, HashSet$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                Benchmark benchmark2 = new Benchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TPCDS Snappy"})).s((Seq)Nil$.MODULE$), numRows, 5, Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
                benchmark2.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, this.nameSuffix$1})), benchmark2.addCase$default$2(), (Function1)new Serializable(this, queryString){
                    public static final long serialVersionUID = 0L;
                    private final String queryString$1;

                    public final void apply(int x$2) {
                        this.apply$mcVI$sp(x$2);
                    }

                    public void apply$mcVI$sp(int x$2) {
                        TPCDSQueryBenchmark$.MODULE$.spark().sql(this.queryString$1).collect();
                    }
                    {
                        this.queryString$1 = queryString$1;
                    }
                });
                TPCDSQueryBenchmark$.MODULE$.logInfo((Function0<String>)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n\\n===== TPCDS QUERY BENCHMARK OUTPUT FOR ", " =====\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                    }
                    {
                        this.name$1 = name$1;
                    }
                });
                benchmark2.run();
                TPCDSQueryBenchmark$.MODULE$.logInfo((Function0<String>)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n\\n===== FINISHED ", " =====\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                    }
                    {
                        this.name$1 = name$1;
                    }
                });
            }
            {
                this.queryLocation$1 = queryLocation$1;
                this.tableSizes$1 = tableSizes$1;
                this.nameSuffix$1 = nameSuffix$1;
            }
        });
    }

    public String runTpcdsQueries$default$4() {
        return "";
    }

    private Seq<String> filterQueries(Seq<String> origQueries, Set<String> queryFilter, String nameSuffix) {
        return queryFilter.nonEmpty() ? (new StringOps(Predef$.MODULE$.augmentString(nameSuffix)).nonEmpty() ? (Seq)origQueries.filter((Function1)new Serializable(queryFilter, nameSuffix){
            public static final long serialVersionUID = 0L;
            private final Set queryFilter$1;
            private final String nameSuffix$2;

            public final boolean apply(String name) {
                return this.queryFilter$1.contains((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, this.nameSuffix$2})));
            }
            {
                this.queryFilter$1 = queryFilter$1;
                this.nameSuffix$2 = nameSuffix$2;
            }
        }) : (Seq)origQueries.filter((Function1)new Serializable(queryFilter){
            public static final long serialVersionUID = 0L;
            private final Set queryFilter$1;

            public final boolean apply(String elem) {
                return this.queryFilter$1.contains((Object)elem);
            }
            {
                this.queryFilter$1 = queryFilter$1;
            }
        })) : origQueries;
    }

    private String filterQueries$default$3() {
        return "";
    }

    public void main(String[] args) {
        Seq<String> queriesV2_7ToRun;
        TPCDSQueryBenchmarkArguments benchmarkArgs = new TPCDSQueryBenchmarkArguments(args);
        Seq tpcdsQueries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14a", "q14b", "q15", "q16", "q17", "q18", "q19", "q20", "q21", "q22", "q23a", "q23b", "q24a", "q24b", "q25", "q26", "q27", "q28", "q29", "q30", "q31", "q32", "q33", "q34", "q35", "q36", "q37", "q38", "q39a", "q39b", "q40", "q41", "q42", "q43", "q44", "q45", "q46", "q47", "q48", "q49", "q50", "q51", "q52", "q53", "q54", "q55", "q56", "q57", "q58", "q59", "q60", "q61", "q62", "q63", "q64", "q65", "q66", "q67", "q68", "q69", "q70", "q71", "q72", "q73", "q74", "q75", "q76", "q77", "q78", "q79", "q80", "q81", "q82", "q83", "q84", "q85", "q86", "q87", "q88", "q89", "q90", "q91", "q92", "q93", "q94", "q95", "q96", "q97", "q98", "q99"}));
        String nameSuffixForQueriesV2_7 = "-v2.7";
        Seq tpcdsQueriesV2_7 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"q5a", "q6", "q10a", "q11", "q12", "q14", "q14a", "q18a", "q20", "q22", "q22a", "q24", "q27a", "q34", "q35", "q35a", "q36a", "q47", "q49", "q51a", "q57", "q64", "q67a", "q70a", "q72", "q74", "q75", "q77a", "q78", "q80a", "q86a", "q98"}));
        Seq<String> queriesV1_4ToRun = this.filterQueries((Seq<String>)tpcdsQueries, benchmarkArgs.queryFilter(), this.filterQueries$default$3());
        if (((SeqLike)queriesV1_4ToRun.$plus$plus(queriesV2_7ToRun = this.filterQueries((Seq<String>)tpcdsQueriesV2_7, benchmarkArgs.queryFilter(), nameSuffixForQueriesV2_7), Seq$.MODULE$.canBuildFrom())).isEmpty()) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Empty queries to run. Bad query name filter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{benchmarkArgs.queryFilter()})));
        }
        Map<String, Object> tableSizes = this.setupTables(benchmarkArgs.dataLocation());
        this.runTpcdsQueries("tpcds", queriesV1_4ToRun, tableSizes, this.runTpcdsQueries$default$4());
        this.runTpcdsQueries("tpcds-v2.7.0", queriesV2_7ToRun, tableSizes, nameSuffixForQueriesV2_7);
    }

    private TPCDSQueryBenchmark$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.conf = new SparkConf().setMaster("local[1]").setAppName("test-sql-context").set("spark.sql.parquet.compression.codec", "snappy").set("spark.sql.shuffle.partitions", "4").set("spark.driver.memory", "3g").set("spark.executor.memory", "3g").set("spark.sql.autoBroadcastJoinThreshold", ((Object)BoxesRunTime.boxToInteger((int)0x1400000)).toString()).set("spark.sql.crossJoin.enabled", "true");
        this.spark = SparkSession$.MODULE$.builder().config(this.conf()).getOrCreate();
        this.tables = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"catalog_page", "catalog_returns", "customer", "customer_address", "customer_demographics", "date_dim", "household_demographics", "inventory", "item", "promotion", "store", "store_returns", "catalog_sales", "web_sales", "store_sales", "web_returns", "web_site", "reason", "call_center", "warehouse", "ship_mode", "income_band", "time_dim", "web_page"}));
    }
}

