/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.NoopColumnStats;
import org.apache.spark.sql.execution.columnar.compression.BooleanBitSet$;
import org.apache.spark.sql.execution.columnar.compression.BooleanBitSetSuite$;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.execution.columnar.compression.Decoder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u000152A!\u0001\u0002\u0001#\t\u0011\"i\\8mK\u0006t')\u001b;TKR\u001cV/\u001b;f\u0015\t\u0019A!A\u0006d_6\u0004(/Z:tS>t'BA\u0003\u0007\u0003!\u0019w\u000e\\;n]\u0006\u0014(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0015%\u0011QC\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005\u0011\u0001\"\u0002\u000f\u0001\t\u0003i\u0012\u0001C:lK2,Go\u001c8\u0015\u0005y!\u0003CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSRDQ!J\u000eA\u0002\u0019\nQaY8v]R\u0004\"aH\u0014\n\u0005!\u0002#aA%oi\")!\u0006\u0001C\u0001W\u0005)2o[3mKR|gNR8s\t\u0016\u001cw.\u001c9sKN\u001cHC\u0001\u0010-\u0011\u0015)\u0013\u00061\u0001'\u0001")
public class BooleanBitSetSuite
extends SparkFunSuite {
    public void skeleton(int count) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply((ColumnStats)new NoopColumnStats(), BOOLEAN$.MODULE$, (CompressionScheme)BooleanBitSet$.MODULE$);
        Seq rows = (Seq)Seq$.MODULE$.fill(count, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InternalRow apply() {
                return ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)BOOLEAN$.MODULE$, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]));
            }
        });
        Seq values = (Seq)rows.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(InternalRow x$1) {
                return x$1.getBoolean(0);
            }
        }, Seq$.MODULE$.canBuildFrom());
        rows.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final TestCompressibleColumnBuilder builder$1;

            public final void apply(InternalRow x$2) {
                this.builder$1.appendFrom(x$2, 0);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        int extra = count % BooleanBitSet$.MODULE$.BITS_PER_LONG() == 0 ? 0 : 1;
        int compressedSize = 8 + (count / BooleanBitSet$.MODULE$.BITS_PER_LONG() + extra) * 8;
        this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)BooleanBitSet$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.assertResult(BoxesRunTime.boxToInteger((int)count), "Wrong element count", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        LongRef word = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)new Serializable(this, values, buffer, word){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;
            private final Seq values$1;
            private final ByteBuffer buffer$1;
            private final LongRef word$1;

            public final Assertion apply(int i) {
                int bit = i % BooleanBitSet$.MODULE$.BITS_PER_LONG();
                this.word$1.elem = bit == 0 ? this.buffer$1.getLong() : this.word$1.elem;
                return this.$outer.assertResult(this.values$1.apply(i), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong value in compressed buffer, index=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), BoxesRunTime.boxToBoolean(((this.word$1.elem & 1L << bit) != 0L ? 1 : 0) != 0), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.values$1 = values$1;
                this.buffer$1 = buffer$1;
                this.word$1 = word$1;
            }
        });
        buffer.rewind().position(headerSize + 4);
        Decoder decoder = BooleanBitSet$.MODULE$.decoder(buffer, (NativeColumnType)BOOLEAN$.MODULE$);
        GenericInternalRow mutableRow = new GenericInternalRow(1);
        if (values.nonEmpty()) {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            values.foreach((Function1)new Serializable(this, decoder, mutableRow){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BooleanBitSetSuite $outer;
                private final Decoder decoder$1;
                private final GenericInternalRow mutableRow$1;

                public final Assertion apply(boolean x$3) {
                    Boolean bl = BoxesRunTime.boxToBoolean((boolean)x$3);
                    this.decoder$1.next((InternalRow)this.mutableRow$1, 0);
                    return this.$outer.assertResult(bl, "Wrong decoded value", BoxesRunTime.boxToBoolean((boolean)this.mutableRow$1.getBoolean(0)), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.decoder$1 = decoder$1;
                    this.mutableRow$1 = mutableRow$1;
                }
            });
        }
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
    }

    public void skeletonForDecompress(int count) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply((ColumnStats)new NoopColumnStats(), BOOLEAN$.MODULE$, (CompressionScheme)BooleanBitSet$.MODULE$);
        Seq rows = (Seq)Seq$.MODULE$.fill(count, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InternalRow apply() {
                return ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)BOOLEAN$.MODULE$, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]));
            }
        });
        Seq values = (Seq)rows.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(InternalRow x$4) {
                return x$4.getBoolean(0);
            }
        }, Seq$.MODULE$.canBuildFrom());
        rows.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final TestCompressibleColumnBuilder builder$2;

            public final void apply(InternalRow x$5) {
                this.builder$2.appendFrom(x$5, 0);
            }
            {
                this.builder$2 = builder$2;
            }
        });
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)BooleanBitSet$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        Decoder decoder = BooleanBitSet$.MODULE$.decoder(buffer, (NativeColumnType)BOOLEAN$.MODULE$);
        OnHeapColumnVector columnVector = new OnHeapColumnVector(values.length(), (DataType)BooleanType$.MODULE$);
        decoder.decompress((WritableColumnVector)columnVector, values.length());
        if (values.nonEmpty()) {
            ((IterableLike)values.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, columnVector){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BooleanBitSetSuite $outer;
                private final OnHeapColumnVector columnVector$1;

                public final Assertion apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        boolean b = tuple2._1$mcZ$sp();
                        int index = tuple2._2$mcI$sp();
                        boolean bl = b;
                        int n = index;
                        Assertion assertion = this.$outer.assertResult(BoxesRunTime.boxToBoolean((boolean)bl), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong ", "-th decoded boolean value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), BoxesRunTime.boxToBoolean((boolean)this.columnVector$1.getBoolean(n)), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
                        return assertion;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.columnVector$1 = columnVector$1;
                }
            });
        }
    }

    public BooleanBitSetSuite() {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeleton(0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": less than 1 word"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG() - 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": exactly 1 word"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": multiple whole words"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG() * 2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": multiple words and 1 more bit"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG() * 2 + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": empty for decompression()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeletonForDecompress(0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": less than 1 word for decompression()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeletonForDecompress(BooleanBitSet$.MODULE$.BITS_PER_LONG() - 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": exactly 1 word for decompression()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeletonForDecompress(BooleanBitSet$.MODULE$.BITS_PER_LONG());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": multiple whole words for decompression()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeletonForDecompress(BooleanBitSet$.MODULE$.BITS_PER_LONG() * 2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": multiple words and 1 more bit for decompression()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeletonForDecompress(BooleanBitSet$.MODULE$.BITS_PER_LONG() * 2 + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Only nulls for decompression()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TestCompressibleColumnBuilder<T> builder = TestCompressibleColumnBuilder$.MODULE$.apply((ColumnStats)new NoopColumnStats(), BOOLEAN$.MODULE$, (CompressionScheme)BooleanBitSet$.MODULE$);
                int numRows = 10;
                Seq rows = (Seq)Seq$.MODULE$.fill(numRows, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * WARNING - void declaration
                     */
                    public final GenericInternalRow apply() {
                        void var1_1;
                        GenericInternalRow row = new GenericInternalRow(1);
                        row.setNullAt(0);
                        return var1_1;
                    }
                });
                rows.foreach((Function1)new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final TestCompressibleColumnBuilder builder$3;

                    public final void apply(InternalRow x$6) {
                        this.builder$3.appendFrom(x$6, 0);
                    }
                    {
                        this.builder$3 = builder$3;
                    }
                });
                ByteBuffer buffer = builder.build();
                int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
                buffer.position(headerSize);
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)BooleanBitSet$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
                Decoder decoder = BooleanBitSet$.MODULE$.decoder(buffer, (NativeColumnType)BOOLEAN$.MODULE$);
                OnHeapColumnVector columnVector = new OnHeapColumnVector(numRows, (DataType)BooleanType$.MODULE$);
                decoder.decompress((WritableColumnVector)columnVector, numRows);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach((Function1)new Serializable(this, columnVector){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;
                    private final OnHeapColumnVector columnVector$2;

                    public final Assertion apply(int rowNum) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.columnVector$2.isNullAt(rowNum), "columnVector.isNullAt(rowNum)", Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$sql$execution$columnar$compression$BooleanBitSetSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.columnVector$2 = columnVector$2;
                    }
                });
            }

            public /* synthetic */ BooleanBitSetSuite org$apache$spark$sql$execution$columnar$compression$BooleanBitSetSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
    }
}

