/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.ByteColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.DOUBLE$;
import org.apache.spark.sql.execution.columnar.DoubleColumnStats;
import org.apache.spark.sql.execution.columnar.FLOAT$;
import org.apache.spark.sql.execution.columnar.FloatColumnStats;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.IntColumnStats;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.LongColumnStats;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.ShortColumnStats;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.execution.columnar.compression.PassThrough;
import org.apache.spark.sql.execution.columnar.compression.PassThrough$;
import org.apache.spark.sql.execution.columnar.compression.PassThroughSuite$;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001#\t\u0001\u0002+Y:t)\"\u0014x.^4i'VLG/\u001a\u0006\u0003\u0007\u0011\t1bY8naJ,7o]5p]*\u0011QAB\u0001\tG>dW/\u001c8be*\u0011q\u0001C\u0001\nKb,7-\u001e;j_:T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0006\n\u0005UQ!!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0005!9A\u0004\u0001b\u0001\n\u0003i\u0012!\u00038vY24\u0016\r\\;f+\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#aA%oi\"1Q\u0005\u0001Q\u0001\ny\t!B\\;mYZ\u000bG.^3!\u0011\u00159\u0003\u0001\"\u0001)\u0003=!Xm\u001d;QCN\u001cH\u000b\u001b:pk\u001eDWCA\u0015;)\rQSf\r\t\u0003?-J!\u0001\f\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006]\u0019\u0002\raL\u0001\fG>dW/\u001c8Ti\u0006$8\u000f\u0005\u00021c5\tA!\u0003\u00023\t\tY1i\u001c7v[:\u001cF/\u0019;t\u0011\u0015!d\u00051\u00016\u0003)\u0019w\u000e\\;n]RK\b/\u001a\t\u0004aYB\u0014BA\u001c\u0005\u0005Aq\u0015\r^5wK\u000e{G.^7o)f\u0004X\r\u0005\u0002:u1\u0001A!B\u001e'\u0005\u0004a$!\u0001+\u0012\u0005u\u0002\u0005CA\u0010?\u0013\ty\u0004EA\u0004O_RD\u0017N\\4\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rC\u0011!\u0002;za\u0016\u001c\u0018BA#C\u0005)\tEo\\7jGRK\b/\u001a")
public class PassThroughSuite
extends SparkFunSuite {
    private final int nullValue;

    public int nullValue() {
        return this.nullValue;
    }

    public <T extends AtomicType> void testPassThrough(ColumnStats columnStats, NativeColumnType<T> columnType) {
        String typeName = new StringOps(Predef$.MODULE$.augmentString(columnType.getClass().getSimpleName())).stripSuffix("$");
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": empty column"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{PassThrough$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PassThroughSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$PassThroughSuite$$skeleton$1((Seq)Seq$.MODULE$.empty(), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        }, new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": long random series"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{PassThrough$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PassThroughSuite $outer;
            private final ColumnStats columnStats$1;
            public final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object[] input = (Object[])Array$.MODULE$.fill(10000, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testPassThrough$2 $outer;

                    public final Object apply() {
                        return ColumnarTestUtils$.MODULE$.makeRandomValue(this.$outer.columnType$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Any());
                this.$outer.org$apache$spark$sql$execution$columnar$compression$PassThroughSuite$$skeleton$1((Seq)Predef$.MODULE$.genericArrayOps((Object)input).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Object x$2) {
                        return x$2;
                    }
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        }, new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": empty column for decompress()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{PassThrough$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PassThroughSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$PassThroughSuite$$skeletonForDecompress$1((Seq)Seq$.MODULE$.empty(), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        }, new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": long random series for decompress()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{PassThrough$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PassThroughSuite $outer;
            private final ColumnStats columnStats$1;
            public final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object[] input = (Object[])Array$.MODULE$.fill(10000, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testPassThrough$4 $outer;

                    public final Object apply() {
                        return ColumnarTestUtils$.MODULE$.makeRandomValue(this.$outer.columnType$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Any());
                this.$outer.org$apache$spark$sql$execution$columnar$compression$PassThroughSuite$$skeletonForDecompress$1((Seq)Predef$.MODULE$.genericArrayOps((Object)input).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Object x$3) {
                        return x$3;
                    }
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        }, new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": simple case with null for decompress()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{PassThrough$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PassThroughSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NativeColumnType nativeColumnType;
                block8: {
                    Seq seq;
                    block3: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            nativeColumnType = this.columnType$1;
                                            if (!BYTE$.MODULE$.equals(nativeColumnType)) break block2;
                                            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{2, 1, 2, (byte)this.$outer.nullValue(), 5}));
                                            break block3;
                                        }
                                        if (!SHORT$.MODULE$.equals(nativeColumnType)) break block4;
                                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapShortArray(new short[]{2, 1, 2, (short)this.$outer.nullValue(), 5}));
                                        break block3;
                                    }
                                    if (!INT$.MODULE$.equals(nativeColumnType)) break block5;
                                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 2, this.$outer.nullValue(), 5}));
                                    break block3;
                                }
                                if (!LONG$.MODULE$.equals(nativeColumnType)) break block6;
                                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L, 1L, 2L, this.$outer.nullValue(), 5L}));
                                break block3;
                            }
                            if (!FLOAT$.MODULE$.equals(nativeColumnType)) break block7;
                            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapFloatArray(new float[]{2.0f, 1.0f, 2.0f, this.$outer.nullValue(), 5.0f}));
                            break block3;
                        }
                        if (!DOUBLE$.MODULE$.equals(nativeColumnType)) break block8;
                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0, 2.0, this.$outer.nullValue(), 5.0}));
                    }
                    Seq input = seq;
                    this.$outer.org$apache$spark$sql$execution$columnar$compression$PassThroughSuite$$skeletonForDecompress$1((Seq)input.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(Object x$4) {
                            return x$4;
                        }
                    }, Seq$.MODULE$.canBuildFrom()), this.columnStats$1, this.columnType$1);
                    return;
                }
                throw new MatchError((Object)nativeColumnType);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        }, new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
    }

    public final void org$apache$spark$sql$execution$columnar$compression$PassThroughSuite$$skeleton$1(Seq input, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)PassThrough$.MODULE$);
        input.foreach((Function1)new Serializable(this, columnType$1, builder){
            public static final long serialVersionUID = 0L;
            private final NativeColumnType columnType$1;
            private final TestCompressibleColumnBuilder builder$1;

            public final void apply(Object value) {
                GenericInternalRow row = new GenericInternalRow(1);
                this.columnType$1.setField((InternalRow)row, 0, value);
                this.builder$1.appendFrom((InternalRow)row, 0);
            }
            {
                this.columnType$1 = columnType$1;
                this.builder$1 = builder$1;
            }
        });
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        int compressedSize = 4 + input.size() * columnType$1.defaultSize();
        this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)PassThrough$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        if (input.nonEmpty()) {
            input.foreach((Function1)new Serializable(this, columnType$1, buffer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PassThroughSuite $outer;
                private final NativeColumnType columnType$1;
                private final ByteBuffer buffer$1;

                public final Assertion apply(Object value) {
                    return this.$outer.assertResult(value, "Wrong value", this.columnType$1.extract(this.buffer$1), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.columnType$1 = columnType$1;
                    this.buffer$1 = buffer$1;
                }
            });
        }
        buffer.rewind().position(headerSize + 4);
        PassThrough.Decoder decoder = PassThrough$.MODULE$.decoder(buffer, columnType$1);
        GenericInternalRow mutableRow = new GenericInternalRow(1);
        if (input.nonEmpty()) {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            input.foreach((Function1)new Serializable(this, columnType$1, decoder, mutableRow){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PassThroughSuite $outer;
                private final NativeColumnType columnType$1;
                private final PassThrough.Decoder decoder$1;
                private final GenericInternalRow mutableRow$1;

                public final Assertion apply(Object x$1) {
                    this.decoder$1.next((InternalRow)this.mutableRow$1, 0);
                    return this.$outer.assertResult(x$1, "Wrong decoded value", this.columnType$1.getField((InternalRow)this.mutableRow$1, 0), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.columnType$1 = columnType$1;
                    this.decoder$1 = decoder$1;
                    this.mutableRow$1 = mutableRow$1;
                }
            });
        }
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
    }

    public final void org$apache$spark$sql$execution$columnar$compression$PassThroughSuite$$skeletonForDecompress$1(Seq input, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)PassThrough$.MODULE$);
        GenericInternalRow row = new GenericInternalRow(1);
        GenericInternalRow nullRow = new GenericInternalRow(1);
        nullRow.setNullAt(0);
        input.foreach((Function1)new Serializable(this, columnType$1, builder, row, nullRow){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PassThroughSuite $outer;
            private final NativeColumnType columnType$1;
            private final TestCompressibleColumnBuilder builder$2;
            private final GenericInternalRow row$1;
            private final GenericInternalRow nullRow$1;

            public final void apply(Object value) {
                if (BoxesRunTime.equals((Object)value, (Object)BoxesRunTime.boxToInteger((int)this.$outer.nullValue()))) {
                    this.builder$2.appendFrom((InternalRow)this.nullRow$1, 0);
                } else {
                    this.columnType$1.setField((InternalRow)this.row$1, 0, value);
                    this.builder$2.appendFrom((InternalRow)this.row$1, 0);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnType$1 = columnType$1;
                this.builder$2 = builder$2;
                this.row$1 = row$1;
                this.nullRow$1 = nullRow$1;
            }
        });
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)PassThrough$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        PassThrough.Decoder decoder = PassThrough$.MODULE$.decoder(buffer, columnType$1);
        OnHeapColumnVector columnVector = new OnHeapColumnVector(input.length(), (DataType)columnType$1.dataType());
        decoder.decompress((WritableColumnVector)columnVector, input.length());
        if (input.nonEmpty()) {
            ((IterableLike)input.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, columnVector){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PassThroughSuite $outer;
                private final OnHeapColumnVector columnVector$1;

                public final Assertion apply(Tuple2<Object, Object> x0$1) {
                    block9: {
                        Assertion assertion;
                        block3: {
                            Tuple2<Object, Object> tuple2;
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block4: {
                                                block2: {
                                                    tuple2 = x0$1;
                                                    if (tuple2 == null) break block2;
                                                    Object expected2 = tuple2._1();
                                                    int index = tuple2._2$mcI$sp();
                                                    if (!(expected2 instanceof Object)) break block2;
                                                    Object object = expected2;
                                                    int n = index;
                                                    if (!BoxesRunTime.equals((Object)object, (Object)BoxesRunTime.boxToInteger((int)this.$outer.nullValue()))) break block2;
                                                    assertion = this.$outer.assertResult(BoxesRunTime.boxToBoolean((boolean)true), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong null ", "th-position"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), BoxesRunTime.boxToBoolean((boolean)this.columnVector$1.isNullAt(n)), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
                                                    break block3;
                                                }
                                                if (tuple2 == null) break block4;
                                                Object expected3 = tuple2._1();
                                                int index = tuple2._2$mcI$sp();
                                                if (!(expected3 instanceof Byte)) break block4;
                                                byte by = BoxesRunTime.unboxToByte((Object)expected3);
                                                int n = index;
                                                assertion = this.$outer.assertResult(BoxesRunTime.boxToByte((byte)by), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong ", "-th decoded byte value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), BoxesRunTime.boxToByte((byte)this.columnVector$1.getByte(n)), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
                                                break block3;
                                            }
                                            if (tuple2 == null) break block5;
                                            Object expected4 = tuple2._1();
                                            int index = tuple2._2$mcI$sp();
                                            if (!(expected4 instanceof Short)) break block5;
                                            short s = BoxesRunTime.unboxToShort((Object)expected4);
                                            int n = index;
                                            assertion = this.$outer.assertResult(BoxesRunTime.boxToShort((short)s), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong ", "-th decoded short value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), BoxesRunTime.boxToShort((short)this.columnVector$1.getShort(n)), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
                                            break block3;
                                        }
                                        if (tuple2 == null) break block6;
                                        Object expected5 = tuple2._1();
                                        int index = tuple2._2$mcI$sp();
                                        if (!(expected5 instanceof Integer)) break block6;
                                        int n = BoxesRunTime.unboxToInt((Object)expected5);
                                        int n2 = index;
                                        assertion = this.$outer.assertResult(BoxesRunTime.boxToInteger((int)n), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong ", "-th decoded int value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n2)})), BoxesRunTime.boxToInteger((int)this.columnVector$1.getInt(n2)), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
                                        break block3;
                                    }
                                    if (tuple2 == null) break block7;
                                    Object expected6 = tuple2._1();
                                    int index = tuple2._2$mcI$sp();
                                    if (!(expected6 instanceof Long)) break block7;
                                    long l = BoxesRunTime.unboxToLong((Object)expected6);
                                    int n = index;
                                    assertion = this.$outer.assertResult(BoxesRunTime.boxToLong((long)l), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong ", "-th decoded long value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), BoxesRunTime.boxToLong((long)this.columnVector$1.getLong(n)), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
                                    break block3;
                                }
                                if (tuple2 == null) break block8;
                                Object expected7 = tuple2._1();
                                int index = tuple2._2$mcI$sp();
                                if (!(expected7 instanceof Float)) break block8;
                                float f = BoxesRunTime.unboxToFloat((Object)expected7);
                                int n = index;
                                assertion = this.$outer.assertResult(BoxesRunTime.boxToFloat((float)f), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong ", "-th decoded float value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), BoxesRunTime.boxToFloat((float)this.columnVector$1.getFloat(n)), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
                                break block3;
                            }
                            if (tuple2 == null) break block9;
                            Object expected8 = tuple2._1();
                            int index = tuple2._2$mcI$sp();
                            if (!(expected8 instanceof Double)) break block9;
                            double d = BoxesRunTime.unboxToDouble((Object)expected8);
                            int n = index;
                            assertion = this.$outer.assertResult(BoxesRunTime.boxToDouble((double)d), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong ", "-th decoded double value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), BoxesRunTime.boxToDouble((double)this.columnVector$1.getDouble(n)), Prettifier$.MODULE$.default(), new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
                        }
                        return assertion;
                    }
                    throw this.$outer.fail("Unsupported type", new Position("PassThroughEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.columnVector$1 = columnVector$1;
                }
            });
        }
    }

    public PassThroughSuite() {
        this.nullValue = -1;
        this.testPassThrough((ColumnStats)new ByteColumnStats(), (NativeColumnType)BYTE$.MODULE$);
        this.testPassThrough((ColumnStats)new ShortColumnStats(), (NativeColumnType)SHORT$.MODULE$);
        this.testPassThrough((ColumnStats)new IntColumnStats(), (NativeColumnType)INT$.MODULE$);
        this.testPassThrough((ColumnStats)new LongColumnStats(), (NativeColumnType)LONG$.MODULE$);
        this.testPassThrough((ColumnStats)new FloatColumnStats(), (NativeColumnType)FLOAT$.MODULE$);
        this.testPassThrough((ColumnStats)new DoubleColumnStats(), (NativeColumnType)DOUBLE$.MODULE$);
    }
}

