/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.File;
import org.apache.spark.SparkConf;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class CSVBenchmarks$
implements SQLHelper {
    public static final CSVBenchmarks$ MODULE$;
    private final SparkConf conf;
    private final SparkSession spark;

    static {
        new CSVBenchmarks$();
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.class.withSQLConf((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.class.withTempPath((SQLHelper)this, f);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void quotedValuesBenchmark(int rowsNum, int numIters) {
        Benchmark benchmark2 = new Benchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parsing quoted values"})).s((Seq)Nil$.MODULE$), (long)rowsNum, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(rowsNum, numIters, benchmark2){
            public static final long serialVersionUID = 0L;
            private final int rowsNum$1;
            private final int numIters$1;
            private final Benchmark benchmark$1;

            public final void apply(File path) {
                String str = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10000).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(int i) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(",");
                CSVBenchmarks$.MODULE$.spark().range((long)this.rowsNum$1).map((Function1)new Serializable(this, str){
                    public static final long serialVersionUID = 0L;
                    private final String str$1;

                    public final String apply(Long x$1) {
                        return this.str$1;
                    }
                    {
                        this.str$1 = str$1;
                    }
                }, CSVBenchmarks$.MODULE$.spark().implicits().newStringEncoder()).write().option("header", true).csv(path.getAbsolutePath());
                StructType schema2 = new StructType().add("value", (DataType)StringType$.MODULE$);
                Dataset ds = CSVBenchmarks$.MODULE$.spark().read().option("header", true).schema(schema2).csv(path.getAbsolutePath());
                this.benchmark$1.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"One quoted string"})).s((Seq)Nil$.MODULE$), this.numIters$1, (Function1)new Serializable(this, ds){
                    public static final long serialVersionUID = 0L;
                    private final Dataset ds$1;

                    public final void apply(int x$2) {
                        this.apply$mcVI$sp(x$2);
                    }

                    public void apply$mcVI$sp(int x$2) {
                        this.ds$1.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Row x$3) {
                                return true;
                            }
                        }).count();
                    }
                    {
                        this.ds$1 = ds$1;
                    }
                });
                this.benchmark$1.run();
            }
            {
                this.rowsNum$1 = rowsNum$1;
                this.numIters$1 = numIters$1;
                this.benchmark$1 = benchmark$1;
            }
        });
    }

    public void multiColumnsBenchmark(int rowsNum) {
        int colsNum = 1000;
        Benchmark benchmark2 = new Benchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wide rows with ", " columns"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)colsNum)})), (long)rowsNum, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(rowsNum, colsNum, benchmark2){
            public static final long serialVersionUID = 0L;
            private final int rowsNum$2;
            private final int colsNum$1;
            private final Benchmark benchmark$2;

            public final void apply(File path) {
                Seq fields = (Seq)Seq$.MODULE$.tabulate(this.colsNum$1, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StructField apply(int i) {
                        return new StructField(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                    }
                });
                StructType schema2 = StructType$.MODULE$.apply(fields);
                String values = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.colsNum$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(int i) {
                        return ((Object)BoxesRunTime.boxToInteger((int)i)).toString();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(",");
                String[] columnNames = schema2.fieldNames();
                CSVBenchmarks$.MODULE$.spark().range((long)this.rowsNum$2).select((Seq)Seq$.MODULE$.tabulate(this.colsNum$1, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Column apply(int i) {
                        return functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)i)).as(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                    }
                })).write().option("header", true).csv(path.getAbsolutePath());
                Dataset ds = CSVBenchmarks$.MODULE$.spark().read().schema(schema2).csv(path.getAbsolutePath());
                this.benchmark$2.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Select ", " columns"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.colsNum$1)})), 3, (Function1)new Serializable(this, ds){
                    public static final long serialVersionUID = 0L;
                    private final Dataset ds$2;

                    public final void apply(int x$4) {
                        this.apply$mcVI$sp(x$4);
                    }

                    public void apply$mcVI$sp(int x$4) {
                        this.ds$2.select("*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Row row) {
                                return true;
                            }
                        }).count();
                    }
                    {
                        this.ds$2 = ds$2;
                    }
                });
                Column[] cols100 = (Column[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])columnNames).take(100)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Column apply(String x$5) {
                        return Column$.MODULE$.apply(x$5);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
                this.benchmark$2.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Select 100 columns"})).s((Seq)Nil$.MODULE$), 3, (Function1)new Serializable(this, ds, cols100){
                    public static final long serialVersionUID = 0L;
                    private final Dataset ds$2;
                    private final Column[] cols100$1;

                    public final void apply(int x$6) {
                        this.apply$mcVI$sp(x$6);
                    }

                    public void apply$mcVI$sp(int x$6) {
                        this.ds$2.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.cols100$1)).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Row row) {
                                return true;
                            }
                        }).count();
                    }
                    {
                        this.ds$2 = ds$2;
                        this.cols100$1 = cols100$1;
                    }
                });
                this.benchmark$2.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Select one column"})).s((Seq)Nil$.MODULE$), 3, (Function1)new Serializable(this, ds){
                    public static final long serialVersionUID = 0L;
                    private final Dataset ds$2;

                    public final void apply(int x$7) {
                        this.apply$mcVI$sp(x$7);
                    }

                    public void apply$mcVI$sp(int x$7) {
                        this.ds$2.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{CSVBenchmarks$.MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)})).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Row row) {
                                return true;
                            }
                        }).count();
                    }
                    {
                        this.ds$2 = ds$2;
                    }
                });
                this.benchmark$2.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"count()"})).s((Seq)Nil$.MODULE$), 3, (Function1)new Serializable(this, ds){
                    public static final long serialVersionUID = 0L;
                    private final Dataset ds$2;

                    public final void apply(int x$8) {
                        this.apply$mcVI$sp(x$8);
                    }

                    public void apply$mcVI$sp(int x$8) {
                        this.ds$2.count();
                    }
                    {
                        this.ds$2 = ds$2;
                    }
                });
                this.benchmark$2.run();
            }
            {
                this.rowsNum$2 = rowsNum$2;
                this.colsNum$1 = colsNum$1;
                this.benchmark$2 = benchmark$2;
            }
        });
    }

    public void countBenchmark(int rowsNum) {
        int colsNum = 10;
        Benchmark benchmark2 = new Benchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Count a dataset with ", " columns"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)colsNum)})), (long)rowsNum, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(rowsNum, colsNum, benchmark2){
            public static final long serialVersionUID = 0L;
            private final int rowsNum$3;
            private final int colsNum$2;
            private final Benchmark benchmark$3;

            public final void apply(File path) {
                Seq fields = (Seq)Seq$.MODULE$.tabulate(this.colsNum$2, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StructField apply(int i) {
                        return new StructField(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                    }
                });
                StructType schema2 = StructType$.MODULE$.apply(fields);
                CSVBenchmarks$.MODULE$.spark().range((long)this.rowsNum$3).select((Seq)Seq$.MODULE$.tabulate(this.colsNum$2, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Column apply(int i) {
                        return functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)i)).as(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                    }
                })).write().csv(path.getAbsolutePath());
                Dataset ds = CSVBenchmarks$.MODULE$.spark().read().schema(schema2).csv(path.getAbsolutePath());
                this.benchmark$3.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Select ", " columns + count()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.colsNum$2)})), 3, (Function1)new Serializable(this, ds){
                    public static final long serialVersionUID = 0L;
                    private final Dataset ds$3;

                    public final void apply(int x$9) {
                        this.apply$mcVI$sp(x$9);
                    }

                    public void apply$mcVI$sp(int x$9) {
                        this.ds$3.select("*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Row x$10) {
                                return true;
                            }
                        }).count();
                    }
                    {
                        this.ds$3 = ds$3;
                    }
                });
                this.benchmark$3.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Select 1 column + count()"})).s((Seq)Nil$.MODULE$), 3, (Function1)new Serializable(this, ds){
                    public static final long serialVersionUID = 0L;
                    private final Dataset ds$3;

                    public final void apply(int x$11) {
                        this.apply$mcVI$sp(x$11);
                    }

                    public void apply$mcVI$sp(int x$11) {
                        this.ds$3.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{CSVBenchmarks$.MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)})).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Row x$12) {
                                return true;
                            }
                        }).count();
                    }
                    {
                        this.ds$3 = ds$3;
                    }
                });
                this.benchmark$3.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"count()"})).s((Seq)Nil$.MODULE$), 3, (Function1)new Serializable(this, ds){
                    public static final long serialVersionUID = 0L;
                    private final Dataset ds$3;

                    public final void apply(int x$13) {
                        this.apply$mcVI$sp(x$13);
                    }

                    public void apply$mcVI$sp(int x$13) {
                        this.ds$3.count();
                    }
                    {
                        this.ds$3 = ds$3;
                    }
                });
                this.benchmark$3.run();
            }
            {
                this.rowsNum$3 = rowsNum$3;
                this.colsNum$2 = colsNum$2;
                this.benchmark$3 = benchmark$3;
            }
        });
    }

    public void main(String[] args) {
        this.quotedValuesBenchmark(50000, 3);
        this.multiColumnsBenchmark(1000000);
        this.countBenchmark(10000000);
    }

    private CSVBenchmarks$() {
        MODULE$ = this;
        SQLHelper.class.$init$((SQLHelper)this);
        this.conf = new SparkConf();
        this.spark = SparkSession$.MODULE$.builder().master("local[1]").appName("benchmark-csv-datasource").config(this.conf()).getOrCreate();
    }
}

