/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import java.io.File;
import org.apache.spark.SparkConf;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JSONBenchmarks$
implements SQLHelper {
    public static final JSONBenchmarks$ MODULE$;
    private final SparkConf conf;
    private final SparkSession spark;

    static {
        new JSONBenchmarks$();
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.class.withSQLConf((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.class.withTempPath((SQLHelper)this, f);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void schemaInferring(int rowsNum) {
        Benchmark benchmark2 = new Benchmark("JSON schema inferring", (long)rowsNum, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(rowsNum, benchmark2){
            public static final long serialVersionUID = 0L;
            private final int rowsNum$1;
            private final Benchmark benchmark$1;

            public final void apply(File path) {
                this.benchmark$1.out().println("Preparing data for benchmarking ...");
                JSONBenchmarks$.MODULE$.spark().implicits().rddToDatasetHolder(JSONBenchmarks$.MODULE$.spark().sparkContext().range(0L, (long)this.rowsNum$1, 1L, JSONBenchmarks$.MODULE$.spark().sparkContext().range$default$4()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(long x$1) {
                        return "a";
                    }
                }, ClassTag$.MODULE$.apply(String.class)), JSONBenchmarks$.MODULE$.spark().implicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fieldA"})).write().option("encoding", "UTF-8").json(path.getAbsolutePath());
                this.benchmark$1.addCase("No encoding", 3, (Function1)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final File path$1;

                    public final void apply(int x$2) {
                        this.apply$mcVI$sp(x$2);
                    }

                    public void apply$mcVI$sp(int x$2) {
                        JSONBenchmarks$.MODULE$.spark().read().json(this.path$1.getAbsolutePath());
                    }
                    {
                        this.path$1 = path$1;
                    }
                });
                this.benchmark$1.addCase("UTF-8 is set", 3, (Function1)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final File path$1;

                    public final void apply(int x$3) {
                        this.apply$mcVI$sp(x$3);
                    }

                    public void apply$mcVI$sp(int x$3) {
                        JSONBenchmarks$.MODULE$.spark().read().option("encoding", "UTF-8").json(this.path$1.getAbsolutePath());
                    }
                    {
                        this.path$1 = path$1;
                    }
                });
                this.benchmark$1.run();
            }
            {
                this.rowsNum$1 = rowsNum$1;
                this.benchmark$1 = benchmark$1;
            }
        });
    }

    public void perlineParsing(int rowsNum) {
        Benchmark benchmark2 = new Benchmark("JSON per-line parsing", (long)rowsNum, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(rowsNum, benchmark2){
            public static final long serialVersionUID = 0L;
            private final int rowsNum$2;
            private final Benchmark benchmark$2;

            public final void apply(File path) {
                this.benchmark$2.out().println("Preparing data for benchmarking ...");
                JSONBenchmarks$.MODULE$.spark().implicits().rddToDatasetHolder(JSONBenchmarks$.MODULE$.spark().sparkContext().range(0L, (long)this.rowsNum$2, 1L, JSONBenchmarks$.MODULE$.spark().sparkContext().range$default$4()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(long x$4) {
                        return "a";
                    }
                }, ClassTag$.MODULE$.apply(String.class)), JSONBenchmarks$.MODULE$.spark().implicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fieldA"})).write().json(path.getAbsolutePath());
                StructType schema2 = new StructType().add("fieldA", (DataType)StringType$.MODULE$);
                this.benchmark$2.addCase("No encoding", 3, (Function1)new Serializable(this, schema2, path){
                    public static final long serialVersionUID = 0L;
                    private final StructType schema$1;
                    private final File path$2;

                    public final void apply(int x$5) {
                        this.apply$mcVI$sp(x$5);
                    }

                    public void apply$mcVI$sp(int x$5) {
                        JSONBenchmarks$.MODULE$.spark().read().schema(this.schema$1).json(this.path$2.getAbsolutePath()).count();
                    }
                    {
                        this.schema$1 = schema$1;
                        this.path$2 = path$2;
                    }
                });
                this.benchmark$2.addCase("UTF-8 is set", 3, (Function1)new Serializable(this, schema2, path){
                    public static final long serialVersionUID = 0L;
                    private final StructType schema$1;
                    private final File path$2;

                    public final void apply(int x$6) {
                        this.apply$mcVI$sp(x$6);
                    }

                    public void apply$mcVI$sp(int x$6) {
                        JSONBenchmarks$.MODULE$.spark().read().option("encoding", "UTF-8").schema(this.schema$1).json(this.path$2.getAbsolutePath()).count();
                    }
                    {
                        this.schema$1 = schema$1;
                        this.path$2 = path$2;
                    }
                });
                this.benchmark$2.run();
            }
            {
                this.rowsNum$2 = rowsNum$2;
                this.benchmark$2 = benchmark$2;
            }
        });
    }

    public void perlineParsingOfWideColumn(int rowsNum) {
        Benchmark benchmark2 = new Benchmark("JSON parsing of wide lines", (long)rowsNum, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(rowsNum, benchmark2){
            public static final long serialVersionUID = 0L;
            private final int rowsNum$3;
            private final Benchmark benchmark$3;

            public final void apply(File path) {
                this.benchmark$3.out().println("Preparing data for benchmarking ...");
                JSONBenchmarks$.MODULE$.spark().implicits().rddToDatasetHolder(JSONBenchmarks$.MODULE$.spark().sparkContext().range(0L, (long)this.rowsNum$3, 1L, JSONBenchmarks$.MODULE$.spark().sparkContext().range$default$4()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(long i) {
                        String s = new StringOps(Predef$.MODULE$.augmentString("abcdef0123456789ABCDEF")).$times(20);
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"a\":\"", "\",\"b\": ", ",\"c\":\"", "\",\"d\":", ",\"e\":\"", "\",\"f\":", ",\"x\":\"", "\",\"y\":", ",\"z\":\"", "\"}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s, BoxesRunTime.boxToLong((long)i), s, BoxesRunTime.boxToLong((long)i), s, BoxesRunTime.boxToLong((long)i), s, BoxesRunTime.boxToLong((long)i), s}));
                    }
                }, ClassTag$.MODULE$.apply(String.class)), JSONBenchmarks$.MODULE$.spark().implicits().newStringEncoder()).toDF().write().text(path.getAbsolutePath());
                StructType schema2 = new StructType().add("a", (DataType)StringType$.MODULE$).add("b", (DataType)LongType$.MODULE$).add("c", (DataType)StringType$.MODULE$).add("d", (DataType)LongType$.MODULE$).add("e", (DataType)StringType$.MODULE$).add("f", (DataType)LongType$.MODULE$).add("x", (DataType)StringType$.MODULE$).add("y", (DataType)LongType$.MODULE$).add("z", (DataType)StringType$.MODULE$);
                this.benchmark$3.addCase("No encoding", 3, (Function1)new Serializable(this, schema2, path){
                    public static final long serialVersionUID = 0L;
                    private final StructType schema$2;
                    private final File path$3;

                    public final void apply(int x$7) {
                        this.apply$mcVI$sp(x$7);
                    }

                    public void apply$mcVI$sp(int x$7) {
                        JSONBenchmarks$.MODULE$.spark().read().schema(this.schema$2).json(this.path$3.getAbsolutePath()).count();
                    }
                    {
                        this.schema$2 = schema$2;
                        this.path$3 = path$3;
                    }
                });
                this.benchmark$3.addCase("UTF-8 is set", 3, (Function1)new Serializable(this, schema2, path){
                    public static final long serialVersionUID = 0L;
                    private final StructType schema$2;
                    private final File path$3;

                    public final void apply(int x$8) {
                        this.apply$mcVI$sp(x$8);
                    }

                    public void apply$mcVI$sp(int x$8) {
                        JSONBenchmarks$.MODULE$.spark().read().option("encoding", "UTF-8").schema(this.schema$2).json(this.path$3.getAbsolutePath()).count();
                    }
                    {
                        this.schema$2 = schema$2;
                        this.path$3 = path$3;
                    }
                });
                this.benchmark$3.run();
            }
            {
                this.rowsNum$3 = rowsNum$3;
                this.benchmark$3 = benchmark$3;
            }
        });
    }

    public void countBenchmark(int rowsNum) {
        int colsNum = 10;
        Benchmark benchmark2 = new Benchmark(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Count a dataset with ", " columns"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)colsNum)})), (long)rowsNum, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)new Serializable(rowsNum, colsNum, benchmark2){
            public static final long serialVersionUID = 0L;
            private final int rowsNum$4;
            private final int colsNum$1;
            private final Benchmark benchmark$4;

            public final void apply(File path) {
                Seq fields = (Seq)Seq$.MODULE$.tabulate(this.colsNum$1, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StructField apply(int i) {
                        return new StructField(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                    }
                });
                StructType schema2 = StructType$.MODULE$.apply(fields);
                String[] columnNames = schema2.fieldNames();
                JSONBenchmarks$.MODULE$.spark().range((long)this.rowsNum$4).select((Seq)Seq$.MODULE$.tabulate(this.colsNum$1, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Column apply(int i) {
                        return functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)i)).as(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                    }
                })).write().json(path.getAbsolutePath());
                Dataset ds = JSONBenchmarks$.MODULE$.spark().read().schema(schema2).json(path.getAbsolutePath());
                this.benchmark$4.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Select ", " columns + count()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.colsNum$1)})), 3, (Function1)new Serializable(this, ds){
                    public static final long serialVersionUID = 0L;
                    private final Dataset ds$1;

                    public final void apply(int x$9) {
                        this.apply$mcVI$sp(x$9);
                    }

                    public void apply$mcVI$sp(int x$9) {
                        this.ds$1.select("*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Row x$10) {
                                return true;
                            }
                        }).count();
                    }
                    {
                        this.ds$1 = ds$1;
                    }
                });
                this.benchmark$4.addCase(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Select 1 column + count()"})).s((Seq)Nil$.MODULE$), 3, (Function1)new Serializable(this, ds){
                    public static final long serialVersionUID = 0L;
                    private final Dataset ds$1;

                    public final void apply(int x$11) {
                        this.apply$mcVI$sp(x$11);
                    }

                    public void apply$mcVI$sp(int x$11) {
                        this.ds$1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{JSONBenchmarks$.MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)})).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Row x$12) {
                                return true;
                            }
                        }).count();
                    }
                    {
                        this.ds$1 = ds$1;
                    }
                });
                this.benchmark$4.run();
            }
            {
                this.rowsNum$4 = rowsNum$4;
                this.colsNum$1 = colsNum$1;
                this.benchmark$4 = benchmark$4;
            }
        });
    }

    public void main(String[] args) {
        this.schemaInferring(100000000);
        this.perlineParsing(100000000);
        this.perlineParsingOfWideColumn(10000000);
        this.countBenchmark(10000000);
    }

    private JSONBenchmarks$() {
        MODULE$ = this;
        SQLHelper.class.$init$((SQLHelper)this);
        this.conf = new SparkConf();
        this.spark = SparkSession$.MODULE$.builder().master("local[1]").appName("benchmark-json-datasource").config(this.conf()).getOrCreate();
    }
}

