/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.Reader;
import org.apache.orc.impl.OrcIndex;
import org.apache.orc.impl.RecordReaderImpl;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.FakeFileSystemRequiringDSOption;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.execution.datasources.orc.OrcData;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.orc.OrcSuite$;
import org.apache.spark.sql.execution.datasources.orc.OrcSuite$$anonfun$5$;
import org.apache.spark.sql.execution.datasources.orc.OrcSuite$$anonfun$6$;
import org.apache.spark.sql.execution.datasources.orc.OrcSuite$$anonfun$6$$anonfun$apply$mcV$sp$23$;
import org.apache.spark.sql.execution.datasources.orc.OrcSuite$$anonfun$7$;
import org.apache.spark.sql.execution.datasources.orc.OrcSuite$$anonfun$9$;
import org.apache.spark.sql.execution.datasources.orc.OrcSuite$$anonfun$9$$anonfun$apply$mcV$sp$2$;
import org.apache.spark.sql.execution.datasources.orc.OrcSuite$$anonfun$testBloomFilterCreation$1$;
import org.apache.spark.sql.execution.datasources.orc.OrcTest;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001u3Q!\u0001\u0002\u0002\u0002E\u0011\u0001b\u0014:d'VLG/\u001a\u0006\u0003\u0007\u0011\t1a\u001c:d\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u000f=\u00138\rV3tiB\u0011qCG\u0007\u00021)\u0011\u0011DD\u0001\ng\u000e\fG.\u0019;fgRL!a\u0007\r\u0003#\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0006cG\u000eC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u00111\u0003\u0001\u0005\bC\u0001\u0001\r\u0011\"\u0001#\u0003-y'o\u0019+bE2,G)\u001b:\u0016\u0003\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\u0005%|'\"\u0001\u0015\u0002\t)\fg/Y\u0005\u0003U\u0015\u0012AAR5mK\"9A\u0006\u0001a\u0001\n\u0003i\u0013aD8sGR\u000b'\r\\3ESJ|F%Z9\u0015\u00059\"\u0004CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$\u0001B+oSRDq!N\u0016\u0002\u0002\u0003\u00071%A\u0002yIEBaa\u000e\u0001!B\u0013\u0019\u0013\u0001D8sGR\u000b'\r\\3ESJ\u0004\u0003bB\u001d\u0001\u0001\u0004%\tAI\u0001\u000e_J\u001cG+\u00192mK\u0006\u001bH)\u001b:\t\u000fm\u0002\u0001\u0019!C\u0001y\u0005\trN]2UC\ndW-Q:ESJ|F%Z9\u0015\u00059j\u0004bB\u001b;\u0003\u0003\u0005\ra\t\u0005\u0007\u007f\u0001\u0001\u000b\u0015B\u0012\u0002\u001d=\u00148\rV1cY\u0016\f5\u000fR5sA!)\u0011\t\u0001C)\u0005\u0006I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002]!)A\t\u0001C\t\u000b\u00069B/Z:u\u00052|w.\u001c$jYR,'o\u0011:fCRLwN\u001c\u000b\u0003]\u0019CQaR\"A\u0002!\u000bqB\u00197p_64\u0015\u000e\u001c;fe.Kg\u000e\u001a\t\u0003\u0013js!AS,\u000f\u0005-#fB\u0001'T\u001d\ti%K\u0004\u0002O#6\tqJ\u0003\u0002Q!\u00051AH]8pizJ\u0011aD\u0005\u0003\u001b9I!a\u0001\u0007\n\u0005U3\u0016\u0001C(sGB\u0013x\u000e^8\u000b\u0005\ra\u0011B\u0001-Z\u0003\u0019\u0019FO]3b[*\u0011QKV\u0005\u00037r\u0013AaS5oI*\u0011\u0001,\u0017")
public abstract class OrcSuite
extends OrcTest {
    private File orcTableDir = null;
    private File orcTableAsDir = null;

    public File orcTableDir() {
        return this.orcTableDir;
    }

    public void orcTableDir_$eq(File x$1) {
        this.orcTableDir = x$1;
    }

    public File orcTableAsDir() {
        return this.orcTableAsDir;
    }

    public void orcTableAsDir_$eq(File x$1) {
        this.orcTableAsDir = x$1;
    }

    @Override
    public void beforeAll() {
        super.beforeAll();
        String x$3 = "orctests";
        String x$4 = Utils$.MODULE$.createTempDir$default$1();
        this.orcTableAsDir_$eq(Utils$.MODULE$.createTempDir(x$4, x$3));
        String x$5 = "orctests";
        String x$6 = Utils$.MODULE$.createTempDir$default$1();
        this.orcTableDir_$eq(Utils$.MODULE$.createTempDir(x$6, x$5));
        SparkContext qual$1 = this.sparkContext();
        Range.Inclusive x$7 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int x$8 = qual$1.makeRDD$default$2();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(OrcSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcSuite$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.execution.datasources.orc.OrcData").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcSuite$$typecreator5$1(OrcSuite $outer) {
            }
        }
        this.testImplicits().rddToDatasetHolder(qual$1.makeRDD((Seq)x$7, x$8, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final OrcData apply(int i) {
                return new OrcData(i, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"part-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
            }
        }, ClassTag$.MODULE$.apply(OrcData.class)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcSuite$$typecreator5$1(this)))).toDF().createOrReplaceTempView("orc_temp_table");
    }

    public void testBloomFilterCreation(OrcProto.Stream.Kind bloomFilterKind) {
        String tableName = "bloomFilter";
        this.withTempDir((Function1<File, BoxedUnit>)new Serializable(this, bloomFilterKind, tableName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrcSuite $outer;
            public final OrcProto.Stream.Kind bloomFilterKind$1;
            public final String tableName$1;

            public final void apply(File dir) {
                this.$outer.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.tableName$1}), (Function0<BoxedUnit>)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testBloomFilterCreation$1 $outer;
                    private final File dir$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        RecordReaderImpl recordReader;
                        String string;
                        block9: {
                            String string2;
                            block8: {
                                block7: {
                                    string = this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().orcImp();
                                    if (!"native".equals(string)) break block7;
                                    string2 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |CREATE TABLE ", " (a INT, b STRING)\n               |USING ORC\n               |OPTIONS (\n               |  path '", "',\n               |  orc.bloom.filter.columns '*',\n               |  orc.bloom.filter.fpp 0.1\n               |)\n            "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.tableName$1, this.dir$1.toURI()})))).stripMargin();
                                    break block8;
                                }
                                if (!"hive".equals(string)) break block9;
                                string2 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |CREATE TABLE ", " (a INT, b STRING)\n               |STORED AS ORC\n               |LOCATION '", "'\n               |TBLPROPERTIES (\n               |  orc.bloom.filter.columns='*',\n               |  orc.bloom.filter.fpp=0.1\n               |)\n            "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.tableName$1, this.dir$1.toURI()})))).stripMargin();
                            }
                            String sqlStatement = string2;
                            this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().sql().apply((Object)sqlStatement);
                            this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().sql().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " VALUES (1, 'str')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.tableName$1})));
                            File[] partFiles = (File[])Predef$.MODULE$.refArrayOps((Object[])this.dir$1.listFiles()).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(File f) {
                                    return f.isFile() && !f.getName().startsWith(".") && !f.getName().startsWith("_");
                                }
                            });
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)partFiles.length));
                            int $org_scalatest_assert_macro_right = 1;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                            this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
                            Path orcFilePath = new Path(((File)Predef$.MODULE$.refArrayOps((Object[])partFiles).head()).getAbsolutePath());
                            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)new Configuration());
                            Reader reader = OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)readerOptions);
                            recordReader = null;
                            recordReader = (RecordReaderImpl)reader.rows();
                            boolean[] sargColumns = new boolean[]{true, true, true};
                            OrcIndex orcIndex = recordReader.readRowIndex(0, null, sargColumns);
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])orcIndex.getBloomFilterKinds()).forall((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testBloomFilterCreation$1$$anonfun$apply$1 $outer;

                                public final boolean apply(OrcProto.Stream.Kind x$1) {
                                    return this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().convertToEqualizer(x$1).$eq$eq$eq((Object)this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$$outer().bloomFilterKind$1, Equality$.MODULE$.default());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }), "scala.this.Predef.refArrayOps[org.apache.orc.OrcProto.Stream.Kind](orcIndex.getBloomFilterKinds()).forall(((x$1: org.apache.orc.OrcProto.Stream.Kind) => OrcSuite.this.convertToEqualizer[org.apache.orc.OrcProto.Stream.Kind](x$1).===(bloomFilterKind)(scalactic.this.Equality.default[org.apache.orc.OrcProto.Stream.Kind])))", Prettifier$.MODULE$.default());
                            this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])orcIndex.getBloomFilterIndex()).forall((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(OrcProto.BloomFilterIndex x$2) {
                                    return x$2.getBloomFilterCount() > 0;
                                }
                            }), "scala.this.Predef.refArrayOps[org.apache.orc.OrcProto.BloomFilterIndex](orcIndex.getBloomFilterIndex()).forall(((x$2: org.apache.orc.OrcProto.BloomFilterIndex) => x$2.getBloomFilterCount().>(0)))", Prettifier$.MODULE$.default());
                            this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
                            return;
                        }
                        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown ORC implementation: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
                        finally {
                            if (recordReader != null) {
                                recordReader.close();
                            }
                        }
                    }

                    public /* synthetic */ $anonfun$testBloomFilterCreation$1 org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dir$1 = dir$1;
                    }
                });
            }

            public /* synthetic */ OrcSuite org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bloomFilterKind$1 = bloomFilterKind$1;
                this.tableName$1 = tableName$1;
            }
        });
    }

    public OrcSuite() {
        this.test("create temporary orc table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrcSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkAnswer((Function0<Dataset<Row>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().sql().apply((Object)"SELECT COUNT(*) FROM normal_orc_source");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10)})));
                this.$outer.checkAnswer((Function0<Dataset<Row>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().sql().apply((Object)"SELECT * FROM normal_orc_source");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Row apply(int i) {
                        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"part-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))}));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())));
                this.$outer.checkAnswer((Function0<Dataset<Row>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().sql().apply((Object)"SELECT * FROM normal_orc_source where intField > 5");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Row apply(int i) {
                        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"part-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))}));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())));
                this.$outer.checkAnswer((Function0<Dataset<Row>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().sql().apply((Object)"SELECT COUNT(intField), stringField FROM normal_orc_source GROUP BY stringField");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Row apply(int i) {
                        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"part-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))}));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())));
            }

            public /* synthetic */ OrcSuite org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("create temporary orc table as", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrcSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkAnswer((Function0<Dataset<Row>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().sql().apply((Object)"SELECT COUNT(*) FROM normal_orc_as_source");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10)})));
                this.$outer.checkAnswer((Function0<Dataset<Row>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().sql().apply((Object)"SELECT * FROM normal_orc_source");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Row apply(int i) {
                        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"part-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))}));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())));
                this.$outer.checkAnswer((Function0<Dataset<Row>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().sql().apply((Object)"SELECT * FROM normal_orc_source WHERE intField > 5");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Row apply(int i) {
                        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"part-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))}));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())));
                this.$outer.checkAnswer((Function0<Dataset<Row>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().sql().apply((Object)"SELECT COUNT(intField), stringField FROM normal_orc_source GROUP BY stringField");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Row apply(int i) {
                        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"part-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))}));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())));
            }

            public /* synthetic */ OrcSuite org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("appending insert", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrcSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)"INSERT INTO TABLE normal_orc_source SELECT * FROM orc_temp_table WHERE intField > 5");
                this.$outer.checkAnswer((Function0<Dataset<Row>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().sql().apply((Object)"SELECT * FROM normal_orc_source");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq<Row>)((Seq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Row apply(int i) {
                        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"part-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))}));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Row> apply(int i) {
                        return (Seq)Seq$.MODULE$.fill(2, (Function0)new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final int i$1;

                            public final Row apply() {
                                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.i$1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"part-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.i$1)}))}));
                            }
                            {
                                this.i$1 = i$1;
                            }
                        });
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom())));
            }

            public /* synthetic */ OrcSuite org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("overwrite insert", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrcSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("INSERT OVERWRITE TABLE normal_orc_as_source\n        |SELECT * FROM orc_temp_table WHERE intField > 5\n      ")).stripMargin());
                this.$outer.checkAnswer((Function0<Dataset<Row>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().sql().apply((Object)"SELECT * FROM normal_orc_as_source");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Row apply(int i) {
                        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"part-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))}));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())));
            }

            public /* synthetic */ OrcSuite org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("write null values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrcSuite $outer;

            public final Dataset<Row> apply() {
                this.$outer.sql().apply((Object)"DROP TABLE IF EXISTS orcNullValues");
                Dataset df3 = (Dataset)this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  CAST(null as TINYINT) as c0,\n        |  CAST(null as SMALLINT) as c1,\n        |  CAST(null as INT) as c2,\n        |  CAST(null as BIGINT) as c3,\n        |  CAST(null as FLOAT) as c4,\n        |  CAST(null as DOUBLE) as c5,\n        |  CAST(null as DECIMAL(7,2)) as c6,\n        |  CAST(null as TIMESTAMP) as c7,\n        |  CAST(null as DATE) as c8,\n        |  CAST(null as STRING) as c9,\n        |  CAST(null as VARCHAR(10)) as c10\n        |FROM orc_temp_table limit 1\n      ")).stripMargin());
                df3.write().format("orc").saveAsTable("orcNullValues");
                this.$outer.checkAnswer((Function0<Dataset<Row>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$14 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().sql().apply((Object)"SELECT * FROM orcNullValues");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Row$.MODULE$.fromSeq((Seq)Seq$.MODULE$.fill(11, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                })));
                return (Dataset)this.$outer.sql().apply((Object)"DROP TABLE IF EXISTS orcNullValues");
            }

            public /* synthetic */ OrcSuite org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("SPARK-18433: Improve DataSource option keys to be more case-insensitive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrcSuite $outer;

            public final Assertion apply() {
                SQLConf conf = this.$outer.spark().sessionState().conf();
                OrcOptions option = new OrcOptions((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcConf.COMPRESS.getAttribute().toUpperCase(Locale.ROOT)), (Object)"NONE")})), conf);
                String $org_scalatest_assert_macro_left = option.compressionCodec();
                String $org_scalatest_assert_macro_right = "NONE";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        this.test("SPARK-21839: Add SQL config for ORC compression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrcSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SQLConf conf = this.$outer.spark().sessionState().conf();
                String $org_scalatest_assert_macro_left = new OrcOptions(Predef$.MODULE$.Map().empty(), conf).compressionCodec();
                String $org_scalatest_assert_macro_right = "SNAPPY";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
                this.$outer.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COMPRESSION().key()), (Object)"uncompressed")}), (Function0<BoxedUnit>)new Serializable(this, conf){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final SQLConf conf$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        String $org_scalatest_assert_macro_left = new OrcOptions(Predef$.MODULE$.Map().empty(), this.conf$1).compressionCodec();
                        String $org_scalatest_assert_macro_right = "NONE";
                        String string = $org_scalatest_assert_macro_left;
                        String string2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
                        scala.collection.immutable.Map map1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcConf.COMPRESS.getAttribute()), (Object)"zlib")}));
                        scala.collection.immutable.Map map2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcConf.COMPRESS.getAttribute()), (Object)"zlib"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression"), (Object)"lzo")}));
                        String $org_scalatest_assert_macro_left2 = new OrcOptions(map1, this.conf$1).compressionCodec();
                        String $org_scalatest_assert_macro_right2 = "ZLIB";
                        String string3 = $org_scalatest_assert_macro_left2;
                        String string4 = $org_scalatest_assert_macro_right2;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
                        String $org_scalatest_assert_macro_left3 = new OrcOptions(map2, this.conf$1).compressionCodec();
                        String $org_scalatest_assert_macro_right3 = "LZO";
                        String string5 = $org_scalatest_assert_macro_left3;
                        String string6 = $org_scalatest_assert_macro_right3;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.conf$1 = conf$1;
                    }
                });
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NONE", "UNCOMPRESSED", "SNAPPY", "ZLIB", "LZO"}))).foreach((Function1)new Serializable(this, conf){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    public final SQLConf conf$1;

                    public final void apply(String c) {
                        this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COMPRESSION().key()), (Object)c)}), (Function0<BoxedUnit>)new Serializable(this, c){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$5$$anonfun$apply$mcV$sp$22 $outer;
                            private final String c$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                String string = this.c$1;
                                String string2 = "UNCOMPRESSED";
                                String expected2 = !(string != null ? !string.equals(string2) : string2 != null) ? "NONE" : this.c$1;
                                String $org_scalatest_assert_macro_left = new OrcOptions(Predef$.MODULE$.Map().empty(), this.$outer.conf$1).compressionCodec();
                                String $org_scalatest_assert_macro_right = expected2;
                                String string3 = $org_scalatest_assert_macro_left;
                                String string4 = $org_scalatest_assert_macro_right;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                                this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.c$1 = c$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$5 org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.conf$1 = conf$1;
                    }
                });
            }

            public /* synthetic */ OrcSuite org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
        this.test("SPARK-23340 Empty float/double array columns raise EOFException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrcSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dataset[]{this.$outer.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new float[][]{(float[])Array$.MODULE$.empty(ClassTag$.MODULE$.Float())})), this.$outer.testImplicits().newFloatArrayEncoder()).toDF(), this.$outer.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{(double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())})), this.$outer.testImplicits().newDoubleArrayEncoder()).toDF()}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(Dataset<Row> df3) {
                        this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().withTempPath((Function1<File, BoxedUnit>)new Serializable(this, df3){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$23 $outer;
                            private final Dataset df$1;

                            public final void apply(File path) {
                                this.df$1.write().format("orc").save(path.getCanonicalPath());
                                this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().checkAnswer((Function0<Dataset<Row>>)new Serializable(this, path){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$23$$anonfun$apply$6 $outer;
                                    private final File path$2;

                                    public final Dataset<Row> apply() {
                                        return this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().spark().read().orc(this.path$2.getCanonicalPath());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.path$2 = path$2;
                                    }
                                }, (Dataset<Row>)this.df$1);
                            }

                            public /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$23 org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.df$1 = df$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$6 org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ OrcSuite org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        this.test("SPARK-24322 Fix incorrect workaround for bug in java.sql.Timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrcSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempPath((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(File path) {
                        Timestamp ts = Timestamp.valueOf("1900-05-05 12:34:56.000789");
                        this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Timestamp[]{ts})), this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().testImplicits().newTimeStampEncoder()).toDF().write().orc(path.getCanonicalPath());
                        this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().checkAnswer((Function0<Dataset<Row>>)new Serializable(this, path){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$7$$anonfun$apply$mcV$sp$24 $outer;
                            private final File path$3;

                            public final Dataset<Row> apply() {
                                return this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().spark().read().orc(this.path$3.getCanonicalPath());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.path$3 = path$3;
                            }
                        }, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ts})));
                    }

                    public /* synthetic */ $anonfun$7 org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ OrcSuite org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        this.test("Write Spark version into ORC file metadata", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrcSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempPath((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(File path) {
                        this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().spark().range(1L).repartition(1).write().orc(path.getCanonicalPath());
                        File[] partFiles = (File[])Predef$.MODULE$.refArrayOps((Object[])path.listFiles()).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(File f) {
                                return f.isFile() && !f.getName().startsWith(".") && !f.getName().startsWith("_");
                            }
                        });
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)partFiles.length));
                        int $org_scalatest_assert_macro_right = 1;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
                        Path orcFilePath = new Path(((File)Predef$.MODULE$.refArrayOps((Object[])partFiles).head()).getAbsolutePath());
                        OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)new Configuration());
                        Reader reader = OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)readerOptions);
                        String version = StandardCharsets.UTF_8.decode(reader.getMetadataValue(package$.MODULE$.SPARK_VERSION_METADATA_KEY())).toString();
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().convertToEqualizer(version);
                        String $org_scalatest_assert_macro_right2 = org.apache.spark.package$.MODULE$.SPARK_VERSION_SHORT();
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ OrcSuite org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        this.test("SPARK-33094: should propagate Hadoop config from DS options to underlying file system", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrcSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.file.impl"), (Object)FakeFileSystemRequiringDSOption.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.file.impl.disable.cache"), (Object)"true")}), (Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().withTempPath((Function1<File, BoxedUnit>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$9$$anonfun$apply$mcV$sp$2 $outer;

                            public final void apply(File dir) {
                                String path = dir.getAbsolutePath();
                                scala.collection.immutable.Map conf = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds_option"), (Object)"value")}));
                                this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().spark().range(1L).write().options((Map)conf).orc(path);
                                this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().checkAnswer((Function0<Dataset<Row>>)new Serializable(this, path, conf){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$9$$anonfun$apply$mcV$sp$2$$anonfun$apply$mcV$sp$26 $outer;
                                    private final String path$1;
                                    private final scala.collection.immutable.Map conf$2;

                                    public final Dataset<Row> apply() {
                                        return this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer().spark().read().options((Map)this.conf$2).orc(this.path$1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.path$1 = path$1;
                                        this.conf$2 = conf$2;
                                    }
                                }, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
                            }

                            public /* synthetic */ $anonfun$9$$anonfun$apply$mcV$sp$2 org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$9 org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ OrcSuite org$apache$spark$sql$execution$datasources$orc$OrcSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
    }
}

