/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.File;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.streaming.CheckpointFileManagerTests;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001m2Q!\u0001\u0002\u0002\u0002=\u00111e\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'\u000fV3tiN|e\u000eT8dC245O\u0003\u0002\u0004\t\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000b\u0019\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001B\u0003\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tQ2\t[3dWB|\u0017N\u001c;GS2,W*\u00198bO\u0016\u0014H+Z:ugB\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\u0006a2\fgn\u001d\u0006\u00033\u0019\t\u0001bY1uC2L8\u000f^\u0005\u00037Y\u0011\u0011bU)M\u0011\u0016d\u0007/\u001a:\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002CA\t\u0001\u0011\u0015\t\u0003\u0001\"\u0005#\u0003I9\u0018\u000e\u001e5UK6\u0004\b*\u00193p_B\u0004\u0016\r\u001e5\u0015\u0005\rJ\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#\u0001B+oSRDQA\u000b\u0011A\u0002-\n\u0011\u0001\u001d\t\u0005I1r3%\u0003\u0002.K\tIa)\u001e8di&|g.\r\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\n!AZ:\u000b\u0005MR\u0011A\u00025bI>|\u0007/\u0003\u00026a\t!\u0001+\u0019;i\u0011\u00159\u0004\u0001\"\u00059\u0003Q\u0019\u0007.Z2l\u0019\u0016\f7.\u001b8h\u0007J\u001cg)\u001b7fgR\u00111%\u000f\u0005\u0006uY\u0002\rAL\u0001\u0005a\u0006$\b\u000e")
public abstract class CheckpointFileManagerTestsOnLocalFs
extends CheckpointFileManagerTests
implements SQLHelper {
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.class.withSQLConf((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.class.withTempPath((SQLHelper)this, f);
    }

    @Override
    public void withTempHadoopPath(Function1<Path, BoxedUnit> p) {
        this.withTempDir((Function1)new Serializable(this, p){
            public static final long serialVersionUID = 0L;
            private final Function1 p$1;

            public final void apply(File f) {
                Path basePath = new Path(f.getAbsolutePath());
                this.p$1.apply((Object)basePath);
            }
            {
                this.p$1 = p$1;
            }
        });
    }

    @Override
    public void checkLeakingCrcFiles(Path path) {
        Seq fileNames = (Seq)((TraversableLike)Predef$.MODULE$.refArrayOps((Object[])new File(path.toString()).listFiles()).toSeq().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File p) {
                return p.isFile();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(File p) {
                return p.getName();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq crcFiles = (Seq)fileNames.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String n) {
                return n.startsWith(".") && n.endsWith(".crc");
            }
        });
        Seq originFileNamesForExistingCrcFiles = (Seq)crcFiles.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String name) {
                return name.substring(1, name.length() - 4);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(originFileNamesForExistingCrcFiles.toSet().subsetOf((GenSet)fileNames.toSet()), "originFileNamesForExistingCrcFiles.toSet[String].subsetOf(fileNames.toSet[String])", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Some of origin files for crc files don't exist - crc files: ", " / "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{crcFiles}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected origin files: ", " / actual files: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{originFileNamesForExistingCrcFiles, fileNames}))).toString(), Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
    }

    public CheckpointFileManagerTestsOnLocalFs() {
        SQLHelper.class.$init$((SQLHelper)this);
    }
}

