/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.continuous;

import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.sql.LocalSparkSession;
import org.apache.spark.sql.LocalSparkSession$class;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.continuous.CommitPartitionEpoch;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.continuous.EpochCoordinatorRef$;
import org.apache.spark.sql.execution.streaming.continuous.GetCurrentEpoch$;
import org.apache.spark.sql.execution.streaming.continuous.ReportPartitionOffset;
import org.apache.spark.sql.execution.streaming.continuous.SetReaderPartitions;
import org.apache.spark.sql.execution.streaming.continuous.SetWriterPartitions;
import org.apache.spark.sql.sources.v2.reader.streaming.ContinuousReader;
import org.apache.spark.sql.sources.v2.reader.streaming.PartitionOffset;
import org.apache.spark.sql.sources.v2.writer.WriterCommitMessage;
import org.apache.spark.sql.sources.v2.writer.streaming.StreamWriter;
import org.apache.spark.sql.test.TestSparkSession;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.mockito.MockitoSugar;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001=\u0011Q#\u00129pG\"\u001cun\u001c:eS:\fGo\u001c:Tk&$XM\u0003\u0002\u0004\t\u0005Q1m\u001c8uS:,x.^:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0003\u0006\r!!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003+Yi\u0011AB\u0005\u0003/\u0019\u0011\u0011\u0003T8dC2\u001c\u0006/\u0019:l'\u0016\u001c8/[8o!\tIb$D\u0001\u001b\u0015\tYB$A\u0004n_\u000e\\\u0017\u000e^8\u000b\u0005ua\u0011!C:dC2\fG/Z:u\u0013\ty\"D\u0001\u0007N_\u000e\\\u0017\u000e^8Tk\u001e\f'\u000f\u0005\u0002\"E5\tA$\u0003\u0002$9\t\u0011\")\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014X)Y2i\u0011\u0015)\u0003\u0001\"\u0001'\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002)\u00015\t!\u0001C\u0005+\u0001\u0001\u0007\t\u0019!C\u0005W\u0005\u0001R\r]8dQ\u000e{wN\u001d3j]\u0006$xN]\u000b\u0002YA\u0011Q\u0006M\u0007\u0002])\u0011q\u0006C\u0001\u0004eB\u001c\u0017BA\u0019/\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001aD\u0011b\r\u0001A\u0002\u0003\u0007I\u0011\u0002\u001b\u0002)\u0015\u0004xn\u00195D_>\u0014H-\u001b8bi>\u0014x\fJ3r)\t)4\b\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtG\u0001\u0003V]&$\bb\u0002\u001f3\u0003\u0003\u0005\r\u0001L\u0001\u0004q\u0012\n\u0004B\u0002 \u0001A\u0003&A&A\tfa>\u001c\u0007nQ8pe\u0012Lg.\u0019;pe\u0002B\u0011\u0002\u0011\u0001A\u0002\u0003\u0007I\u0011B!\u0002\r]\u0014\u0018\u000e^3s+\u0005\u0011\u0005CA\"K\u001b\u0005!%BA\u0003F\u0015\t\u0001eI\u0003\u0002H\u0011\u0006\u0011aO\r\u0006\u0003\u0013\u001a\tqa]8ve\u000e,7/\u0003\u0002L\t\na1\u000b\u001e:fC6<&/\u001b;fe\"IQ\n\u0001a\u0001\u0002\u0004%IAT\u0001\u000boJLG/\u001a:`I\u0015\fHCA\u001bP\u0011\u001daD*!AA\u0002\tCa!\u0015\u0001!B\u0013\u0011\u0015aB<sSR,'\u000f\t\u0005\n'\u0002\u0001\r\u00111A\u0005\nQ\u000bQ!];fef,\u0012!\u0016\t\u0003-nk\u0011a\u0016\u0006\u0003\u0007aS!!B-\u000b\u0005i3\u0011!C3yK\u000e,H/[8o\u0013\tavKA\nD_:$\u0018N\\;pkN,\u00050Z2vi&|g\u000eC\u0005_\u0001\u0001\u0007\t\u0019!C\u0005?\u0006I\u0011/^3ss~#S-\u001d\u000b\u0003k\u0001Dq\u0001P/\u0002\u0002\u0003\u0007Q\u000b\u0003\u0004c\u0001\u0001\u0006K!V\u0001\u0007cV,'/\u001f\u0011\t\u0013\u0011\u0004\u0001\u0019!a\u0001\n\u0013)\u0017!D8sI\u0016\u0014h+\u001a:jM&,'/F\u0001g!\t9\u0017.D\u0001i\u0015\tYB\"\u0003\u0002kQ\n9\u0011J\\(sI\u0016\u0014\b\"\u00037\u0001\u0001\u0004\u0005\r\u0011\"\u0003n\u0003Ey'\u000fZ3s-\u0016\u0014\u0018NZ5fe~#S-\u001d\u000b\u0003k9Dq\u0001P6\u0002\u0002\u0003\u0007a\r\u0003\u0004q\u0001\u0001\u0006KAZ\u0001\u000f_J$WM\u001d,fe&4\u0017.\u001a:!\u0011\u0015\u0011\b\u0001\"\u0011t\u0003)\u0011WMZ8sK\u0016\u000b7\r\u001b\u000b\u0002k!)Q\u000f\u0001C\u0005m\u0006\u00192/\u001a;Xe&$XM\u001d)beRLG/[8ogR\u0011Qg\u001e\u0005\u0006qR\u0004\r!_\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0011\u0005YR\u0018BA>8\u0005\rIe\u000e\u001e\u0005\u0006{\u0002!IA`\u0001\u0014g\u0016$(+Z1eKJ\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003k}DQ\u0001\u001f?A\u0002eDq!a\u0001\u0001\t\u0013\t)!\u0001\u000bd_6l\u0017\u000e\u001e)beRLG/[8o\u000bB|7\r\u001b\u000b\u0006k\u0005\u001d\u00111\u0002\u0005\b\u0003\u0013\t\t\u00011\u0001z\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u0011\u00055\u0011\u0011\u0001a\u0001\u0003\u001f\tQ!\u001a9pG\"\u00042ANA\t\u0013\r\t\u0019b\u000e\u0002\u0005\u0019>tw\rC\u0004\u0002\u0018\u0001!I!!\u0007\u0002+I,\u0007o\u001c:u!\u0006\u0014H/\u001b;j_:|eMZ:fiR)Q'a\u0007\u0002\u001e!9\u0011\u0011BA\u000b\u0001\u0004I\b\u0002CA\u0007\u0003+\u0001\r!a\u0004\t\r\u0005\u0005\u0002\u0001\"\u0003t\u0003Mi\u0017m[3Ts:\u001c\u0007N]8o_V\u001c8)\u00197m\u0011\u001d\t)\u0003\u0001C\u0005\u0003O\tAB^3sS\u001aL8i\\7nSR$2!NA\u0015\u0011!\ti!a\tA\u0002\u0005=\u0001bBA\u0017\u0001\u0011%\u0011qF\u0001\u0012m\u0016\u0014\u0018NZ=O_\u000e{W.\\5u\r>\u0014HcA\u001b\u00022!A\u0011QBA\u0016\u0001\u0004\ty\u0001C\u0004\u00026\u0001!I!a\u000e\u0002-Y,'/\u001b4z\u0007>lW.\u001b;t\u0013:|%\u000fZ3s\u001f\u001a$2!NA\u001d\u0011!\tY$a\rA\u0002\u0005u\u0012AB3q_\u000eD7\u000f\u0005\u0004\u0002@\u0005=\u0013q\u0002\b\u0005\u0003\u0003\nYE\u0004\u0003\u0002D\u0005%SBAA#\u0015\r\t9ED\u0001\u0007yI|w\u000e\u001e \n\u0003aJ1!!\u00148\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0015\u0002T\t\u00191+Z9\u000b\u0007\u00055s\u0007")
public class EpochCoordinatorSuite
extends SparkFunSuite
implements LocalSparkSession,
MockitoSugar {
    private RpcEndpointRef epochCoordinator;
    private StreamWriter writer;
    private ContinuousExecution query;
    private InOrder orderVerifier;
    private transient SparkSession spark;

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (String)name, classTag);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    @TraitSetter
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$LocalSparkSession$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$LocalSparkSession$$super$afterEach() {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this);
    }

    @Override
    public void beforeAll() {
        LocalSparkSession$class.beforeAll(this);
    }

    @Override
    public void afterEach() {
        LocalSparkSession$class.afterEach(this);
    }

    private RpcEndpointRef epochCoordinator() {
        return this.epochCoordinator;
    }

    private void epochCoordinator_$eq(RpcEndpointRef x$1) {
        this.epochCoordinator = x$1;
    }

    private StreamWriter writer() {
        return this.writer;
    }

    private void writer_$eq(StreamWriter x$1) {
        this.writer = x$1;
    }

    private ContinuousExecution query() {
        return this.query;
    }

    private void query_$eq(ContinuousExecution x$1) {
        this.query = x$1;
    }

    private InOrder orderVerifier() {
        return this.orderVerifier;
    }

    private void orderVerifier_$eq(InOrder x$1) {
        this.orderVerifier = x$1;
    }

    public void beforeEach() {
        ContinuousReader reader = (ContinuousReader)this.mock(ClassTag$.MODULE$.apply(ContinuousReader.class));
        this.writer_$eq((StreamWriter)this.mock(ClassTag$.MODULE$.apply(StreamWriter.class)));
        this.query_$eq((ContinuousExecution)this.mock(ClassTag$.MODULE$.apply(ContinuousExecution.class)));
        this.orderVerifier_$eq(Mockito.inOrder((Object[])new Object[]{this.writer(), this.query()}));
        this.spark_$eq(new TestSparkSession());
        this.epochCoordinator_$eq(EpochCoordinatorRef$.MODULE$.create(this.writer(), reader, this.query(), "test", 1L, this.spark(), SparkEnv$.MODULE$.get()));
    }

    public void org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setWriterPartitions(int numPartitions) {
        this.epochCoordinator().askSync((Object)new SetWriterPartitions(numPartitions), ClassTag$.MODULE$.Unit());
    }

    public void org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setReaderPartitions(int numPartitions) {
        this.epochCoordinator().askSync((Object)new SetReaderPartitions(numPartitions), ClassTag$.MODULE$.Unit());
    }

    public void org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(int partitionId, long epoch) {
        WriterCommitMessage dummyMessage = (WriterCommitMessage)this.mock(ClassTag$.MODULE$.apply(WriterCommitMessage.class));
        this.epochCoordinator().send((Object)new CommitPartitionEpoch(partitionId, epoch, dummyMessage));
    }

    public void org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(int partitionId, long epoch) {
        PartitionOffset dummyOffset = (PartitionOffset)this.mock(ClassTag$.MODULE$.apply(PartitionOffset.class));
        this.epochCoordinator().send((Object)new ReportPartitionOffset(partitionId, epoch, dummyOffset));
    }

    public void org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$makeSynchronousCall() {
        this.epochCoordinator().askSync((Object)GetCurrentEpoch$.MODULE$, ClassTag$.MODULE$.Long());
    }

    public void org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$verifyCommit(long epoch) {
        ((StreamWriter)this.orderVerifier().verify((Object)this.writer())).commit(ArgumentMatchers.eq((long)epoch), (WriterCommitMessage[])ArgumentMatchers.any());
        ((ContinuousExecution)this.orderVerifier().verify((Object)this.query())).commit(epoch);
    }

    public void org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$verifyNoCommitFor(long epoch) {
        ((StreamWriter)Mockito.verify((Object)this.writer(), (VerificationMode)Mockito.never())).commit(ArgumentMatchers.eq((long)epoch), (WriterCommitMessage[])ArgumentMatchers.any());
        ((ContinuousExecution)Mockito.verify((Object)this.query(), (VerificationMode)Mockito.never())).commit(epoch);
    }

    public void org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$verifyCommitsInOrderOf(Seq<Object> epochs) {
        epochs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochCoordinatorSuite $outer;

            public final void apply(long epoch) {
                this.apply$mcVJ$sp(epoch);
            }

            public void apply$mcVJ$sp(long epoch) {
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$verifyCommit(epoch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public EpochCoordinatorSuite() {
        LocalSparkSession$class.$init$(this);
        MockitoSugar.class.$init$((MockitoSugar)this);
        this.test("single epoch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochCoordinatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setWriterPartitions(3);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setReaderPartitions(2);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(1, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(2, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(1, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$makeSynchronousCall();
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$verifyCommit(1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("single epoch, all but one writer partition has committed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochCoordinatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setWriterPartitions(3);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setReaderPartitions(2);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(1, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(1, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$makeSynchronousCall();
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$verifyNoCommitFor(1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("single epoch, all but one reader partition has reported an offset", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochCoordinatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setWriterPartitions(3);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setReaderPartitions(2);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(1, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(2, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$makeSynchronousCall();
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$verifyNoCommitFor(1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("consequent epochs, messages for epoch (k + 1) arrive after messages for epoch k", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochCoordinatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setWriterPartitions(2);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setReaderPartitions(2);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(1, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(1, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 2L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(1, 2L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 2L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(1, 2L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$makeSynchronousCall();
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$verifyCommitsInOrderOf((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 2L})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("consequent epochs, a message for epoch k arrives after messages for epoch (k + 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochCoordinatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setWriterPartitions(2);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setReaderPartitions(2);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(1, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 2L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(1, 2L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 2L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(1, 2L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(1, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$makeSynchronousCall();
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$verifyCommitsInOrderOf((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 2L})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("several epochs, messages arrive in order 1 -> 3 -> 4 -> 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochCoordinatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setWriterPartitions(1);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setReaderPartitions(1);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 3L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 3L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 4L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 4L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 2L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 2L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$makeSynchronousCall();
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$verifyCommitsInOrderOf((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L, 4L})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("several epochs, messages arrive in order 1 -> 3 -> 5 -> 4 -> 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochCoordinatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setWriterPartitions(1);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$setReaderPartitions(1);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 1L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 3L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 3L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 5L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 5L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 4L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 4L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$commitPartitionEpoch(0, 2L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$reportPartitionOffset(0, 2L);
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$makeSynchronousCall();
                this.$outer.org$apache$spark$sql$streaming$continuous$EpochCoordinatorSuite$$verifyCommitsInOrderOf((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L, 4L, 5L})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
    }
}

