/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.test;

import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.spark.SparkExecutorInfo;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.util.UninterruptibleThread;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.FunSuiteLike;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.time.Span$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

public abstract class SQLTestUtils$class {
    public static void beforeAll(SQLTestUtils $this) {
        $this.org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll();
        if ($this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests()) {
            $this.loadTestData();
        }
    }

    public static void withTempDir(SQLTestUtils $this, Function1 f) {
        $this.org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir((Function1)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SQLTestUtils $outer;
            private final Function1 f$1;

            public final void apply(File dir) {
                this.f$1.apply((Object)dir);
                this.$outer.waitForTasksToFinish();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$1 = f$1;
            }
        });
    }

    public static void setupTestData(SQLTestUtils $this) {
        $this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(true);
    }

    public static void testQuietly(SQLTestUtils $this, String name, Function0 f) {
        ((FunSuiteLike)$this).test(name, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final Function0 f$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                package$.MODULE$.quietly(this.f$2);
            }
            {
                this.f$2 = f$2;
            }
        }, new Position("SQLTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
    }

    public static void testWithUninterruptibleThread(SQLTestUtils $this, String name, boolean quietly, Function0 body) {
        int timeoutMillis = 10000;
        ObjectRef ex = ObjectRef.create(null);
        if (quietly) {
            $this.testQuietly(name, (Function0<BoxedUnit>)new Serializable($this, timeoutMillis, ex, name, body){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SQLTestUtils $outer;
                private final int timeoutMillis$1;
                private final ObjectRef ex$1;
                private final String name$1;
                private final Function0 body$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    SQLTestUtils$class.runOnThread$1(this.$outer, this.timeoutMillis$1, this.ex$1, this.name$1, this.body$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timeoutMillis$1 = timeoutMillis$1;
                    this.ex$1 = ex$1;
                    this.name$1 = name$1;
                    this.body$1 = body$1;
                }
            });
        } else {
            ((FunSuiteLike)$this).test(name, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable($this, timeoutMillis, ex, name, body){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SQLTestUtils $outer;
                private final int timeoutMillis$1;
                private final ObjectRef ex$1;
                private final String name$1;
                private final Function0 body$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    SQLTestUtils$class.runOnThread$1(this.$outer, this.timeoutMillis$1, this.ex$1, this.name$1, this.body$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timeoutMillis$1 = timeoutMillis$1;
                    this.ex$1 = ex$1;
                    this.name$1 = name$1;
                    this.body$1 = body$1;
                }
            }, new Position("SQLTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        }
    }

    public static boolean testWithUninterruptibleThread$default$2(SQLTestUtils $this) {
        return false;
    }

    public static void withResourceTempPath(SQLTestUtils $this, String resourcePath, Function1 f) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
        $this.withTempDir((Function1<File, BoxedUnit>)new Serializable($this, inputStream, f){
            public static final long serialVersionUID = 0L;
            private final InputStream inputStream$1;
            private final Function1 f$3;

            public final void apply(File dir) {
                File tmpFile = new File(dir, "tmp");
                Files.copy(this.inputStream$1, tmpFile.toPath(), new CopyOption[0]);
                this.f$3.apply((Object)tmpFile);
            }
            {
                this.inputStream$1 = inputStream$1;
                this.f$3 = f$3;
            }
        });
    }

    public static void waitForTasksToFinish(SQLTestUtils $this) {
        $this.eventually($this.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds())), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SQLTestUtils $outer;

            public final Assertion apply() {
                int $org_scalatest_assert_macro_left = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.spark().sparkContext().statusTracker().getExecutorInfos()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(SparkExecutorInfo x$1) {
                        return x$1.numRunningTasks();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return ((Assertions)this.$outer).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.patienceConfig(), new Position("SQLTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
    }

    /*
     * WARNING - void declaration
     */
    public static void withTempPaths(SQLTestUtils $this, int numPaths, Function1 f) {
        File[] files = (File[])Array$.MODULE$.fill(numPaths, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final File apply() {
                return Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalFile();
            }
        }, ClassTag$.MODULE$.apply(File.class));
        try {
            f.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])files));
            $this.waitForTasksToFinish();
        }
        catch (Throwable throwable) {
            void var3_3;
            $this.waitForTasksToFinish();
            Predef$.MODULE$.refArrayOps((Object[])var3_3).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final void apply(File file) {
                    Utils$.MODULE$.deleteRecursively(file);
                }
            });
            throw throwable;
        }
        Predef$.MODULE$.refArrayOps((Object[])files).foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public static final void runOnThread$1(SQLTestUtils $this, int timeoutMillis$1, ObjectRef ex$1, String name$1, Function0 body$1) {
        UninterruptibleThread thread = new UninterruptibleThread($this, ex$1, name$1, body$1){
            private final ObjectRef ex$1;
            private final Function0 body$1;

            public void run() {
                try {
                    this.body$1.apply$mcV$sp();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.ex$1.elem = e;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.ex$1 = ex$1;
                this.body$1 = body$1;
                super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Testing thread for test ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name$1})));
            }
        };
        thread.setDaemon(true);
        thread.start();
        thread.join((long)timeoutMillis$1);
        if (thread.isAlive()) {
            thread.interrupt();
            throw ((Assertions)$this).fail(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test '", "' running on o.a.s.util.UninterruptibleThread timed out after"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)timeoutMillis$1)}))).toString(), new Position("SQLTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        }
        if ((Throwable)ex$1.elem == null) {
            return;
        }
        throw (Throwable)ex$1.elem;
    }

    public static void $init$(SQLTestUtils $this) {
        $this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(false);
    }
}

