/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.sources.v2;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.InputPartitionReader;
import org.apache.spark.sql.types.StructType;

public class JavaSimpleDataSourceV2
implements DataSourceV2,
ReadSupport {
    public DataSourceReader createReader(DataSourceOptions options) {
        return new Reader();
    }

    static class JavaSimpleInputPartition
    implements InputPartition<InternalRow>,
    InputPartitionReader<InternalRow> {
        private int start;
        private int end;

        JavaSimpleInputPartition(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public InputPartitionReader<InternalRow> createPartitionReader() {
            return new JavaSimpleInputPartition(this.start - 1, this.end);
        }

        public boolean next() {
            ++this.start;
            return this.start < this.end;
        }

        public InternalRow get() {
            return new GenericInternalRow(new Object[]{this.start, -this.start});
        }

        public void close() throws IOException {
        }
    }

    class Reader
    implements DataSourceReader {
        private final StructType schema = new StructType().add("i", "int").add("j", "int");

        Reader() {
        }

        public StructType readSchema() {
            return this.schema;
        }

        public List<InputPartition<InternalRow>> planInputPartitions() {
            return Arrays.asList(new JavaSimpleInputPartition(0, 5), new JavaSimpleInputPartition(5, 10));
        }
    }
}

