/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.model.Record;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer$;
import org.apache.spark.streaming.kinesis.KinesisRecordProcessor;
import org.apache.spark.streaming.kinesis.SequenceNumberRange;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t=gAB\u0001\u0003\u0001\ta\u0001PA\bLS:,7/[:SK\u000e,\u0017N^3s\u0015\t\u0019A!A\u0004lS:,7/[:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<WCA\u0007\u0017'\r\u0001ab\t\t\u0004\u001fI!R\"\u0001\t\u000b\u0005E!\u0011\u0001\u0003:fG\u0016Lg/\u001a:\n\u0005M\u0001\"\u0001\u0003*fG\u0016Lg/\u001a:\u0011\u0005U1B\u0002\u0001\u0003\u0006/\u0001\u0011\r!\u0007\u0002\u0002)\u000e\u0001\u0011C\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aG\u0011\n\u0005\tb\"aA!osB\u0011AeJ\u0007\u0002K)\u0011aEB\u0001\tS:$XM\u001d8bY&\u0011\u0001&\n\u0002\b\u0019><w-\u001b8h\u0011!Q\u0003A!b\u0001\n\u0003Y\u0013AC:ue\u0016\fWNT1nKV\tA\u0006\u0005\u0002.a9\u00111DL\u0005\u0003_q\ta\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\u0019\u0019FO]5oO*\u0011q\u0006\b\u0005\ti\u0001\u0011\t\u0011)A\u0005Y\u0005Y1\u000f\u001e:fC6t\u0015-\\3!\u0011!1\u0004A!A!\u0002\u0013a\u0013aC3oIB|\u0017N\u001c;Ve2D\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\u000be\u0016<\u0017n\u001c8OC6,\u0007\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\u0002/%t\u0017\u000e^5bYB{7/\u001b;j_:Len\u0015;sK\u0006l\u0007C\u0001\u001fK\u001b\u0005i$B\u0001 @\u0003\u00199xN]6fe*\u0011\u0001)Q\u0001\u0004Y&\u0014'B\u0001\"D\u00035\u0019G.[3oi2L'M]1ss*\u00111\u0001\u0012\u0006\u0003\u000b\u001a\u000b\u0001b]3sm&\u001cWm\u001d\u0006\u0003\u000f\"\u000b\u0011\"Y7bu>t\u0017m^:\u000b\u0003%\u000b1aY8n\u0013\tYUHA\fJ]&$\u0018.\u00197Q_NLG/[8o\u0013:\u001cFO]3b[\"AQ\n\u0001B\u0001B\u0003%A&A\tdQ\u0016\u001c7\u000e]8j]R\f\u0005\u000f\u001d(b[\u0016D\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001U\u0001\u0013G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\u0005\u0002R%6\tA!\u0003\u0002T\t\tAA)\u001e:bi&|g\u000eC\u0005V\u0001\t\u0005\t\u0015!\u0003W9\u0006a1\u000f^8sC\u001e,G*\u001a<fYB\u0011qKW\u0007\u00021*\u0011\u0011LB\u0001\bgR|'/Y4f\u0013\tY\u0006L\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G.\u0003\u0002V%!Aa\f\u0001B\u0001B\u0003%q,\u0001\bnKN\u001c\u0018mZ3IC:$G.\u001a:\u0011\tm\u0001'\rF\u0005\u0003Cr\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015\u001c\u0015!B7pI\u0016d\u0017BA4e\u0005\u0019\u0011VmY8sI\"A\u0011\u000e\u0001B\u0001B\u0003%!.\u0001\u0007lS:,7/[:De\u0016$7\u000f\u0005\u0002lY6\t!!\u0003\u0002n\u0005\t\u00192\u000b]1sW\u0006;6k\u0011:fI\u0016tG/[1mg\"Aq\u000e\u0001B\u0001B\u0003%\u0001/A\u0007es:\fWn\u001c#C\u0007J,Gm\u001d\t\u00047ET\u0017B\u0001:\u001d\u0005\u0019y\u0005\u000f^5p]\"AA\u000f\u0001B\u0001B\u0003%\u0001/A\bdY>,HmV1uG\"\u001c%/\u001a3t\u0011\u00151\b\u0001\"\u0001x\u0003\u0019a\u0014N\\5u}Q\u0001\u00020\u001f>|yvtx0!\u0001\u0002\u0004\u0005\u0015\u0011q\u0001\t\u0004W\u0002!\u0002\"\u0002\u0016v\u0001\u0004a\u0003\"\u0002\u001cv\u0001\u0004a\u0003\"\u0002\u001dv\u0001\u0004a\u0003\"\u0002\u001ev\u0001\u0004Y\u0004\"B'v\u0001\u0004a\u0003\"B(v\u0001\u0004\u0001\u0006\"B+v\u0001\u00041\u0006\"\u00020v\u0001\u0004y\u0006\"B5v\u0001\u0004Q\u0007\"B8v\u0001\u0004\u0001\b\"\u0002;v\u0001\u0004\u0001\b\u0002CA\u0006\u0001\u0001\u0007I\u0011B\u0016\u0002\u0011]|'o[3s\u0013\u0012D\u0011\"a\u0004\u0001\u0001\u0004%I!!\u0005\u0002\u0019]|'o[3s\u0013\u0012|F%Z9\u0015\t\u0005M\u0011\u0011\u0004\t\u00047\u0005U\u0011bAA\f9\t!QK\\5u\u0011%\tY\"!\u0004\u0002\u0002\u0003\u0007A&A\u0002yIEBq!a\b\u0001A\u0003&A&A\u0005x_J\\WM]%eA!\"\u0011QDA\u0012!\rY\u0012QE\u0005\u0004\u0003Oa\"\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0011y\u0002\u0001\u0019!C\u0005\u0003W)\"!!\f\u0011\u0007q\ny#C\u0002\u00022u\u0012aaV8sW\u0016\u0014\b\"CA\u001b\u0001\u0001\u0007I\u0011BA\u001c\u0003)9xN]6fe~#S-\u001d\u000b\u0005\u0003'\tI\u0004\u0003\u0006\u0002\u001c\u0005M\u0012\u0011!a\u0001\u0003[A\u0001\"!\u0010\u0001A\u0003&\u0011QF\u0001\bo>\u00148.\u001a:!Q\u0011\tY$a\t\t\u0013\u0005\r\u0003\u00011A\u0005\n\u0005\u0015\u0013\u0001D<pe.,'\u000f\u00165sK\u0006$WCAA$!\u0011\tI%a\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\nA\u0001\\1oO*\u0011\u0011\u0011K\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002V\u0005-#A\u0002+ie\u0016\fG\rC\u0005\u0002Z\u0001\u0001\r\u0011\"\u0003\u0002\\\u0005\u0001ro\u001c:lKJ$\u0006N]3bI~#S-\u001d\u000b\u0005\u0003'\ti\u0006\u0003\u0006\u0002\u001c\u0005]\u0013\u0011!a\u0001\u0003\u000fB\u0001\"!\u0019\u0001A\u0003&\u0011qI\u0001\u000eo>\u00148.\u001a:UQJ,\u0017\r\u001a\u0011)\t\u0005}\u00131\u0005\u0005\n\u0003O\u0002\u0001\u0019!C\u0005\u0003S\naB\u00197pG.<UM\\3sCR|'/\u0006\u0002\u0002lA\u0019q\"!\u001c\n\u0007\u0005=\u0004C\u0001\bCY>\u001c7nR3oKJ\fGo\u001c:\t\u0013\u0005M\u0004\u00011A\u0005\n\u0005U\u0014A\u00052m_\u000e\\w)\u001a8fe\u0006$xN]0%KF$B!a\u0005\u0002x!Q\u00111DA9\u0003\u0003\u0005\r!a\u001b\t\u0011\u0005m\u0004\u0001)Q\u0005\u0003W\nqB\u00197pG.<UM\\3sCR|'\u000f\t\u0015\u0005\u0003s\n\u0019\u0003C\u0005\u0002\u0002\u0002\u0011\r\u0011\"\u0003\u0002\u0004\u0006Q2/Z9Ok6\u0014\u0016M\\4fg&s7)\u001e:sK:$(\t\\8dWV\u0011\u0011Q\u0011\t\u0007\u0003\u000f\u000b\t*!&\u000e\u0005\u0005%%\u0002BAF\u0003\u001b\u000bq!\\;uC\ndWMC\u0002\u0002\u0010r\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019*!#\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004W\u0006]\u0015bAAM\u0005\t\u00192+Z9vK:\u001cWMT;nE\u0016\u0014(+\u00198hK\"A\u0011Q\u0014\u0001!\u0002\u0013\t))A\u000etKFtU/\u001c*b]\u001e,7/\u00138DkJ\u0014XM\u001c;CY>\u001c7\u000e\t\u0005\n\u0003C\u0003!\u0019!C\u0005\u0003G\u000bQC\u00197pG.LE\rV8TKFtU/\u001c*b]\u001e,7/\u0006\u0002\u0002&BA\u0011qUAY\u0003k\u000bY,\u0004\u0002\u0002**!\u00111VAW\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003_\u000by%\u0001\u0003vi&d\u0017\u0002BAZ\u0003S\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\r9\u0016qW\u0005\u0004\u0003sC&!D*ue\u0016\fWN\u00117pG.LE\rE\u0002l\u0003{K1!a0\u0003\u0005Q\u0019V-];f]\u000e,g*^7cKJ\u0014\u0016M\\4fg\"A\u00111\u0019\u0001!\u0002\u0013\t)+\u0001\fcY>\u001c7.\u00133U_N+\u0017OT;n%\u0006tw-Z:!\u0011%\t9\r\u0001a\u0001\n\u0013\tI-A\nlS:,7/[:DQ\u0016\u001c7\u000e]8j]R,'/\u0006\u0002\u0002LB\u00191.!4\n\u0007\u0005='AA\nLS:,7/[:DQ\u0016\u001c7\u000e]8j]R,'\u000fC\u0005\u0002T\u0002\u0001\r\u0011\"\u0003\u0002V\u000692.\u001b8fg&\u001c8\t[3dWB|\u0017N\u001c;fe~#S-\u001d\u000b\u0005\u0003'\t9\u000e\u0003\u0006\u0002\u001c\u0005E\u0017\u0011!a\u0001\u0003\u0017D\u0001\"a7\u0001A\u0003&\u00111Z\u0001\u0015W&tWm]5t\u0007\",7m\u001b9pS:$XM\u001d\u0011)\t\u0005e\u00171\u0005\u0005\n\u0003C\u0004!\u0019!C\u0005\u0003G\f1d\u001d5be\u0012LE\rV8MCR,7\u000f^*u_J,GmU3r\u001dVlWCAAs!\u0019\t9+!--Y!A\u0011\u0011\u001e\u0001!\u0002\u0013\t)/\u0001\u000ftQ\u0006\u0014H-\u00133U_2\u000bG/Z:u'R|'/\u001a3TKFtU/\u001c\u0011\t\u000f\u00055\b\u0001\"\u0011\u0002p\u00069qN\\*uCJ$HCAA\n\u0011\u001d\t\u0019\u0010\u0001C!\u0003_\faa\u001c8Ti>\u0004\b\u0002CA|\u0001\u0011\u0005!!!?\u0002\u0015\u0005$GMU3d_J$7\u000f\u0006\u0004\u0002\u0014\u0005m\u0018q \u0005\b\u0003{\f)\u00101\u0001-\u0003\u001d\u0019\b.\u0019:e\u0013\u0012D\u0001B!\u0001\u0002v\u0002\u0007!1A\u0001\be\u0016\u001cwN\u001d3t!\u0015\u0011)Aa\u0002c\u001b\t\ti+\u0003\u0003\u0003\n\u00055&\u0001\u0002'jgRD\u0001B!\u0004\u0001\t\u0003\u0011!qB\u0001\u0010O\u0016$8)\u001e:sK:$H*[7jiV\u0011!\u0011\u0003\t\u00047\tM\u0011b\u0001B\u000b9\t\u0019\u0011J\u001c;\t\u0011\te\u0001\u0001\"\u0001\u0003\u00057\t1dZ3u\u0019\u0006$Xm\u001d;TKFtU/\u001c+p\u0007\",7m\u001b9pS:$H\u0003\u0002B\u000f\u0005?\u00012aG9-\u0011\u001d\tiPa\u0006A\u00021BqAa\t\u0001\t\u0003\u0011)#A\btKR\u001c\u0005.Z2la>Lg\u000e^3s)\u0019\t\u0019Ba\n\u0003*!9\u0011Q B\u0011\u0001\u0004a\u0003\u0002\u0003B\u0016\u0005C\u0001\rA!\f\u0002\u0019\rDWmY6q_&tG/\u001a:\u0011\t\t=\"QG\u0007\u0003\u0005cQ1Aa\rB\u0003)Ig\u000e^3sM\u0006\u001cWm]\u0005\u0005\u0005o\u0011\tD\u0001\u000fJ%\u0016\u001cwN\u001d3Qe>\u001cWm]:pe\u000eCWmY6q_&tG/\u001a:\t\u000f\tm\u0002\u0001\"\u0001\u0003>\u0005\u0011\"/Z7pm\u0016\u001c\u0005.Z2la>Lg\u000e^3s)\u0019\t\u0019Ba\u0010\u0003B!9\u0011Q B\u001d\u0001\u0004a\u0003\u0002\u0003B\u0016\u0005s\u0001\rA!\f\t\u000f\t\u0015\u0003\u0001\"\u0003\u0003H\u0005\u0011\"/Z7f[\n,'/\u00113eK\u0012\u0014\u0016M\\4f)\u0011\t\u0019B!\u0013\t\u0011\t-#1\ta\u0001\u0003+\u000bQA]1oO\u0016DqAa\u0014\u0001\t\u0013\u0011\t&A\u000fgS:\fG.\u001b>f%\u0006tw-Z:G_J\u001cUO\u001d:f]R\u0014En\\2l)\u0011\t\u0019Ba\u0015\t\u0011\tU#Q\na\u0001\u0003k\u000bqA\u00197pG.LE\rC\u0004\u0003Z\u0001!IAa\u0017\u0002)M$xN]3CY>\u001c7nV5uQJ\u000bgnZ3t)\u0019\t\u0019B!\u0018\u0003`!A!Q\u000bB,\u0001\u0004\t)\f\u0003\u0005\u0003b\t]\u0003\u0019\u0001B2\u0003-\t'O]1z\u0005V4g-\u001a:\u0011\u000b\u0005\u001d\u0015\u0011\u0013\u000b\u0007\r\t\u001d\u0004\u0001\u0002B5\u0005U9UM\\3sCR,GM\u00117pG.D\u0015M\u001c3mKJ\u001cbA!\u001a\u0003l\tE\u0004cA\u000e\u0003n%\u0019!q\u000e\u000f\u0003\r\u0005s\u0017PU3g!\ry!1O\u0005\u0004\u0005k\u0002\"A\u0006\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d'jgR,g.\u001a:\t\u000fY\u0014)\u0007\"\u0001\u0003zQ\u0011!1\u0010\t\u0005\u0005{\u0012)'D\u0001\u0001\u0011!\u0011\tI!\u001a\u0005\u0002\t\r\u0015!C8o\u0003\u0012$G)\u0019;b)\u0019\t\u0019B!\"\u0003\n\"9!q\u0011B@\u0001\u0004\u0001\u0013\u0001\u00023bi\u0006DqAa#\u0003\u0000\u0001\u0007\u0001%\u0001\u0005nKR\fG-\u0019;b\u0011!\u0011yI!\u001a\u0005\u0002\tE\u0015aD8o\u000f\u0016tWM]1uK\ncwnY6\u0015\t\u0005M!1\u0013\u0005\t\u0005+\u0012i\t1\u0001\u00026\"A!q\u0013B3\t\u0003\u0011I*A\u0006p]B+8\u000f\u001b\"m_\u000e\\GCBA\n\u00057\u0013i\n\u0003\u0005\u0003V\tU\u0005\u0019AA[\u0011!\u0011\tG!&A\u0002\t}\u0005\u0007\u0002BQ\u0005K\u0003b!a\"\u0002\u0012\n\r\u0006cA\u000b\u0003&\u0012Y!q\u0015BO\u0003\u0003\u0005\tQ!\u0001\u001a\u0005\ryF%\r\u0005\t\u0005W\u0013)\u0007\"\u0001\u0003.\u00069qN\\#se>\u0014HCBA\n\u0005_\u0013\u0019\fC\u0004\u00032\n%\u0006\u0019\u0001\u0017\u0002\u000f5,7o]1hK\"A!Q\u0017BU\u0001\u0004\u00119,A\u0005uQJ|w/\u00192mKB!!\u0011\u0018Be\u001d\u0011\u0011YL!2\u000f\t\tu&1Y\u0007\u0003\u0005\u007fS1A!1\u0019\u0003\u0019a$o\\8u}%\tQ$C\u0002\u0003Hr\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003L\n5'!\u0003+ie><\u0018M\u00197f\u0015\r\u00119\r\b")
public class KinesisReceiver<T>
extends Receiver<T>
implements Logging {
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final InitialPositionInStream initialPositionInStream;
    private final String checkpointAppName;
    private final Duration checkpointInterval;
    private final Function1<Record, T> messageHandler;
    private final SparkAWSCredentials kinesisCreds;
    private final Option<SparkAWSCredentials> dynamoDBCreds;
    private final Option<SparkAWSCredentials> cloudWatchCreds;
    private volatile String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    private volatile Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    private volatile Thread workerThread;
    private volatile BlockGenerator blockGenerator;
    private final ArrayBuffer<SequenceNumberRange> seqNumRangesInCurrentBlock;
    private final ConcurrentHashMap<StreamBlockId, SequenceNumberRanges> org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges;
    private volatile KinesisCheckpointer kinesisCheckpointer;
    private final ConcurrentHashMap<String, String> org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public String streamName() {
        return this.streamName;
    }

    public String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    }

    private void org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(String x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = x$1;
    }

    public Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    }

    private void org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(Worker x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = x$1;
    }

    private Thread workerThread() {
        return this.workerThread;
    }

    private void workerThread_$eq(Thread x$1) {
        this.workerThread = x$1;
    }

    private BlockGenerator blockGenerator() {
        return this.blockGenerator;
    }

    private void blockGenerator_$eq(BlockGenerator x$1) {
        this.blockGenerator = x$1;
    }

    private ArrayBuffer<SequenceNumberRange> seqNumRangesInCurrentBlock() {
        return this.seqNumRangesInCurrentBlock;
    }

    public ConcurrentHashMap<StreamBlockId, SequenceNumberRanges> org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges;
    }

    private KinesisCheckpointer kinesisCheckpointer() {
        return this.kinesisCheckpointer;
    }

    private void kinesisCheckpointer_$eq(KinesisCheckpointer x$1) {
        this.kinesisCheckpointer = x$1;
    }

    public ConcurrentHashMap<String, String> org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum;
    }

    public void onStart() {
        this.blockGenerator_$eq(this.supervisor().createBlockGenerator((BlockGeneratorListener)new GeneratedBlockHandler()));
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(new StringBuilder().append((Object)Utils$.MODULE$.localHostName()).append((Object)":").append((Object)UUID.randomUUID()).toString());
        this.kinesisCheckpointer_$eq(new KinesisCheckpointer(this, this.checkpointInterval, this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId(), KinesisCheckpointer$.MODULE$.$lessinit$greater$default$4()));
        AWSCredentialsProvider kinesisProvider = this.kinesisCreds.provider();
        KinesisClientLibConfiguration kinesisClientLibConfiguration = new KinesisClientLibConfiguration(this.checkpointAppName, this.streamName(), kinesisProvider, (AWSCredentialsProvider)this.dynamoDBCreds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AWSCredentialsProvider apply(SparkAWSCredentials x$1) {
                return x$1.provider();
            }
        }).getOrElse((Function0)new Serializable(this, kinesisProvider){
            public static final long serialVersionUID = 0L;
            private final AWSCredentialsProvider kinesisProvider$1;

            public final AWSCredentialsProvider apply() {
                return this.kinesisProvider$1;
            }
            {
                this.kinesisProvider$1 = kinesisProvider$1;
            }
        }), (AWSCredentialsProvider)this.cloudWatchCreds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AWSCredentialsProvider apply(SparkAWSCredentials x$2) {
                return x$2.provider();
            }
        }).getOrElse((Function0)new Serializable(this, kinesisProvider){
            public static final long serialVersionUID = 0L;
            private final AWSCredentialsProvider kinesisProvider$1;

            public final AWSCredentialsProvider apply() {
                return this.kinesisProvider$1;
            }
            {
                this.kinesisProvider$1 = kinesisProvider$1;
            }
        }), this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()).withKinesisEndpoint(this.endpointUrl).withInitialPositionInStream(this.initialPositionInStream).withTaskBackoffTimeMillis(500L).withRegionName(this.regionName);
        IRecordProcessorFactory recordProcessorFactory = new IRecordProcessorFactory(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public IRecordProcessor createProcessor() {
                return new KinesisRecordProcessor<T>(this.$outer, this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(new Worker(recordProcessorFactory, kinesisClientLibConfiguration));
        this.workerThread_$eq(new Thread(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public void run() {
                try {
                    this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().run();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.$outer.restart("Error running the KCL worker in Receiver", e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges().clear();
        this.blockGenerator().start();
        this.workerThread().setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kinesis Receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId())})));
        this.workerThread().setDaemon(true);
        this.workerThread().start();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisReceiver $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started receiver with workerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void onStop() {
        if (this.workerThread() != null) {
            if (this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() != null) {
                this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().shutdown();
                this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(null);
            }
            this.workerThread().join();
            this.workerThread_$eq(null);
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KinesisReceiver $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopped receiver for workerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(null);
        if (this.kinesisCheckpointer() != null) {
            this.kinesisCheckpointer().shutdown();
            this.kinesisCheckpointer_$eq(null);
        }
    }

    public void addRecords(String shardId, List<Record> records) {
        if (records.size() > 0) {
            Iterator dataIterator = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(records.iterator()).asScala()).map(this.messageHandler);
            SequenceNumberRange metadata = new SequenceNumberRange(this.streamName(), shardId, records.get(0).getSequenceNumber(), records.get(records.size() - 1).getSequenceNumber(), records.size());
            this.blockGenerator().addMultipleDataWithCallback(dataIterator, (Object)metadata);
        }
    }

    public int getCurrentLimit() {
        Predef$.MODULE$.assert(this.blockGenerator() != null);
        return (int)package$.MODULE$.min(this.blockGenerator().getCurrentLimit(), Integer.MAX_VALUE);
    }

    public Option<String> getLatestSeqNumToCheckpoint(String shardId) {
        return Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum().get(shardId));
    }

    public void setCheckpointer(String shardId, IRecordProcessorCheckpointer checkpointer) {
        Predef$.MODULE$.assert(this.kinesisCheckpointer() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kinesis Checkpointer not initialized!";
            }
        });
        this.kinesisCheckpointer().setCheckpointer(shardId, checkpointer);
    }

    public void removeCheckpointer(String shardId, IRecordProcessorCheckpointer checkpointer) {
        Predef$.MODULE$.assert(this.kinesisCheckpointer() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kinesis Checkpointer not initialized!";
            }
        });
        this.kinesisCheckpointer().removeCheckpointer(shardId, checkpointer);
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$rememberAddedRange(SequenceNumberRange range) {
        this.seqNumRangesInCurrentBlock().$plus$eq((Object)range);
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$finalizeRangesForCurrentBlock(StreamBlockId blockId) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges().put(blockId, new SequenceNumberRanges((Seq<SequenceNumberRange>)Predef$.MODULE$.wrapRefArray((Object[])this.seqNumRangesInCurrentBlock().toArray(ClassTag$.MODULE$.apply(SequenceNumberRange.class)))));
        this.seqNumRangesInCurrentBlock().clear();
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisReceiver $outer;
            private final StreamBlockId blockId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Generated block ", " has ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1, this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$1 = blockId$1;
            }
        });
    }

    /*
     * Exception decompiling
     */
    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$storeBlockWithRanges(StreamBlockId blockId, ArrayBuffer<T> arrayBuffer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [0 : 179->192)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public KinesisReceiver(String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, String checkpointAppName, Duration checkpointInterval, StorageLevel storageLevel, Function1<Record, T> messageHandler, SparkAWSCredentials kinesisCreds, Option<SparkAWSCredentials> dynamoDBCreds, Option<SparkAWSCredentials> cloudWatchCreds) {
        this.streamName = streamName2;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPositionInStream = initialPositionInStream;
        this.checkpointAppName = checkpointAppName;
        this.checkpointInterval = checkpointInterval;
        this.messageHandler = messageHandler;
        this.kinesisCreds = kinesisCreds;
        this.dynamoDBCreds = dynamoDBCreds;
        this.cloudWatchCreds = cloudWatchCreds;
        super(storageLevel);
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = null;
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = null;
        this.workerThread = null;
        this.blockGenerator = null;
        this.seqNumRangesInCurrentBlock = new ArrayBuffer();
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges = new ConcurrentHashMap();
        this.kinesisCheckpointer = null;
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum = new ConcurrentHashMap();
    }

    public class GeneratedBlockHandler
    implements BlockGeneratorListener {
        public void onAddData(Object data, Object metadata) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$rememberAddedRange((SequenceNumberRange)metadata);
        }

        public void onGenerateBlock(StreamBlockId blockId) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$finalizeRangesForCurrentBlock(blockId);
        }

        public void onPushBlock(StreamBlockId blockId, ArrayBuffer<?> arrayBuffer) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$storeBlockWithRanges(blockId, arrayBuffer);
        }

        public void onError(String message, Throwable throwable) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().reportError(message, throwable);
        }

        public /* synthetic */ KinesisReceiver org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer() {
            return KinesisReceiver.this;
        }

        public GeneratedBlockHandler() {
            if (KinesisReceiver.this == null) {
                throw null;
            }
        }
    }
}

