/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.scheduler.ExecutorAllocationManager$;
import org.apache.spark.streaming.scheduler.OutputOperationInfo;
import org.apache.spark.streaming.scheduler.ReceiverTracker;
import org.apache.spark.streaming.scheduler.StreamingListener;
import org.apache.spark.streaming.scheduler.StreamingListener$class;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchSubmitted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.apache.spark.streaming.scheduler.StreamingListenerStreamingStarted;
import org.apache.spark.streaming.util.RecurringTimer;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005=g!B\u0001\u0003\u0001\u0011a!!G#yK\u000e,Ho\u001c:BY2|7-\u0019;j_:l\u0015M\\1hKJT!a\u0001\u0003\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\u0011\u0001QbE\f\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!R#D\u0001\u0003\u0013\t1\"AA\tTiJ,\u0017-\\5oO2K7\u000f^3oKJ\u0004\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001H\r\u0003\u000f1{wmZ5oO\"Aa\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0004dY&,g\u000e^\u0002\u0001!\t\t#%D\u0001\u0007\u0013\t\u0019cA\u0001\rFq\u0016\u001cW\u000f^8s\u00032dwnY1uS>t7\t\\5f]RD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0010e\u0016\u001cW-\u001b<feR\u0013\u0018mY6feB\u0011AcJ\u0005\u0003Q\t\u0011qBU3dK&4XM\u001d+sC\u000e\\WM\u001d\u0005\tU\u0001\u0011\t\u0011)A\u0005W\u0005!1m\u001c8g!\t\tC&\u0003\u0002.\r\tI1\u000b]1sW\u000e{gN\u001a\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005y!-\u0019;dQ\u0012+(/\u0019;j_:l5\u000f\u0005\u0002\u000fc%\u0011!g\u0004\u0002\u0005\u0019>tw\r\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0003\u0015\u0019Gn\\2l!\t1\u0014(D\u00018\u0015\tAd!\u0001\u0003vi&d\u0017B\u0001\u001e8\u0005\u0015\u0019En\\2l\u0011\u0015a\u0004\u0001\"\u0001>\u0003\u0019a\u0014N\\5u}Q1ah\u0010!B\u0005\u000e\u0003\"\u0001\u0006\u0001\t\u000byY\u0004\u0019\u0001\u0011\t\u000b\u0015Z\u0004\u0019\u0001\u0014\t\u000b)Z\u0004\u0019A\u0016\t\u000b=Z\u0004\u0019\u0001\u0019\t\u000bQZ\u0004\u0019A\u001b\t\u000f\u0015\u0003!\u0019!C\u0005\r\u0006\u00192oY1mS:<\u0017J\u001c;feZ\fGnU3dgV\t\u0001\u0007\u0003\u0004I\u0001\u0001\u0006I\u0001M\u0001\u0015g\u000e\fG.\u001b8h\u0013:$XM\u001d<bYN+7m\u001d\u0011\t\u000f)\u0003!\u0019!C\u0005\u0017\u0006q1oY1mS:<W\u000b\u001d*bi&|W#\u0001'\u0011\u00059i\u0015B\u0001(\u0010\u0005\u0019!u.\u001e2mK\"1\u0001\u000b\u0001Q\u0001\n1\u000bqb]2bY&tw-\u00169SCRLw\u000e\t\u0005\b%\u0002\u0011\r\u0011\"\u0003L\u0003A\u00198-\u00197j]\u001e$un\u001e8SCRLw\u000e\u0003\u0004U\u0001\u0001\u0006I\u0001T\u0001\u0012g\u000e\fG.\u001b8h\t><hNU1uS>\u0004\u0003b\u0002,\u0001\u0005\u0004%IaV\u0001\u0010[&tg*^7Fq\u0016\u001cW\u000f^8sgV\t\u0001\f\u0005\u0002\u000f3&\u0011!l\u0004\u0002\u0004\u0013:$\bB\u0002/\u0001A\u0003%\u0001,\u0001\tnS:tU/\\#yK\u000e,Ho\u001c:tA!9a\f\u0001b\u0001\n\u00139\u0016aD7bq:+X.\u0012=fGV$xN]:\t\r\u0001\u0004\u0001\u0015!\u0003Y\u0003Ai\u0017\r\u001f(v[\u0016CXmY;u_J\u001c\b\u0005C\u0004c\u0001\t\u0007I\u0011B2\u0002\u000bQLW.\u001a:\u0016\u0003\u0011\u0004\"!Z4\u000e\u0003\u0019T!\u0001\u000f\u0003\n\u0005!4'A\u0004*fGV\u0014(/\u001b8h)&lWM\u001d\u0005\u0007U\u0002\u0001\u000b\u0011\u00023\u0002\rQLW.\u001a:!\u0011\u001da\u0007\u00011A\u0005\n\u0019\u000b\u0001CY1uG\"\u0004&o\\2US6,7+^7\t\u000f9\u0004\u0001\u0019!C\u0005_\u0006!\"-\u0019;dQB\u0013xn\u0019+j[\u0016\u001cV/\\0%KF$\"\u0001]:\u0011\u00059\t\u0018B\u0001:\u0010\u0005\u0011)f.\u001b;\t\u000fQl\u0017\u0011!a\u0001a\u0005\u0019\u0001\u0010J\u0019\t\rY\u0004\u0001\u0015)\u00031\u0003E\u0011\u0017\r^2i!J|7\rV5nKN+X\u000e\t\u0015\u0003kb\u0004\"AD=\n\u0005i|!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000fq\u0004\u0001\u0019!C\u0005/\u0006\u0011\"-\u0019;dQB\u0013xn\u0019+j[\u0016\u001cu.\u001e8u\u0011\u001dq\b\u00011A\u0005\n}\faCY1uG\"\u0004&o\\2US6,7i\\;oi~#S-\u001d\u000b\u0004a\u0006\u0005\u0001b\u0002;~\u0003\u0003\u0005\r\u0001\u0017\u0005\b\u0003\u000b\u0001\u0001\u0015)\u0003Y\u0003M\u0011\u0017\r^2i!J|7\rV5nK\u000e{WO\u001c;!Q\r\t\u0019\u0001\u001f\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0003\u0015\u0019H/\u0019:u)\u0005\u0001\bbBA\t\u0001\u0011\u0005\u0011QB\u0001\u0005gR|\u0007\u000fC\u0004\u0002\u0016\u0001!I!!\u0004\u0002!5\fg.Y4f\u00032dwnY1uS>t\u0007bBA\r\u0001\u0011%\u00111D\u0001\u0011e\u0016\fX/Z:u\u000bb,7-\u001e;peN$2\u0001]A\u000f\u0011\u001d\ty\"a\u0006A\u0002a\u000bqB\\;n\u001d\u0016<X\t_3dkR|'o\u001d\u0005\b\u0003G\u0001A\u0011BA\u0007\u00031Y\u0017\u000e\u001c7Fq\u0016\u001cW\u000f^8s\u0011\u001d\t9\u0003\u0001C\u0005\u0003S\t\u0001#\u00193e\u0005\u0006$8\r\u001b)s_\u000e$\u0016.\\3\u0015\u0007A\fY\u0003C\u0004\u0002.\u0005\u0015\u0002\u0019\u0001\u0019\u0002\rQLW.Z't\u0011\u001d\t\t\u0004\u0001C\u0005\u0003\u001b\t\u0001C^1mS\u0012\fG/Z*fiRLgnZ:\t\u000f\u0005U\u0002\u0001\"\u0011\u00028\u0005\u0001rN\u001c\"bi\u000eD7i\\7qY\u0016$X\r\u001a\u000b\u0004a\u0006e\u0002\u0002CA\u001e\u0003g\u0001\r!!\u0010\u0002\u001d\t\fGo\u00195D_6\u0004H.\u001a;fIB\u0019A#a\u0010\n\u0007\u0005\u0005#AA\u0010TiJ,\u0017-\\5oO2K7\u000f^3oKJ\u0014\u0015\r^2i\u0007>l\u0007\u000f\\3uK\u0012<\u0001\"!\u0012\u0003\u0011\u0003!\u0011qI\u0001\u001a\u000bb,7-\u001e;pe\u0006cGn\\2bi&|g.T1oC\u001e,'\u000fE\u0002\u0015\u0003\u00132q!\u0001\u0002\t\u0002\u0011\tYe\u0005\u0003\u0002J59\u0002b\u0002\u001f\u0002J\u0011\u0005\u0011q\n\u000b\u0003\u0003\u000fB!\"a\u0015\u0002J\t\u0007I\u0011AA+\u0003-)e*\u0011\"M\u000b\u0012{6*R-\u0016\u0005\u0005]\u0003\u0003BA-\u0003Gj!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u0005Y\u0006twM\u0003\u0002\u0002b\u0005!!.\u0019<b\u0013\u0011\t)'a\u0017\u0003\rM#(/\u001b8h\u0011%\tI'!\u0013!\u0002\u0013\t9&\u0001\u0007F\u001d\u0006\u0013E*\u0012#`\u0017\u0016K\u0006\u0005\u0003\u0006\u0002n\u0005%#\u0019!C\u0001\u0003+\nAcU\"B\u0019&suiX%O)\u0016\u0013f+\u0011'`\u0017\u0016K\u0006\"CA9\u0003\u0013\u0002\u000b\u0011BA,\u0003U\u00196)\u0011'J\u001d\u001e{\u0016J\u0014+F%Z\u000bEjX&F3\u0002B\u0011\"!\u001e\u0002J\t\u0007I\u0011A,\u0002;M\u001b\u0015\tT%O\u000f~Ke\nV#S-\u0006cu\fR#G\u0003VcEkX*F\u0007NC\u0001\"!\u001f\u0002J\u0001\u0006I\u0001W\u0001\u001f'\u000e\u000bE*\u0013(H?&sE+\u0012*W\u00032{F)\u0012$B+2#vlU#D'\u0002B!\"! \u0002J\t\u0007I\u0011AA+\u0003Q\u00196)\u0011'J\u001d\u001e{V\u000bU0S\u0003RKujX&F3\"I\u0011\u0011QA%A\u0003%\u0011qK\u0001\u0016'\u000e\u000bE*\u0013(H?V\u0003vLU!U\u0013>{6*R-!\u0011%\t))!\u0013C\u0002\u0013\u00051*\u0001\rT\u0007\u0006c\u0015JT$`+B{&+\u0011+J\u001f~#UIR!V\u0019RC\u0001\"!#\u0002J\u0001\u0006I\u0001T\u0001\u001a'\u000e\u000bE*\u0013(H?V\u0003vLU!U\u0013>{F)\u0012$B+2#\u0006\u0005\u0003\u0006\u0002\u000e\u0006%#\u0019!C\u0001\u0003+\nacU\"B\u0019&sui\u0018#P/:{&+\u0011+J\u001f~[U)\u0017\u0005\n\u0003#\u000bI\u0005)A\u0005\u0003/\nqcU\"B\u0019&sui\u0018#P/:{&+\u0011+J\u001f~[U)\u0017\u0011\t\u0013\u0005U\u0015\u0011\nb\u0001\n\u0003Y\u0015AG*D\u00032KejR0E\u001f^suLU!U\u0013>{F)\u0012$B+2#\u0006\u0002CAM\u0003\u0013\u0002\u000b\u0011\u0002'\u00027M\u001b\u0015\tT%O\u000f~#uj\u0016(`%\u0006#\u0016jT0E\u000b\u001a\u000bU\u000b\u0014+!\u0011)\ti*!\u0013C\u0002\u0013\u0005\u0011QK\u0001\u0012\u001b&su,\u0012-F\u0007V#vJU*`\u0017\u0016K\u0006\"CAQ\u0003\u0013\u0002\u000b\u0011BA,\u0003Ii\u0015JT0F1\u0016\u001bU\u000bV(S'~[U)\u0017\u0011\t\u0015\u0005\u0015\u0016\u0011\nb\u0001\n\u0003\t)&A\tN\u0003b{V\tW#D+R{%kU0L\u000bfC\u0011\"!+\u0002J\u0001\u0006I!a\u0016\u0002%5\u000b\u0005lX#Y\u000b\u000e+Fk\u0014*T?.+\u0015\f\t\u0005\t\u0003[\u000bI\u0005\"\u0001\u00020\u0006Q\u0012n\u001d#z]\u0006l\u0017nY!mY>\u001c\u0017\r^5p]\u0016s\u0017M\u00197fIR!\u0011\u0011WA\\!\rq\u00111W\u0005\u0004\u0003k{!a\u0002\"p_2,\u0017M\u001c\u0005\u0007U\u0005-\u0006\u0019A\u0016\t\u0011\u0005m\u0016\u0011\nC\u0001\u0003{\u000bqb\u0019:fCR,\u0017JZ#oC\ndW\r\u001a\u000b\r\u0003\u007f\u000b)-a2\u0002J\u0006-\u0017Q\u001a\t\u0005\u001d\u0005\u0005g(C\u0002\u0002D>\u0011aa\u00149uS>t\u0007B\u0002\u0010\u0002:\u0002\u0007\u0001\u0005\u0003\u0004&\u0003s\u0003\rA\n\u0005\u0007U\u0005e\u0006\u0019A\u0016\t\r=\nI\f1\u00011\u0011\u0019!\u0014\u0011\u0018a\u0001k\u0001")
public class ExecutorAllocationManager
implements StreamingListener,
Logging {
    private final ExecutorAllocationClient client;
    private final ReceiverTracker receiverTracker;
    private final SparkConf conf;
    private final long batchDurationMs;
    private final long org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingIntervalSecs;
    private final double org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingUpRatio;
    private final double org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingDownRatio;
    private final int minNumExecutors;
    private final int maxNumExecutors;
    private final RecurringTimer timer;
    private volatile long org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeSum;
    private volatile int org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeCount;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<ExecutorAllocationManager> createIfEnabled(ExecutorAllocationClient executorAllocationClient, ReceiverTracker receiverTracker, SparkConf sparkConf, long l, Clock clock) {
        return ExecutorAllocationManager$.MODULE$.createIfEnabled(executorAllocationClient, receiverTracker, sparkConf, l, clock);
    }

    public static boolean isDynamicAllocationEnabled(SparkConf sparkConf) {
        return ExecutorAllocationManager$.MODULE$.isDynamicAllocationEnabled(sparkConf);
    }

    public static String MAX_EXECUTORS_KEY() {
        return ExecutorAllocationManager$.MODULE$.MAX_EXECUTORS_KEY();
    }

    public static String MIN_EXECUTORS_KEY() {
        return ExecutorAllocationManager$.MODULE$.MIN_EXECUTORS_KEY();
    }

    public static double SCALING_DOWN_RATIO_DEFAULT() {
        return ExecutorAllocationManager$.MODULE$.SCALING_DOWN_RATIO_DEFAULT();
    }

    public static String SCALING_DOWN_RATIO_KEY() {
        return ExecutorAllocationManager$.MODULE$.SCALING_DOWN_RATIO_KEY();
    }

    public static double SCALING_UP_RATIO_DEFAULT() {
        return ExecutorAllocationManager$.MODULE$.SCALING_UP_RATIO_DEFAULT();
    }

    public static String SCALING_UP_RATIO_KEY() {
        return ExecutorAllocationManager$.MODULE$.SCALING_UP_RATIO_KEY();
    }

    public static int SCALING_INTERVAL_DEFAULT_SECS() {
        return ExecutorAllocationManager$.MODULE$.SCALING_INTERVAL_DEFAULT_SECS();
    }

    public static String SCALING_INTERVAL_KEY() {
        return ExecutorAllocationManager$.MODULE$.SCALING_INTERVAL_KEY();
    }

    public static String ENABLED_KEY() {
        return ExecutorAllocationManager$.MODULE$.ENABLED_KEY();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    @Override
    public void onStreamingStarted(StreamingListenerStreamingStarted streamingStarted) {
        StreamingListener$class.onStreamingStarted(this, streamingStarted);
    }

    @Override
    public void onReceiverStarted(StreamingListenerReceiverStarted receiverStarted) {
        StreamingListener$class.onReceiverStarted(this, receiverStarted);
    }

    @Override
    public void onReceiverError(StreamingListenerReceiverError receiverError) {
        StreamingListener$class.onReceiverError(this, receiverError);
    }

    @Override
    public void onReceiverStopped(StreamingListenerReceiverStopped receiverStopped) {
        StreamingListener$class.onReceiverStopped(this, receiverStopped);
    }

    @Override
    public void onBatchSubmitted(StreamingListenerBatchSubmitted batchSubmitted) {
        StreamingListener$class.onBatchSubmitted(this, batchSubmitted);
    }

    @Override
    public void onBatchStarted(StreamingListenerBatchStarted batchStarted) {
        StreamingListener$class.onBatchStarted(this, batchStarted);
    }

    @Override
    public void onOutputOperationStarted(StreamingListenerOutputOperationStarted outputOperationStarted) {
        StreamingListener$class.onOutputOperationStarted(this, outputOperationStarted);
    }

    @Override
    public void onOutputOperationCompleted(StreamingListenerOutputOperationCompleted outputOperationCompleted) {
        StreamingListener$class.onOutputOperationCompleted(this, outputOperationCompleted);
    }

    public long org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingIntervalSecs() {
        return this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingIntervalSecs;
    }

    public double org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingUpRatio() {
        return this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingUpRatio;
    }

    public double org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingDownRatio() {
        return this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingDownRatio;
    }

    private int minNumExecutors() {
        return this.minNumExecutors;
    }

    private int maxNumExecutors() {
        return this.maxNumExecutors;
    }

    private RecurringTimer timer() {
        return this.timer;
    }

    public long org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeSum() {
        return this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeSum;
    }

    private void org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeSum_$eq(long x$1) {
        this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeSum = x$1;
    }

    public int org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeCount() {
        return this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeCount;
    }

    private void org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeCount_$eq(int x$1) {
        this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeCount = x$1;
    }

    public void start() {
        this.timer().start();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorAllocationManager $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ExecutorAllocationManager started with "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ratios = [", ", ", "] and interval = ", " sec"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingUpRatio()), BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingDownRatio()), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingIntervalSecs())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void stop() {
        this.timer().stop(true);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "ExecutorAllocationManager stopped";
            }
        });
    }

    public synchronized void org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$manageAllocation() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorAllocationManager $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Managing executor allocation with ratios = [", ", ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingUpRatio()), BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingDownRatio())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeCount() > 0) {
            long averageBatchProcTime = this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeSum() / (long)this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeCount();
            double ratio = (double)averageBatchProcTime / (double)this.batchDurationMs;
            this.logInfo((Function0<String>)new Serializable(this, averageBatchProcTime, ratio){
                public static final long serialVersionUID = 0L;
                private final long averageBatchProcTime$1;
                private final double ratio$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Average: ", ", ratio = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.averageBatchProcTime$1), BoxesRunTime.boxToDouble((double)this.ratio$1)}));
                }
                {
                    this.averageBatchProcTime$1 = averageBatchProcTime$1;
                    this.ratio$1 = ratio$1;
                }
            });
            if (ratio >= this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingUpRatio()) {
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Requesting executors";
                    }
                });
                int numNewExecutors = package$.MODULE$.max((int)package$.MODULE$.round(ratio), 1);
                this.requestExecutors(numNewExecutors);
            } else if (ratio <= this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingDownRatio()) {
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Killing executors";
                    }
                });
                this.killExecutor();
            }
        }
        this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeSum_$eq(0L);
        this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeCount_$eq(0);
    }

    private void requestExecutors(int numNewExecutors) {
        Predef$.MODULE$.require(numNewExecutors >= 1);
        Seq allExecIds = this.client.getExecutorIds();
        this.logDebug((Function0<String>)new Serializable(this, allExecIds){
            public static final long serialVersionUID = 0L;
            private final Seq allExecIds$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executors (", ") = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.allExecIds$1.size()), this.allExecIds$1}));
            }
            {
                this.allExecIds$1 = allExecIds$1;
            }
        });
        int targetTotalExecutors = package$.MODULE$.max(package$.MODULE$.min(this.maxNumExecutors(), allExecIds.size() + numNewExecutors), this.minNumExecutors());
        this.client.requestTotalExecutors(targetTotalExecutors, 0, Predef$.MODULE$.Map().empty());
        this.logInfo((Function0<String>)new Serializable(this, targetTotalExecutors){
            public static final long serialVersionUID = 0L;
            private final int targetTotalExecutors$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested total ", " executors"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.targetTotalExecutors$1)}));
            }
            {
                this.targetTotalExecutors$1 = targetTotalExecutors$1;
            }
        });
    }

    private void killExecutor() {
        Seq allExecIds = this.client.getExecutorIds();
        this.logDebug((Function0<String>)new Serializable(this, allExecIds){
            public static final long serialVersionUID = 0L;
            private final Seq allExecIds$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executors (", ") = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.allExecIds$2.size()), this.allExecIds$2}));
            }
            {
                this.allExecIds$2 = allExecIds$2;
            }
        });
        if (allExecIds.nonEmpty() && allExecIds.size() > this.minNumExecutors()) {
            Seq execIdsWithReceivers = ((TraversableOnce)this.receiverTracker.allocatedExecutors().values().flatten((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<String> apply(Option<String> xo) {
                    return Option$.MODULE$.option2Iterable(xo);
                }
            })).toSeq();
            this.logInfo((Function0<String>)new Serializable(this, execIdsWithReceivers){
                public static final long serialVersionUID = 0L;
                private final Seq execIdsWithReceivers$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executors with receivers (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.execIdsWithReceivers$1.size()), this.execIdsWithReceivers$1}));
                }
                {
                    this.execIdsWithReceivers$1 = execIdsWithReceivers$1;
                }
            });
            Seq removableExecIds = (Seq)allExecIds.diff((GenSeq)execIdsWithReceivers);
            this.logDebug((Function0<String>)new Serializable(this, removableExecIds){
                public static final long serialVersionUID = 0L;
                private final Seq removableExecIds$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removable executors (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.removableExecIds$1.size()), this.removableExecIds$1}));
                }
                {
                    this.removableExecIds$1 = removableExecIds$1;
                }
            });
            if (removableExecIds.nonEmpty()) {
                String execIdToRemove = (String)removableExecIds.apply(Random$.MODULE$.nextInt(removableExecIds.size()));
                this.client.killExecutor(execIdToRemove);
                this.logInfo((Function0<String>)new Serializable(this, execIdToRemove){
                    public static final long serialVersionUID = 0L;
                    private final String execIdToRemove$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested to kill executor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.execIdToRemove$1}));
                    }
                    {
                        this.execIdToRemove$1 = execIdToRemove$1;
                    }
                });
            } else {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No non-receiver executors to kill"})).s((Seq)Nil$.MODULE$);
                    }
                });
            }
        } else {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "No available executor to kill";
                }
            });
        }
    }

    public synchronized void org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$addBatchProcTime(long timeMs) {
        this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeSum_$eq(this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeSum() + timeMs);
        this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeCount_$eq(this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeCount() + 1);
        this.logDebug((Function0<String>)new Serializable(this, timeMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorAllocationManager $outer;
            private final long timeMs$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Added batch processing time ", ", sum = ", ", count = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeMs$1), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeSum()), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeCount())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timeMs$1 = timeMs$1;
            }
        });
    }

    private void validateSettings() {
        Predef$.MODULE$.require(this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingIntervalSecs() > 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Config ", " must be more than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ExecutorAllocationManager$.MODULE$.SCALING_INTERVAL_KEY()}));
            }
        });
        Predef$.MODULE$.require(this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingUpRatio() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Config ", " must be more than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ExecutorAllocationManager$.MODULE$.SCALING_UP_RATIO_KEY()}));
            }
        });
        Predef$.MODULE$.require(this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingDownRatio() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Config ", " must be more than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ExecutorAllocationManager$.MODULE$.SCALING_DOWN_RATIO_KEY()}));
            }
        });
        Predef$.MODULE$.require(this.minNumExecutors() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Config ", " must be more than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ExecutorAllocationManager$.MODULE$.MIN_EXECUTORS_KEY()}));
            }
        });
        Predef$.MODULE$.require(this.maxNumExecutors() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " must be more than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ExecutorAllocationManager$.MODULE$.MAX_EXECUTORS_KEY()}));
            }
        });
        Predef$.MODULE$.require(this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingUpRatio() > this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingDownRatio(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Config ", " must be more than config ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ExecutorAllocationManager$.MODULE$.SCALING_UP_RATIO_KEY(), ExecutorAllocationManager$.MODULE$.SCALING_DOWN_RATIO_KEY()}));
            }
        });
        if (this.conf.contains(ExecutorAllocationManager$.MODULE$.MIN_EXECUTORS_KEY()) && this.conf.contains(ExecutorAllocationManager$.MODULE$.MAX_EXECUTORS_KEY())) {
            Predef$.MODULE$.require(this.maxNumExecutors() >= this.minNumExecutors(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Config ", " must be more than config ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ExecutorAllocationManager$.MODULE$.MAX_EXECUTORS_KEY(), ExecutorAllocationManager$.MODULE$.MIN_EXECUTORS_KEY()}));
                }
            });
        }
    }

    @Override
    public void onBatchCompleted(StreamingListenerBatchCompleted batchCompleted) {
        this.logDebug((Function0<String>)new Serializable(this, batchCompleted){
            public static final long serialVersionUID = 0L;
            private final StreamingListenerBatchCompleted batchCompleted$1;

            public final String apply() {
                return new StringBuilder().append((Object)"onBatchCompleted called: ").append((Object)this.batchCompleted$1).toString();
            }
            {
                this.batchCompleted$1 = batchCompleted$1;
            }
        });
        if (!batchCompleted.batchInfo().outputOperationInfos().values().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(OutputOperationInfo x$2) {
                return x$2.failureReason().nonEmpty();
            }
        })) {
            batchCompleted.batchInfo().processingDelay().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExecutorAllocationManager $outer;

                public final void apply(long timeMs) {
                    this.apply$mcVJ$sp(timeMs);
                }

                public void apply$mcVJ$sp(long timeMs) {
                    this.$outer.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$addBatchProcTime(timeMs);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public ExecutorAllocationManager(ExecutorAllocationClient client, ReceiverTracker receiverTracker, SparkConf conf, long batchDurationMs, Clock clock) {
        this.client = client;
        this.receiverTracker = receiverTracker;
        this.conf = conf;
        this.batchDurationMs = batchDurationMs;
        StreamingListener$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingIntervalSecs = conf.getTimeAsSeconds(ExecutorAllocationManager$.MODULE$.SCALING_INTERVAL_KEY(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ExecutorAllocationManager$.MODULE$.SCALING_INTERVAL_DEFAULT_SECS())})));
        this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingUpRatio = conf.getDouble(ExecutorAllocationManager$.MODULE$.SCALING_UP_RATIO_KEY(), ExecutorAllocationManager$.MODULE$.SCALING_UP_RATIO_DEFAULT());
        this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingDownRatio = conf.getDouble(ExecutorAllocationManager$.MODULE$.SCALING_DOWN_RATIO_KEY(), ExecutorAllocationManager$.MODULE$.SCALING_DOWN_RATIO_DEFAULT());
        this.minNumExecutors = conf.getInt(ExecutorAllocationManager$.MODULE$.MIN_EXECUTORS_KEY(), package$.MODULE$.max(1, receiverTracker.numReceivers()));
        this.maxNumExecutors = conf.getInt(ExecutorAllocationManager$.MODULE$.MAX_EXECUTORS_KEY(), Integer.MAX_VALUE);
        this.timer = new RecurringTimer(clock, this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$scalingIntervalSecs() * 1000L, (Function1<Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorAllocationManager $outer;

            public final void apply(long x$1) {
                this.apply$mcVJ$sp(x$1);
            }

            public void apply$mcVJ$sp(long x$1) {
                this.$outer.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$manageAllocation();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "streaming-executor-allocation-manager");
        this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeSum = 0L;
        this.org$apache$spark$streaming$scheduler$ExecutorAllocationManager$$batchProcTimeCount = 0;
        this.validateSettings();
    }
}

