/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.ui;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringEscapeUtils;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public final class UIUtils$ {
    public static final UIUtils$ MODULE$;

    static {
        new UIUtils$();
    }

    public String shortTimeUnitString(TimeUnit unit) {
        TimeUnit timeUnit;
        block9: {
            String string;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        timeUnit = unit;
                                        if (!((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit)) break block2;
                                        string = "ns";
                                        break block3;
                                    }
                                    if (!((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit)) break block4;
                                    string = "us";
                                    break block3;
                                }
                                if (!((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit)) break block5;
                                string = "ms";
                                break block3;
                            }
                            if (!((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit)) break block6;
                            string = "sec";
                            break block3;
                        }
                        if (!((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit)) break block7;
                        string = "min";
                        break block3;
                    }
                    if (!((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit)) break block8;
                    string = "hrs";
                    break block3;
                }
                if (!((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit)) break block9;
                string = "days";
            }
            return string;
        }
        throw new MatchError((Object)timeUnit);
    }

    public Tuple2<Object, TimeUnit> normalizeDuration(long milliseconds) {
        if (milliseconds < 1000L) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)milliseconds), (Object)TimeUnit.MILLISECONDS);
        }
        double seconds = (double)milliseconds / (double)1000;
        if (seconds < (double)60) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)seconds), (Object)TimeUnit.SECONDS);
        }
        double minutes = seconds / (double)60;
        if (minutes < (double)60) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)minutes), (Object)TimeUnit.MINUTES);
        }
        double hours = minutes / (double)60;
        if (hours < (double)24) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)hours), (Object)TimeUnit.HOURS);
        }
        double days = hours / (double)24;
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)days), (Object)TimeUnit.DAYS);
    }

    public double convertToTimeUnit(long milliseconds, TimeUnit unit) {
        TimeUnit timeUnit;
        block9: {
            double d;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        timeUnit = unit;
                                        if (!((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit)) break block2;
                                        d = milliseconds * 1000L * 1000L;
                                        break block3;
                                    }
                                    if (!((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit)) break block4;
                                    d = milliseconds * 1000L;
                                    break block3;
                                }
                                if (!((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit)) break block5;
                                d = milliseconds;
                                break block3;
                            }
                            if (!((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit)) break block6;
                            d = (double)milliseconds / 1000.0;
                            break block3;
                        }
                        if (!((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit)) break block7;
                        d = (double)milliseconds / 1000.0 / 60.0;
                        break block3;
                    }
                    if (!((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit)) break block8;
                    d = (double)milliseconds / 1000.0 / 60.0 / 60.0;
                    break block3;
                }
                if (!((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit)) break block9;
                d = (double)milliseconds / 1000.0 / 60.0 / 60.0 / 24.0;
            }
            return d;
        }
        throw new MatchError((Object)timeUnit);
    }

    public String createOutputOperationFailureForUI(String failure) {
        String string;
        if (failure.startsWith("org.apache.spark.Spark")) {
            string = new StringBuilder().append((Object)"Failed due to Spark job error\n").append((Object)failure).toString();
        } else {
            int nextLineIndex = failure.indexOf("\n");
            if (nextLineIndex < 0) {
                nextLineIndex = failure.length();
            }
            String firstLine = failure.substring(0, nextLineIndex);
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed due to error: ", "\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstLine, failure}));
        }
        return string;
    }

    public Seq<Node> failureReasonCell(String failureReason, int rowspan, boolean includeFirstLineInExpandDetails) {
        Elem elem;
        boolean isMultiline = failureReason.indexOf(10) >= 0;
        String failureReasonSummary = StringEscapeUtils.escapeHtml4((String)(isMultiline ? failureReason.substring(0, failureReason.indexOf(10)) : failureReason));
        String failureDetails = isMultiline && !includeFirstLineInExpandDetails ? failureReason.substring(failureReason.indexOf(10) + 1) : failureReason;
        Seq details = org.apache.spark.ui.UIUtils$.MODULE$.detailsUINode(isMultiline, failureDetails);
        if (rowspan == 1) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("style", (Seq)new Text("max-width: 300px"), (MetaData)$md);
            $md = new UnprefixedAttribute("valign", (Seq)new Text("middle"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)failureReasonSummary);
            $buf.$amp$plus((Object)details);
            Elem elem2 = new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            elem = elem2;
        } else {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("rowspan", ((Object)BoxesRunTime.boxToInteger((int)rowspan)).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("style", (Seq)new Text("max-width: 300px"), (MetaData)$md);
            $md = new UnprefixedAttribute("valign", (Seq)new Text("middle"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)failureReasonSummary);
            $buf.$amp$plus((Object)details);
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem elem3 = new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            elem = elem3;
        }
        return elem;
    }

    public int failureReasonCell$default$2() {
        return 1;
    }

    public boolean failureReasonCell$default$3() {
        return true;
    }

    private UIUtils$() {
        MODULE$ = this;
    }
}

