/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.FailureTracker;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.BlacklistTracker$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=e!B\u0001\u0003\u0001\u0019a!!H-be:\fE\u000e\\8dCR|'O\u00117bG.d\u0017n\u001d;Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011\u0001B=be:T!!\u0002\u0004\u0002\r\u0011,\u0007\u000f\\8z\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e'A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001G\u000b\u0003\u000f1{wmZ5oO\"A!\u0004\u0001B\u0001B\u0003%A$A\u0005ta\u0006\u00148nQ8oM\u000e\u0001\u0001CA\u000f\u001f\u001b\u00051\u0011BA\u0010\u0007\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003!\tWn\u00117jK:$\bcA\u0012,[5\tAE\u0003\u0002&M\u0005\u0019\u0011\r]5\u000b\u0005\u001dB\u0013AB2mS\u0016tGO\u0003\u0002\u0004S)\u0011!\u0006C\u0001\u0007Q\u0006$wn\u001c9\n\u00051\"#AC!N%6\u001bE.[3oiB\u0011a\u0006\u0011\b\u0003_yr!\u0001M\u001f\u000f\u0005EbdB\u0001\u001a<\u001d\t\u0019$H\u0004\u00025s9\u0011Q\u0007O\u0007\u0002m)\u0011qgG\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005)B\u0011BA\u0002*\u0013\t9\u0003&\u0003\u0002&M%\u0011q\bJ\u0001\u000b\u00036\u0013Vj\u00117jK:$\u0018BA!C\u0005A\u0019uN\u001c;bS:,'OU3rk\u0016\u001cHO\u0003\u0002@I!AA\t\u0001B\u0001B\u0003%Q)\u0001\bgC&dWO]3Ue\u0006\u001c7.\u001a:\u0011\u0005\u0019;U\"\u0001\u0002\n\u0005!\u0013!A\u0004$bS2,(/\u001a+sC\u000e\\WM\u001d\u0005\u0006\u0015\u0002!\taS\u0001\u0007y%t\u0017\u000e\u001e \u0015\t1kej\u0014\t\u0003\r\u0002AQAG%A\u0002qAQ!I%A\u0002\tBQ\u0001R%A\u0002\u0015Cq!\u0015\u0001C\u0002\u0013%!+\u0001\fcY\u0006\u001c7\u000e\\5tiRKW.Z8vi6KG\u000e\\5t+\u0005\u0019\u0006C\u0001\bU\u0013\t)vB\u0001\u0003M_:<\u0007BB,\u0001A\u0003%1+A\fcY\u0006\u001c7\u000e\\5tiRKW.Z8vi6KG\u000e\\5tA!9\u0011\f\u0001b\u0001\n\u0013Q\u0016A\u00067bk:\u001c\u0007N\u00117bG.d\u0017n\u001d;F]\u0006\u0014G.\u001a3\u0016\u0003m\u0003\"A\u0004/\n\u0005u{!a\u0002\"p_2,\u0017M\u001c\u0005\u0007?\u0002\u0001\u000b\u0011B.\u0002/1\fWO\\2i\u00052\f7m\u001b7jgR,e.\u00192mK\u0012\u0004\u0003bB1\u0001\u0005\u0004%IAY\u0001\u0013[\u0006Dh)Y5mkJ,7\u000fU3s\u0011>\u001cH/F\u0001d!\tqA-\u0003\u0002f\u001f\t\u0019\u0011J\u001c;\t\r\u001d\u0004\u0001\u0015!\u0003d\u0003Mi\u0017\r\u001f$bS2,(/Z:QKJDun\u001d;!\u0011\u001dI\u0007A1A\u0005\n)\fA\"\u001a=dYV$WMT8eKN,\u0012a\u001b\t\u0004YF\u001cX\"A7\u000b\u00059|\u0017!C5n[V$\u0018M\u00197f\u0015\t\u0001x\"\u0001\u0006d_2dWm\u0019;j_:L!A]7\u0003\u0007M+G\u000f\u0005\u0002uo:\u0011a\"^\u0005\u0003m>\ta\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\u0019\u0019FO]5oO*\u0011ao\u0004\u0005\u0007w\u0002\u0001\u000b\u0011B6\u0002\u001b\u0015D8\r\\;eK:{G-Z:!\u0011\u001di\bA1A\u0005\ny\f!#\u00197m_\u000e\fGo\u001c:CY\u0006\u001c7\u000e\\5tiV\tq\u0010\u0005\u0004\u0002\u0002\u0005\u001d1oU\u0007\u0003\u0003\u0007Q1!!\u0002p\u0003\u001diW\u000f^1cY\u0016LA!!\u0003\u0002\u0004\t9\u0001*Y:i\u001b\u0006\u0004\bbBA\u0007\u0001\u0001\u0006Ia`\u0001\u0014C2dwnY1u_J\u0014E.Y2lY&\u001cH\u000f\t\u0005\t\u0003#\u0001\u0001\u0019!C\u0005U\u0006Y2-\u001e:sK:$(\t\\1dW2L7\u000f^3e3\u0006\u0014hNT8eKND\u0011\"!\u0006\u0001\u0001\u0004%I!a\u0006\u0002?\r,(O]3oi\nc\u0017mY6mSN$X\rZ-be:tu\u000eZ3t?\u0012*\u0017\u000f\u0006\u0003\u0002\u001a\u0005}\u0001c\u0001\b\u0002\u001c%\u0019\u0011QD\b\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003C\t\u0019\"!AA\u0002-\f1\u0001\u001f\u00132\u0011\u001d\t)\u0003\u0001Q!\n-\fAdY;se\u0016tGO\u00117bG.d\u0017n\u001d;fIf\u000b'O\u001c(pI\u0016\u001c\b\u0005\u0003\u0005\u0002*\u0001\u0001\r\u0011\"\u0003k\u0003I\u00198\r[3ek2,'O\u00117bG.d\u0017n\u001d;\t\u0013\u00055\u0002\u00011A\u0005\n\u0005=\u0012AF:dQ\u0016$W\u000f\\3s\u00052\f7m\u001b7jgR|F%Z9\u0015\t\u0005e\u0011\u0011\u0007\u0005\n\u0003C\tY#!AA\u0002-Dq!!\u000e\u0001A\u0003&1.A\ntG\",G-\u001e7fe\nc\u0017mY6mSN$\b\u0005\u0003\u0005\u0002:\u0001\u0001\r\u0011\"\u0003c\u0003=qW/\\\"mkN$XM\u001d(pI\u0016\u001c\b\"CA\u001f\u0001\u0001\u0007I\u0011BA \u0003MqW/\\\"mkN$XM\u001d(pI\u0016\u001cx\fJ3r)\u0011\tI\"!\u0011\t\u0013\u0005\u0005\u00121HA\u0001\u0002\u0004\u0019\u0007bBA#\u0001\u0001\u0006KaY\u0001\u0011]Vl7\t\\;ti\u0016\u0014hj\u001c3fg\u0002Bq!!\u0013\u0001\t\u0003\tY%\u0001\ntKRtU/\\\"mkN$XM\u001d(pI\u0016\u001cH\u0003BA\r\u0003\u001bBq!!\u000f\u0002H\u0001\u00071\rC\u0004\u0002R\u0001!\t!a\u0015\u0002?!\fg\u000e\u001a7f%\u0016\u001cx.\u001e:dK\u0006cGn\\2bi&|gNR1jYV\u0014X\r\u0006\u0003\u0002\u001a\u0005U\u0003\u0002CA,\u0003\u001f\u0002\r!!\u0017\u0002\u000f!|7\u000f^(qiB!a\"a\u0017t\u0013\r\tif\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d\u0005\u0001S\u000f\u001d3bi\u0016\fE\u000e\\8dCRLwN\u001c\"mC\u000e\\G.[:uK\u0012tu\u000eZ3t)\u0011\tI\"!\u001a\t\u000f\u0005\u001d\u0014q\fa\u0001g\u0006A\u0001n\\:u]\u0006lW\rC\u0004\u0002l\u0001!\t!!\u001c\u00029M,GoU2iK\u0012,H.\u001a:CY\u0006\u001c7\u000e\\5ti\u0016$gj\u001c3fgR!\u0011\u0011DA8\u0011!\t\t(!\u001bA\u0002\u0005M\u0014aI:dQ\u0016$W\u000f\\3s\u00052\f7m\u001b7jgR,GMT8eKN<\u0016\u000e\u001e5FqBL'/\u001f\t\u0005i\u0006U4/\u0003\u0002ss\"1\u0011\u0011\u0010\u0001\u0005\u0002i\u000bA#[:BY2tu\u000eZ3CY\u0006\u001c7\u000e\\5ti\u0016$\u0007bBA?\u0001\u0011%\u0011qP\u0001\u0018e\u00164'/Z:i\u00052\f7m\u001b7jgR,GMT8eKN$\"!!\u0007\t\u000f\u0005\r\u0005\u0001\"\u0003\u0002\u0006\u0006\u00113/\u001f8dQJ|g.\u001b>f\u00052\f7m\u001b7jgR,GMT8eK^KG\u000f[-be:$B!!\u0007\u0002\b\"A\u0011\u0011RAA\u0001\u0004\t\u0019(\u0001\to_\u0012,7\u000fV8CY\u0006\u001c7\u000e\\5ti\"9\u0011Q\u0012\u0001\u0005\n\u0005}\u0014!\t:f[>4X-\u0012=qSJ,G-W1s]\nc\u0017mY6mSN$X\r\u001a(pI\u0016\u001c\b")
public class YarnAllocatorBlacklistTracker
implements Logging {
    private final AMRMClient<AMRMClient.ContainerRequest> amClient;
    private final FailureTracker failureTracker;
    private final long blacklistTimeoutMillis;
    private final boolean launchBlacklistEnabled;
    private final int maxFailuresPerHost;
    private final Set<String> excludeNodes;
    private final HashMap<String, Object> allocatorBlacklist;
    private Set<String> currentBlacklistedYarnNodes;
    private Set<String> schedulerBlacklist;
    private int numClusterNodes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private long blacklistTimeoutMillis() {
        return this.blacklistTimeoutMillis;
    }

    private boolean launchBlacklistEnabled() {
        return this.launchBlacklistEnabled;
    }

    private int maxFailuresPerHost() {
        return this.maxFailuresPerHost;
    }

    private Set<String> excludeNodes() {
        return this.excludeNodes;
    }

    private HashMap<String, Object> allocatorBlacklist() {
        return this.allocatorBlacklist;
    }

    private Set<String> currentBlacklistedYarnNodes() {
        return this.currentBlacklistedYarnNodes;
    }

    private void currentBlacklistedYarnNodes_$eq(Set<String> x$1) {
        this.currentBlacklistedYarnNodes = x$1;
    }

    private Set<String> schedulerBlacklist() {
        return this.schedulerBlacklist;
    }

    private void schedulerBlacklist_$eq(Set<String> x$1) {
        this.schedulerBlacklist = x$1;
    }

    private int numClusterNodes() {
        return this.numClusterNodes;
    }

    private void numClusterNodes_$eq(int x$1) {
        this.numClusterNodes = x$1;
    }

    public void setNumClusterNodes(int numClusterNodes) {
        this.numClusterNodes_$eq(numClusterNodes);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleResourceAllocationFailure(Option<String> hostOpt) {
        Option<String> option = hostOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String hostname = (String)some.x();
            if (this.launchBlacklistEnabled()) {
                BoxedUnit boxedUnit;
                if (this.schedulerBlacklist().contains((Object)hostname) || this.allocatorBlacklist().contains((Object)hostname)) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.failureTracker.registerFailureOnHost(hostname);
                    this.updateAllocationBlacklistedNodes(hostname);
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return;
            }
        }
        this.failureTracker.registerExecutorFailure();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void updateAllocationBlacklistedNodes(String hostname) {
        int failuresOnHost = this.failureTracker.numFailuresOnHost(hostname);
        if (failuresOnHost > this.maxFailuresPerHost()) {
            this.logInfo((Function0<String>)new Serializable(this, hostname, failuresOnHost){
                public static final long serialVersionUID = 0L;
                private final String hostname$2;
                private final int failuresOnHost$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blacklisting ", " as YARN allocation failed ", " times"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname$2, BoxesRunTime.boxToInteger((int)this.failuresOnHost$1)}));
                }
                {
                    this.hostname$2 = hostname$2;
                    this.failuresOnHost$1 = failuresOnHost$1;
                }
            });
            this.allocatorBlacklist().put((Object)hostname, (Object)BoxesRunTime.boxToLong((long)(this.failureTracker.clock().getTimeMillis() + this.blacklistTimeoutMillis())));
            this.refreshBlacklistedNodes();
        }
    }

    public void setSchedulerBlacklistedNodes(Set<String> schedulerBlacklistedNodesWithExpiry) {
        this.schedulerBlacklist_$eq(schedulerBlacklistedNodesWithExpiry);
        this.refreshBlacklistedNodes();
    }

    public boolean isAllNodeBlacklisted() {
        return this.currentBlacklistedYarnNodes().size() >= this.numClusterNodes();
    }

    private void refreshBlacklistedNodes() {
        this.removeExpiredYarnBlacklistedNodes();
        Set allBlacklistedNodes = (Set)this.excludeNodes().$plus$plus(this.schedulerBlacklist()).$plus$plus((GenTraversableOnce)this.allocatorBlacklist().keySet());
        this.synchronizeBlacklistedNodeWithYarn((Set<String>)allBlacklistedNodes);
    }

    private void synchronizeBlacklistedNodeWithYarn(Set<String> nodesToBlacklist) {
        List additions = (List)((TraversableOnce)nodesToBlacklist.$minus$minus(this.currentBlacklistedYarnNodes())).toList().sorted((Ordering)Ordering.String$.MODULE$);
        List removals = (List)((TraversableOnce)this.currentBlacklistedYarnNodes().$minus$minus(nodesToBlacklist)).toList().sorted((Ordering)Ordering.String$.MODULE$);
        if (additions.nonEmpty()) {
            this.logInfo((Function0<String>)new Serializable(this, additions){
                public static final long serialVersionUID = 0L;
                private final List additions$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"adding nodes to YARN application master's blacklist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.additions$1}));
                }
                {
                    this.additions$1 = additions$1;
                }
            });
        }
        if (removals.nonEmpty()) {
            this.logInfo((Function0<String>)new Serializable(this, removals){
                public static final long serialVersionUID = 0L;
                private final List removals$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"removing nodes from YARN application master's blacklist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.removals$1}));
                }
                {
                    this.removals$1 = removals$1;
                }
            });
        }
        if (additions.nonEmpty() || removals.nonEmpty()) {
            this.amClient.updateBlacklist((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)additions).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)removals).asJava());
        }
        this.currentBlacklistedYarnNodes_$eq(nodesToBlacklist);
    }

    private void removeExpiredYarnBlacklistedNodes() {
        long now = this.failureTracker.clock().getTimeMillis();
        this.allocatorBlacklist().retain((Function2)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final long now$1;

            public final boolean apply(String x$1, long expiryTime) {
                return expiryTime > this.now$1;
            }
            {
                this.now$1 = now$1;
            }
        });
    }

    public YarnAllocatorBlacklistTracker(SparkConf sparkConf, AMRMClient<AMRMClient.ContainerRequest> amClient, FailureTracker failureTracker) {
        this.amClient = amClient;
        this.failureTracker = failureTracker;
        Logging.class.$init$((Logging)this);
        this.blacklistTimeoutMillis = BlacklistTracker$.MODULE$.getBlacklistTimeout(sparkConf);
        this.launchBlacklistEnabled = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.YARN_EXECUTOR_LAUNCH_BLACKLIST_ENABLED()));
        this.maxFailuresPerHost = BoxesRunTime.unboxToInt((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.MAX_FAILED_EXEC_PER_NODE()));
        this.excludeNodes = ((TraversableOnce)sparkConf.get(package$.MODULE$.YARN_EXCLUDE_NODES())).toSet();
        this.allocatorBlacklist = new HashMap();
        this.currentBlacklistedYarnNodes = Predef$.MODULE$.Set().empty();
        this.schedulerBlacklist = Predef$.MODULE$.Set().empty();
        this.numClusterNodes = Integer.MAX_VALUE;
    }
}

