/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.Client$;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.deploy.yarn.YarnAppReport;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.OptionalConfigEntry;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark_project.guava.base.Objects;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Client$
implements Logging {
    public static final Client$ MODULE$;
    private final String APP_JAR_NAME;
    private final String SPARK_STAGING;
    private final FsPermission STAGING_DIR_PERMISSION;
    private final FsPermission APP_FILE_PERMISSION;
    private final String ENV_DIST_CLASSPATH;
    private final String LOCALIZED_CONF_DIR;
    private final String LOCALIZED_HADOOP_CONF_DIR;
    private final String LOCALIZED_CONF_ARCHIVE;
    private final String SPARK_CONF_FILE;
    private final String DIST_CACHE_CONF_FILE;
    private final String LOCALIZED_PYTHON_DIR;
    private final String LOCALIZED_LIB_DIR;
    private final String LOCALIZED_HIVE_LIB_DIR;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new Client$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public String APP_JAR_NAME() {
        return this.APP_JAR_NAME;
    }

    public String SPARK_STAGING() {
        return this.SPARK_STAGING;
    }

    public FsPermission STAGING_DIR_PERMISSION() {
        return this.STAGING_DIR_PERMISSION;
    }

    public FsPermission APP_FILE_PERMISSION() {
        return this.APP_FILE_PERMISSION;
    }

    public String ENV_DIST_CLASSPATH() {
        return this.ENV_DIST_CLASSPATH;
    }

    public String LOCALIZED_CONF_DIR() {
        return this.LOCALIZED_CONF_DIR;
    }

    public String LOCALIZED_HADOOP_CONF_DIR() {
        return this.LOCALIZED_HADOOP_CONF_DIR;
    }

    public String LOCALIZED_CONF_ARCHIVE() {
        return this.LOCALIZED_CONF_ARCHIVE;
    }

    public String SPARK_CONF_FILE() {
        return this.SPARK_CONF_FILE;
    }

    public String DIST_CACHE_CONF_FILE() {
        return this.DIST_CACHE_CONF_FILE;
    }

    public String LOCALIZED_PYTHON_DIR() {
        return this.LOCALIZED_PYTHON_DIR;
    }

    public String LOCALIZED_LIB_DIR() {
        return this.LOCALIZED_LIB_DIR;
    }

    public String LOCALIZED_HIVE_LIB_DIR() {
        return this.LOCALIZED_HIVE_LIB_DIR;
    }

    public String org$apache$spark$deploy$yarn$Client$$getAppStagingDir(ApplicationId appId) {
        return this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.SPARK_STAGING(), appId.toString()}));
    }

    public void populateHadoopClasspath(Configuration conf, HashMap<String, String> env) {
        Seq classPathElementsToAdd = (Seq)this.getYarnAppClasspath(conf).$plus$plus(this.getMRAppClasspath(conf), Seq$.MODULE$.canBuildFrom());
        classPathElementsToAdd.foreach((Function1)new Serializable(env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$3;

            public final void apply(String c) {
                YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)this.env$3, ApplicationConstants.Environment.CLASSPATH.name(), c.trim());
            }
            {
                this.env$3 = env$3;
            }
        });
    }

    private Seq<String> getYarnAppClasspath(Configuration conf) {
        Option option;
        block4: {
            Seq seq;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)conf.getStrings("yarn.application.classpath"));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String[] s = (String[])some.x();
                    seq = Predef$.MODULE$.refArrayOps((Object[])s).toSeq();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                seq = this.getDefaultYarnApplicationClasspath();
            }
            return seq;
        }
        throw new MatchError((Object)option);
    }

    private Seq<String> getMRAppClasspath(Configuration conf) {
        Option option;
        block4: {
            Seq seq;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)conf.getStrings("mapreduce.application.classpath"));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String[] s = (String[])some.x();
                    seq = Predef$.MODULE$.refArrayOps((Object[])s).toSeq();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                seq = this.getDefaultMRApplicationClasspath();
            }
            return seq;
        }
        throw new MatchError((Object)option);
    }

    public Seq<String> getDefaultYarnApplicationClasspath() {
        return Predef$.MODULE$.refArrayOps((Object[])YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH).toSeq();
    }

    public Seq<String> getDefaultMRApplicationClasspath() {
        return Predef$.MODULE$.refArrayOps((Object[])StringUtils.getStrings((String)MRJobConfig.DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH)).toSeq();
    }

    public void populateClasspath(ClientArguments args, Configuration conf, SparkConf sparkConf, HashMap<String, String> env, Option<String> extraClassPath) {
        extraClassPath.foreach((Function1)new Serializable(sparkConf, env){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$1;
            private final HashMap env$2;

            public final void apply(String cp) {
                Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(Client$.MODULE$.getClusterPath(this.sparkConf$1, cp), (HashMap<String, String>)this.env$2);
            }
            {
                this.sparkConf$1 = sparkConf$1;
                this.env$2 = env$2;
            }
        });
        this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(ApplicationConstants.Environment.PWD.$$(), env);
        this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(new StringBuilder().append((Object)ApplicationConstants.Environment.PWD.$$()).append((Object)"/").append((Object)this.LOCALIZED_CONF_DIR()).toString(), env);
        if (BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.USER_CLASS_PATH_FIRST()))) {
            Option<URI> mainJar = args == null ? this.getMainJarUri((Option<String>)((Option)sparkConf.get(package$.MODULE$.APP_JAR()))) : this.getMainJarUri((Option<String>)Option$.MODULE$.apply((Object)args.userJar()));
            mainJar.foreach((Function1)new Serializable(conf, sparkConf, env){
                public static final long serialVersionUID = 0L;
                private final Configuration conf$1;
                private final SparkConf sparkConf$1;
                private final HashMap env$2;

                public final void apply(URI x$20) {
                    Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addFileToClasspath(this.sparkConf$1, this.conf$1, x$20, Client$.MODULE$.APP_JAR_NAME(), (HashMap<String, String>)this.env$2);
                }
                {
                    this.conf$1 = conf$1;
                    this.sparkConf$1 = sparkConf$1;
                    this.env$2 = env$2;
                }
            });
            Seq<URI> secondaryJars = args == null ? this.getSecondaryJarUris((Option<Seq<String>>)((Option)sparkConf.get(package$.MODULE$.SECONDARY_JARS()))) : this.getSecondaryJarUris((Option<Seq<String>>)Option$.MODULE$.apply(sparkConf.get(package$.MODULE$.JARS_TO_DISTRIBUTE())));
            secondaryJars.foreach((Function1)new Serializable(conf, sparkConf, env){
                public static final long serialVersionUID = 0L;
                private final Configuration conf$1;
                private final SparkConf sparkConf$1;
                private final HashMap env$2;

                public final void apply(URI x) {
                    Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addFileToClasspath(this.sparkConf$1, this.conf$1, x, null, (HashMap<String, String>)this.env$2);
                }
                {
                    this.conf$1 = conf$1;
                    this.sparkConf$1 = sparkConf$1;
                    this.env$2 = env$2;
                }
            });
        }
        this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), this.LOCALIZED_LIB_DIR(), "*"})), env);
        if (((Option)sparkConf.get(package$.MODULE$.SPARK_ARCHIVE())).isEmpty()) {
            ((Option)sparkConf.get(package$.MODULE$.SPARK_JARS())).foreach((Function1)new Serializable(sparkConf, env){
                public static final long serialVersionUID = 0L;
                public final SparkConf sparkConf$1;
                public final HashMap env$2;

                public final void apply(Seq<String> jars) {
                    ((IterableLike)jars.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String uri) {
                            return Utils$.MODULE$.isLocalUri(uri);
                        }
                    })).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.populateClasspath.4 $outer;

                        public final void apply(String jar) {
                            URI uri = new URI(jar);
                            Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(Client$.MODULE$.getClusterPath(this.$outer.sparkConf$1, uri.getPath()), (HashMap<String, String>)this.$outer.env$2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.sparkConf$1 = sparkConf$1;
                    this.env$2 = env$2;
                }
            });
        }
        if (BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.POPULATE_HADOOP_CLASSPATH()))) {
            this.populateHadoopClasspath(conf, env);
        }
        scala.sys.package$.MODULE$.env().get((Object)this.ENV_DIST_CLASSPATH()).foreach((Function1)new Serializable(sparkConf, env){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$1;
            private final HashMap env$2;

            public final void apply(String cp) {
                Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(Client$.MODULE$.getClusterPath(this.sparkConf$1, cp), (HashMap<String, String>)this.env$2);
            }
            {
                this.sparkConf$1 = sparkConf$1;
                this.env$2 = env$2;
            }
        });
        this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), this.LOCALIZED_CONF_DIR(), this.LOCALIZED_HADOOP_CONF_DIR()})), env);
    }

    public Option<String> populateClasspath$default$5() {
        return None$.MODULE$;
    }

    public URI[] getUserClasspath(SparkConf conf) {
        Option<URI> mainUri = this.getMainJarUri((Option<String>)((Option)conf.get(package$.MODULE$.APP_JAR())));
        Seq<URI> secondaryUris = this.getSecondaryJarUris((Option<Seq<String>>)((Option)conf.get(package$.MODULE$.SECONDARY_JARS())));
        return (URI[])((TraversableOnce)Option$.MODULE$.option2Iterable(mainUri).$plus$plus(secondaryUris, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(URI.class));
    }

    private Option<URI> getMainJarUri(Option<String> mainJar) {
        return mainJar.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<URI> apply(String path) {
                URI uri = Utils$.MODULE$.resolveURI(path);
                String string = uri.getScheme();
                String string2 = Utils$.MODULE$.LOCAL_SCHEME();
                return !(string != null ? !string.equals(string2) : string2 != null) ? new Some((Object)uri) : None$.MODULE$;
            }
        }).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Some<URI> apply() {
                return new Some((Object)new URI(Client$.MODULE$.APP_JAR_NAME()));
            }
        });
    }

    private Seq<URI> getSecondaryJarUris(Option<Seq<String>> secondaryJars) {
        return (Seq)((TraversableLike)secondaryJars.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final URI apply(String x$21) {
                return new URI(x$21);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void org$apache$spark$deploy$yarn$Client$$addFileToClasspath(SparkConf conf, Configuration hadoopConf, URI uri, String fileName, HashMap<String, String> env) {
        if (uri != null) {
            String string = uri.getScheme();
            String string2 = Utils$.MODULE$.LOCAL_SCHEME();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(this.getClusterPath(conf, uri.getPath()), env);
                return;
            }
        }
        if (fileName == null) {
            if (uri == null) return;
            Path localPath = this.org$apache$spark$deploy$yarn$Client$$getQualifiedLocalPath(uri, hadoopConf);
            String linkName = (String)Option$.MODULE$.apply((Object)uri.getFragment()).getOrElse((Function0)new Serializable(localPath){
                public static final long serialVersionUID = 0L;
                private final Path localPath$2;

                public final String apply() {
                    return this.localPath$2.getName();
                }
                {
                    this.localPath$2 = localPath$2;
                }
            });
            this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), linkName})), env);
            return;
        }
        this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), fileName})), env);
    }

    public void org$apache$spark$deploy$yarn$Client$$addClasspathEntry(String path, HashMap<String, String> env) {
        YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment(env, ApplicationConstants.Environment.CLASSPATH.name(), path);
    }

    public String getClusterPath(SparkConf conf, String path) {
        String localPath = (String)conf.get(package$.MODULE$.GATEWAY_ROOT_PATH());
        String clusterPath = (String)conf.get(package$.MODULE$.REPLACEMENT_ROOT_PATH());
        return localPath == null || clusterPath == null ? path : path.replace(localPath, clusterPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compareUri(URI srcUri, URI dstUri) {
        if (srcUri.getScheme() == null) return false;
        String string = srcUri.getScheme();
        String string2 = dstUri.getScheme();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String srcAuthority = srcUri.getAuthority();
        String dstAuthority = dstUri.getAuthority();
        if (srcAuthority != null) {
            if (!srcAuthority.equalsIgnoreCase(dstAuthority)) return false;
        }
        String srcHost = srcUri.getHost();
        String dstHost = dstUri.getHost();
        if (srcHost != null && dstHost != null) {
            String string3 = srcHost;
            String string4 = dstHost;
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                try {
                    srcHost = InetAddress.getByName(srcHost).getCanonicalHostName();
                    dstHost = InetAddress.getByName(dstHost).getCanonicalHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    return false;
                }
            }
        }
        if (!Objects.equal((Object)srcHost, (Object)dstHost)) return false;
        if (srcUri.getPort() != dstUri.getPort()) return false;
        return true;
    }

    public boolean compareFs(FileSystem srcFs, FileSystem destFs) {
        URI srcUri = srcFs.getUri();
        URI dstUri = destFs.getUri();
        return this.compareUri(srcUri, dstUri);
    }

    public Path org$apache$spark$deploy$yarn$Client$$getQualifiedLocalPath(URI localURI, Configuration hadoopConf) {
        URI qualifiedURI = localURI.getScheme() == null ? new URI(FileSystem.getLocal((Configuration)hadoopConf).makeQualified(new Path(localURI)).toString()) : localURI;
        return new Path(qualifiedURI);
    }

    public boolean isUserClassPathFirst(SparkConf conf, boolean isDriver) {
        return isDriver ? BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_USER_CLASS_PATH_FIRST())) : BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_USER_CLASS_PATH_FIRST()));
    }

    public String buildPath(Seq<String> components) {
        return components.mkString("/");
    }

    public YarnAppReport createAppReport(ApplicationReport report) {
        String diags = report.getDiagnostics();
        None$ diagsOpt = diags != null && new StringOps(Predef$.MODULE$.augmentString(diags)).nonEmpty() ? new Some((Object)diags) : None$.MODULE$;
        return new YarnAppReport(report.getYarnApplicationState(), report.getFinalApplicationStatus(), (Option<String>)diagsOpt);
    }

    public String createLibraryPathPrefix(String libpath, SparkConf conf) {
        String string;
        if (Utils$.MODULE$.isWindows()) {
            string = Utils$.MODULE$.libraryPathEnvPrefix((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{libpath})));
        } else {
            String envName = Utils$.MODULE$.libraryPathEnvName();
            String quoted = libpath.replace("\"", "\\\\\\\"");
            string = new StringBuilder().append((Object)envName).append((Object)"=\\\"").append((Object)quoted).append((Object)File.pathSeparator).append((Object)"$").append((Object)envName).append((Object)"\\\"").toString();
        }
        String cmdPrefix = string;
        return this.getClusterPath(conf, cmdPrefix);
    }

    /*
     * WARNING - void declaration
     */
    public Properties confToProperties(SparkConf conf) {
        void var2_2;
        Properties props = new Properties();
        Predef$.MODULE$.refArrayOps((Object[])conf.getAll()).foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(Tuple2<String, String> x0$9) {
                Tuple2<String, String> tuple2 = x0$9;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.props$1.setProperty(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.props$1 = props$1;
            }
        });
        return var2_2;
    }

    public void writePropertiesToArchive(Properties props, String name, ZipOutputStream out) {
        out.putNextEntry(new ZipEntry(name));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
        props.store(writer, "Spark configuration.");
        writer.flush();
        out.closeEntry();
    }

    public Seq<ResourceRequest> getAMLocalityRequests(SparkConf conf, Resource capability, boolean isDriver) {
        String RACK_GROUP = "rack";
        String NODE_IF_RACK_GROUP = "node1";
        String NODE_IF_NO_RACK_GROUP = "node2";
        Pattern RACK_NODE_PATTERN = Pattern.compile(String.format("(?<%s>[^/]+?)|(?<%s>/[^/]+?)(?:/(?<%s>[^/]+?))?", NODE_IF_NO_RACK_GROUP, RACK_GROUP, NODE_IF_RACK_GROUP));
        HashMap rackRequests = new HashMap();
        OptionalConfigEntry<Seq<String>> confKey = isDriver ? package$.MODULE$.DRIVER_LOCALITY() : package$.MODULE$.AM_LOCALITY();
        Seq nodeRequests = (Seq)((TraversableLike)((Option)conf.get(confKey)).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        })).flatMap((Function1)new Serializable(capability, RACK_GROUP, NODE_IF_RACK_GROUP, NODE_IF_NO_RACK_GROUP, RACK_NODE_PATTERN, rackRequests){
            public static final long serialVersionUID = 0L;
            public final Resource capability$2;
            private final String RACK_GROUP$1;
            private final String NODE_IF_RACK_GROUP$1;
            private final String NODE_IF_NO_RACK_GROUP$1;
            private final Pattern RACK_NODE_PATTERN$1;
            private final HashMap rackRequests$1;

            public final Iterable<ResourceRequest> apply(String locality) {
                Matcher matcher = this.RACK_NODE_PATTERN$1.matcher(locality);
                if (matcher.matches()) {
                    Tuple2 tuple2;
                    Option option = Option$.MODULE$.apply((Object)matcher.group(this.RACK_GROUP$1));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String rack = (String)some.x();
                        tuple2 = new Tuple2((Object)rack, (Object)matcher.group(this.NODE_IF_RACK_GROUP$1));
                    } else {
                        tuple2 = new Tuple2((Object)"/default-rack", (Object)matcher.group(this.NODE_IF_NO_RACK_GROUP$1));
                    }
                    Tuple2 tuple22 = tuple2;
                    if (tuple22 != null) {
                        Tuple2 tuple23;
                        String rackName = (String)tuple22._1();
                        String nodeName = (String)tuple22._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)rackName, (Object)nodeName);
                        String rackName2 = (String)tuple24._1();
                        String nodeName2 = (String)tuple24._2();
                        ResourceRequest rackRequest = (ResourceRequest)this.rackRequests$1.getOrElseUpdate((Object)rackName2, (Function0)new Serializable(this, rackName2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.28 $outer;
                            private final String rackName$1;

                            public final ResourceRequest apply() {
                                return Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$createAMResourceRequest(this.rackName$1, this.$outer.capability$2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.rackName$1 = rackName$1;
                            }
                        });
                        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)nodeName2).map((Function1)new Serializable(this, rackRequest){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.28 $outer;
                            private final ResourceRequest rackRequest$1;

                            public final ResourceRequest apply(String name) {
                                this.rackRequest$1.setRelaxLocality(false);
                                return Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$createAMResourceRequest(name, this.$outer.capability$2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.rackRequest$1 = rackRequest$1;
                            }
                        }));
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid locality pattern: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{locality})));
            }
            {
                this.capability$2 = capability$2;
                this.RACK_GROUP$1 = RACK_GROUP$1;
                this.NODE_IF_RACK_GROUP$1 = NODE_IF_RACK_GROUP$1;
                this.NODE_IF_NO_RACK_GROUP$1 = NODE_IF_NO_RACK_GROUP$1;
                this.RACK_NODE_PATTERN$1 = RACK_NODE_PATTERN$1;
                this.rackRequests$1 = rackRequests$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)rackRequests.values().toSeq().$plus$plus((GenTraversableOnce)nodeRequests, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public ResourceRequest org$apache$spark$deploy$yarn$Client$$createAMResourceRequest(String resource, Resource capability) {
        void var3_3;
        ResourceRequest request = (ResourceRequest)Records.newRecord(ResourceRequest.class);
        request.setPriority(Priority.newInstance((int)0));
        request.setResourceName(resource);
        request.setCapability(capability);
        request.setNumContainers(1);
        request.setRelaxLocality(true);
        return var3_3;
    }

    private Client$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.APP_JAR_NAME = "__app__.jar";
        this.SPARK_STAGING = ".sparkStaging";
        this.STAGING_DIR_PERMISSION = FsPermission.createImmutable((short)((short)Integer.parseInt("700", 8)));
        this.APP_FILE_PERMISSION = FsPermission.createImmutable((short)((short)Integer.parseInt("644", 8)));
        this.ENV_DIST_CLASSPATH = "SPARK_DIST_CLASSPATH";
        this.LOCALIZED_CONF_DIR = "__spark_conf__";
        this.LOCALIZED_HADOOP_CONF_DIR = "__hadoop_conf__";
        this.LOCALIZED_CONF_ARCHIVE = new StringBuilder().append((Object)this.LOCALIZED_CONF_DIR()).append((Object)".zip").toString();
        this.SPARK_CONF_FILE = "__spark_conf__.properties";
        this.DIST_CACHE_CONF_FILE = "__spark_dist_cache__.properties";
        this.LOCALIZED_PYTHON_DIR = "__pyfiles__";
        this.LOCALIZED_LIB_DIR = "__spark_libs__";
        this.LOCALIZED_HIVE_LIB_DIR = "__hive_libs__";
    }
}

