/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.CausedBy$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class ResourceRequestHelper$
implements Logging {
    public static final ResourceRequestHelper$ MODULE$;
    private final Regex org$apache$spark$deploy$yarn$ResourceRequestHelper$$AMOUNT_AND_UNIT_REGEX;
    private final String org$apache$spark$deploy$yarn$ResourceRequestHelper$$RESOURCE_INFO_CLASS;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ResourceRequestHelper$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Regex org$apache$spark$deploy$yarn$ResourceRequestHelper$$AMOUNT_AND_UNIT_REGEX() {
        return this.org$apache$spark$deploy$yarn$ResourceRequestHelper$$AMOUNT_AND_UNIT_REGEX;
    }

    public String org$apache$spark$deploy$yarn$ResourceRequestHelper$$RESOURCE_INFO_CLASS() {
        return this.org$apache$spark$deploy$yarn$ResourceRequestHelper$$RESOURCE_INFO_CLASS;
    }

    public void validateResources(SparkConf sparkConf) {
        Seq resourceDefinitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package$.MODULE$.AM_MEMORY().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX()).append((Object)"memory").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX()).append((Object)"memory").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX()).append((Object)"memory").toString()), new Tuple2((Object)package$.MODULE$.AM_MEMORY().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX()).append((Object)"mb").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX()).append((Object)"mb").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX()).append((Object)"mb").toString()), new Tuple2((Object)package$.MODULE$.AM_MEMORY().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX()).append((Object)"memory-mb").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX()).append((Object)"memory-mb").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX()).append((Object)"memory-mb").toString()), new Tuple2((Object)package$.MODULE$.AM_CORES().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX()).append((Object)"cores").toString()), new Tuple2((Object)package$.MODULE$.DRIVER_CORES().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX()).append((Object)"cores").toString()), new Tuple2((Object)package$.MODULE$.EXECUTOR_CORES().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX()).append((Object)"cores").toString()), new Tuple2((Object)package$.MODULE$.AM_CORES().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX()).append((Object)"vcores").toString()), new Tuple2((Object)package$.MODULE$.DRIVER_CORES().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX()).append((Object)"vcores").toString()), new Tuple2((Object)package$.MODULE$.EXECUTOR_CORES().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX()).append((Object)"vcores").toString()), new Tuple2((Object)package$.MODULE$.AM_CORES().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX()).append((Object)"cpu-vcores").toString()), new Tuple2((Object)package$.MODULE$.DRIVER_CORES().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX()).append((Object)"cpu-vcores").toString()), new Tuple2((Object)package$.MODULE$.EXECUTOR_CORES().key(), (Object)new StringBuilder().append((Object)package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX()).append((Object)"cpu-vcores").toString())}));
        StringBuilder errorMessage = new StringBuilder();
        resourceDefinitions.foreach((Function1)new Serializable(sparkConf, errorMessage){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$1;
            private final StringBuilder errorMessage$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String sparkName = (String)tuple2._1();
                    String resourceRequest = (String)tuple2._2();
                    BoxedUnit boxedUnit = this.sparkConf$1.contains(resourceRequest) ? this.errorMessage$1.append(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: Do not use ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceRequest}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"please use ", " instead!\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sparkName}))).toString()) : BoxedUnit.UNIT;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sparkConf$1 = sparkConf$1;
                this.errorMessage$1 = errorMessage$1;
            }
        });
        if (errorMessage.nonEmpty()) {
            throw new SparkException(errorMessage.toString());
        }
    }

    public void setResourceRequests(Map<String, String> resources, Resource resource) {
        Predef$.MODULE$.require(resource != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Resource parameter should not be null!";
            }
        });
        this.logDebug((Function0<String>)new Serializable(resources){
            public static final long serialVersionUID = 0L;
            private final Map resources$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Custom resources requested: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.resources$1}));
            }
            {
                this.resources$1 = resources$1;
            }
        });
        if (this.isYarnResourceTypesAvailable()) {
            Class resInfoClass = Utils$.MODULE$.classForName(this.org$apache$spark$deploy$yarn$ResourceRequestHelper$$RESOURCE_INFO_CLASS());
            Method setResourceInformationMethod = resource.getClass().getMethod("setResourceInformation", String.class, resInfoClass);
            resources.foreach((Function1)new Serializable(resource, resInfoClass, setResourceInformationMethod){
                public static final long serialVersionUID = 0L;
                private final Resource resource$1;
                private final Class resInfoClass$1;
                private final Method setResourceInformationMethod$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object apply(Tuple2<String, String> x0$2) {
                    String string;
                    block5: {
                        Tuple2<String, String> tuple2 = x0$2;
                        if (tuple2 == null) throw new MatchError(tuple2);
                        String name = (String)tuple2._1();
                        String rawAmount = (String)tuple2._2();
                        try {
                            Tuple2 tuple22;
                            string = rawAmount;
                            Option option = ResourceRequestHelper$.MODULE$.org$apache$spark$deploy$yarn$ResourceRequestHelper$$AMOUNT_AND_UNIT_REGEX().unapplySeq((CharSequence)string);
                            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) break block5;
                            String amountPart = (String)((LinearSeqOptimized)option.get()).apply(0);
                            String unitPart = (String)((LinearSeqOptimized)option.get()).apply(1);
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)amountPart, (Object)unitPart);
                            String amountPart2 = (String)tuple23._1();
                            String unitPart2 = (String)tuple23._2();
                            long amount = new StringOps(Predef$.MODULE$.augmentString(amountPart2)).toLong();
                            String string2 = unitPart2;
                            String string3 = "g".equals(string2) ? "G" : ("t".equals(string2) ? "T" : ("p".equals(string2) ? "P" : unitPart2));
                            String unit = string3;
                            ResourceRequestHelper$.MODULE$.logDebug((Function0<String>)new Serializable(this, name, amount, unit){
                                public static final long serialVersionUID = 0L;
                                private final String name$1;
                                private final long amount$1;
                                private final String unit$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registering resource with name: ", ", amount: ", ", unit: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1, BoxesRunTime.boxToLong((long)this.amount$1), this.unit$1}));
                                }
                                {
                                    this.name$1 = name$1;
                                    this.amount$1 = amount$1;
                                    this.unit$1 = unit$1;
                                }
                            });
                            Object resourceInformation = ResourceRequestHelper$.MODULE$.org$apache$spark$deploy$yarn$ResourceRequestHelper$$createResourceInformation(name, amount, unit, this.resInfoClass$1);
                            return this.setResourceInformationMethod$1.invoke((Object)this.resource$1, name, resourceInformation);
                        }
                        catch (Throwable throwable) {
                            Throwable e;
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof MatchError) {
                                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resource request for '", "' ('", "') "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, rawAmount}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not match pattern ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ResourceRequestHelper$.MODULE$.org$apache$spark$deploy$yarn$ResourceRequestHelper$$AMOUNT_AND_UNIT_REGEX()}))).toString());
                            }
                            Option option = CausedBy$.MODULE$.unapply(throwable2);
                            if (!option.isEmpty() && (e = (Throwable)option.get()) instanceof IllegalArgumentException) {
                                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)e;
                                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid request for ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, illegalArgumentException.getMessage()})));
                            }
                            if (!(throwable2 instanceof InvocationTargetException)) throw throwable;
                            InvocationTargetException invocationTargetException = (InvocationTargetException)throwable2;
                            if (invocationTargetException.getCause() == null) throw throwable;
                            throw invocationTargetException.getCause();
                        }
                    }
                    throw new MatchError((Object)string);
                }
                {
                    this.resource$1 = resource$1;
                    this.resInfoClass$1 = resInfoClass$1;
                    this.setResourceInformationMethod$1 = setResourceInformationMethod$1;
                }
            });
            return;
        }
        if (resources.nonEmpty()) {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Ignoring custom resource requests because the version of YARN does not support it!";
                }
            });
        }
    }

    public Object org$apache$spark$deploy$yarn$ResourceRequestHelper$$createResourceInformation(String resourceName, long amount, String unit, Class<?> resInfoClass) {
        Object object;
        if (new StringOps(Predef$.MODULE$.augmentString(unit)).nonEmpty()) {
            Method resInfoNewInstanceMethod = resInfoClass.getMethod("newInstance", String.class, String.class, Long.TYPE);
            object = resInfoNewInstanceMethod.invoke(null, resourceName, unit, BoxesRunTime.boxToLong((long)amount));
        } else {
            Method resInfoNewInstanceMethod = resInfoClass.getMethod("newInstance", String.class, Long.TYPE);
            object = resInfoNewInstanceMethod.invoke(null, resourceName, BoxesRunTime.boxToLong((long)amount));
        }
        Object resourceInformation = object;
        return resourceInformation;
    }

    public boolean isYarnResourceTypesAvailable() {
        return Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<Object> apply() {
                return Utils$.MODULE$.classForName(ResourceRequestHelper$.MODULE$.org$apache$spark$deploy$yarn$ResourceRequestHelper$$RESOURCE_INFO_CLASS());
            }
        }).isSuccess();
    }

    private ResourceRequestHelper$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$deploy$yarn$ResourceRequestHelper$$AMOUNT_AND_UNIT_REGEX = new StringOps(Predef$.MODULE$.augmentString("([0-9]+)([A-Za-z]*)")).r();
        this.org$apache$spark$deploy$yarn$ResourceRequestHelper$$RESOURCE_INFO_CLASS = "org.apache.hadoop.yarn.api.records.ResourceInformation";
    }
}

