/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.execution.mapreduce;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.io.NullWritable;
import org.apache.sqoop.common.Direction;
import org.apache.sqoop.common.MutableMapContext;
import org.apache.sqoop.driver.ExecutionEngine;
import org.apache.sqoop.driver.JobRequest;
import org.apache.sqoop.execution.mapreduce.MRJobRequest;
import org.apache.sqoop.job.etl.From;
import org.apache.sqoop.job.etl.To;
import org.apache.sqoop.job.io.SqoopWritable;
import org.apache.sqoop.job.mr.SqoopInputFormat;
import org.apache.sqoop.job.mr.SqoopMapper;
import org.apache.sqoop.job.mr.SqoopNullOutputFormat;

public class MapreduceExecutionEngine
extends ExecutionEngine {
    public JobRequest createJobRequest() {
        return new MRJobRequest();
    }

    public void prepareJob(JobRequest jobRequest) {
        MRJobRequest mrJobRequest = (MRJobRequest)jobRequest;
        this.addDependencies(mrJobRequest);
        mrJobRequest.setInputFormatClass(SqoopInputFormat.class);
        mrJobRequest.setMapperClass(SqoopMapper.class);
        mrJobRequest.setMapOutputKeyClass(SqoopWritable.class);
        mrJobRequest.setMapOutputValueClass(NullWritable.class);
        mrJobRequest.setOutputFormatClass(SqoopNullOutputFormat.class);
        mrJobRequest.setOutputKeyClass(SqoopWritable.class);
        mrJobRequest.setOutputValueClass(NullWritable.class);
        From from = (From)mrJobRequest.getFrom();
        To to = (To)mrJobRequest.getTo();
        MutableMapContext context = mrJobRequest.getDriverContext();
        context.setString("org.apache.sqoop.job.etl.partitioner", from.getPartitioner().getName());
        context.setString("org.apache.sqoop.job.etl.extractor", from.getExtractor().getName());
        context.setString("org.apache.sqoop.job.etl.loader", to.getLoader().getName());
        context.setString("org.apache.sqoop.job.etl.from.destroyer", from.getDestroyer().getName());
        context.setString("org.apache.sqoop.job.etl.to.destroyer", to.getDestroyer().getName());
        context.setString("org.apache.sqoop.execution.from.intermediate.format", mrJobRequest.getIntermediateDataFormat(Direction.FROM).getName());
        context.setString("org.apache.sqoop.execution.to.intermediate.format", mrJobRequest.getIntermediateDataFormat(Direction.TO).getName());
        if (mrJobRequest.getExtractors() != null) {
            context.setInteger("org.apache.sqoop.job.etl.extractor.count", mrJobRequest.getExtractors().intValue());
        }
    }

    protected void addDependencies(MRJobRequest jobrequest) {
        jobrequest.addJarForClass(ThreadFactoryBuilder.class);
    }
}

