/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.mr;

import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.Direction;
import org.apache.sqoop.common.ImmutableContext;
import org.apache.sqoop.common.PrefixContext;
import org.apache.sqoop.connector.matcher.Matcher;
import org.apache.sqoop.connector.matcher.MatcherFactory;
import org.apache.sqoop.job.etl.Destroyer;
import org.apache.sqoop.job.etl.DestroyerContext;
import org.apache.sqoop.job.mr.MRConfigurationUtils;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.utils.ClassUtils;

public class SqoopDestroyerExecutor {
    public static final Logger LOG = Logger.getLogger(SqoopDestroyerExecutor.class);

    public static void executeDestroyer(boolean success, Configuration configuration, Direction direction) {
        String prefixPropertyName;
        String destroyerPropertyName;
        switch (direction) {
            default: {
                destroyerPropertyName = "org.apache.sqoop.job.etl.from.destroyer";
                prefixPropertyName = "org.apache.sqoop.job.connector.from.context.";
                break;
            }
            case TO: {
                destroyerPropertyName = "org.apache.sqoop.job.etl.to.destroyer";
                prefixPropertyName = "org.apache.sqoop.job.connector.to.context.";
            }
        }
        Destroyer destroyer = (Destroyer)ClassUtils.instantiate((String)configuration.get(destroyerPropertyName), (Object[])new Object[0]);
        if (destroyer == null) {
            LOG.info((Object)"Skipping running destroyer as non was defined.");
            return;
        }
        PrefixContext subContext = new PrefixContext(configuration, prefixPropertyName);
        Object configConnection = MRConfigurationUtils.getConnectorLinkConfig(direction, configuration);
        Object configJob = MRConfigurationUtils.getConnectorJobConfig(direction, configuration);
        Matcher matcher = MatcherFactory.getMatcher((Schema)MRConfigurationUtils.getConnectorSchema(Direction.FROM, configuration), (Schema)MRConfigurationUtils.getConnectorSchema(Direction.TO, configuration));
        Schema schema = direction == Direction.FROM ? matcher.getFromSchema() : matcher.getToSchema();
        DestroyerContext destroyerContext = new DestroyerContext((ImmutableContext)subContext, success, schema);
        LOG.info((Object)("Executing destroyer class " + destroyer.getClass()));
        destroyer.destroy(destroyerContext, configConnection, configJob);
    }

    private SqoopDestroyerExecutor() {
    }
}

