/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparable;
import org.apache.sqoop.connector.idf.IntermediateDataFormat;
import org.apache.sqoop.utils.ClassUtils;

public class SqoopWritable
implements Configurable,
WritableComparable<SqoopWritable> {
    private IntermediateDataFormat<?> toIDF;
    private Configuration conf;

    public SqoopWritable() {
        this(null);
    }

    public SqoopWritable(IntermediateDataFormat<?> dataFormat) {
        this.toIDF = dataFormat;
    }

    void setString(String data) {
        this.toIDF.setCSVTextData(data);
    }

    public void write(DataOutput out) throws IOException {
        this.toIDF.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.toIDF.read(in);
    }

    public int compareTo(SqoopWritable o) {
        return this.toIDF.compareTo(o.toIDF);
    }

    public String toString() {
        return this.toIDF.toString();
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        if (this.toIDF == null) {
            String toIDFClass = conf.get("org.apache.sqoop.execution.to.intermediate.format");
            this.toIDF = (IntermediateDataFormat)ClassUtils.instantiate((String)toIDFClass, (Object[])new Object[0]);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.toIDF == null ? 0 : this.toIDF.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SqoopWritable other = (SqoopWritable)obj;
        return !(this.toIDF == null ? other.toIDF != null : !this.toIDF.equals(other.toIDF));
    }
}

