/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.mr;

import java.io.InputStream;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.log4j.PropertyConfigurator;
import org.apache.sqoop.common.Direction;
import org.apache.sqoop.job.mr.SqoopMapper;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.util.SchemaSerialization;
import org.apache.sqoop.model.ConfigUtils;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.utils.ClassUtils;
import org.json.simple.JSONObject;

public final class MRConfigurationUtils {
    private static final String MR_JOB_CONFIG_CLASS_FROM_CONNECTOR_LINK = "org.apache.sqoop.job.config.class.connector.from.link";
    private static final String MR_JOB_CONFIG_CLASS_TO_CONNECTOR_LINK = "org.apache.sqoop.job.config.class.connector.to.link";
    private static final String MR_JOB_CONFIG_CLASS_FROM_CONNECTOR_JOB = "org.apache.sqoop.job.config.class.connector.from.job";
    private static final String MR_JOB_CONFIG_CLASS_TO_CONNECTOR_JOB = "org.apache.sqoop.job.config.class.connector.to.job";
    private static final String MR_JOB_CONFIG_DRIVER_CONFIG_CLASS = "org.apache.sqoop.job.config.class.driver";
    private static final String MR_JOB_CONFIG_FROM_CONNECTOR_LINK = "org.apache.sqoop.job.config.connector.from.link";
    private static final Text MR_JOB_CONFIG_FROM_CONNECTOR_LINK_KEY = new Text("org.apache.sqoop.job.config.connector.from.link");
    private static final String MR_JOB_CONFIG_TO_CONNECTOR_LINK = "org.apache.sqoop.job.config.connector.to.link";
    private static final Text MR_JOB_CONFIG_TO_CONNECTOR_LINK_KEY = new Text("org.apache.sqoop.job.config.connector.to.link");
    private static final String MR_JOB_CONFIG_FROM_JOB_CONFIG = "org.apache.sqoop.job.config.connector.from.job";
    private static final Text MR_JOB_CONFIG_FROM_JOB_CONFIG_KEY = new Text("org.apache.sqoop.job.config.connector.from.job");
    private static final String MR_JOB_CONFIG_TO_JOB_CONFIG = "org.apache.sqoop.job.config.connector.to.job";
    private static final Text MR_JOB_CONFIG_TO_JOB_CONFIG_KEY = new Text("org.apache.sqoop.job.config.connector.to.job");
    private static final String MR_JOB_CONFIG_DRIVER_CONFIG = "org.apache.sqoop.job.config.driver";
    private static final Text MR_JOB_CONFIG_DRIVER_CONFIG_KEY = new Text("org.apache.sqoop.job.config.driver");
    private static final String SCHEMA_FROM = "org.apache.sqoop.job.schema.connector.from";
    private static final Text SCHEMA_FROM_KEY = new Text("org.apache.sqoop.job.schema.connector.from");
    private static final String SCHEMA_TO = "org.apache.sqoop.job.schema.connector.to";
    private static final Text SCHEMA_TO_KEY = new Text("org.apache.sqoop.job.schema.connector.to");

    public static void setConnectorLinkConfig(Direction type, Job job, Object obj) {
        switch (type) {
            case FROM: {
                job.getConfiguration().set(MR_JOB_CONFIG_CLASS_FROM_CONNECTOR_LINK, obj.getClass().getName());
                job.getCredentials().addSecretKey(MR_JOB_CONFIG_FROM_CONNECTOR_LINK_KEY, ConfigUtils.toJson((Object)obj).getBytes());
                break;
            }
            case TO: {
                job.getConfiguration().set(MR_JOB_CONFIG_CLASS_TO_CONNECTOR_LINK, obj.getClass().getName());
                job.getCredentials().addSecretKey(MR_JOB_CONFIG_TO_CONNECTOR_LINK_KEY, ConfigUtils.toJson((Object)obj).getBytes());
            }
        }
    }

    public static void setConnectorJobConfig(Direction type, Job job, Object obj) {
        switch (type) {
            case FROM: {
                job.getConfiguration().set(MR_JOB_CONFIG_CLASS_FROM_CONNECTOR_JOB, obj.getClass().getName());
                job.getCredentials().addSecretKey(MR_JOB_CONFIG_FROM_JOB_CONFIG_KEY, ConfigUtils.toJson((Object)obj).getBytes());
                break;
            }
            case TO: {
                job.getConfiguration().set(MR_JOB_CONFIG_CLASS_TO_CONNECTOR_JOB, obj.getClass().getName());
                job.getCredentials().addSecretKey(MR_JOB_CONFIG_TO_JOB_CONFIG_KEY, ConfigUtils.toJson((Object)obj).getBytes());
            }
        }
    }

    public static void setDriverConfig(Job job, Object obj) {
        job.getConfiguration().set(MR_JOB_CONFIG_DRIVER_CONFIG_CLASS, obj.getClass().getName());
        job.getCredentials().addSecretKey(MR_JOB_CONFIG_DRIVER_CONFIG_KEY, ConfigUtils.toJson((Object)obj).getBytes());
    }

    public static void setConnectorSchema(Direction type, Job job, Schema schema) {
        String jsonSchema = SchemaSerialization.extractSchema((Schema)schema).toJSONString();
        switch (type) {
            case FROM: {
                job.getCredentials().addSecretKey(SCHEMA_FROM_KEY, jsonSchema.getBytes());
                return;
            }
            case TO: {
                job.getCredentials().addSecretKey(SCHEMA_TO_KEY, jsonSchema.getBytes());
                return;
            }
        }
    }

    public static Object getConnectorLinkConfig(Direction type, Configuration configuration) {
        switch (type) {
            case FROM: {
                return MRConfigurationUtils.loadConfiguration((JobConf)configuration, MR_JOB_CONFIG_CLASS_FROM_CONNECTOR_LINK, MR_JOB_CONFIG_FROM_CONNECTOR_LINK_KEY);
            }
            case TO: {
                return MRConfigurationUtils.loadConfiguration((JobConf)configuration, MR_JOB_CONFIG_CLASS_TO_CONNECTOR_LINK, MR_JOB_CONFIG_TO_CONNECTOR_LINK_KEY);
            }
        }
        return null;
    }

    public static Object getConnectorJobConfig(Direction type, Configuration configuration) {
        switch (type) {
            case FROM: {
                return MRConfigurationUtils.loadConfiguration((JobConf)configuration, MR_JOB_CONFIG_CLASS_FROM_CONNECTOR_JOB, MR_JOB_CONFIG_FROM_JOB_CONFIG_KEY);
            }
            case TO: {
                return MRConfigurationUtils.loadConfiguration((JobConf)configuration, MR_JOB_CONFIG_CLASS_TO_CONNECTOR_JOB, MR_JOB_CONFIG_TO_JOB_CONFIG_KEY);
            }
        }
        return null;
    }

    public static Object getDriverConfig(Configuration configuration) {
        return MRConfigurationUtils.loadConfiguration((JobConf)configuration, MR_JOB_CONFIG_DRIVER_CONFIG_CLASS, MR_JOB_CONFIG_DRIVER_CONFIG_KEY);
    }

    public static Schema getConnectorSchema(Direction type, Configuration configuration) {
        switch (type) {
            case FROM: {
                return MRConfigurationUtils.getSchemaFromBytes(((JobConf)configuration).getCredentials().getSecretKey(SCHEMA_FROM_KEY));
            }
            case TO: {
                return MRConfigurationUtils.getSchemaFromBytes(((JobConf)configuration).getCredentials().getSecretKey(SCHEMA_TO_KEY));
            }
        }
        return null;
    }

    private static Schema getSchemaFromBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        JSONObject jsonSchema = JSONUtils.parse((String)new String(bytes));
        return SchemaSerialization.restoreSchema((JSONObject)jsonSchema);
    }

    private static Object loadConfiguration(JobConf configuration, String classProperty, Text valueProperty) {
        Object object = ClassUtils.instantiate((String)configuration.get(classProperty), (Object[])new Object[0]);
        if (object == null) {
            return null;
        }
        String json = new String(configuration.getCredentials().getSecretKey(valueProperty));
        ConfigUtils.fillValues((String)json, (Object)object);
        return object;
    }

    private MRConfigurationUtils() {
    }

    public static void configureLogging() {
        try {
            Properties props = new Properties();
            InputStream resourceAsStream = SqoopMapper.class.getResourceAsStream("/META-INF/log4j.properties");
            props.load(resourceAsStream);
            PropertyConfigurator.configure((Properties)props);
        }
        catch (Exception e) {
            System.err.println("Encountered exception while configuring logging for sqoop: " + e);
        }
    }
}

