/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.mr;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.Direction;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.ImmutableContext;
import org.apache.sqoop.common.PrefixContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.idf.IntermediateDataFormat;
import org.apache.sqoop.connector.matcher.Matcher;
import org.apache.sqoop.connector.matcher.MatcherFactory;
import org.apache.sqoop.error.code.MRExecutionError;
import org.apache.sqoop.etl.io.DataWriter;
import org.apache.sqoop.job.etl.Extractor;
import org.apache.sqoop.job.etl.ExtractorContext;
import org.apache.sqoop.job.io.SqoopWritable;
import org.apache.sqoop.job.mr.MRConfigurationUtils;
import org.apache.sqoop.job.mr.SqoopProgressRunnable;
import org.apache.sqoop.job.mr.SqoopSplit;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.submission.counter.SqoopCounters;
import org.apache.sqoop.utils.ClassUtils;

public class SqoopMapper
extends Mapper<SqoopSplit, NullWritable, SqoopWritable, NullWritable> {
    public static final Logger LOG;
    private final ScheduledExecutorService progressService = Executors.newSingleThreadScheduledExecutor();
    private IntermediateDataFormat<Object> fromIDF = null;
    private IntermediateDataFormat<Object> toIDF = null;
    private Matcher matcher;

    public void run(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String extractorName = conf.get("org.apache.sqoop.job.etl.extractor");
        Extractor extractor = (Extractor)ClassUtils.instantiate((String)extractorName, (Object[])new Object[0]);
        Schema fromSchema = MRConfigurationUtils.getConnectorSchema(Direction.FROM, conf);
        Schema toSchema = MRConfigurationUtils.getConnectorSchema(Direction.TO, conf);
        this.matcher = MatcherFactory.getMatcher((Schema)fromSchema, (Schema)toSchema);
        String fromIDFClass = conf.get("org.apache.sqoop.execution.from.intermediate.format");
        this.fromIDF = (IntermediateDataFormat)ClassUtils.instantiate((String)fromIDFClass, (Object[])new Object[0]);
        this.fromIDF.setSchema(this.matcher.getFromSchema());
        String toIDFClass = conf.get("org.apache.sqoop.execution.to.intermediate.format");
        this.toIDF = (IntermediateDataFormat)ClassUtils.instantiate((String)toIDFClass, (Object[])new Object[0]);
        this.toIDF.setSchema(this.matcher.getToSchema());
        PrefixContext subContext = new PrefixContext(conf, "org.apache.sqoop.job.connector.from.context.");
        Object fromConfig = MRConfigurationUtils.getConnectorLinkConfig(Direction.FROM, conf);
        Object fromJob = MRConfigurationUtils.getConnectorJobConfig(Direction.FROM, conf);
        SqoopSplit split = (SqoopSplit)((Object)context.getCurrentKey());
        ExtractorContext extractorContext = new ExtractorContext((ImmutableContext)subContext, (DataWriter)new SqoopMapDataWriter(context), fromSchema);
        try {
            LOG.info((Object)"Starting progress service");
            this.progressService.scheduleAtFixedRate(new SqoopProgressRunnable((TaskInputOutputContext<?, ?, ?, ?>)context), 0L, 2L, TimeUnit.MINUTES);
            LOG.info((Object)("Running extractor class " + extractorName));
            extractor.extract(extractorContext, fromConfig, fromJob, (Object)split.getPartition());
            LOG.info((Object)"Extractor has finished");
            context.getCounter((Enum)SqoopCounters.ROWS_READ).increment(extractor.getRowsRead());
        }
        catch (Exception e) {
            throw new SqoopException((ErrorCode)MRExecutionError.MAPRED_EXEC_0017, (Throwable)e);
        }
        finally {
            LOG.info((Object)"Stopping progress service");
            this.progressService.shutdown();
            if (!this.progressService.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOG.info((Object)"Stopping progress service with shutdownNow");
                this.progressService.shutdownNow();
            }
        }
    }

    static {
        MRConfigurationUtils.configureLogging();
        LOG = Logger.getLogger(SqoopMapper.class);
    }

    private class SqoopMapDataWriter
    extends DataWriter {
        private Mapper.Context context;
        private SqoopWritable writable;

        public SqoopMapDataWriter(Mapper.Context context) {
            this.context = context;
            this.writable = new SqoopWritable(SqoopMapper.this.toIDF);
        }

        public void writeArrayRecord(Object[] array) {
            SqoopMapper.this.fromIDF.setObjectData(array);
            this.writeContent();
        }

        public void writeStringRecord(String text) {
            SqoopMapper.this.fromIDF.setCSVTextData(text);
            this.writeContent();
        }

        public void writeRecord(Object obj) {
            SqoopMapper.this.fromIDF.setData(obj);
            this.writeContent();
        }

        private void writeContent() {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Extracted data: " + SqoopMapper.this.fromIDF.getCSVTextData()));
                }
                SqoopMapper.this.toIDF.setObjectData(SqoopMapper.this.matcher.getMatchingData(SqoopMapper.this.fromIDF.getObjectData()));
                this.context.write((Object)this.writable, (Object)NullWritable.get());
            }
            catch (Exception e) {
                throw new SqoopException((ErrorCode)MRExecutionError.MAPRED_EXEC_0013, (Throwable)e);
            }
        }
    }
}

