/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.mr;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.log4j.Logger;
import org.apache.sqoop.job.io.SqoopWritable;
import org.apache.sqoop.job.mr.MRConfigurationUtils;
import org.apache.sqoop.job.mr.SqoopProgressRunnable;

public class SqoopReducer
extends Reducer<SqoopWritable, NullWritable, SqoopWritable, NullWritable> {
    public static final Logger LOG;
    private final ScheduledExecutorService progressService = Executors.newSingleThreadScheduledExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Reducer.Context context) throws IOException, InterruptedException {
        try {
            LOG.info((Object)"Starting progress service");
            this.progressService.scheduleAtFixedRate(new SqoopProgressRunnable((TaskInputOutputContext<?, ?, ?, ?>)context), 0L, 2L, TimeUnit.MINUTES);
            super.run(context);
        }
        finally {
            LOG.info((Object)"Stopping progress service");
            this.progressService.shutdown();
            if (!this.progressService.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOG.info((Object)"Stopping progress service with shutdownNow");
                this.progressService.shutdownNow();
            }
        }
    }

    static {
        MRConfigurationUtils.configureLogging();
        LOG = Logger.getLogger(SqoopReducer.class);
    }
}

