/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.request;

import org.apache.sshd.sftp.Handle;
import org.apache.sshd.sftp.request.BaseRequest;
import org.apache.sshd.sftp.subsystem.SftpConstants;

public class SshFxpReadRequest
extends BaseRequest {
    private final String handleId;
    private final long offset;
    private final Handle handle;
    private final int length;

    public SshFxpReadRequest(int id, String handleId, long offset, int length, Handle handle) {
        super(id);
        this.handleId = handleId;
        this.offset = offset;
        this.length = length;
        this.handle = handle;
    }

    public SftpConstants.Type getMessage() {
        return SftpConstants.Type.SSH_FXP_READ;
    }

    public String toString() {
        String ps = this.handle != null && this.handle.getFile() != null ? this.handle.getFile().getAbsolutePath() : "";
        return this.getName() + "[handle=" + this.handleId + ", file=" + ps + ", offset=" + this.offset + ", length=" + this.length + "]";
    }

    public Handle getHandle() {
        return this.handle;
    }

    public String getHandleId() {
        return this.handleId;
    }

    public int getLength() {
        return this.length;
    }

    public long getOffset() {
        return this.offset;
    }
}

