/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client.registry;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;

@InterfaceAudience.Public
public class AMRecord {
    private ApplicationId appId;
    private String hostName;
    private String hostIp;
    private int port;
    private String externalId;
    private String computeName;
    private Token clientToAMToken;
    private static final String APP_ID_RECORD_KEY = "appId";
    private static final String HOST_NAME_RECORD_KEY = "hostName";
    private static final String HOST_IP_RECORD_KEY = "hostIp";
    private static final String PORT_RECORD_KEY = "port";
    private static final String EXTERNAL_ID_KEY = "externalId";
    private static final String COMPUTE_GROUP_NAME_KEY = "computeName";
    private static final String CLIENT_TO_AM_TOKEN_KEY = "clientToAMToken";

    public AMRecord(ApplicationId appId, String hostName, String hostIp, int port, String externalId, String computeName) {
        this(appId, hostName, hostIp, port, externalId, computeName, null);
    }

    public AMRecord(ApplicationId appId, String hostName, String hostIp, int port, String externalId, String computeName, Token clientToAMToken) {
        Preconditions.checkNotNull((Object)appId);
        Preconditions.checkNotNull((Object)hostName);
        this.appId = appId;
        this.hostName = hostName;
        this.hostIp = hostIp;
        this.port = port;
        this.externalId = externalId == null ? "" : externalId;
        this.computeName = computeName == null ? "default-compute" : computeName;
        this.clientToAMToken = clientToAMToken;
    }

    public AMRecord(AMRecord other) {
        Preconditions.checkNotNull((Object)other);
        this.appId = other.getApplicationId();
        this.hostName = other.getHost();
        this.hostIp = other.getHostIp();
        this.port = other.getPort();
        this.externalId = other.getExternalId();
        this.computeName = other.getComputeName();
        this.clientToAMToken = other.getClientToAMToken();
    }

    public AMRecord(ServiceRecord serviceRecord) {
        String serviceAppId = serviceRecord.get(APP_ID_RECORD_KEY);
        Preconditions.checkNotNull((Object)serviceAppId);
        this.appId = ApplicationId.fromString((String)serviceAppId);
        String serviceHost = serviceRecord.get(HOST_NAME_RECORD_KEY);
        Preconditions.checkNotNull((Object)serviceHost);
        this.hostName = serviceHost;
        String serviceHostIp = serviceRecord.get(HOST_IP_RECORD_KEY);
        Preconditions.checkNotNull((Object)serviceHostIp);
        this.hostIp = serviceHostIp;
        String servicePort = serviceRecord.get(PORT_RECORD_KEY);
        this.port = Integer.parseInt(servicePort);
        String externalId = serviceRecord.get(EXTERNAL_ID_KEY);
        Preconditions.checkNotNull((Object)externalId);
        this.externalId = externalId;
        String computeName = serviceRecord.get(COMPUTE_GROUP_NAME_KEY);
        Preconditions.checkNotNull((Object)computeName);
        this.computeName = computeName;
        String clientToAMTokenString = serviceRecord.get(CLIENT_TO_AM_TOKEN_KEY);
        if (clientToAMTokenString != null) {
            try {
                Token clientToAMToken = new Token();
                clientToAMToken.decodeFromUrlString(clientToAMTokenString);
                this.clientToAMToken = clientToAMToken;
            }
            catch (IOException err) {
                throw new RuntimeException("Error decoding clientToAMToken", err);
            }
        }
    }

    public ApplicationId getApplicationId() {
        return this.appId;
    }

    public String getHost() {
        return this.hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostIp() {
        return this.hostIp;
    }

    public int getPort() {
        return this.port;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getComputeName() {
        return this.computeName;
    }

    public Token getClientToAMToken() {
        return this.clientToAMToken;
    }

    public void setClientToAMToken(Token clientToAMToken) {
        this.clientToAMToken = clientToAMToken;
    }

    private static boolean tokenEquals(Token t1, Token t2) {
        if (t1 == null && t2 == null) {
            return true;
        }
        if (t1 != null && t2 != null) {
            return t1.equals((Object)t2);
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof AMRecord) {
            AMRecord otherRecord = (AMRecord)other;
            return this.appId.equals((Object)otherRecord.appId) && this.hostName.equals(otherRecord.hostName) && this.hostIp.equals(otherRecord.hostIp) && this.port == otherRecord.port && this.externalId.equals(otherRecord.externalId) && this.computeName.equals(otherRecord.computeName) && AMRecord.tokenEquals(this.clientToAMToken, ((AMRecord)other).clientToAMToken);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.appId.hashCode() + 31 * this.hostName.hashCode() + 31 * this.hostIp.hashCode() + 31 * this.externalId.hashCode() + 31 * this.computeName.hashCode() + 31 * this.port + 31 * (this.clientToAMToken == null ? 0 : this.clientToAMToken.hashCode());
    }

    public ServiceRecord toServiceRecord() {
        ServiceRecord serviceRecord = new ServiceRecord();
        serviceRecord.set(APP_ID_RECORD_KEY, (Object)this.appId);
        serviceRecord.set(HOST_NAME_RECORD_KEY, (Object)this.hostName);
        serviceRecord.set(HOST_IP_RECORD_KEY, (Object)this.hostIp);
        serviceRecord.set(PORT_RECORD_KEY, (Object)this.port);
        serviceRecord.set(EXTERNAL_ID_KEY, (Object)this.externalId);
        serviceRecord.set(COMPUTE_GROUP_NAME_KEY, (Object)this.computeName);
        if (this.clientToAMToken != null) {
            try {
                serviceRecord.set(CLIENT_TO_AM_TOKEN_KEY, (Object)this.clientToAMToken.encodeToUrlString());
            }
            catch (IOException err) {
                throw new RuntimeException("Error encoding clientToAMToken", err);
            }
        }
        return serviceRecord;
    }

    public String toString() {
        return this.toServiceRecord().toString();
    }
}

