/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client.registry.zookeeper;

import com.google.common.base.Preconditions;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ZkConfig.class);
    private static final String ZK_NAMESPACE_PREFIX = "/tez-external-sessions";
    public static final String COMPUTE_GROUP_NAME_ENV = "COMPUTE_GROUP_NAME";
    public static final String DEFAULT_COMPUTE_GROUP_NAME = "default-compute";
    private String zkQuorum;
    private String zkNamespace;
    private int curatorBackoffSleep;
    private int curatorMaxRetries;
    private int sessionTimeoutMs;
    private int connectionTimeoutMs;

    public ZkConfig(Configuration conf) {
        this.zkQuorum = conf.get("tez.am.zookeeper.quorum");
        Preconditions.checkNotNull((Object)this.zkQuorum);
        String fullZkNamespace = ZK_NAMESPACE_PREFIX;
        String namespace = conf.get("tez.am.registry.namespace", "/tez_am/server");
        Preconditions.checkNotNull((Object)namespace);
        fullZkNamespace = namespace.startsWith("/") ? fullZkNamespace + namespace : fullZkNamespace + "/" + namespace;
        boolean enableComputeGroups = conf.getBoolean("tez.am.registry.enable.compute.groups", false);
        if (enableComputeGroups) {
            String subNamespace = System.getenv(COMPUTE_GROUP_NAME_ENV);
            if (subNamespace != null && !subNamespace.isEmpty()) {
                fullZkNamespace = subNamespace.startsWith("/") ? fullZkNamespace + subNamespace : fullZkNamespace + "/" + subNamespace;
                LOG.info("Compute groups enabled. subNamespace: {} fullZkNamespace: {}", (Object)subNamespace, (Object)fullZkNamespace);
            }
        } else {
            LOG.info("Compute groups disabled. fullZkNamespace: {}", (Object)fullZkNamespace);
        }
        this.zkNamespace = fullZkNamespace;
        this.curatorBackoffSleep = conf.getInt("tez.am.curator.backoff.sleep", 1000);
        this.curatorMaxRetries = conf.getInt("tez.am.curator.max.retries", 3);
        this.sessionTimeoutMs = conf.getInt("tez.am.curator.session.timeout", 150000);
        this.connectionTimeoutMs = conf.getInt("tez.am.curator.connection.timeout", 15000);
    }

    public String getZkQuorum() {
        return this.zkQuorum;
    }

    public String getZkNamespace() {
        return this.zkNamespace;
    }

    public int getCuratorBackoffSleep() {
        return this.curatorBackoffSleep;
    }

    public int getCuratorMaxRetries() {
        return this.curatorMaxRetries;
    }

    public int getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public RetryPolicy getRetryPolicy() {
        return new ExponentialBackoffRetry(this.getCuratorBackoffSleep(), this.getCuratorMaxRetries());
    }

    public CuratorFramework createCuratorFramework() {
        return CuratorFrameworkFactory.newClient((String)this.getZkQuorum(), (int)this.getSessionTimeoutMs(), (int)this.getConnectionTimeoutMs(), (RetryPolicy)this.getRetryPolicy());
    }
}

