/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.frameworkplugins;

import java.util.ArrayList;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezReflectionException;
import org.apache.tez.frameworkplugins.ClientFrameworkService;
import org.apache.tez.frameworkplugins.FrameworkMode;
import org.apache.tez.frameworkplugins.FrameworkService;

public class FrameworkUtils {
    public static <T extends FrameworkService> Optional<T> get(Class<T> interfaze, @Nullable TezConfiguration conf) {
        try {
            if (conf != null && conf.get("tez..framework.mode") != null) {
                return FrameworkUtils.getByMode(interfaze, conf.get("tez..framework.mode"));
            }
            if (System.getenv("TEZ_FRAMEWORK_MODE") != null) {
                return FrameworkUtils.getByMode(interfaze, System.getenv("TEZ_FRAMEWORK_MODE"));
            }
            return FrameworkUtils.getByServiceLoader(interfaze);
        }
        catch (TezReflectionException e) {
            throw new RuntimeException("Failed to load framework service for interface: " + interfaze.getName());
        }
    }

    private static <T extends FrameworkService> Optional<T> getByServiceLoader(Class<T> interfaze) {
        ArrayList<FrameworkService> services = new ArrayList<FrameworkService>();
        ServiceLoader<FrameworkService> frameworkService = ServiceLoader.load(interfaze);
        for (FrameworkService service : frameworkService) {
            services.add(service);
        }
        if (services.size() == 0) {
            return Optional.empty();
        }
        if (services.size() > 1) {
            throw new RuntimeException("Layering of multiple framework services is not supported. Please provide only one implementation class in configuration.");
        }
        return Optional.of(services.get(0));
    }

    private static <T> Optional<T> getByMode(Class<T> interfaze, String mode) throws TezReflectionException {
        mode = mode.toUpperCase();
        String clazz = null;
        clazz = interfaze == ClientFrameworkService.class ? FrameworkMode.valueOf((String)mode).clientClassName : FrameworkMode.valueOf((String)mode).serverClassName;
        return Optional.of(ReflectionUtils.createClazzInstance(clazz));
    }
}

