/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client.registry.zookeeper;

import java.io.IOException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.Records;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.client.registry.AMRecord;
import org.apache.tez.client.registry.zookeeper.ZkAMRegistryClient;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkFrameworkClient
extends FrameworkClient {
    private static final Logger LOG = LoggerFactory.getLogger(ZkFrameworkClient.class);
    private AMRecord amRecord;
    private TezConfiguration tezConf;
    private ZkAMRegistryClient amRegistryClient = null;
    private boolean isRunning = false;

    @Override
    public synchronized void init(TezConfiguration tezConf) {
        this.tezConf = tezConf;
        if (this.amRegistryClient == null) {
            try {
                this.amRegistryClient = ZkAMRegistryClient.getClient(tezConf);
                this.isRunning = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.isRunning = false;
        if (this.amRegistryClient != null) {
            this.amRegistryClient.close();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.amRegistryClient != null) {
            this.amRegistryClient.close();
        }
    }

    @Override
    public YarnClientApplication createApplication() throws YarnException, IOException {
        ApplicationSubmissionContext context = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        ApplicationId appId = this.amRecord.getApplicationId();
        context.setApplicationId(appId);
        GetNewApplicationResponse response = (GetNewApplicationResponse)Records.newRecord(GetNewApplicationResponse.class);
        response.setApplicationId(appId);
        return new YarnClientApplication(response, context);
    }

    @Override
    public ApplicationId submitApplication(ApplicationSubmissionContext appSubmissionContext) throws YarnException, IOException, TezException {
        return null;
    }

    @Override
    public void killApplication(ApplicationId appId) throws YarnException, IOException {
        if (this.amRegistryClient != null) {
            this.amRegistryClient.close();
        }
    }

    @Override
    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        ApplicationReport report = (ApplicationReport)Records.newRecord(ApplicationReport.class);
        report.setApplicationId(appId);
        report.setTrackingUrl("");
        this.amRecord = this.amRegistryClient.getRecord(appId.toString());
        if (this.amRecord == null) {
            report.setYarnApplicationState(YarnApplicationState.FINISHED);
            report.setFinalApplicationStatus(FinalApplicationStatus.FAILED);
            report.setDiagnostics("AM record not found (likely died) in zookeeper for application id: " + appId);
        } else {
            report.setHost(this.amRecord.getHost());
            report.setRpcPort(this.amRecord.getPort());
            report.setYarnApplicationState(YarnApplicationState.RUNNING);
            report.setClientToAMToken(ZkFrameworkClient.convertToProtoToken(this.amRecord.getClientToAMToken()));
        }
        return report;
    }

    private static org.apache.hadoop.yarn.api.records.Token convertToProtoToken(Token token) {
        if (token == null) {
            return null;
        }
        return org.apache.hadoop.yarn.api.records.Token.newInstance((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
    }

    @Override
    public boolean isRunning() throws IOException {
        return this.isRunning;
    }
}

