/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.MergedInputContext;
import org.apache.tez.runtime.api.ProgressFailedException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class MergedLogicalInput
implements LogicalInput {
    private AtomicBoolean notifiedInputReady = new AtomicBoolean(false);
    private List<Input> inputs;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final MergedInputContext context;

    public MergedLogicalInput(MergedInputContext context, List<Input> inputs) {
        this.inputs = Collections.unmodifiableList(inputs);
        this.context = context;
    }

    public final List<Input> getInputs() {
        return this.inputs;
    }

    public final MergedInputContext getContext() {
        return this.context;
    }

    @Override
    public final void start() throws Exception {
        if (!this.isStarted.getAndSet(true)) {
            for (Input input : this.inputs) {
                input.start();
            }
        }
    }

    protected final void informInputReady() {
        if (!this.notifiedInputReady.getAndSet(true)) {
            this.context.inputIsReady();
        }
    }

    public abstract void setConstituentInputIsReady(Input var1);

    public float getProgress() throws ProgressFailedException, InterruptedException {
        return 0.0f;
    }
}

