/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.common.TezClassLoader;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.runtime.api.TaskContext;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

@InterfaceAudience.Public
public final class TezUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TezUtils.class);

    private TezUtils() {
    }

    public static void addLog4jSystemProperties(String logLevel, List<String> vargs) {
        TezClientUtils.addLog4jSystemProperties(logLevel, vargs);
    }

    public static ByteString createByteStringFromConf(Configuration conf) throws IOException {
        Objects.requireNonNull(conf, "Configuration must be specified");
        ByteString.Output os = ByteString.newOutput();
        try (SnappyOutputStream compressOs = new SnappyOutputStream((OutputStream)os);){
            TezUtils.writeConfInPB((OutputStream)compressOs, conf);
        }
        return os.toByteString();
    }

    public static UserPayload createUserPayloadFromConf(Configuration conf) throws IOException {
        return UserPayload.create(TezUtils.createByteStringFromConf(conf).asReadOnlyByteBuffer());
    }

    private static DAGProtos.ConfigurationProto createConfProto(SnappyInputStream uncompressIs) throws IOException {
        CodedInputStream in = CodedInputStream.newInstance((InputStream)uncompressIs);
        in.setSizeLimit(Integer.MAX_VALUE);
        return DAGProtos.ConfigurationProto.parseFrom(in);
    }

    public static Configuration createConfFromByteString(ByteString byteString) throws IOException {
        Objects.requireNonNull(byteString, "ByteString must be specified");
        try (SnappyInputStream uncompressIs = new SnappyInputStream(byteString.newInput());){
            DAGProtos.ConfigurationProto confProto = TezUtils.createConfProto(uncompressIs);
            Configuration conf = new Configuration(false);
            TezUtils.readConfFromPB(confProto, conf);
            TezClassLoader.setupForConfiguration(conf);
            Configuration configuration = conf;
            return configuration;
        }
    }

    public static Configuration createConfFromBaseConfAndPayload(TaskContext context) throws IOException {
        Configuration baseConf = context.getContainerConfiguration();
        Configuration configuration = new Configuration(baseConf);
        UserPayload payload = context.getUserPayload();
        ByteString byteString = ByteString.copyFrom((ByteBuffer)payload.getPayload());
        try (SnappyInputStream uncompressIs = new SnappyInputStream(byteString.newInput());){
            DAGProtos.ConfigurationProto confProto = TezUtils.createConfProto(uncompressIs);
            TezUtils.readConfFromPB(confProto, configuration);
            TezClassLoader.setupForConfiguration(configuration);
            Configuration configuration2 = configuration;
            return configuration2;
        }
    }

    public static void addToConfFromByteString(Configuration configuration, ByteString byteString) throws IOException {
        try (SnappyInputStream uncompressIs = new SnappyInputStream(byteString.newInput());){
            DAGProtos.ConfigurationProto confProto = TezUtils.createConfProto(uncompressIs);
            TezUtils.readConfFromPB(confProto, configuration);
            TezClassLoader.setupForConfiguration(configuration);
        }
    }

    public static Configuration createConfFromUserPayload(UserPayload payload) throws IOException {
        return TezUtils.createConfFromByteString(ByteString.copyFrom((ByteBuffer)payload.getPayload()));
    }

    private static void writeConfInPB(OutputStream dos, Configuration conf) throws IOException {
        DAGProtos.ConfigurationProto.Builder confProtoBuilder = DAGProtos.ConfigurationProto.newBuilder();
        TezUtils.populateConfProtoFromEntries((Iterable<Map.Entry<String, String>>)conf, confProtoBuilder);
        DAGProtos.ConfigurationProto confProto = confProtoBuilder.build();
        confProto.writeTo(dos);
    }

    private static void readConfFromPB(DAGProtos.ConfigurationProto confProto, Configuration conf) {
        List<DAGProtos.PlanKeyValuePair> settingList = confProto.getConfKeyValuesList();
        for (DAGProtos.PlanKeyValuePair setting : settingList) {
            conf.set(setting.getKey(), setting.getValue());
        }
    }

    public static String convertToHistoryText(String description, Configuration conf) {
        JSONObject jsonObject = new JSONObject();
        try {
            if (description != null && !description.isEmpty()) {
                jsonObject.put("desc", (Object)description);
            }
            if (conf != null) {
                JSONObject confJson = new JSONObject();
                for (Map.Entry entry : conf) {
                    String key = (String)entry.getKey();
                    String val = conf.get((String)entry.getKey());
                    if (val != null) {
                        confJson.put(key, (Object)val);
                        continue;
                    }
                    LOG.debug("null value in Configuration after replacement for key={}. Skipping.", (Object)key);
                }
                jsonObject.put("config", (Object)confJson);
            }
        }
        catch (JSONException e) {
            throw new TezUncheckedException("Error when trying to convert description/conf to JSON", e);
        }
        return jsonObject.toString();
    }

    public static String convertToHistoryText(Configuration conf) {
        return TezUtils.convertToHistoryText(null, conf);
    }

    public static void populateConfProtoFromEntries(Iterable<Map.Entry<String, String>> params, DAGProtos.ConfigurationProto.Builder confBuilder) {
        for (Map.Entry<String, String> entry : params) {
            String key = entry.getKey();
            String val = entry.getValue();
            if (val != null) {
                DAGProtos.PlanKeyValuePair.Builder kvp = DAGProtos.PlanKeyValuePair.newBuilder();
                kvp.setKey(key);
                kvp.setValue(val);
                confBuilder.addConfKeyValues(kvp);
                continue;
            }
            LOG.debug("null value for key={}. Skipping.", (Object)key);
        }
    }
}

